/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.ListIterator;
import org.jlab.coda.et.EtException;
import org.jlab.coda.et.EtTooManyException;
import org.jlab.coda.et.SystemOpen;
import org.jlab.coda.et.SystemOpenConfig;

public class SystemOpen {
    SystemOpenConfig config;
    Socket sock;
    String host;
    int tcpPort;
    int debug;
    int endian;
    int numEvents;
    int eventSize;
    int version;
    int stationSelectInts;
    int language;
    ArrayList respondingHosts;
    ArrayList respondingPorts;
    private boolean connected;
    private final boolean foundServer = true;
    private final boolean cannotFindServer = false;
    private final boolean gotMatch = true;
    private final boolean noMatch = false;

    public SystemOpen(SystemOpenConfig systemOpenConfig) {
        this.config = new SystemOpenConfig(systemOpenConfig);
        this.debug = 2;
        this.respondingHosts = new ArrayList(20);
        this.respondingPorts = new ArrayList(20);
    }

    public void setDebug(int n) throws EtException {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4) {
            throw new EtException("bad debug argument");
        }
        this.debug = n;
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    public int getEventSize() {
        return this.eventSize;
    }

    public int getPort() {
        return this.tcpPort;
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.config.name;
    }

    public int getEndian() {
        return this.endian;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLanguage() {
        return this.language;
    }

    public int getSelectInts() {
        return this.stationSelectInts;
    }

    public Socket getSocket() {
        return this.sock;
    }

    public int getDebug() {
        return this.debug;
    }

    public SystemOpenConfig getConfig() {
        return new SystemOpenConfig(this.config);
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public String[] getAllHosts() {
        int n = this.respondingHosts.size();
        if (n == 0) {
            if (this.host == null) {
                return null;
            }
            String[] stringArray = new String[]{this.host};
            return stringArray;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.respondingHosts.get(n2);
            ++n2;
        }
        return stringArray;
    }

    public int[] getAllPorts() {
        int n = this.respondingPorts.size();
        if (n == 0) {
            if (this.tcpPort == 0) {
                return null;
            }
            int[] nArray = new int[]{this.tcpPort};
            return nArray;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (Integer)this.respondingPorts.get(n2);
            ++n2;
        }
        return nArray;
    }

    private boolean findServerPort() throws IOException, UnknownHostException, EtTooManyException {
        Object object;
        Object object2;
        Get[] getArray;
        boolean bl = false;
        int n = 0;
        int n2 = 4;
        int[] nArray = new int[]{50, 2000, 4000, 7000};
        int n3 = 20000;
        String string = null;
        this.respondingHosts.clear();
        this.respondingPorts.clear();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(110);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(8);
        dataOutputStream.writeInt(this.config.name.length() + 1);
        try {
            dataOutputStream.write(this.config.name.getBytes("ASCII"));
            dataOutputStream.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        dataOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.close();
        byteArrayOutputStream.close();
        int n4 = 0;
        int n5 = this.config.getNumBroadcastAddrs();
        int n6 = this.config.getNumMulticastAddrs();
        int n7 = n5 + n6 + 1;
        Send[] sendArray = new Send[n7];
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (!this.config.host.equals(".remote") && !this.config.host.equals(".anywhere")) {
            getArray = new MulticastSocket();
            try {
                getArray.setSoTimeout(n3);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            string = this.config.host.equals(".local") || this.config.host.equals("localhost") ? string2 : this.config.host;
            sendArray[n4++] = new Send(this, byArray, string, (MulticastSocket)getArray, this.config.udpPort);
            n7 = 1;
            if (this.config.contactMethod == 0 || this.config.contactMethod == 3) {
                object2 = this.config.multicastAddrs.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    MulticastSocket multicastSocket = new MulticastSocket();
                    try {
                        multicastSocket.setSoTimeout(n3);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    if (this.config.ttl != 1) {
                        multicastSocket.setTimeToLive(this.config.ttl);
                    }
                    sendArray[n4++] = new Send(this, byArray, (String)object, multicastSocket, this.config.multicastPort);
                    if (this.debug < 4) continue;
                    System.out.println("findServerPort: multicasting to " + (String)object);
                }
            } else {
                n6 = 0;
            }
            n7 += n6;
            if (this.debug >= 4) {
                System.out.println("findServerPort: send to local or specified host");
            }
        } else {
            if (this.config.contactMethod == 1 || this.config.contactMethod == 3) {
                object = this.config.broadcastAddrs.iterator();
                while (object.hasNext()) {
                    getArray = (String)object.next();
                    object2 = new MulticastSocket();
                    try {
                        ((DatagramSocket)object2).setSoTimeout(n3);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    sendArray[n4++] = new Send(this, byArray, (String)getArray, (MulticastSocket)object2, this.config.udpPort);
                    if (this.debug < 4) continue;
                    System.out.println("findServerPort: broadcasting to " + (String)getArray);
                }
            } else {
                n5 = 0;
            }
            if (this.config.contactMethod == 0 || this.config.contactMethod == 3) {
                object = this.config.multicastAddrs.iterator();
                while (object.hasNext()) {
                    getArray = (String)object.next();
                    object2 = new MulticastSocket();
                    try {
                        ((DatagramSocket)object2).setSoTimeout(n3);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    if (this.config.ttl != 1) {
                        ((MulticastSocket)object2).setTimeToLive(this.config.ttl);
                    }
                    sendArray[n4++] = new Send(this, byArray, (String)getArray, (MulticastSocket)object2, this.config.multicastPort);
                    if (this.debug < 4) continue;
                    System.out.println("findServerPort: multicasting to " + (String)getArray);
                }
            } else {
                n6 = 0;
            }
            n7 = n5 + n6;
        }
        getArray = new Get[n7];
        int n8 = 0;
        while (n8 < n7) {
            getArray[n8] = new Get(this, sendArray[n8].socket);
            if (this.debug >= 4) {
                System.out.println("findServerPort: starting thread to socket " + sendArray[n8].socket);
            }
            getArray[n8].start();
            ++n8;
        }
        Thread.currentThread();
        Thread.yield();
        while (n < n2) {
            int n9 = 0;
            while (n9 < n7) {
                sendArray[n9].socket.send(sendArray[n9].packet);
                ++n9;
            }
            int n10 = nArray[n++];
            block20: while (true) {
                if (this.debug >= 4) {
                    System.out.println("findServerPort: wait for " + n10 + " milliseconds");
                }
                try {
                    Thread.sleep(n10);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int n11 = 0;
                while (n11 < n7) {
                    int n12 = getArray[n11].thread.waitForReply(10);
                    if (this.debug >= 4) {
                        System.out.println("findServerPort: receive on socket " + getArray[n11].socket + ", status = " + n12);
                    }
                    if (n12 != -1 && n12 != 0 && n12 == 1) {
                        if (this.replyMatch(getArray[n11].packet)) {
                            if (this.debug >= 4) {
                                System.out.println("findServerPort: found match");
                            }
                            bl = true;
                        } else if (this.debug >= 4) {
                            System.out.println("findServerPort: no match");
                        }
                        n10 = 50;
                        getArray[n11].start();
                        Thread.currentThread();
                        Thread.yield();
                        continue block20;
                    }
                    ++n11;
                }
                break;
            }
            if (bl || n >= n2) break;
            if (this.debug < 4) continue;
            System.out.println("findServerPort: timedout, try again with longer wait");
        }
        if (bl) {
            if (!this.config.host.equals(".remote") && !this.config.host.equals(".anywhere")) {
                if (this.respondingHosts.size() > 1) {
                    object2 = null;
                    ListIterator listIterator = this.respondingHosts.listIterator();
                    while (listIterator.hasNext()) {
                        object2 = (String)listIterator.next();
                        if (!string.equals(object2)) continue;
                        this.host = object2;
                        this.tcpPort = (Integer)this.respondingPorts.get(this.respondingHosts.indexOf(object2));
                        return true;
                    }
                }
            } else if (this.respondingHosts.size() > 1) {
                if (this.config.responsePolicy == 0) {
                    this.host = (String)this.respondingHosts.get(0);
                    this.tcpPort = (Integer)this.respondingPorts.get(0);
                } else if (this.config.responsePolicy == 1) {
                    boolean bl2 = false;
                    String string3 = null;
                    ListIterator listIterator = this.respondingHosts.listIterator();
                    while (listIterator.hasNext()) {
                        string3 = (String)listIterator.next();
                        if (!string2.equals(string3)) continue;
                        this.host = string3;
                        this.tcpPort = (Integer)this.respondingPorts.get(this.respondingHosts.indexOf(string3));
                        bl2 = true;
                    }
                    if (!bl2) {
                        this.host = (String)this.respondingHosts.get(0);
                        this.tcpPort = (Integer)this.respondingPorts.get(0);
                    }
                } else {
                    throw new EtTooManyException("too many responding ET systems");
                }
            }
            return true;
        }
        if (this.debug >= 4) {
            System.out.println("findServerPort: cannot find server, quitting");
        }
        this.host = null;
        this.tcpPort = 0;
        return false;
    }

    private boolean replyMatch(DatagramPacket datagramPacket) throws IOException, UnknownHostException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n3];
            dataInputStream.readFully(byArray, 0, n3);
            String string = new String(byArray, 0, n3 - 1, "ASCII");
            n3 = dataInputStream.readInt();
            byArray = new byte[n3];
            dataInputStream.readFully(byArray, 0, n3);
            String string2 = new String(byArray, 0, n3 - 1, "ASCII");
            n3 = dataInputStream.readInt();
            byArray = new byte[n3];
            dataInputStream.readFully(byArray, 0, n3);
            String string3 = new String(byArray, 0, n3 - 1, "ASCII");
            if (this.debug >= 4) {
                System.out.println("replyMatch: port = " + n2 + ", server = " + string + ", IP addr = " + string2 + ", uname = " + string3);
            }
            dataInputStream.close();
            byteArrayInputStream.close();
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            if (this.config.host.equals(".anywhere")) {
                if (this.debug >= 4) {
                    System.out.println("replyMatch: .anywhere");
                }
                this.respondingHosts.add(string);
                this.respondingPorts.add(new Integer(n2));
                this.host = string;
                this.tcpPort = n2;
                return true;
            }
            if (this.config.host.equals(".remote")) {
                if (this.debug >= 4) {
                    System.out.println("replyMatch: .remote");
                }
                if (!inetAddress2.equals(inetAddress)) {
                    this.respondingHosts.add(string);
                    this.respondingPorts.add(new Integer(n2));
                    this.host = string;
                    this.tcpPort = n2;
                    return true;
                }
            } else if (this.config.host.equals(".local") || this.config.host.equals("localhost")) {
                if (this.debug >= 4) {
                    System.out.println("replyMatch: .local");
                }
                if (inetAddress2.equals(inetAddress)) {
                    this.host = string;
                    this.tcpPort = n2;
                    return true;
                }
            } else {
                InetAddress inetAddress3;
                if (this.debug >= 4) {
                    System.out.println("replyMatch: <name>");
                }
                if ((inetAddress3 = InetAddress.getByName(this.config.host)).equals(inetAddress)) {
                    this.host = string;
                    this.tcpPort = n2;
                    return true;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return false;
    }

    private void open() throws IOException, EtException {
        DataInputStream dataInputStream = new DataInputStream(this.sock.getInputStream());
        DataOutputStream dataOutputStream = new DataOutputStream(this.sock.getOutputStream());
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this.config.name.length() + 1);
        dataOutputStream.writeLong(0L);
        try {
            dataOutputStream.write(this.config.name.getBytes("ASCII"));
            dataOutputStream.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        dataOutputStream.flush();
        if (dataInputStream.readInt() != 0) {
            throw new EtException("found the wrong ET system");
        }
        this.endian = dataInputStream.readInt();
        this.numEvents = dataInputStream.readInt();
        this.eventSize = dataInputStream.readInt();
        this.version = dataInputStream.readInt();
        this.stationSelectInts = dataInputStream.readInt();
        this.language = dataInputStream.readInt();
        dataInputStream.skipBytes(8);
        if (this.version != 8) {
            this.disconnect();
            throw new EtException("may not open wrong version ET system");
        }
        if (this.stationSelectInts != 4) {
            this.disconnect();
            throw new EtException("may not open ET system with different # of select integers");
        }
        this.connected = true;
        if (this.debug >= 4) {
            System.out.println("open: endian = " + this.endian + ", nevents = " + this.numEvents + ", event size = " + this.eventSize + ", version = " + this.version + ",\n      selectInts = " + this.stationSelectInts + ", language = " + this.language);
        }
    }

    public synchronized void connect() throws IOException, UnknownHostException, EtException, EtTooManyException {
        if (this.config.contactMethod == 2) {
            if (this.debug >= 4) {
                System.out.println("connect: make a direct connection");
            }
            this.tcpPort = this.config.tcpPort;
            if (this.config.host.equals(".local")) {
                this.host = InetAddress.getLocalHost().getHostName();
            } else if (this.config.host.indexOf(".") < 0) {
                if (this.debug >= 4) {
                    System.out.println("connect: try to make " + this.config.host + " a fully qualified name");
                }
                this.host = InetAddress.getByName(this.config.host).getHostName();
            } else {
                this.host = this.config.host;
            }
        } else {
            if (this.debug >= 4) {
                System.out.println("connect: try to find server port");
            }
            if (!this.findServerPort()) {
                throw new EtException("Cannot find ET system");
            }
        }
        this.sock = new Socket(this.host, this.tcpPort);
        try {
            this.sock.setTcpNoDelay(true);
            this.sock.setSoTimeout(2000);
            this.sock.setKeepAlive(true);
            this.sock.setReceiveBufferSize(65535);
            this.sock.setSendBufferSize(65535);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (this.debug >= 4) {
            System.out.println("connect: try to open ET system");
        }
        this.open();
    }

    public synchronized void disconnect() {
        this.connected = false;
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

