/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.DataInputStream;
import java.io.IOException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemData {
    int alive;
    int heartbeat;
    int temps;
    int stations;
    int attachments;
    int processes;
    int eventsOwned;
    int mutex;
    int statMutex;
    int statAddMutex;
    int endian;
    int share;
    int mainPid;
    int selects;
    int events;
    int eventSize;
    int tempsMax;
    int stationsMax;
    int attachmentsMax;
    int processesMax;
    int tcpPort;
    int udpPort;
    int multicastPort;
    int interfaceCount;
    int multicastCount;
    String[] interfaceAddresses;
    String[] multicastAddresses;
    String etName;

    public boolean alive() {
        return this.alive == 1;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public int getTemps() {
        return this.temps;
    }

    public int getStations() {
        return this.stations;
    }

    public int getAttachments() {
        return this.attachments;
    }

    public int getProcesses() {
        return this.processes;
    }

    public int getEventsOwned() {
        return this.eventsOwned;
    }

    public int getMutex() {
        return this.mutex;
    }

    public int getStatMutex() {
        return this.statMutex;
    }

    public int getStatAddMutex() {
        return this.statAddMutex;
    }

    public int getEndian() {
        return this.endian;
    }

    public int getShare() {
        return this.share;
    }

    public int getMainPid() {
        return this.mainPid;
    }

    public int getSelects() {
        return this.selects;
    }

    public int getEvents() {
        return this.events;
    }

    public int getEventSize() {
        return this.eventSize;
    }

    public int getTempsMax() {
        return this.tempsMax;
    }

    public int getStationsMax() {
        return this.stationsMax;
    }

    public int getAttachmentsMax() {
        return this.attachmentsMax;
    }

    public int getProcessesMax() {
        return this.processesMax;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getInterfaces() {
        return this.interfaceCount;
    }

    public int getMulticasts() {
        return this.multicastCount;
    }

    public String[] getInterfaceAddresses() {
        return (String[])this.interfaceAddresses.clone();
    }

    public String[] getMulticastAddresses() {
        return (String[])this.multicastAddresses.clone();
    }

    public String getEtName() {
        return this.etName;
    }

    private static final int bytesToInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        return n2;
    }

    void read(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[100];
        dataInputStream.readFully(byArray);
        this.alive = SystemData.bytesToInt((byte[])byArray, (int)0);
        this.heartbeat = SystemData.bytesToInt((byte[])byArray, (int)4);
        this.temps = SystemData.bytesToInt((byte[])byArray, (int)8);
        this.stations = SystemData.bytesToInt((byte[])byArray, (int)12);
        this.attachments = SystemData.bytesToInt((byte[])byArray, (int)16);
        this.processes = SystemData.bytesToInt((byte[])byArray, (int)20);
        this.eventsOwned = SystemData.bytesToInt((byte[])byArray, (int)24);
        this.mutex = SystemData.bytesToInt((byte[])byArray, (int)28);
        this.statMutex = SystemData.bytesToInt((byte[])byArray, (int)32);
        this.statAddMutex = SystemData.bytesToInt((byte[])byArray, (int)36);
        this.endian = SystemData.bytesToInt((byte[])byArray, (int)40);
        this.share = SystemData.bytesToInt((byte[])byArray, (int)44);
        this.mainPid = SystemData.bytesToInt((byte[])byArray, (int)48);
        this.selects = SystemData.bytesToInt((byte[])byArray, (int)52);
        this.events = SystemData.bytesToInt((byte[])byArray, (int)56);
        this.eventSize = SystemData.bytesToInt((byte[])byArray, (int)60);
        this.tempsMax = SystemData.bytesToInt((byte[])byArray, (int)64);
        this.stationsMax = SystemData.bytesToInt((byte[])byArray, (int)68);
        this.attachmentsMax = SystemData.bytesToInt((byte[])byArray, (int)72);
        this.processesMax = SystemData.bytesToInt((byte[])byArray, (int)76);
        this.tcpPort = SystemData.bytesToInt((byte[])byArray, (int)80);
        this.udpPort = SystemData.bytesToInt((byte[])byArray, (int)84);
        this.multicastPort = SystemData.bytesToInt((byte[])byArray, (int)88);
        this.interfaceCount = SystemData.bytesToInt((byte[])byArray, (int)92);
        this.multicastCount = SystemData.bytesToInt((byte[])byArray, (int)96);
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[this.interfaceCount + this.multicastCount + 1];
        int n3 = 0;
        while (n3 < this.interfaceCount + this.multicastCount + 1) {
            nArray[n3] = dataInputStream.readInt();
            n2 += nArray[n3];
            ++n3;
        }
        if (n2 > 100) {
            byArray = new byte[n2];
        }
        dataInputStream.readFully(byArray, 0, n2);
        this.interfaceAddresses = new String[this.interfaceCount];
        int n4 = 0;
        while (n4 < this.interfaceCount) {
            this.interfaceAddresses[n4] = new String(byArray, n, nArray[n4] - 1, "ASCII");
            n += nArray[n4];
            ++n4;
        }
        this.multicastAddresses = new String[this.multicastCount];
        int n5 = 0;
        while (n5 < this.multicastCount) {
            this.multicastAddresses[n5] = new String(byArray, n, nArray[n5 + this.interfaceCount] - 1, "ASCII");
            n += nArray[n5 + this.interfaceCount];
            ++n5;
        }
        this.etName = new String(byArray, n, nArray[this.interfaceCount + this.multicastCount] - 1, "ASCII");
    }
}

