/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jlab.coda.et.AttachmentLocal;
import org.jlab.coda.et.EtBusyException;
import org.jlab.coda.et.EtEmptyException;
import org.jlab.coda.et.EtException;
import org.jlab.coda.et.EtExistsException;
import org.jlab.coda.et.EtTimeoutException;
import org.jlab.coda.et.EtTooManyException;
import org.jlab.coda.et.EtWakeUpException;
import org.jlab.coda.et.Event;
import org.jlab.coda.et.StationConfig;
import org.jlab.coda.et.StationLocal;
import org.jlab.coda.et.SystemConfig;
import org.jlab.coda.et.SystemTcpServer;
import org.jlab.coda.et.SystemUdpServer;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemCreate {
    SystemConfig config;
    String name;
    LinkedList stations;
    int stationCount;
    private StationLocal gcStation;
    HashMap attachments;
    HashMap events;
    InetAddress[] netAddresses;
    private boolean running;
    byte[] systemLock;
    byte[] stationLock;
    volatile boolean killAllThreads;
    private boolean gather = true;
    private long time1 = 0L;
    private long time2 = 0L;
    int dataLength = 0;
    byte[] infoArray = new byte[6000];

    public SystemCreate(String string) throws EtException {
        this.name = string;
        this.config = new SystemConfig();
        this.attachments = new HashMap(111, 1.0f);
        this.events = new HashMap(this.config.numEvents + 1, 1.0f);
        this.stations = new LinkedList();
        this.systemLock = new byte[0];
        this.stationLock = new byte[0];
        File file = new File(this.name);
        try {
            if (!file.createNewFile()) {
                if (this.config.debug >= 4) {
                    System.out.println("ET file already exists");
                }
                throw new EtException("ET file already exists");
            }
        }
        catch (IOException iOException) {
            if (this.config.debug >= 4) {
                System.out.println("cannot create ET file");
            }
            throw new EtException("Cannot create ET file");
        }
        file.deleteOnExit();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "ASCII");
            outputStreamWriter.write("JAVA ET SYSTEM FILE", 0, 19);
            outputStreamWriter.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.startUp();
    }

    public SystemCreate(String string, SystemConfig systemConfig) throws EtException {
        this.name = string;
        this.config = new SystemConfig(systemConfig);
        this.attachments = new HashMap(111, 1.0f);
        this.events = new HashMap(this.config.numEvents + 1, 1.0f);
        this.stations = new LinkedList();
        this.systemLock = new byte[0];
        this.stationLock = new byte[0];
        File file = new File(this.name);
        try {
            if (!file.createNewFile()) {
                if (this.config.debug >= 4) {
                    System.out.println("ET file already exists");
                }
                throw new EtException("ET file already exists");
            }
        }
        catch (IOException iOException) {
            if (this.config.debug >= 4) {
                System.out.println("cannot create ET file");
            }
            throw new EtException("Cannot create ET file");
        }
        file.deleteOnExit();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "ASCII");
            outputStreamWriter.write("JAVA ET SYSTEM FILE", 0, 19);
            outputStreamWriter.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.startUp();
    }

    public String getName() {
        return this.name;
    }

    public SystemConfig getConfig() {
        return new SystemConfig(this.config);
    }

    public synchronized boolean running() {
        return this.running;
    }

    public synchronized void startUp() {
        if (this.running) {
            return;
        }
        this.gcStation = this.createGrandCentral();
        ArrayList<Event> arrayList = new ArrayList<Event>(this.config.numEvents);
        int n = 0;
        while (n < this.config.numEvents) {
            Event event = new Event(this.config.eventSize);
            event.id = n++;
            arrayList.add(event);
            this.events.put(new Integer(event.id), event);
        }
        this.gcStation.inputList.putInLow(arrayList);
        this.gcStation.inputList.eventsIn = 0L;
        SystemTcpServer systemTcpServer = new SystemTcpServer(this);
        systemTcpServer.start();
        SystemUdpServer systemUdpServer = new SystemUdpServer(this);
        systemUdpServer.start();
        this.running = true;
    }

    public synchronized void shutdown() {
        if (!this.running) {
            return;
        }
        this.killAllThreads = true;
        try {
            Thread.currentThread();
            Thread.sleep(2500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        File file = new File(this.name);
        file.delete();
        this.stations = null;
        this.attachments = null;
        this.events = null;
        this.netAddresses = null;
        this.stationLock = null;
        this.killAllThreads = false;
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StationLocal createStation(StationConfig stationConfig, String string) throws EtException, EtExistsException, EtTooManyException {
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            StationLocal stationLocal = this.createStation(stationConfig, string, this.stations.size(), -1);
            return stationLocal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StationLocal createStation(StationConfig stationConfig, String string, int n, int n2) throws EtException, EtExistsException, EtTooManyException {
        int n3 = 0;
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            StationLocal stationLocal;
            block21: {
                block19: {
                    StationLocal stationLocal2;
                    if (this.stations.size() >= this.config.stationsMax) {
                        throw new EtTooManyException("Maximum number of stations already created");
                    }
                    if (n > this.stations.size()) {
                        n = this.stations.size();
                    }
                    try {
                        stationLocal2 = this.stationNameToObject(string);
                        if (stationLocal2.config.flowMode != stationConfig.flowMode || stationLocal2.config.userMode != stationConfig.userMode || stationLocal2.config.blockMode != stationConfig.blockMode || stationLocal2.config.selectMode != stationConfig.selectMode || stationLocal2.config.restoreMode != stationConfig.restoreMode || stationLocal2.config.prescale != stationConfig.prescale || stationLocal2.config.cue != stationConfig.cue || !Arrays.equals(stationLocal2.config.select, stationConfig.select)) break block19;
                        if (stationLocal2.config.selectClass != null && !stationLocal2.config.selectClass.equals(stationConfig.selectClass)) {
                            throw new EtExistsException("Station already exists with different configuration");
                        }
                        StationLocal stationLocal3 = stationLocal2;
                        return stationLocal3;
                    }
                    catch (EtException etException) {
                        int n4 = 0;
                        while (n4 < this.stationCount + 1) {
                            block20: {
                                ListIterator listIterator = this.stations.listIterator();
                                while (listIterator.hasNext()) {
                                    stationLocal2 = (StationLocal)listIterator.next();
                                    if (stationLocal2.id == n4) break block20;
                                    if (stationLocal2.config.flowMode != 1) continue;
                                    ListIterator listIterator2 = stationLocal2.parallelStations.listIterator(1);
                                    while (listIterator2.hasNext()) {
                                        stationLocal2 = (StationLocal)listIterator2.next();
                                        if (stationLocal2.id != n4) {
                                            continue;
                                        }
                                        break block20;
                                    }
                                }
                                n3 = n4;
                                break;
                            }
                            ++n4;
                        }
                        stationLocal = new StationLocal(this, string, stationConfig, n3);
                        stationLocal.start();
                        Thread.yield();
                        while (stationLocal.status != 2) {
                            if (this.config.debug >= 4) {
                                System.out.println("Waiting for " + string + "'s conductor thread to start");
                            }
                            try {
                                Thread.sleep(0L, 1);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        this.gcStation.addStation(stationLocal, n, n2);
                        ++this.stationCount;
                        break block21;
                    }
                }
                throw new EtExistsException("Station already exists with different configuration");
            }
            return stationLocal;
        }
    }

    private StationLocal createGrandCentral() {
        StationConfig stationConfig = new StationConfig();
        StationLocal stationLocal = null;
        try {
            stationLocal = new StationLocal(this, "GRAND_CENTRAL", stationConfig, 0);
        }
        catch (EtException etException) {
            // empty catch block
        }
        this.stations.clear();
        this.stations.addFirst(stationLocal);
        stationLocal.start();
        ++this.stationCount;
        return stationLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStation(int n) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            StationLocal stationLocal = this.stationIdToObject(n);
            if (stationLocal.attachments.size() != 0) {
                throw new EtException("Remove all attachments before removing station");
            }
            this.gcStation.removeStation(stationLocal);
            stationLocal.killConductor = true;
            stationLocal.interrupt();
            stationLocal.status = 0;
            --this.stationCount;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStationPosition(int n, int n2, int n3) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            StationLocal stationLocal = this.stationIdToObject(n);
            this.gcStation.moveStation(stationLocal, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getStationPosition(int n) throws EtException {
        if (n == 0) {
            return 0;
        }
        int n2 = 1;
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            ListIterator listIterator = this.stations.listIterator(1);
            while (listIterator.hasNext()) {
                StationLocal stationLocal = (StationLocal)listIterator.next();
                if (stationLocal.id == n) {
                    return n2;
                }
                if (stationLocal.config.flowMode == 1) {
                    ListIterator listIterator2 = stationLocal.parallelStations.listIterator();
                    while (listIterator2.hasNext()) {
                        stationLocal = (StationLocal)listIterator2.next();
                        if (stationLocal.id != n) continue;
                        return n2;
                    }
                }
                ++n2;
            }
            throw new EtException("cannot find station");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getStationParallelPosition(int n) throws EtException {
        if (n == 0) {
            return 0;
        }
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            ListIterator listIterator = this.stations.listIterator(1);
            while (listIterator.hasNext()) {
                StationLocal stationLocal = (StationLocal)listIterator.next();
                if (stationLocal.id == n) {
                    return 0;
                }
                if (stationLocal.config.flowMode != 1) continue;
                int n2 = 1;
                ListIterator listIterator2 = stationLocal.parallelStations.listIterator(1);
                while (listIterator2.hasNext()) {
                    stationLocal = (StationLocal)listIterator2.next();
                    if (stationLocal.id == n) {
                        return n2;
                    }
                    ++n2;
                }
            }
            throw new EtException("cannot find station");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean stationAttached(int n, int n2) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            StationLocal stationLocal = this.stationIdToObject(n);
            Iterator iterator = stationLocal.attachments.iterator();
            while (iterator.hasNext()) {
                if (((AttachmentLocal)iterator.next()).id != n2) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean stationExists(StationLocal stationLocal) {
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            if (this.stations.contains(stationLocal)) {
                return true;
            }
            ListIterator listIterator = this.stations.listIterator();
            while (listIterator.hasNext()) {
                StationLocal stationLocal2 = (StationLocal)listIterator.next();
                if (stationLocal2.config.flowMode != 1 || !stationLocal2.parallelStations.contains(stationLocal)) continue;
                return true;
            }
            return false;
        }
    }

    boolean stationExists(String string) {
        try {
            this.stationNameToObject(string);
        }
        catch (EtException etException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    StationLocal stationNameToObject(String string) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            ListIterator listIterator = this.stations.listIterator();
            while (listIterator.hasNext()) {
                StationLocal stationLocal = (StationLocal)listIterator.next();
                if (stationLocal.name.equals(string)) {
                    return stationLocal;
                }
                if (stationLocal.config.flowMode != 1) continue;
                ListIterator listIterator2 = stationLocal.parallelStations.listIterator();
                while (listIterator2.hasNext()) {
                    stationLocal = (StationLocal)listIterator2.next();
                    if (!stationLocal.name.equals(string)) continue;
                    return stationLocal;
                }
            }
            throw new EtException("station " + string + " does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    StationLocal stationIdToObject(int n) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            ListIterator listIterator = this.stations.listIterator();
            while (listIterator.hasNext()) {
                StationLocal stationLocal = (StationLocal)listIterator.next();
                if (stationLocal.id == n) {
                    return stationLocal;
                }
                if (stationLocal.config.flowMode != 1) continue;
                ListIterator listIterator2 = stationLocal.parallelStations.listIterator();
                while (listIterator2.hasNext()) {
                    stationLocal = (StationLocal)listIterator2.next();
                    if (stationLocal.id != n) continue;
                    return stationLocal;
                }
            }
            throw new EtException("station  with id \"" + n + "\" does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AttachmentLocal attach(int n) throws EtException, EtTooManyException {
        AttachmentLocal attachmentLocal = null;
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            StationLocal stationLocal = this.stationIdToObject(n);
            if (stationLocal.config.userMode > 0 && stationLocal.config.userMode <= stationLocal.attachments.size()) {
                throw new EtTooManyException("no more attachments allowed to station");
            }
            byte[] byArray2 = this.systemLock;
            synchronized (byArray2) {
                if (this.attachments.size() >= this.config.attachmentsMax) {
                    throw new EtTooManyException("no more attachments allowed to ET system");
                }
                attachmentLocal = new AttachmentLocal();
                attachmentLocal.station = stationLocal;
                if (this.attachments.size() == 0) {
                    attachmentLocal.id = 0;
                } else {
                    int n2 = 0;
                    while (n2 < this.attachments.size() + 1) {
                        block13: {
                            Iterator iterator = this.attachments.keySet().iterator();
                            while (iterator.hasNext()) {
                                if ((Integer)iterator.next() != n2) {
                                    continue;
                                }
                                break block13;
                            }
                            attachmentLocal.id = n2;
                            break;
                        }
                        ++n2;
                    }
                }
                this.attachments.put(new Integer(attachmentLocal.id), attachmentLocal);
            }
            stationLocal.attachments.add(attachmentLocal);
            this.gcStation.changeStationStatus(stationLocal, 3);
        }
        return attachmentLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach(AttachmentLocal attachmentLocal) {
        byte[] byArray = this.stationLock;
        synchronized (byArray) {
            if (attachmentLocal.station.attachments.size() == 1 && attachmentLocal.station.id != 0) {
                this.gcStation.changeStationStatus(attachmentLocal.station, 2);
                Thread.currentThread();
                Thread.yield();
                try {
                    this.putEvents(attachmentLocal, this.getEvents(attachmentLocal, 2, 0, this.config.numEvents));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            attachmentLocal.station.attachments.remove(attachmentLocal);
            this.restoreEvents(attachmentLocal);
            byte[] byArray2 = this.systemLock;
            synchronized (byArray2) {
                this.attachments.remove(new Integer(attachmentLocal.id));
            }
        }
    }

    private void restoreEvents(AttachmentLocal attachmentLocal) {
        ArrayList<Event> arrayList = new ArrayList<Event>(this.config.numEvents);
        ArrayList<Event> arrayList2 = new ArrayList<Event>(this.config.numEvents);
        Iterator iterator = this.events.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Event event = (Event)entry.getValue();
            if (event.owner != attachmentLocal.id) continue;
            if (event.age == 1) {
                arrayList2.add(event);
                continue;
            }
            if (event.priority == 1) {
                arrayList.add(0, event);
                continue;
            }
            arrayList.add(event);
        }
        if (arrayList2.size() > 0) {
            this.dumpEvents(attachmentLocal, arrayList2);
        }
        if (arrayList.size() > 0) {
            if (attachmentLocal.station.config.restoreMode == 2 || attachmentLocal.station.id == 0) {
                this.dumpEvents(attachmentLocal, arrayList);
            } else if (attachmentLocal.station.config.restoreMode == 0 || attachmentLocal.station.config.restoreMode == 1 && attachmentLocal.station.attachments.size() == 0) {
                this.putEvents(attachmentLocal, arrayList);
            } else if (attachmentLocal.station.config.restoreMode == 1) {
                if (attachmentLocal.station.config.blockMode == 1) {
                    attachmentLocal.station.inputList.put(arrayList);
                } else {
                    int n = this.stations.indexOf(attachmentLocal.station) - 1;
                    if (n < 0) {
                        return;
                    }
                    StationLocal stationLocal = (StationLocal)this.stations.get(n);
                }
            }
        }
    }

    Event[] newEvents(AttachmentLocal attachmentLocal, int n, int n2, int n3, int n4) throws EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        if (this.gcStation.inputList.locked && n == 2) {
            throw new EtBusyException("input list is busy");
        }
        Event[] eventArray = this.gcStation.inputList.get(attachmentLocal, n, n2, n3);
        int n5 = eventArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Event event = eventArray[n6];
            event.init();
            event.owner = attachmentLocal.id;
            if (event.memSize < n4) {
                event.data = new byte[n4];
                event.memSize = n4;
            }
            ++n6;
        }
        attachmentLocal.eventsMake += (long)n5;
        return eventArray;
    }

    Event[] getEvents(AttachmentLocal attachmentLocal, int n, int n2, int n3) throws EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        if (attachmentLocal.station.inputList.locked && n == 2) {
            throw new EtBusyException("input list is busy");
        }
        Event[] eventArray = attachmentLocal.station.inputList.get(attachmentLocal, n, n2, n3);
        int n4 = eventArray.length;
        int n5 = 0;
        while (n5 < n4) {
            eventArray[n5].owner = attachmentLocal.id;
            ++n5;
        }
        attachmentLocal.eventsGet += (long)n4;
        return eventArray;
    }

    void putEvents(AttachmentLocal attachmentLocal, Event[] eventArray) {
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            event.age = 0;
            event.owner = -1;
            ++n2;
        }
        attachmentLocal.station.outputList.put(eventArray);
        attachmentLocal.eventsPut += (long)n;
    }

    private void putEvents(AttachmentLocal attachmentLocal, ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Event event = (Event)arrayList.get(n2);
            event.age = 0;
            event.owner = -1;
            ++n2;
        }
        attachmentLocal.station.outputList.put(arrayList);
        attachmentLocal.eventsPut += (long)n;
    }

    void dumpEvents(AttachmentLocal attachmentLocal, Event[] eventArray) {
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            eventArray[n2].owner = -1;
            ++n2;
        }
        this.gcStation.inputList.putInGC(eventArray);
        attachmentLocal.eventsDump += (long)n;
    }

    private void dumpEvents(AttachmentLocal attachmentLocal, ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ((Event)arrayList.get((int)n2)).owner = -1;
            ++n2;
        }
        this.gcStation.inputList.putInGC((List)arrayList);
        attachmentLocal.eventsDump += (long)n;
    }

    private static final void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 0xFF000000) >>> 24);
        byArray[n2 + 1] = (byte)((n & 0xFF0000) >>> 16);
        byArray[n2 + 2] = (byte)((n & 0xFF00) >>> 8);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    private static final void longToBytes(long l, byte[] byArray, int n) {
        byArray[n] = (byte)((l & 0xFF00000000000000L) >>> 56);
        byArray[n + 1] = (byte)((l & 0xFF000000000000L) >>> 48);
        byArray[n + 2] = (byte)((l & 0xFF0000000000L) >>> 40);
        byArray[n + 3] = (byte)((l & 0xFF00000000L) >>> 32);
        byArray[n + 4] = (byte)((l & 0xFF000000L) >>> 24);
        byArray[n + 5] = (byte)((l & 0xFF0000L) >>> 16);
        byArray[n + 6] = (byte)((l & 0xFF00L) >>> 8);
        byArray[n + 7] = (byte)(l & 0xFFL);
    }

    int gatherSystemData() {
        int n = 0;
        this.time2 = System.currentTimeMillis();
        if (this.time2 - this.time1 > 1000L) {
            this.gather = true;
        }
        if (this.gather) {
            this.time1 = System.currentTimeMillis();
            try {
                int n2 = this.stationCount;
                int n3 = this.attachments.size();
                int n4 = 600 + 570 * n2 + 160 * n3;
                if (n4 > this.infoArray.length) {
                    this.infoArray = new byte[n4];
                }
                int n5 = this.writeSystemData(this.infoArray, 4);
                int n6 = this.writeStationData(this.infoArray, 4 + n5, n2);
                int n7 = this.writeAttachmentData(this.infoArray, 4 + n5 + n6, n3);
                SystemCreate.intToBytes((int)0, (byte[])this.infoArray, (int)(4 + n5 + n6 + n7));
                this.dataLength = 4 + n5 + n6 + n7;
                this.gather = false;
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        return n;
    }

    private int writeSystemData(byte[] byArray, int n) {
        byte[] byArray2;
        InetAddress inetAddress;
        int n2;
        SystemCreate.intToBytes((int)1, (byte[])byArray, (int)n);
        SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.stations.size(), (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.attachments.size(), (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n += 4));
        int n3 = 0;
        Iterator iterator = this.events.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Event event = (Event)entry.getValue();
            if (event.owner != -1) continue;
            ++n3;
        }
        SystemCreate.intToBytes((int)n3, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)1, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)-1, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)4, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.config.numEvents, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.config.eventSize, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.config.stationsMax, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.config.attachmentsMax, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.config.serverPort, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.config.udpPort, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.config.multicastPort, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.netAddresses.length, (byte[])byArray, (int)(n += 4));
        SystemCreate.intToBytes((int)this.config.multicastAddrs.size(), (byte[])byArray, (int)(n += 4));
        int n4 = 25;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.netAddresses.length) {
            n2 = this.netAddresses[n6].getHostAddress().length() + 1;
            SystemCreate.intToBytes((int)n2, (byte[])byArray, (int)(n += 4));
            ++n4;
            n5 += n2;
            ++n6;
        }
        Iterator iterator2 = this.config.multicastAddrs.iterator();
        while (iterator2.hasNext()) {
            inetAddress = (InetAddress)iterator2.next();
            n2 = inetAddress.getHostAddress().length() + 1;
            SystemCreate.intToBytes((int)n2, (byte[])byArray, (int)(n += 4));
            ++n4;
            n5 += n2;
        }
        n2 = this.name.length() + 1;
        SystemCreate.intToBytes((int)n2, (byte[])byArray, (int)(n += 4));
        int n7 = 4 * ++n4 + (n5 += n2);
        n += 4;
        int n8 = 0;
        while (n8 < this.netAddresses.length) {
            try {
                byArray2 = this.netAddresses[n8].getHostAddress().getBytes("ASCII");
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                n += byArray2.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            byArray[n++] = 0;
            ++n8;
        }
        Iterator iterator3 = this.config.multicastAddrs.iterator();
        while (iterator3.hasNext()) {
            inetAddress = (InetAddress)iterator3.next();
            try {
                byArray2 = inetAddress.getHostAddress().getBytes("ASCII");
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                n += byArray2.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            byArray[n++] = 0;
        }
        try {
            byArray2 = this.name.getBytes("ASCII");
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byArray[n] = 0;
        return n7;
    }

    private int writeStationData(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        n4 += 4;
        n3 += 4;
        ListIterator listIterator = null;
        ListIterator listIterator2 = this.stations.listIterator();
        StationLocal stationLocal = (StationLocal)listIterator2.next();
        while (true) {
            int n6 = n3;
            SystemCreate.intToBytes((int)stationLocal.id, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)stationLocal.status, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n3 += 4));
            int n7 = 0;
            Iterator iterator = stationLocal.attachments.iterator();
            while (iterator.hasNext()) {
                SystemCreate.intToBytes((int)((AttachmentLocal)iterator.next()).id, (byte[])byArray, (int)(n3 += 4));
                ++n7;
            }
            SystemCreate.intToBytes((int)n7, (byte[])byArray, (int)n6);
            int n8 = n7;
            SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)stationLocal.inputList.events.size(), (byte[])byArray, (int)(n3 += 4));
            SystemCreate.longToBytes((long)stationLocal.inputList.eventsTry, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.longToBytes((long)stationLocal.inputList.eventsIn, (byte[])byArray, (int)(n3 += 8));
            SystemCreate.intToBytes((int)0, (byte[])byArray, (int)(n3 += 8));
            SystemCreate.intToBytes((int)stationLocal.outputList.events.size(), (byte[])byArray, (int)(n3 += 4));
            SystemCreate.longToBytes((long)stationLocal.outputList.eventsOut, (byte[])byArray, (int)(n3 += 4));
            if (stationLocal.config.flowMode == 1 && bl) {
                SystemCreate.intToBytes((int)2, (byte[])byArray, (int)(n3 += 8));
            } else {
                SystemCreate.intToBytes((int)stationLocal.config.flowMode, (byte[])byArray, (int)(n3 += 8));
            }
            SystemCreate.intToBytes((int)stationLocal.config.userMode, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)stationLocal.config.restoreMode, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)stationLocal.config.blockMode, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)stationLocal.config.prescale, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)stationLocal.config.cue, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)stationLocal.config.selectMode, (byte[])byArray, (int)(n3 += 4));
            int n9 = 0;
            while (n9 < 4) {
                SystemCreate.intToBytes((int)stationLocal.config.select[n9], (byte[])byArray, (int)(n3 += 4));
                ++n9;
            }
            int n10 = 0;
            if (stationLocal.config.selectFunction != null) {
                n10 = stationLocal.config.selectFunction.length() + 1;
            }
            int n11 = 0;
            if (stationLocal.config.selectLibrary != null) {
                n11 = stationLocal.config.selectLibrary.length() + 1;
            }
            int n12 = 0;
            if (stationLocal.config.selectClass != null) {
                n12 = stationLocal.config.selectClass.length() + 1;
            }
            int n13 = stationLocal.name.length() + 1;
            SystemCreate.intToBytes((int)n10, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)n11, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)n12, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)n13, (byte[])byArray, (int)(n3 += 4));
            n3 += 4;
            try {
                byte[] byArray2;
                if (n10 > 0) {
                    byArray2 = stationLocal.config.selectFunction.getBytes("ASCII");
                    System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                    n3 += byArray2.length;
                    byArray[n3++] = 0;
                }
                if (n11 > 0) {
                    byArray2 = stationLocal.config.selectLibrary.getBytes("ASCII");
                    System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                    n3 += byArray2.length;
                    byArray[n3++] = 0;
                }
                if (n12 > 0) {
                    byArray2 = stationLocal.config.selectClass.getBytes("ASCII");
                    System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                    n3 += byArray2.length;
                    byArray[n3++] = 0;
                }
                byArray2 = stationLocal.name.getBytes("ASCII");
                System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                n3 += byArray2.length;
                byArray[n3++] = 0;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            n4 += 4 * (19 + n8 + 4) + 24 + n10 + n11 + n12 + n13;
            if (++n5 >= n2) break;
            if (stationLocal.config.flowMode == 1 && this.stations.contains(stationLocal)) {
                listIterator = stationLocal.parallelStations.listIterator(1);
                if (listIterator.hasNext()) {
                    bl = false;
                    stationLocal = (StationLocal)listIterator.next();
                    continue;
                }
            } else if (stationLocal.config.flowMode == 1 && listIterator.hasNext()) {
                bl = false;
                stationLocal = (StationLocal)listIterator.next();
                continue;
            }
            bl = true;
            if (!listIterator2.hasNext()) continue;
            stationLocal = (StationLocal)listIterator2.next();
        }
        SystemCreate.intToBytes((int)n5, (byte[])byArray, (int)n);
        return n4;
    }

    private int writeAttachmentData(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            SystemCreate.intToBytes((int)0, (byte[])byArray, (int)n);
            return 4;
        }
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        n3 += 4;
        n4 += 4;
        Iterator iterator = this.attachments.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AttachmentLocal attachmentLocal = (AttachmentLocal)entry.getValue();
            SystemCreate.intToBytes((int)attachmentLocal.id, (byte[])byArray, (int)n3);
            SystemCreate.intToBytes((int)-1, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)attachmentLocal.station.id, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)-1, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)(attachmentLocal.waiting ? 1 : 0), (byte[])byArray, (int)(n3 += 4));
            SystemCreate.intToBytes((int)(attachmentLocal.wakeUp ? 1 : 0), (byte[])byArray, (int)(n3 += 4));
            int n6 = 0;
            Iterator iterator2 = this.events.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = iterator2.next();
                Event event = (Event)entry.getValue();
                if (event.owner != attachmentLocal.id) continue;
                ++n6;
            }
            SystemCreate.intToBytes((int)n6, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.longToBytes((long)attachmentLocal.eventsPut, (byte[])byArray, (int)(n3 += 4));
            SystemCreate.longToBytes((long)attachmentLocal.eventsGet, (byte[])byArray, (int)(n3 += 8));
            SystemCreate.longToBytes((long)attachmentLocal.eventsDump, (byte[])byArray, (int)(n3 += 8));
            SystemCreate.longToBytes((long)attachmentLocal.eventsMake, (byte[])byArray, (int)(n3 += 8));
            int n7 = attachmentLocal.host.length() + 1;
            int n8 = attachmentLocal.station.name.length() + 1;
            SystemCreate.intToBytes((int)n7, (byte[])byArray, (int)(n3 += 8));
            SystemCreate.intToBytes((int)n8, (byte[])byArray, (int)(n3 += 4));
            n3 += 4;
            try {
                byte[] byArray2 = attachmentLocal.host.getBytes("ASCII");
                System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                n3 += byArray2.length;
                byArray[n3++] = 0;
                byArray2 = attachmentLocal.station.name.getBytes("ASCII");
                System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                n3 += byArray2.length;
                byArray[n3++] = 0;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            n4 += 68 + n7 + n8;
            if (++n5 >= n2) break;
        }
        SystemCreate.intToBytes((int)n5, (byte[])byArray, (int)n);
        return n4;
    }
}

