/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jlab.coda.et.SystemConfig;
import org.jlab.coda.et.SystemCreate;

class ListeningThread
extends Thread {
    private boolean isIpAddr;
    private InetAddress addr;
    private SystemCreate sys;
    private SystemConfig config;

    ListeningThread(SystemCreate systemCreate, InetAddress inetAddress) {
        this.sys = systemCreate;
        this.config = this.sys.config;
        this.addr = inetAddress;
    }

    ListeningThread(SystemCreate systemCreate, InetAddress inetAddress, boolean bl) {
        this.sys = systemCreate;
        this.config = this.sys.config;
        this.addr = inetAddress;
        this.isIpAddr = bl;
    }

    public void run() {
        Closeable closeable;
        Object object;
        DatagramSocket datagramSocket = null;
        MulticastSocket multicastSocket = null;
        try {
            if (this.isIpAddr) {
                datagramSocket = new DatagramSocket(this.config.udpPort, this.addr);
            } else if (this.addr.isMulticastAddress()) {
                multicastSocket = new MulticastSocket(this.config.multicastPort);
                multicastSocket.joinGroup(this.addr);
                datagramSocket = multicastSocket;
            } else {
                datagramSocket = new DatagramSocket(this.config.udpPort, this.addr);
            }
            datagramSocket.setReceiveBufferSize(512);
            datagramSocket.setSendBufferSize(512);
        }
        catch (SocketException socketException) {
            if (this.config.debug >= 2) {
                System.out.println("Port " + this.config.udpPort + " is taken or bad interface address");
                System.out.println("Try making the udp port different from the multicast port");
            }
            return;
        }
        catch (IOException iOException) {
            if (this.config.debug >= 2) {
                System.out.println("cannot listen on multicast address " + this.addr);
                iOException.printStackTrace();
            }
            return;
        }
        byte[] byArray = new byte[512];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 512);
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            object = InetAddress.getLocalHost().getHostName();
            int n = 12 + this.addr.getHostName().length() + 1 + 4 + this.addr.getHostAddress().length() + 1 + 4 + ((String)object).length() + 1;
            byteArrayOutputStream = new ByteArrayOutputStream(n);
            closeable = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)closeable).writeInt(8);
            ((DataOutputStream)closeable).writeInt(this.config.serverPort);
            if (this.isIpAddr) {
                ((DataOutputStream)closeable).writeInt(this.addr.getHostName().length() + 1);
                ((FilterOutputStream)closeable).write(this.addr.getHostName().getBytes("ASCII"));
                ((DataOutputStream)closeable).writeByte(0);
            } else {
                ((DataOutputStream)closeable).writeInt(((String)object).length() + 1);
                ((FilterOutputStream)closeable).write(((String)object).getBytes("ASCII"));
                ((DataOutputStream)closeable).writeByte(0);
            }
            if (this.isIpAddr) {
                ((DataOutputStream)closeable).writeInt(this.addr.getHostAddress().length() + 1);
                ((FilterOutputStream)closeable).write(this.addr.getHostAddress().getBytes("ASCII"));
                ((DataOutputStream)closeable).writeByte(0);
            } else {
                String string = InetAddress.getLocalHost().getHostAddress();
                ((DataOutputStream)closeable).writeInt(string.length() + 1);
                ((FilterOutputStream)closeable).write(string.getBytes("ASCII"));
                ((DataOutputStream)closeable).writeByte(0);
            }
            ((DataOutputStream)closeable).writeInt(((String)object).length() + 1);
            ((FilterOutputStream)closeable).write(((String)object).getBytes("ASCII"));
            ((DataOutputStream)closeable).writeByte(0);
            ((DataOutputStream)closeable).flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = byteArrayOutputStream.toByteArray();
        {
            while (true) {
                try {
                    datagramSocket.receive(datagramPacket);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!this.sys.killAllThreads) continue;
                    return;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
                closeable = new DataInputStream(byteArrayInputStream);
                int n = ((DataInputStream)closeable).readInt();
                int n2 = ((DataInputStream)closeable).readInt();
                if (n != 8 || n2 < 1 || n2 > 101) continue;
                String string = new String(datagramPacket.getData(), 8, n2 - 1, "ASCII");
                if (this.config.debug >= 4) {
                    System.out.println("et_listen_thread: received packet from " + datagramPacket.getAddress().getHostName() + " @ " + datagramPacket.getAddress().getHostAddress() + " for " + string);
                }
                if (!string.equals(this.sys.name)) continue;
                DatagramPacket datagramPacket2 = new DatagramPacket((byte[])object, ((Object)object).length, datagramPacket.getAddress(), datagramPacket.getPort());
                if (this.config.debug >= 4) {
                    System.out.println("et_listen_thread: send return packet");
                }
                datagramSocket.send(datagramPacket2);
            }
        }
    }
}

