/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jlab.coda.et.AttachmentLocal;
import org.jlab.coda.et.EtEmptyException;
import org.jlab.coda.et.EtTimeoutException;
import org.jlab.coda.et.EtWakeUpException;
import org.jlab.coda.et.Event;

class EventList {
    LinkedList events = new LinkedList();
    long eventsIn;
    long eventsOut;
    long eventsTry;
    volatile boolean locked;
    private boolean wakeAll;
    private int waitingCount;
    private int lastHigh;

    EventList() {
    }

    synchronized void wakeUp(AttachmentLocal attachmentLocal) {
        if (!attachmentLocal.waiting) {
            return;
        }
        attachmentLocal.wakeUp = true;
        this.notifyAll();
    }

    synchronized void wakeUpAll() {
        if (this.waitingCount < 1) {
            return;
        }
        this.wakeAll = true;
        this.notifyAll();
    }

    void putInLow(List list) {
        this.events.addAll(list);
        this.eventsIn += (long)list.size();
    }

    synchronized void putInGC(Event[] eventArray) {
        this.putInLow(Arrays.asList(eventArray));
    }

    synchronized void putInGC(List list) {
        this.putInLow(list);
    }

    void putAll(List list) {
        int n = list.size();
        if (this.events.size() == 0) {
            this.events.addAll(list);
        } else if (((Event)list.get((int)0)).priority == 0) {
            this.events.addAll(list);
        } else {
            int n2 = 0;
            ListIterator listIterator = this.events.listIterator();
            while (listIterator.hasNext()) {
                if (((Event)listIterator.next()).priority != 1) break;
                ++n2;
            }
            int n3 = 0;
            int n4 = list.size();
            int n5 = 0;
            while (n5 < n4) {
                Event event = (Event)list.get(n5);
                if (event.priority != 1) break;
                this.events.add(n2 + n3++, event);
                ++n5;
            }
            if (n3 < n) {
                this.events.addAll(list.subList(n3, n));
            }
        }
        this.eventsIn += (long)n;
    }

    synchronized void put(Event[] eventArray) {
        if (this.events.size() == 0) {
            this.lastHigh = 0;
        }
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (eventArray[n2].priority == 0) {
                this.events.addLast(eventArray[n2]);
            } else {
                this.events.add(this.lastHigh++, eventArray[n2]);
            }
            ++n2;
        }
        this.notify();
    }

    synchronized void put(ArrayList arrayList) {
        if (this.events.size() == 0) {
            this.lastHigh = 0;
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Event event = (Event)arrayList.get(n2);
            if (event.priority == 0) {
                this.events.addLast(event);
            } else {
                this.events.add(this.lastHigh++, event);
            }
            ++n2;
        }
        this.notify();
    }

    synchronized void get(ArrayList arrayList) {
        arrayList.addAll(this.events);
        this.eventsOut += (long)this.events.size();
        this.events.clear();
    }

    synchronized Event[] get(AttachmentLocal attachmentLocal, int n, int n2, int n3) throws EtEmptyException, EtWakeUpException, EtTimeoutException {
        this.locked = true;
        int n4 = this.events.size();
        if (n4 == 0) {
            if (n == 0) {
                while (n4 < 1) {
                    ++this.waitingCount;
                    attachmentLocal.waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (attachmentLocal.wakeUp || this.wakeAll) {
                        attachmentLocal.wakeUp = false;
                        attachmentLocal.waiting = false;
                        if (--this.waitingCount < 1) {
                            this.wakeAll = false;
                        }
                        throw new EtWakeUpException("attachment " + attachmentLocal.id + " woken up");
                    }
                    attachmentLocal.waiting = false;
                    --this.waitingCount;
                    n4 = this.events.size();
                }
            } else if (n == 1) {
                long l = n2 / 1000;
                int n5 = 1000 * (n2 - (int)(l * 1000L));
                ++this.waitingCount;
                attachmentLocal.waiting = true;
                try {
                    this.wait(l, n5);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (attachmentLocal.wakeUp || this.wakeAll) {
                    attachmentLocal.wakeUp = false;
                    attachmentLocal.waiting = false;
                    if (--this.waitingCount < 1) {
                        this.wakeAll = false;
                    }
                    throw new EtWakeUpException("attachment " + attachmentLocal.id + " woken up");
                }
                attachmentLocal.waiting = false;
                --this.waitingCount;
                n4 = this.events.size();
                if (n4 < 1) {
                    throw new EtTimeoutException("timed out");
                }
            } else if (n == 2) {
                throw new EtEmptyException("no events in list");
            }
        }
        if (n3 > n4) {
            n3 = n4;
        }
        List list = this.events.subList(0, n3);
        Event[] eventArray = new Event[n3];
        list.toArray(eventArray);
        list.clear();
        this.eventsOut += (long)n3;
        this.locked = false;
        return eventArray;
    }
}

