/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import org.jlab.coda.et.EtException;

/*
 * Exception performing whole class analysis ignored.
 */
public class Event {
    private static final int numSelectInts = 4;
    private static final int[] controlInitValues = new int[4];
    private static final int newAge = 1;
    private static final int system = -1;
    private static final int high = 1;
    private static final int low = 0;
    private static final int ok = 0;
    int id;
    int age;
    int priority;
    int owner;
    int length;
    int memSize;
    int sizeLimit;
    int dataStatus;
    int byteOrder;
    int modify;
    int[] control;
    byte[] data;
    boolean isJava;

    Event(int n) {
        this.memSize = n;
        this.isJava = true;
        this.data = new byte[this.memSize];
        this.control = new int[4];
        this.init();
    }

    Event(int n, int n2, boolean bl) {
        this.memSize = n;
        this.sizeLimit = n2;
        this.isJava = bl;
        this.data = new byte[this.memSize];
        this.control = new int[4];
        this.init();
    }

    void init() {
        this.age = 1;
        this.priority = 0;
        this.owner = -1;
        this.length = 0;
        this.modify = 0;
        this.byteOrder = 67305985;
        this.dataStatus = 0;
        System.arraycopy(controlInitValues, 0, this.control, 0, 4);
    }

    public int getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getLength() {
        return this.length;
    }

    public int getMemSize() {
        return this.memSize;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public int getDataStatus() {
        return this.dataStatus;
    }

    public int getModify() {
        return this.modify;
    }

    public int[] getControl() {
        return (int[])this.control.clone();
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] copyData() {
        return (byte[])this.data.clone();
    }

    public void setData(byte[] byArray) throws EtException {
        if (!this.isJava && this.data.length > this.sizeLimit) {
            throw new EtException("data array is too big, limit is " + this.sizeLimit + " bytes");
        }
        this.data = byArray;
        this.length = byArray.length;
        this.memSize = byArray.length;
    }

    public void copyDataIn(byte[] byArray) throws EtException {
        if (byArray.length > this.memSize) {
            throw new EtException("data array is too big, limit is " + this.memSize + " bytes");
        }
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
        this.length = byArray.length;
    }

    public void copyDataIn(byte[] byArray, int n, int n2, int n3) throws EtException {
        if (n3 > this.data.length) {
            throw new EtException("too much data, try using \"setData\" method");
        }
        System.arraycopy(byArray, n, this.data, n2, n3);
    }

    public void setPriority(int n) throws EtException {
        if (n != 0 && n != 1) {
            throw new EtException("bad value for event priority");
        }
        this.priority = n;
    }

    public void setLength(int n) throws EtException {
        if (n < 0) {
            throw new EtException("bad value for event data length");
        }
        this.length = n;
    }

    public void setControl(int[] nArray) throws EtException {
        if (nArray.length != 4) {
            throw new EtException("wrong number of elements in control array");
        }
        System.arraycopy(nArray, 0, this.control, 0, 4);
    }

    public void setDataStatus(int n) throws EtException {
        if (n != 0 && n != 1 && n != 2) {
            throw new EtException("bad value for data status");
        }
        this.dataStatus = n;
    }

    public int getByteOrder() {
        int n = this.byteOrder == 67305985 ? 0 : 1;
        return n;
    }

    public void setByteOrder(int n) throws EtException {
        if (n == 0) {
            this.byteOrder = 67305985;
        } else if (n == 1) {
            this.byteOrder = 16909060;
        } else if (n == 2) {
            this.byteOrder = 67305985;
        } else if (n == 3) {
            this.byteOrder = 16909060;
        } else if (n == 4) {
            this.byteOrder = Event.swapInt((int)this.byteOrder);
        } else {
            throw new EtException("bad value for byte order");
        }
    }

    public boolean needToSwap() throws EtException {
        if (this.byteOrder == 67305985) {
            return false;
        }
        if (this.byteOrder == 16909060) {
            return true;
        }
        throw new EtException("byteOrder member has bad value");
    }

    public void codaSwap() {
        int n = 16;
        int[] nArray = new int[]{0, 2, 2, 0, 1, 1, 0, 0, 3, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int n2 = 0;
        int n3 = 0;
        boolean bl = this.byteOrder == 67305985;
        this.byteOrder = Event.swapInt((int)this.byteOrder);
        while (n2 < this.length / 4) {
            int n4;
            int n5;
            n3 = 4 * n2;
            int n6 = Event.bytesToInt((byte[])this.data, (int)n3);
            int n7 = Event.bytesToInt((byte[])this.data, (int)(n3 + 4));
            if (bl) {
                n5 = n6 - 1;
                n4 = (n7 & 0xFF00) >>> 8;
            } else {
                n5 = Event.swapInt((int)n6) - 1;
                n4 = (Event.swapInt((int)n7) & 0xFF00) >>> 8;
            }
            Event.intToBytes((int)Event.swapInt((int)n6), (byte[])this.data, (int)n3);
            Event.intToBytes((int)Event.swapInt((int)n7), (byte[])this.data, (int)(n3 + 4));
            n2 += 2;
            n3 += 8;
            if (n4 == n) continue;
            switch (nArray[n4]) {
                case 0: {
                    n2 += n5;
                    break;
                }
                case 1: {
                    int n8 = 0;
                    while (n8 < n5 << 1) {
                        Event.swapArrayShort((byte[])this.data, (int)n3);
                        n3 += 2;
                        ++n8;
                    }
                    n2 += n5;
                    break;
                }
                case 2: 
                case 3: {
                    int n9 = 0;
                    while (n9 < n5) {
                        Event.swapArrayInt((byte[])this.data, (int)n3);
                        n3 += 4;
                        ++n9;
                    }
                    n2 += n5;
                    break;
                }
                default: {
                    n2 += n5;
                }
            }
        }
    }

    public static final int swapInt(int n) {
        return n << 24 | n >>> 24 | (n & 0xFF00) << 8 | (n & 0xFF0000) >>> 8;
    }

    public static final short swapShort(short s) {
        return (short)(s << 8 | s >>> 8);
    }

    public static final int bytesToInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        return n2;
    }

    public static final void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 0xFF000000) >>> 24);
        byArray[n2 + 1] = (byte)((n & 0xFF0000) >>> 16);
        byArray[n2 + 2] = (byte)((n & 0xFF00) >>> 8);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    public static final void swapArrayInt(byte[] byArray, int n) {
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        byte by3 = byArray[n + 2];
        byte by4 = byArray[n + 3];
        byArray[n + 3] = by;
        byArray[n + 2] = by2;
        byArray[n + 1] = by3;
        byArray[n] = by4;
    }

    public static final short bytesToShort(byte[] byArray, int n) {
        short s = (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
        return s;
    }

    public static final void shortToBytes(short s, byte[] byArray, int n) {
        byArray[n] = (byte)((s & 0xFF00) >>> 8);
        byArray[n + 1] = (byte)(s & 0xFF);
    }

    public static final void swapArrayShort(byte[] byArray, int n) {
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        byArray[n + 1] = by;
        byArray[n] = by2;
    }
}

