/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test.blast;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.data.RingItemFactory;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.EvioCompactReaderUnsync;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;

public class EmuBlastee {
    private AtomicInteger clientNumber = new AtomicInteger(1);
    private AtomicInteger clientCount = new AtomicInteger(0);
    private volatile boolean killThreads;
    private boolean direct;
    private boolean parseData;
    private ConcurrentHashMap<Integer, ByteBufferSupply> allSupplies = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ClientHandler> clients = new ConcurrentHashMap();
    private ClientMergerForBuffers mergerForBuffersThread;
    private ClientMergerForEvio mergerForEvioThread;
    private int bufferSize = 8192;
    private int receiveBufferSize = 32768;
    private int blasteePort = 22333;
    private int blockCount = 4;
    private boolean noDelay;
    private int timeInterval = 5;
    private long messageCount = 0L;
    private volatile long byteCount = 0L;
    private Statistics statThread;

    private static void usage() {
        System.out.println("\nUsage:\n\n   java EmuBlastee\n        [-d <buf size>]    reading data buffer size in bytes (8192)\n        [-r <buf size>]    TCP receive buffer size in bytes (4*8192)\n        [-b <blocks>]      number of buffers to read in one loop (4)\n        [-p <port>]        TCP port (22333)\n        [-t <seconds>]     time between printouts in sec (5)\n        [-parse]           parse data into evio events and place in ring\n        [-help]            print this message\n");
    }

    public static void main(String[] args) {
        try {
            EmuBlastee blastee = new EmuBlastee(args);
            blastee.run();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void stopServer() {
    }

    public EmuBlastee(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        boolean setReceiveBufSize = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-help")) {
                    EmuBlastee.usage();
                    System.exit(-1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-d")) {
                    this.bufferSize = Integer.parseInt(args[i + 1]);
                    if (this.bufferSize < 1) {
                        System.out.println("Data buffer size must be > 0");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-r")) {
                    this.receiveBufferSize = Integer.parseInt(args[i + 1]);
                    if (this.receiveBufferSize < 1) {
                        System.out.println("TCP receive buffer size must be > 0");
                        System.exit(1);
                    }
                    setReceiveBufSize = true;
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-b")) {
                    this.blockCount = Integer.parseInt(args[i + 1]);
                    if (this.blockCount < 1) {
                        System.out.println("Number of blocks must be > 0");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-p")) {
                    this.blasteePort = Integer.parseInt(args[i + 1]);
                    if (this.blasteePort < 1024 || this.blasteePort > 65535) {
                        System.out.println("Port must be > 1023 & < 65536");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-parse")) {
                    this.parseData = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-t")) {
                    this.timeInterval = Integer.parseInt(args[i + 1]);
                    if (this.timeInterval < 1) {
                        this.timeInterval = 1;
                    }
                    ++i;
                    continue;
                }
                EmuBlastee.usage();
                System.exit(-1);
            }
        }
        catch (Exception ex) {
            EmuBlastee.usage();
            System.exit(-1);
        }
        if (!setReceiveBufSize) {
            this.receiveBufferSize = this.bufferSize <= 8192 ? 32768 : 4 * this.bufferSize;
        }
    }

    public void run() {
        this.statThread = new Statistics();
        this.statThread.start();
        if (this.parseData) {
            this.mergerForEvioThread = new ClientMergerForEvio();
        } else {
            this.mergerForBuffersThread = new ClientMergerForBuffers();
        }
        try {
            ServerSocket listeningSocket = new ServerSocket();
            listeningSocket.setReuseAddress(true);
            listeningSocket.setReceiveBufferSize(this.receiveBufferSize);
            listeningSocket.setPerformancePreferences(0, 0, 1);
            listeningSocket.bind(new InetSocketAddress(this.blasteePort));
            while (true) {
                Socket socket = listeningSocket.accept();
                new ClientHandler(socket);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    private class Statistics
    extends Thread {
        private boolean init;
        private long totalBytes;
        private long oldVal;
        private long totalT;
        private long totalCount;
        long localByteCount;
        long t;
        long deltaT;
        long deltaCount;
        private int skip = 2;

        private Statistics() {
        }

        private synchronized void clear() {
            this.totalBytes = 0L;
            this.totalT = 0L;
            this.totalCount = 0L;
            EmuBlastee.this.byteCount = 0L;
            EmuBlastee.this.messageCount = 0L;
            this.oldVal = 0L;
            this.skip = 2;
            this.init = true;
            this.t = System.currentTimeMillis();
        }

        @Override
        public void run() {
            int sleepTime = 1000 * EmuBlastee.this.timeInterval;
            this.clear();
            while (true) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.localByteCount = EmuBlastee.this.byteCount;
                this.deltaT = System.currentTimeMillis() - this.t;
                if (this.localByteCount > 0L) {
                    if (!this.init) {
                        this.totalBytes += this.localByteCount;
                    }
                    if (this.skip-- < 1) {
                        this.totalT += this.deltaT;
                        this.deltaCount = this.totalBytes - this.oldVal;
                        this.totalCount += this.deltaCount;
                        System.out.printf("%3.2e bytes/s in %d sec, %3.2e avg,  Messages: %d Hz,  %d blasters\n", (double)this.deltaCount * 1000.0 / (double)this.deltaT, EmuBlastee.this.timeInterval, (double)this.totalCount * 1000.0 / (double)this.totalT, EmuBlastee.this.messageCount * 1000L / this.deltaT, EmuBlastee.this.clientCount.get());
                    } else {
                        System.out.printf("%3.2e bytes/s in %d sec,  Messages: %d Hz,  %d blasters\n", (double)this.localByteCount * 1000.0 / (double)this.deltaT, EmuBlastee.this.timeInterval, EmuBlastee.this.messageCount * 1000L / this.deltaT, EmuBlastee.this.clientCount.get());
                    }
                    this.t = System.currentTimeMillis();
                    this.init = false;
                    this.oldVal = this.totalBytes;
                    EmuBlastee.this.byteCount = 0L;
                    EmuBlastee.this.messageCount = 0L;
                    continue;
                }
                System.out.println("No bytes read in the last " + EmuBlastee.this.timeInterval + " seconds.");
                this.clear();
            }
        }
    }

    private class ClientMergerForEvio
    extends Thread {
        ClientMergerForEvio() {
            this.start();
        }

        @Override
        public void run() {
            long counter = 0L;
            try {
                block2: while (true) {
                    Iterator iterator = EmuBlastee.this.clients.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        ClientHandler client = (ClientHandler)iterator.next();
                        if (client.availableSequence <= client.nextSequence) {
                            client.availableSequence = client.barrier.waitFor(client.nextSequence);
                        }
                        RingItem ri = (RingItem)client.ringBuffer.get(client.nextSequence);
                        client.sequence.set(client.nextSequence++);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private class ClientMergerForBuffers
    extends Thread {
        ClientMergerForBuffers() {
            this.start();
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    Iterator iterator = EmuBlastee.this.allSupplies.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        ByteBufferSupply supply = (ByteBufferSupply)iterator.next();
                        ByteBufferItem item = supply.consumerGet();
                        supply.release(item);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private class ClientHandler
    extends Thread {
        Socket socket;
        BufferedInputStream in;
        ByteBufferSupply bbSupply;
        int me;
        long nextSequence;
        long availableSequence = -1L;
        Sequence sequence;
        SequenceBarrier barrier;
        RingBuffer<RingItem> ringBuffer;

        ClientHandler(Socket socket) {
            this.socket = socket;
            this.start();
        }

        @Override
        public void run() {
            boolean blasteeStop = false;
            this.me = EmuBlastee.this.clientNumber.getAndIncrement();
            DataInputStream in = null;
            BufferedInputStream bufferedIn = null;
            SocketChannel channel = null;
            Thread parsingThread = null;
            ByteBuffer wordCmdBuf = ByteBuffer.allocate(8);
            IntBuffer ibuf = wordCmdBuf.asIntBuffer();
            System.out.println("Start handling client " + this.me + ", bufferSize = " + EmuBlastee.this.bufferSize);
            try {
                channel = this.socket.getChannel();
                this.socket.setPerformancePreferences(0, 0, 1);
                if (EmuBlastee.this.receiveBufferSize > 0) {
                    this.socket.setReceiveBufferSize(EmuBlastee.this.receiveBufferSize);
                }
                SocketChannel socketChannel = this.socket.getChannel();
                bufferedIn = new BufferedInputStream(this.socket.getInputStream());
                in = new DataInputStream(bufferedIn);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bbSupply = new ByteBufferSupply(16, EmuBlastee.this.bufferSize, ByteOrder.BIG_ENDIAN, EmuBlastee.this.direct, true);
            if (EmuBlastee.this.parseData) {
                this.ringBuffer = RingBuffer.createSingleProducer((EventFactory)new RingItemFactory(), (int)4096, (WaitStrategy)new YieldingWaitStrategy());
                this.barrier = this.ringBuffer.newBarrier(new Sequence[0]);
                this.sequence = new Sequence(-1L);
                this.ringBuffer.addGatingSequences(new Sequence[]{this.sequence});
                this.nextSequence = this.sequence.get() + 1L;
                EmuBlastee.this.clients.put(this.me, this);
                parsingThread = new ParsingThread();
            }
            EmuBlastee.this.allSupplies.put(this.me, this.bbSupply);
            EmuBlastee.this.clientCount.getAndIncrement();
            EmuBlastee.this.statThread.clear();
            block7: while (true) {
                if (blasteeStop) {
                    if (!EmuBlastee.this.parseData) break;
                    parsingThread.stop();
                    break;
                }
                int blocks = 0;
                while (true) {
                    int size;
                    if (blocks >= EmuBlastee.this.blockCount) continue block7;
                    ByteBufferItem item = null;
                    try {
                        int cmd;
                        item = this.bbSupply.get();
                        ByteBuffer buf = item.getBuffer();
                        byte[] array = item.getBuffer().array();
                        if (EmuBlastee.this.direct) {
                            channel.read(wordCmdBuf);
                            cmd = ibuf.get();
                            size = ibuf.get();
                            ibuf.position(0);
                            wordCmdBuf.position(0);
                            buf.limit(size);
                            while (buf.position() < buf.limit()) {
                                channel.read(buf);
                            }
                            buf.flip();
                            buf.position(0).limit(size);
                        } else {
                            long cmdAndSize = in.readLong();
                            cmd = (int)(cmdAndSize >>> 32 & 0xFFL);
                            size = (int)cmdAndSize;
                            buf.limit(size);
                            in.readFully(array, 0, size);
                        }
                    }
                    catch (InterruptedException ex) {
                        blasteeStop = true;
                        continue block7;
                    }
                    catch (IOException ex) {
                        blasteeStop = true;
                        continue block7;
                    }
                    this.bbSupply.publish(item);
                    EmuBlastee.this.byteCount = EmuBlastee.this.byteCount + (long)(size + 8);
                    EmuBlastee.this.messageCount++;
                    ++blocks;
                }
                break;
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Blaster " + this.me + " quitting");
            EmuBlastee.this.allSupplies.remove(this.me);
            EmuBlastee.this.clientCount.getAndDecrement();
            if (EmuBlastee.this.parseData) {
                EmuBlastee.this.mergerForEvioThread.stop();
                EmuBlastee.this.mergerForEvioThread = new ClientMergerForEvio();
            } else {
                EmuBlastee.this.mergerForBuffersThread.stop();
                EmuBlastee.this.mergerForBuffersThread = new ClientMergerForBuffers();
            }
            EmuBlastee.this.statThread.clear();
        }

        private class ParsingThread
        extends Thread {
            boolean isER = false;

            ParsingThread() {
                this.start();
            }

            @Override
            public void run() {
                System.out.println("Parsing Thread started");
                long counter = 0L;
                try {
                    while (true) {
                        ByteBufferItem item = ClientHandler.this.bbSupply.consumerGet();
                        this.parseToRing(item);
                        ClientHandler.this.bbSupply.release(item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }

            private final void parseToRing(ByteBufferItem item) throws IOException, EvioException {
                boolean isUser = false;
                boolean dumpData = false;
                boolean haveInputEndEvent = false;
                ControlType controlType = null;
                EvioCompactReaderUnsync compactReader = null;
                int id = 0;
                int sourceId = 0;
                ByteBuffer buf = item.getBuffer();
                try {
                    if (compactReader == null) {
                        compactReader = new EvioCompactReaderUnsync(buf);
                    } else {
                        compactReader.setBuffer(buf);
                    }
                }
                catch (EvioException e) {
                    System.out.println("EmuBlastee: data NOT evio v4 format");
                    throw e;
                }
                BlockHeaderV4 blockHeader = compactReader.getFirstBlockHeader();
                if (blockHeader.getVersion() < 4) {
                    System.out.println("EmuBlastee: data NOT evio v4 format");
                    throw new EvioException("Data not in evio v4 format");
                }
                boolean hasFirstEvent = blockHeader.hasFirstEvent();
                EventType eventType = EventType.getEventType(blockHeader.getEventType());
                if (eventType == null) {
                    System.out.println("EmuBlastee: bad format evio block header");
                    throw new EvioException("bad format evio block header");
                }
                int recordId = blockHeader.getNumber();
                int eventCount = compactReader.getEventCount();
                item.setUsers(eventCount);
                for (int i = 1; i < eventCount + 1; ++i) {
                    EvioNode node = this.isER ? compactReader.getEvent(i) : compactReader.getScannedEvent(i);
                    if (eventType == EventType.ROC_RAW) {
                        if (Evio.isUserEvent(node)) {
                            isUser = true;
                            eventType = EventType.USER;
                            if (hasFirstEvent) {
                                System.out.println("EmuBlastee: FIRST event from ROC RAW");
                            } else {
                                System.out.println("EmuBlastee: USER event from ROC RAW");
                            }
                        }
                    } else if (eventType == EventType.CONTROL) {
                        controlType = ControlType.getControlType(node.getTag());
                        System.out.println("EmuBlastee: " + (Object)((Object)controlType) + " event from ROC");
                        if (controlType == null) {
                            System.out.println("EmuBlastee: found unidentified control event");
                            throw new EvioException("Found unidentified control event");
                        }
                    } else if (eventType == EventType.USER) {
                        isUser = true;
                        if (hasFirstEvent) {
                            System.out.println("EmuBlastee: FIRST event");
                        } else {
                            System.out.println("EmuBlastee: USER event");
                        }
                    }
                    if (dumpData) {
                        ClientHandler.this.bbSupply.release(item);
                        continue;
                    }
                    long nextRingItem = ClientHandler.this.ringBuffer.next();
                    RingItem ri = (RingItem)ClientHandler.this.ringBuffer.get(nextRingItem);
                    if (eventType.isBuildable()) {
                        ri.setAll(null, null, node, eventType, controlType, isUser, hasFirstEvent, id, recordId, sourceId, node.getNum(), "Blaster", item, ClientHandler.this.bbSupply);
                    } else {
                        ri.setAll(null, null, node, eventType, controlType, isUser, hasFirstEvent, id, recordId, sourceId, 1, "Blaster", item, ClientHandler.this.bbSupply);
                    }
                    hasFirstEvent = false;
                    isUser = false;
                    ClientHandler.this.ringBuffer.publish(nextRingItem);
                    if (controlType != ControlType.END) continue;
                    System.out.println("EmuBlastee: found END event");
                    haveInputEndEvent = true;
                    break;
                }
            }
        }
    }
}

