/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.emu.EmuUtilities;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtStationConfig;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.enums.Mode;
import org.jlab.coda.et.exception.EtExistsException;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;

public class ReceiverEt {
    private String name = "Looker";
    private String etName = "/tmp/emuOut";
    private int delay = 1000;
    private boolean debug;
    private EtSystem sys;
    private EtStation station;
    private EtAttachment att;

    ReceiverEt(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                ReceiverEt.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-f")) {
                this.etName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            ReceiverEt.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java ReceiverEt\n        [-n <name>]          client name\n        [-f <et filename>]   et system filename\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            ReceiverEt receiver = new ReceiverEt(args);
            receiver.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run() {
        if (this.debug) {
            System.out.println("Running ReceiverEt\n");
        }
        try {
            EtSystemOpenConfig config = new EtSystemOpenConfig(this.etName, "localhost", 12349);
            this.sys = new EtSystem(config, 4);
            this.sys.open();
            try {
                this.station = this.sys.createStation(new EtStationConfig(), "getMeEvents");
            }
            catch (EtExistsException e) {
                this.station = this.sys.stationNameToObject("getMeEvents");
            }
            this.att = this.sys.attach(this.station);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        EmuUtilities.inputStr("Enter to GO");
        receiveDataThread receiver = new receiveDataThread();
        receiver.start();
        EmuUtilities.inputStr("Enter to QUIT");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class receiveDataThread
    extends Thread {
        receiveDataThread() {
        }

        @Override
        public void run() {
            if (ReceiverEt.this.debug) {
                System.out.println("Running ReceiverEt as EMU's bitbucket\n");
            }
            int chunk = 300;
            int count = 0;
            long totalT = 0L;
            long totalCount = 0L;
            long t1 = System.currentTimeMillis();
            try {
                for (int i = 0; i < 50; ++i) {
                    while ((long)count < 300000L) {
                        EtEvent[] mevs = ReceiverEt.this.sys.getEvents(ReceiverEt.this.att, Mode.SLEEP, null, 0, chunk);
                        if (count == 0) {
                            t1 = System.currentTimeMillis();
                        }
                        for (EtEvent mev : mevs) {
                            int[] con;
                            ByteBuffer buf = mev.getDataBuffer();
                            System.out.println("event's data buffer is " + buf.order() + ", limit = " + buf.limit() + ", capacity = " + buf.capacity());
                            System.out.println("swap = " + mev.needToSwap());
                            if (mev.needToSwap()) {
                                buf.order(ByteOrder.LITTLE_ENDIAN);
                            }
                            EvioReader parser = new EvioReader(buf);
                            try {
                                EvioEvent ev = parser.parseNextEvent();
                                System.out.println("Event = \n" + ev.toXML());
                            }
                            catch (EvioException e) {
                                System.out.println("Event NOT in evio foramt");
                            }
                            System.out.println("buffer cap = " + buf.capacity() + ", lim = " + buf.limit() + ", pos = " + buf.position());
                            int num = mev.getDataBuffer().getInt(0);
                            System.out.println("data byte order = " + mev.getByteOrder());
                            if (mev.needToSwap()) {
                                System.out.println("    data swap = " + Integer.reverseBytes(num));
                            } else {
                                System.out.println("    data = " + num);
                            }
                            for (int j : con = mev.getControl()) {
                                System.out.print(j + " ");
                            }
                            System.out.println("pri = " + mev.getPriority());
                        }
                        ReceiverEt.this.sys.putEvents(ReceiverEt.this.att, mevs);
                        count += mevs.length;
                    }
                    long t2 = System.currentTimeMillis();
                    double rate = 1000.0 * (double)count / (double)(t2 - t1);
                    double avgRate = 1000.0 * (double)(totalCount += (long)count) / (double)(totalT += t2 - t1);
                    System.out.println("rate = " + String.format("%.3g", rate) + " Hz,   avg = " + String.format("%.3g", avgRate));
                    count = 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

