/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.emu.test.LocalEmuDomainServer;

class LocalEmuDomainUdpListener
extends Thread {
    private LocalEmuDomainServer server;
    private int multicastPort;
    private int tcpPort;
    private MulticastSocket multicastSocket;
    private int debug = 4;
    private String expid;
    private String emuName;
    private volatile boolean killThreads;

    void killAllThreads() {
        this.killThreads = true;
        this.interrupt();
    }

    public LocalEmuDomainUdpListener(LocalEmuDomainServer server, int port, String expid, String emuName) throws cMsgException {
        this.expid = expid;
        this.emuName = emuName;
        this.multicastPort = this.tcpPort = port;
        try {
            System.out.println("Listening for multicasts on port " + this.multicastPort);
            this.multicastSocket = new MulticastSocket(this.multicastPort);
            InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName("239.230.0.0"), this.multicastPort);
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || !ni.supportsMulticast() || ni.isLoopback()) continue;
                this.multicastSocket.joinGroup(sa, ni);
            }
            this.multicastSocket.setReceiveBufferSize(65535);
            this.multicastSocket.setReuseAddress(true);
            this.multicastSocket.setTimeToLive(32);
        }
        catch (IOException e) {
            throw new cMsgException("Port " + this.multicastPort + " is taken", (Throwable)e);
        }
        this.server = server;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DatagramPacket sendPacket;
        byte[] outBuf;
        DatagramPacket packet;
        byte[] buf;
        block34: {
            if (this.debug >= 4) {
                System.out.println("Emu Multicast Listening Thread: running");
            }
            buf = new byte[2048];
            packet = new DatagramPacket(buf, 2048);
            outBuf = null;
            sendPacket = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(baos);
            ArrayList ipAddresses = new ArrayList(cMsgUtilities.getAllIpAddresses());
            List ifAddrs = cMsgUtilities.getAllIpInfo();
            try {
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(this.tcpPort);
                int addrCount = ifAddrs.size();
                out.writeInt(addrCount);
                for (InterfaceAddress ifAddr : ifAddrs) {
                    Inet4Address bAddr;
                    try {
                        bAddr = (Inet4Address)ifAddr.getBroadcast();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    String ipAddr = ifAddr.getAddress().getHostAddress();
                    out.writeInt(ipAddr.length());
                    out.write(ipAddr.getBytes("US-ASCII"));
                    String broadcastAddr = bAddr.getHostAddress();
                    out.writeInt(broadcastAddr.length());
                    out.write(broadcastAddr.getBytes("US-ASCII"));
                }
                out.flush();
                out.close();
                outBuf = baos.toByteArray();
                baos.close();
            }
            catch (IOException e) {
                if (this.debug < 2) break block34;
                System.out.println("I/O Error: " + e);
            }
        }
        LocalEmuDomainUdpListener e = this;
        synchronized (e) {
            this.notifyAll();
        }
        try {
            block24: while (true) {
                if (this.killThreads) {
                    return;
                }
                packet.setLength(2048);
                System.out.println("Emu listen: WAITING TO RECEIVE PACKET");
                this.multicastSocket.receive(packet);
                if (this.killThreads) {
                    return;
                }
                InetAddress multicasterAddress = packet.getAddress();
                String multicasterHost = multicasterAddress.getHostName();
                int multicasterUdpPort = packet.getPort();
                if (packet.getLength() < 16) {
                    if (this.debug < 3) continue;
                    System.out.println("Emu listen: got multicast packet that's too small");
                    continue;
                }
                int magic1 = cMsgUtilities.bytesToInt((byte[])buf, (int)0);
                int magic2 = cMsgUtilities.bytesToInt((byte[])buf, (int)4);
                int magic3 = cMsgUtilities.bytesToInt((byte[])buf, (int)8);
                if (magic1 != cMsgNetworkConstants.magicNumbers[0] || magic2 != cMsgNetworkConstants.magicNumbers[1] || magic3 != cMsgNetworkConstants.magicNumbers[2]) {
                    if (this.debug < 3) continue;
                    System.out.println("Emu listen: got multicast packet with bad magic #s");
                    continue;
                }
                int msgType = cMsgUtilities.bytesToInt((byte[])buf, (int)12);
                switch (msgType) {
                    case 2: {
                        System.out.println("Emu listen: client wants to connect");
                        break;
                    }
                    case 16: {
                        System.out.println("Emu listen: I was probed");
                        break;
                    }
                    default: {
                        System.out.println("Emu listen: unknown command");
                        continue block24;
                    }
                }
                int cMsgVersion = cMsgUtilities.bytesToInt((byte[])buf, (int)16);
                int nameLen = cMsgUtilities.bytesToInt((byte[])buf, (int)20);
                int expidLen = cMsgUtilities.bytesToInt((byte[])buf, (int)24);
                int pos = 28;
                if (cMsgVersion != 6) {
                    if (this.debug < 4) continue;
                    System.out.println("Emu listen: conflicting cMsg versions, client = " + cMsgVersion + ", cMsg lib = " + 6);
                    continue;
                }
                String componentName = null;
                try {
                    componentName = new String(buf, pos, nameLen, "US-ASCII");
                    pos += nameLen;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                String multicasterExpid = null;
                try {
                    multicasterExpid = new String(buf, pos, expidLen, "US-ASCII");
                    pos += expidLen;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (!this.expid.equalsIgnoreCase(multicasterExpid)) {
                    if (this.debug < 4) continue;
                    System.out.println("Emu listen: conflicting EXPIDs, got " + multicasterExpid + ", need " + this.expid);
                    continue;
                }
                if (multicasterUdpPort == this.server.localTempPort) continue;
                if (msgType == 2 && !componentName.equalsIgnoreCase(this.emuName)) {
                    if (this.debug < 4) continue;
                    System.out.println("Emu UDP listen: this emu wrong destination, I am " + this.emuName + ", client looking for " + componentName);
                    continue;
                }
                try {
                    sendPacket = new DatagramPacket(outBuf, outBuf.length, multicasterAddress, multicasterUdpPort);
                    this.multicastSocket.send(sendPacket);
                }
                catch (IOException e2) {
                    System.out.println("I/O Error: " + e2);
                }
                continue;
                break;
            }
        }
        catch (IOException e3) {
            if (this.debug < 2) return;
            System.out.println("Emu listen: I/O ERROR in emu multicast server");
            System.out.println("Emu listen: close multicast socket, port = " + this.multicastSocket.getLocalPort());
            return;
        }
        finally {
            if (!this.multicastSocket.isClosed()) {
                this.multicastSocket.close();
            }
        }
    }
}

