/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.emu.test.InputDataChannelImplEmu;
import org.jlab.coda.emu.test.LocalEmuDomainServer;

class LocalEmuDomainTcpServer
extends Thread {
    private int debug = 2;
    private final int serverPort;
    private final LocalEmuDomainServer server;
    private volatile boolean killThreads;

    void killAllThreads() {
        this.killThreads = true;
        this.interrupt();
    }

    public LocalEmuDomainTcpServer(LocalEmuDomainServer server, int serverPort) {
        this.server = server;
        this.serverPort = serverPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block53: {
            if (this.debug >= 4) {
                System.out.println("Emu domain TCP server: running");
            }
            BYTES_TO_READ = 32;
            buffer = ByteBuffer.allocateDirect(BYTES_TO_READ);
            selector = null;
            serverChannel = null;
            emuChannel = new InputDataChannelImplEmu();
            try {
                selector = Selector.open();
                try {
                    serverChannel = ServerSocketChannel.open();
                    listeningSocket = serverChannel.socket();
                    listeningSocket.setReuseAddress(true);
                    listeningSocket.setPerformancePreferences(0, 1, 2);
                    listeningSocket.bind(new InetSocketAddress(this.serverPort));
                }
                catch (IOException ex) {
                    System.out.println("Emu domain server: TCP port number " + this.serverPort + " in use.");
                    System.exit(-1);
                }
                serverChannel.configureBlocking(false);
                serverChannel.register(selector, 16);
                ex = this;
                synchronized (ex) {
                    this.notifyAll();
                }
lbl27:
                // 2 sources

                while (true) {
                    if ((n = selector.select(3000L)) == 0) {
                        if (!this.killThreads) continue;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (IOException ex) {
                System.out.println("Emu domain server: main server IO error");
                ex.printStackTrace();
                try {
                    if (serverChannel != null) {
                        serverChannel.close();
                    }
                }
                catch (IOException var6_10) {
                    // empty catch block
                }
                try {
                    if (selector != null) {
                        selector.close();
                    }
                    break block53;
                }
                catch (IOException var6_11) {}
                break block53;
            }
            catch (Throwable var21_30) {
                try {
                    if (serverChannel != null) {
                        serverChannel.close();
                    }
                }
                catch (IOException var22_31) {
                    // empty catch block
                }
                try {
                    if (selector == null) throw var21_30;
                    selector.close();
                    throw var21_30;
                }
                catch (IOException var22_32) {
                    // empty catch block
                }
                throw var21_30;
            }
            try {
                if (serverChannel != null) {
                    serverChannel.close();
                }
            }
            catch (IOException var7_13) {
                // empty catch block
            }
            try {
                if (selector == null) return;
                selector.close();
                return;
            }
            catch (IOException var7_14) {
                // empty catch block
            }
            return;
lbl-1000:
            // 1 sources

            {
                System.out.println("Emu domain server: someone trying to connect");
                it = selector.selectedKeys().iterator();
                block26: while (true) {
                    if (it.hasNext()) ** break;
                    ** continue;
                    key = it.next();
                    if (key.isValid() && key.isAcceptable()) {
                        channel = serverChannel.accept();
                        codaId = -1;
                        bufferSizeDesired = -1;
                        socketCount = -1;
                        socketPosition = -1;
                        bytesRead = 0;
                        loops = 0;
                        buffer.clear();
                        buffer.limit(BYTES_TO_READ);
                        channel.configureBlocking(false);
                        while (bytesRead < BYTES_TO_READ) {
                            if (this.debug >= 4) {
                                System.out.println("Emu domain server: try reading rest of Buffer");
                            }
                            if ((bytes = channel.read(buffer)) == -1) {
                                channel.close();
                                it.remove();
                                continue block26;
                            }
                            bytesRead += bytes;
                            if (this.debug >= 4) {
                                System.out.println("Emu domain server: bytes read = " + bytesRead);
                            }
                            if (bytesRead >= BYTES_TO_READ) {
                                buffer.flip();
                                magic1 = buffer.getInt();
                                magic2 = buffer.getInt();
                                magic3 = buffer.getInt();
                                if (magic1 != cMsgNetworkConstants.magicNumbers[0] || magic2 != cMsgNetworkConstants.magicNumbers[1] || magic3 != cMsgNetworkConstants.magicNumbers[2]) {
                                    if (this.debug >= 4) {
                                        System.out.println("Emu domain server: Magic #s did NOT match, ignore");
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                version = buffer.getInt();
                                if (version != 6) {
                                    if (this.debug >= 4) {
                                        System.out.println("Emu domain server: version mismatch, got " + version + ", needed " + 6);
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                codaId = buffer.getInt();
                                if (codaId < 0) {
                                    if (this.debug >= 4) {
                                        System.out.println("Emu domain server: bad coda id of sender (" + codaId + ')');
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                bufferSizeDesired = buffer.getInt();
                                if (bufferSizeDesired < 40) {
                                    if (this.debug >= 4) {
                                        System.out.println("Emu domain server: bad buffer size from sender (" + bufferSizeDesired + ')');
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                socketCount = buffer.getInt();
                                System.out.println("Got socket count = " + socketCount);
                                if (socketCount < 1) {
                                    if (this.debug >= 4) {
                                        System.out.println("    Transport Emu: domain server, bad socket count of sender (" + socketCount + ')');
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                socketPosition = buffer.getInt();
                                System.out.println("Got socket position = " + socketPosition);
                                if (socketCount >= 1) continue;
                                if (this.debug >= 4) {
                                    System.out.println("    Transport Emu: domain server, bad socket position of sender (" + socketPosition + ')');
                                }
                                channel.close();
                                it.remove();
                                continue block26;
                            }
                            if (++loops > 10) {
                                channel.close();
                                it.remove();
                                continue block26;
                            }
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException magic1) {}
                        }
                        channel.configureBlocking(true);
                        try {
                            emuChannel.attachToInput(channel, codaId, bufferSizeDesired, socketCount, socketPosition);
                        }
                        catch (IOException e) {
                            if (this.debug >= 4) {
                                System.out.println("Emu domain server: " + e.getMessage());
                            }
                            channel.close();
                            it.remove();
                            continue;
                        }
                        if (this.debug >= 4) {
                            System.out.println("Emu domain server: new connection");
                        }
                    }
                    it.remove();
                }
            }
        }
        if (this.debug < 4) return;
        System.out.println("Emu domain server: quitting");
    }
}

