/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.enums.Mode;
import org.jlab.coda.jevio.ByteDataTransformer;

public class InjectFirstEvent {
    private static void usage() {
        System.out.println("\nUsage: java InjectFirstEvent -f <et name>\n                      [-h] [-v] [-r] [-m]\n                      [-host <ET host>] [-w <big endian? 0/1>]\n                      [-g <group>] [-d <delay>] [-p <ET port>]\n                      [-i <interface address>] [-a <mcast addr>]\n                      \n\n       -f     ET system's (memory-mapped file) name\n       -host  ET system's host if direct connection (default to local)\n       -h     help\n       -v     verbose output\n\n       -g     group from which to get new events (1,2,...)\n       -d     delay in millisec between each round of getting and putting events\n\n       -p     ET port (TCP for direct, UDP for broad/multicast)\n       -r     act as remote (TCP) client even if ET system is local\n       -i     outgoing network interface address (dot-decimal)\n       -a     multicast address(es) (dot-decimal), may use multiple times\n       -m     multicast to find ET (use default address if -a unused)\n       -b     broadcast to find ET\n\n        This program works by making a direct connection to the\n        ET system's server port and host unless at least one multicast address\n        is specified with -a, the -m option is used, or the -b option is used\n        in which case multi/broadcasting used to find the ET system.\n        If multi/broadcasting fails, look locally to find the ET system.\n        This program injects a \"first event\" into the ER's ET system\n\n");
    }

    public static void main(String[] args) {
        int group = 1;
        int delay = 0;
        int port = 0;
        boolean verbose = false;
        boolean remote = false;
        boolean multicast = false;
        HashSet<String> multicastAddrs = new HashSet<String>(4);
        String outgoingInterface = null;
        String etName = null;
        String host = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-f")) {
                etName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-a")) {
                try {
                    String addr = args[++i];
                    if (InetAddress.getByName(addr).isMulticastAddress()) {
                        multicastAddrs.add(addr);
                        multicast = true;
                        continue;
                    }
                    System.out.println("\nignoring improper multicast address\n");
                }
                catch (UnknownHostException addr) {}
                continue;
            }
            if (args[i].equalsIgnoreCase("-i")) {
                outgoingInterface = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                remote = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-m")) {
                multicast = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                try {
                    port = Integer.parseInt(args[++i]);
                    if (port >= 1024 && port <= 65535) continue;
                    System.out.println("Port number must be between 1024 and 65535.");
                    InjectFirstEvent.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper port number.");
                    InjectFirstEvent.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-g")) {
                try {
                    group = Integer.parseInt(args[++i]);
                    if (group >= 1 && group <= 10) continue;
                    System.out.println("Group number must be between 0 and 10.");
                    InjectFirstEvent.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper group number.");
                    InjectFirstEvent.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-d")) {
                try {
                    delay = Integer.parseInt(args[++i]);
                    if (delay >= 1) continue;
                    System.out.println("delay must be > 0.");
                    InjectFirstEvent.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper delay.");
                    InjectFirstEvent.usage();
                    return;
                }
            }
            InjectFirstEvent.usage();
            return;
        }
        if (etName == null) {
            InjectFirstEvent.usage();
            return;
        }
        try {
            EtSystemOpenConfig config = new EtSystemOpenConfig();
            if (multicast) {
                if (multicastAddrs.size() < 1) {
                    config.addMulticastAddr("239.200.0.0");
                } else {
                    for (String mcastAddr : multicastAddrs) {
                        config.addMulticastAddr(mcastAddr);
                    }
                }
            }
            if (multicast) {
                System.out.println("Multicasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(0);
                config.setHost(".anywhere");
            } else {
                if (port == 0) {
                    port = 11111;
                }
                config.setTcpPort(port);
                config.setNetworkContactMethod(2);
                if (host == null) {
                    host = ".local";
                }
                config.setHost(host);
                System.out.println("Direct connection to " + host);
            }
            config.setNetworkInterface(outgoingInterface);
            config.setWaitTime(0L);
            config.setEtName(etName);
            config.setResponsePolicy(2);
            if (remote) {
                System.out.println("Set as remote");
                config.setConnectRemotely(remote);
            }
            EtSystem sys = new EtSystem(config);
            if (verbose) {
                sys.setDebug(4);
            }
            sys.open();
            EtStation gc = sys.stationNameToObject("GRAND_CENTRAL");
            EtAttachment att = sys.attach(gc);
            int[] con = new int[6];
            for (int i = 0; i < 6; ++i) {
                con[i] = i + 1;
            }
            int[] data = new int[]{11, 1, 8, 1, 0, 20996, 0, -1059454720, 2, 65794, 8};
            ByteBuffer dataBuf = ByteBuffer.wrap(ByteDataTransformer.toBytes((int[])data, (ByteOrder)ByteOrder.BIG_ENDIAN));
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Hit any key to inject first event");
            br.readLine();
            EtEvent[] mevs = sys.newEvents(att, Mode.SLEEP, false, 0, 1, 44, 1);
            mevs[0].getDataBuffer().put(dataBuf);
            mevs[0].setByteOrder(ByteOrder.BIG_ENDIAN);
            mevs[0].setLength(44);
            mevs[0].setControl(con);
            sys.putEvents(att, mevs);
        }
        catch (Exception ex) {
            System.out.println("Error using ET system as producer");
            ex.printStackTrace();
        }
    }
}

