/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.transport.EmuDomainServer;

public class EmuDomainUdpListener
extends Thread {
    private EmuDomainServer server;
    private int multicastPort;
    private int tcpPort;
    private MulticastSocket multicastSocket;
    private int debug = 2;
    private String expid;
    private String emuName;
    private volatile boolean killThreads;

    void killAllThreads() {
        this.killThreads = true;
        this.interrupt();
    }

    public EmuDomainUdpListener(EmuDomainServer server, int port, String expid, String emuName) throws cMsgException {
        this.setName("Emu-socket UDP listener");
        this.expid = expid;
        this.emuName = emuName;
        this.multicastPort = this.tcpPort = port;
        try {
            this.multicastSocket = new MulticastSocket(this.multicastPort);
            InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName("239.230.0.0"), this.multicastPort);
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || !ni.supportsMulticast() || ni.isLoopback()) continue;
                this.multicastSocket.joinGroup(sa, ni);
            }
            this.multicastSocket.setReceiveBufferSize(65535);
            this.multicastSocket.setReuseAddress(true);
            this.multicastSocket.setTimeToLive(32);
            this.multicastSocket.setSoTimeout(2000);
        }
        catch (IOException e) {
            System.out.println("    Emu UDP listen: UDP port number " + this.multicastPort + " already in use.");
            System.exit(-1);
        }
        this.server = server;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block42: {
            if (this.debug >= 4) {
                System.out.println("    Emu UDP listen: running");
            }
            buf = new byte[2048];
            packet = new DatagramPacket(buf, 2048);
            outBuf = null;
            sendPacket = null;
            baos = new ByteArrayOutputStream(1024);
            out = new DataOutputStream(baos);
            try {
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(this.tcpPort);
                try {
                    ifAddrs = cMsgUtilities.getAllIpInfo();
                    addrCount = ifAddrs.size();
                    out.writeInt(addrCount);
                    for (InterfaceAddress ifAddr : ifAddrs) {
                        try {
                            bAddr = (Inet4Address)ifAddr.getBroadcast();
                        }
                        catch (ClassCastException e) {
                            continue;
                        }
                        broadcastAddr = bAddr.getHostAddress();
                        ipAddr = ifAddr.getAddress().getHostAddress();
                        out.writeInt(ipAddr.length());
                        out.write(ipAddr.getBytes("US-ASCII"));
                        out.writeInt(broadcastAddr.length());
                        out.write(broadcastAddr.getBytes("US-ASCII"));
                    }
                }
                catch (UnsupportedEncodingException ifAddrs) {
                    // empty catch block
                }
                out.flush();
                out.close();
                outBuf = baos.toByteArray();
                baos.close();
            }
            catch (IOException e) {
                this.server.transport.transportState = CODAState.ERROR;
                this.server.transport.emu.setErrorState("Transport Emu: IO error in emu UDP server");
                if (this.debug < 2) break block42;
                System.out.println("    Emu UDP listen: main server IO error: " + e.getMessage());
            }
        }
        e = this;
        synchronized (e) {
            this.notifyAll();
        }
        block27: while (true) {
            if (this.killThreads) {
                System.out.println("    Emu UDP listen: multicast listening thread exiting");
            }
            ** GOTO lbl69
            {
                catch (IOException e) {
                    this.server.transport.transportState = CODAState.ERROR;
                    this.server.transport.emu.setErrorState("Transport Emu: IO error in emu UDP server");
                    if (this.debug >= 2) {
                        System.out.println("    Emu UDP server: IO error: " + e.getMessage());
                    }
                    if (this.multicastSocket.isClosed()) break;
                    this.multicastSocket.close();
                    break;
                }
                catch (Throwable var21_35) {
                    if (!this.multicastSocket.isClosed()) {
                        this.multicastSocket.close();
                    }
                    throw var21_35;
                }
                if (!this.multicastSocket.isClosed()) {
                    this.multicastSocket.close();
                }
                return;
lbl69:
                // 1 sources

                packet.setLength(2048);
                do {
                    try {
                        this.multicastSocket.receive(packet);
                    }
                    catch (SocketTimeoutException e) {}
                } while (!this.killThreads);
                System.out.println("    Emu UDP listen: multicast listening thread exiting *****************");
                if (!this.multicastSocket.isClosed()) {
                    this.multicastSocket.close();
                }
                return;
            }
            {
                multicasterAddress = packet.getAddress();
                multicasterHost = multicasterAddress.getHostName();
                multicasterUdpPort = packet.getPort();
                if (packet.getLength() < 16) {
                    if (this.debug < 3) continue;
                    System.out.println("    Emu UDP listen: got multicast packet that's too small");
                    continue;
                }
                magic1 = cMsgUtilities.bytesToInt((byte[])buf, (int)0);
                magic2 = cMsgUtilities.bytesToInt((byte[])buf, (int)4);
                magic3 = cMsgUtilities.bytesToInt((byte[])buf, (int)8);
                if (magic1 != cMsgNetworkConstants.magicNumbers[0] || magic2 != cMsgNetworkConstants.magicNumbers[1] || magic3 != cMsgNetworkConstants.magicNumbers[2]) {
                    if (this.debug < 3) continue;
                    System.out.println("    Emu UDP listen: got multicast packet with bad magic #s");
                    continue;
                }
                msgType = cMsgUtilities.bytesToInt((byte[])buf, (int)12);
                switch (msgType) {
                    case 2: {
                        break;
                    }
                    case 16: {
                        break;
                    }
                    default: {
                        continue block27;
                    }
                }
                cMsgVersion = cMsgUtilities.bytesToInt((byte[])buf, (int)16);
                nameLen = cMsgUtilities.bytesToInt((byte[])buf, (int)20);
                expidLen = cMsgUtilities.bytesToInt((byte[])buf, (int)24);
                pos = 28;
                if (cMsgVersion != 6) {
                    if (this.debug < 4) continue;
                    System.out.println("    Emu UDP listen: conflicting cMsg versions, got " + cMsgVersion + ", need " + 6);
                    continue;
                }
                componentName = null;
                try {
                    componentName = new String(buf, pos, nameLen, "US-ASCII");
                    pos += nameLen;
                }
                catch (UnsupportedEncodingException var19_31) {
                    // empty catch block
                }
                multicasterExpid = null;
                try {
                    multicasterExpid = new String(buf, pos, expidLen, "US-ASCII");
                    pos += expidLen;
                }
                catch (UnsupportedEncodingException var20_33) {
                    // empty catch block
                }
                if (this.debug >= 4) {
                    System.out.println("    Emu UDP listen: multicaster's host = " + multicasterHost + ", UDP port = " + multicasterUdpPort + ", cMsg version = " + cMsgVersion + ", name = " + componentName + ", expid = " + multicasterExpid);
                }
                if (!this.expid.equalsIgnoreCase(multicasterExpid)) {
                    if (this.debug < 4) continue;
                    System.out.println("    Emu UDP listen: conflicting EXPIDs, got " + multicasterExpid + ", need " + this.expid);
                    continue;
                }
                if (msgType == 2 && !componentName.equalsIgnoreCase(this.emuName)) {
                    if (this.debug < 4) continue;
                    System.out.println("    Emu UDP listen: this emu is wrong destination, I am " + this.emuName + ", client looking for " + componentName);
                    continue;
                }
                try {
                    sendPacket = new DatagramPacket(outBuf, outBuf.length, multicasterAddress, multicasterUdpPort);
                    this.multicastSocket.send(sendPacket);
                }
                catch (IOException e) {
                    System.out.println("I/O Error: " + e);
                }
                System.out.println("    Emu UDP listen: accept from host = " + multicasterHost + ", UDP port = " + multicasterUdpPort + ", name = " + componentName + ", expid = " + multicasterExpid + ": reply sent back");
                continue;
            }
            break;
        }
        if (this.debug >= 4) {
            System.out.println("    Emu UDP server: quitting");
        }
    }
}

