/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.transport.EmuDomainServer;

public class EmuDomainTcpServer
extends Thread {
    private int debug = 2;
    private final int serverPort;
    private final EmuDomainServer server;
    private volatile boolean killThreads;

    void killAllThreads() {
        this.killThreads = true;
        this.interrupt();
    }

    public EmuDomainTcpServer(EmuDomainServer server, int serverPort) {
        this.setName("Emu-socket TCP server");
        this.server = server;
        this.serverPort = serverPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block55: {
            if (this.debug >= 4) {
                System.out.println("    Emu TCP Server: running, listening on port " + this.serverPort);
            }
            BYTES_TO_READ = 32;
            buffer = ByteBuffer.allocateDirect(BYTES_TO_READ);
            selector = null;
            serverChannel = null;
            try {
                selector = Selector.open();
                try {
                    serverChannel = ServerSocketChannel.open();
                    listeningSocket = serverChannel.socket();
                    listeningSocket.setReuseAddress(true);
                    listeningSocket.setPerformancePreferences(0, 0, 1);
                    listeningSocket.bind(new InetSocketAddress(this.serverPort));
                }
                catch (IOException ex) {
                    System.out.println("    Emu TCP Server: TCP port number " + this.serverPort + " already in use.");
                    System.exit(-1);
                }
                serverChannel.configureBlocking(false);
                serverChannel.register(selector, 16);
                ex = this;
                synchronized (ex) {
                    this.notifyAll();
                }
lbl26:
                // 2 sources

                while (true) {
                    if ((n = selector.select(3000L)) == 0) {
                        if (!this.killThreads) continue;
                        System.out.println("    Emu TCP Server: thread exiting");
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (Exception ex) {
                this.server.transport.transportState = CODAState.ERROR;
                this.server.transport.emu.setErrorState("    Emu TCP Server: in emu TCP server: " + ex.getMessage());
                if (this.debug >= 2) {
                    System.out.println("    Emu TCP Server: error, " + ex.getMessage());
                }
                try {
                    if (serverChannel != null) {
                        serverChannel.close();
                    }
                }
                catch (IOException var5_9) {
                    // empty catch block
                }
                try {
                    if (selector != null) {
                        selector.close();
                    }
                    break block55;
                }
                catch (IOException var5_10) {}
                break block55;
            }
            catch (Throwable var20_30) {
                try {
                    if (serverChannel != null) {
                        serverChannel.close();
                    }
                }
                catch (IOException var21_31) {
                    // empty catch block
                }
                try {
                    if (selector == null) throw var20_30;
                    selector.close();
                    throw var20_30;
                }
                catch (IOException var21_32) {
                    // empty catch block
                }
                throw var20_30;
            }
            try {
                if (serverChannel != null) {
                    serverChannel.close();
                }
            }
            catch (IOException var6_12) {
                // empty catch block
            }
            try {
                if (selector == null) return;
                selector.close();
                return;
            }
            catch (IOException var6_13) {
                // empty catch block
            }
            return;
lbl-1000:
            // 1 sources

            {
                it = selector.selectedKeys().iterator();
                block26: while (true) {
                    if (it.hasNext()) ** break;
                    ** continue;
                    key = it.next();
                    if (key.isValid() && key.isAcceptable()) {
                        channel = serverChannel.accept();
                        codaId = -1;
                        bufferSizeDesired = -1;
                        socketCount = -1;
                        socketPosition = -1;
                        bytesRead = 0;
                        loops = 0;
                        buffer.clear();
                        buffer.limit(BYTES_TO_READ);
                        channel.configureBlocking(false);
                        while (bytesRead < BYTES_TO_READ) {
                            if (this.debug >= 4) {
                                System.out.println("    Emu TCP Server: try reading rest of Buffer");
                            }
                            if ((bytes = channel.read(buffer)) == -1) {
                                channel.close();
                                it.remove();
                                continue block26;
                            }
                            bytesRead += bytes;
                            if (this.debug >= 4) {
                                System.out.println("    Emu TCP Server: bytes read = " + bytesRead);
                            }
                            if (bytesRead >= BYTES_TO_READ) {
                                buffer.flip();
                                magic1 = buffer.getInt();
                                magic2 = buffer.getInt();
                                magic3 = buffer.getInt();
                                if (magic1 != cMsgNetworkConstants.magicNumbers[0] || magic2 != cMsgNetworkConstants.magicNumbers[1] || magic3 != cMsgNetworkConstants.magicNumbers[2]) {
                                    if (this.debug >= 4) {
                                        System.out.println("    Emu TCP Server: Magic #s did NOT match, ignore");
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                version = buffer.getInt();
                                if (version != 6) {
                                    if (this.debug >= 4) {
                                        System.out.println("    Emu TCP Server: version mismatch, got " + version + ", needed " + 6);
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                codaId = buffer.getInt();
                                if (codaId < 0) {
                                    if (this.debug >= 4) {
                                        System.out.println("    Emu TCP Server: bad coda id of sender (" + codaId + ')');
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                bufferSizeDesired = buffer.getInt();
                                if (bufferSizeDesired < 40) {
                                    if (this.debug >= 4) {
                                        System.out.println("    Emu TCP Server: bad buffer size from sender (" + bufferSizeDesired + ')');
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                socketCount = buffer.getInt();
                                if (socketCount < 1) {
                                    if (this.debug >= 4) {
                                        System.out.println("    Emu TCP Server: bad socket count of sender (" + socketCount + ')');
                                    }
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                socketPosition = buffer.getInt();
                                if (socketCount >= 1) continue;
                                if (this.debug >= 4) {
                                    System.out.println("    Emu TCP Server: bad socket position of sender (" + socketPosition + ')');
                                }
                                channel.close();
                                it.remove();
                                continue block26;
                            }
                            if (++loops > 10) {
                                channel.close();
                                it.remove();
                                continue block26;
                            }
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException magic1) {}
                        }
                        channel.configureBlocking(true);
                        emuChannel = this.server.transport.inputChannelTable.get(codaId);
                        if (emuChannel == null) {
                            if (this.debug >= 4) {
                                System.out.println("    Emu TCP Server: no emu input channel found for CODA id = " + codaId);
                            }
                            channel.close();
                            it.remove();
                            continue;
                        }
                        try {
                            emuChannel.attachToInput(channel, codaId, bufferSizeDesired, socketCount, socketPosition);
                        }
                        catch (IOException e) {
                            if (this.debug >= 4) {
                                System.out.println("    Emu TCP Server: " + e.getMessage());
                            }
                            channel.close();
                            it.remove();
                            continue;
                        }
                    }
                    it.remove();
                }
            }
        }
        if (this.debug < 4) return;
        System.out.println("    Emu TCP Server: quitting");
    }
}

