/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SpinCountBackoffWaitStrategy;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.EmuUtilities;
import org.jlab.coda.emu.support.codaComponent.CODAClass;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.emu.support.transport.DataChannelAdapter;
import org.jlab.coda.emu.support.transport.DataTransportException;
import org.jlab.coda.emu.support.transport.DataTransportImplEt;
import org.jlab.coda.emu.support.transport.TransportType;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtContainer;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtStationConfig;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.enums.Mode;
import org.jlab.coda.et.enums.Modify;
import org.jlab.coda.et.exception.EtClosedException;
import org.jlab.coda.et.exception.EtDeadException;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtExistsException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtWakeUpException;
import org.jlab.coda.et.system.AttachmentLocal;
import org.jlab.coda.et.system.StationLocal;
import org.jlab.coda.et.system.SystemCreate;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriterUnsync;
import org.jlab.coda.jevio.EvioCompactReaderUnsync;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioNodePool;
import org.jlab.coda.jevio.EvioNodeSource;
import org.jlab.coda.jevio.Utilities;

public class DataChannelImplEt
extends DataChannelAdapter {
    private final DataTransportImplEt dataTransportImplEt;
    private final boolean input;
    private volatile boolean pause;
    private volatile boolean haveInputEndEvent;
    private volatile boolean gotResetCmd;
    private volatile boolean stopGetterThread;
    private DataOutputHelper dataOutputThread;
    private boolean isROC;
    private boolean isEB;
    private boolean isFinalEB;
    private boolean isFirstEB;
    private boolean isER;
    private DataInputHelper dataInputThread;
    private EvioNodePool[] nodePools;
    private int chunk;
    private int group;
    private boolean deadLockAtPrestart;
    private int[] control;
    private EtSystem etSystem;
    private SystemCreate etSysLocal;
    private EtStation station;
    private StationLocal stationLocal;
    private String stationName;
    private int stationPosition = 1;
    private EtAttachment attachment;
    private AttachmentLocal attachmentLocal;
    private EtStationConfig stationConfig;
    private static final int etWaitTime = 500000;
    private long nextRingItem;
    protected ByteBufferSupply bbSupply;

    private static final ByteBuffer copyBuffer(ByteBuffer srcBuf, ByteBuffer destBuf, int len) {
        if (srcBuf.hasArray() && destBuf.hasArray()) {
            System.arraycopy(srcBuf.array(), 0, destBuf.array(), 0, len);
        } else {
            srcBuf.limit(len).position(0);
            destBuf.clear();
            destBuf.put(srcBuf);
        }
        destBuf.order(srcBuf.order());
        return (ByteBuffer)destBuf.position(0).limit(len);
    }

    DataChannelImplEt(String name, DataTransportImplEt transport, Map<String, String> attributeMap, boolean input, Emu emu, EmuModule module, int outputIndex) throws DataTransportException {
        super(name, transport, attributeMap, input, emu, module, outputIndex);
        CODAClass emuClass;
        this.input = input;
        this.dataTransportImplEt = transport;
        if (input) {
            this.logger.info("      DataChannel Et: creating input channel " + name);
        } else {
            this.logger.info("      DataChannel Et: creating output channel " + name);
        }
        int tcpSendBuf = 0;
        String attribString = attributeMap.get("sendBuf");
        if (attribString != null) {
            try {
                tcpSendBuf = Integer.parseInt(attribString);
                if (tcpSendBuf < 0) {
                    tcpSendBuf = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int tcpRecvBuf = 0;
        attribString = attributeMap.get("recvBuf");
        if (attribString != null) {
            try {
                tcpRecvBuf = Integer.parseInt(attribString);
                if (tcpRecvBuf < 0) {
                    tcpRecvBuf = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean noDelay = true;
        attribString = attributeMap.get("noDelay");
        if (attribString != null && (attribString.equalsIgnoreCase("false") || attribString.equalsIgnoreCase("off") || attribString.equalsIgnoreCase("no"))) {
            noDelay = false;
        }
        try {
            EtSystemOpenConfig openConfig = new EtSystemOpenConfig(this.dataTransportImplEt.getOpenConfig());
            openConfig.setTcpRecvBufSize(tcpRecvBuf);
            openConfig.setTcpSendBufSize(tcpSendBuf);
            openConfig.setNoDelay(noDelay);
            this.etSystem = new EtSystem(openConfig);
            this.etSystem.setDebug(4);
        }
        catch (EtException e) {
            throw new DataTransportException("", (Exception)((Object)e));
        }
        this.chunk = 4;
        attribString = attributeMap.get("chunk");
        if (attribString != null) {
            try {
                this.chunk = Integer.parseInt(attribString);
                if (this.chunk < 1) {
                    this.chunk = 1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.logger.info("      DataChannel Et: chunk = " + this.chunk);
        this.group = 1;
        attribString = attributeMap.get("group");
        if (attribString != null) {
            try {
                this.group = Integer.parseInt(attribString);
                if (this.group < 1) {
                    this.group = 1;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.stationName = attributeMap.get("stationName");
        attribString = attributeMap.get("position");
        if (attribString != null) {
            try {
                this.stationPosition = Integer.parseInt(attribString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (input) {
            try {
                emuClass = emu.getCodaClass();
                this.isFirstEB = emuClass == CODAClass.PEB || emuClass == CODAClass.DC || emuClass == CODAClass.PEBER;
                boolean bl = this.isER = emuClass == CODAClass.ER;
                if (transport.tryToCreateET()) {
                    this.etSysLocal = transport.getLocalEtSystem();
                }
                this.stationConfig = new EtStationConfig();
                try {
                    this.stationConfig.setUserMode(1);
                }
                catch (EtException etException) {
                    // empty catch block
                }
                if (this.isER) {
                    this.stationName = emu.name();
                    this.stationConfig.setSelectMode(4);
                    this.stationConfig.setFlowMode(1);
                    this.stationConfig.setBlockMode(1);
                    this.stationConfig.setRestoreMode(0);
                    this.stationConfig.setPrescale(1);
                } else {
                    String controlFilter;
                    String idFilter = attributeMap.get("idFilter");
                    if (idFilter != null && idFilter.equalsIgnoreCase("on")) {
                        int[] selects = new int[6];
                        Arrays.fill(selects, -1);
                        selects[0] = this.id;
                        this.stationConfig.setSelect(selects);
                        this.stationConfig.setSelectMode(2);
                    }
                    if ((controlFilter = attributeMap.get("controlFilter")) != null && controlFilter.equalsIgnoreCase("on")) {
                        int[] selects = new int[6];
                        Arrays.fill(selects, -1);
                        selects[0] = EventType.CONTROL.getValue();
                        this.stationConfig.setSelect(selects);
                        this.stationConfig.setSelectMode(2);
                    }
                }
                if (this.stationName == null) {
                    this.stationName = this.isER ? emu.name() : name;
                }
                this.openEtSystem();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            emu.addOutputDestination(transport.getOpenConfig().getEtName());
            if (this.stationName == null) {
                this.stationName = "GRAND_CENTRAL";
            }
            if (!this.stationName.equals("GRAND_CENTRAL")) {
                try {
                    this.stationConfig = new EtStationConfig();
                    try {
                        this.stationConfig.setUserMode(1);
                    }
                    catch (EtException e) {}
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            emuClass = emu.getCodaClass();
            this.isEB = emuClass.isEventBuilder();
            boolean bl = this.isROC = emuClass == CODAClass.ROC;
            if (this.isEB || this.isROC) {
                this.control = new int[6];
                this.control[0] = this.id;
                this.isFinalEB = emuClass.isFinalEventBuilder();
            }
            this.openEtSystem();
        }
    }

    private long getEtEventSize() {
        if (this.etSysLocal != null) {
            return this.etSysLocal.getConfig().getEventSize();
        }
        return this.etSystem.getEventSize();
    }

    private int getEtEventCount() {
        if (this.etSysLocal != null) {
            return this.etSysLocal.getConfig().getNumEvents();
        }
        return this.etSystem.getNumEvents();
    }

    private void openEtSystem() throws DataTransportException {
        if (this.etSysLocal != null) {
            try {
                if (this.stationName.equals("GRAND_CENTRAL")) {
                    this.stationLocal = this.etSysLocal.stationNameToObject(this.stationName);
                } else {
                    try {
                        this.stationLocal = this.etSysLocal.createStation(this.stationConfig, this.stationName);
                        this.etSysLocal.setStationPosition(this.stationLocal.getStationId(), this.stationPosition, 0);
                    }
                    catch (EtExistsException e) {
                        this.stationLocal = this.etSysLocal.stationNameToObject(this.stationName);
                        this.etSysLocal.setStationPosition(this.stationLocal.getStationId(), this.stationPosition, 0);
                    }
                }
                this.attachmentLocal = this.etSysLocal.attach(this.stationLocal.getStationId());
            }
            catch (Exception e) {
                System.out.println("      DataChannel Et: can't create/attach to station " + this.stationName + "; " + e.getMessage());
                this.emu.setErrorState("DataChannel Et: can't create/attach to station " + this.stationName + "; " + e.getMessage());
                this.channelState = CODAState.ERROR;
                throw new DataTransportException("cannot create/attach to station " + this.stationName, e);
            }
        }
        try {
            EtSystemOpenConfig config = this.etSystem.getConfig();
            this.logger.info("      DataChannel Et: try opening " + config.getEtName());
            int method = config.getNetworkContactMethod();
            if (method == 2) {
                this.logger.info(" directly on " + config.getHost() + ", port " + config.getTcpPort());
            } else if (method == 0) {
                this.logger.info(" by multicasting to port " + config.getUdpPort());
            } else if (method == 1) {
                this.logger.info(" by broadcasting to port " + config.getUdpPort());
            } else if (method == 3) {
                this.logger.info(" by multi & broadcasting to port " + config.getUdpPort());
            }
            if (config.isConnectRemotely()) {
                System.out.println(", using sockets only");
            } else {
                System.out.println();
            }
            this.etSystem.open();
            this.logger.info("      DataChannel Et: SUCCESS opening ET from local addr, " + this.etSystem.getLocalAddress());
            if (this.etSystem.getLanguage() == 2) {
                System.out.println(", written in Java");
            } else {
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EtSystemOpenConfig config = this.etSystem.getConfig();
            String errString = "cannot connect to ET " + config.getEtName() + ", ";
            int method = config.getNetworkContactMethod();
            if (method == 2) {
                errString = errString + " direct to " + config.getHost() + " on port " + config.getTcpPort();
            } else if (method == 0) {
                errString = errString + " multicasting to port " + config.getUdpPort();
            } else if (method == 1) {
                errString = errString + " broadcasting to port " + config.getUdpPort();
            } else if (method == 3) {
                errString = errString + " multi/broadcasting to port " + config.getUdpPort();
            }
            System.out.println("      DataChannel Et:" + errString + "; " + e.getMessage());
            this.emu.setErrorState("DataChannel Et: " + errString + "; " + e.getMessage());
            this.channelState = CODAState.ERROR;
            throw new DataTransportException(errString, e);
        }
        try {
            if (this.stationName.equals("GRAND_CENTRAL")) {
                this.station = this.etSystem.stationNameToObject(this.stationName);
            } else {
                try {
                    if (this.isER) {
                        if (this.dataTransportImplEt.tryToCreateET()) {
                            System.out.println("      DataChannel Et: try creating station " + this.stationName + " at pos " + this.stationPosition + ", at parallel pos = head");
                            this.station = this.etSystem.createStation(this.stationConfig, this.stationName, this.stationPosition, -2);
                        } else {
                            System.out.println("      DataChannel Et: try creating station " + this.stationName + " at pos " + this.stationPosition + ", at parallel pos = end");
                            this.station = this.etSystem.createStation(this.stationConfig, this.stationName, this.stationPosition, -1);
                        }
                    } else {
                        this.station = this.etSystem.createStation(this.stationConfig, this.stationName, this.stationPosition, 0);
                    }
                }
                catch (EtExistsException e) {
                    System.out.println("      DataChannel Et: try creating station " + this.stationName + " at pos " + this.stationPosition + ", but it exists so attach to existing");
                    this.station = this.etSystem.stationNameToObject(this.stationName);
                    this.etSystem.setStationPosition(this.station, this.stationPosition, 0);
                }
            }
            this.attachment = this.etSystem.attach(this.station);
        }
        catch (Exception e) {
            System.out.println("      DataChannel Et: can't create/attach to station " + this.stationName + "; " + e.getMessage());
            this.emu.setErrorState("DataChannel Et: can't create/attach to station " + this.stationName + "; " + e.getMessage());
            this.channelState = CODAState.ERROR;
            throw new DataTransportException("cannot create/attach to station " + this.stationName, e);
        }
    }

    private void closeEtSystem() throws DataTransportException {
        if (this.etSysLocal != null) {
            try {
                this.etSysLocal.detach(this.attachmentLocal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!this.stationName.equals("GRAND_CENTRAL")) {
                    this.etSysLocal.removeStation(this.stationLocal.getStationId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.etSysLocal = null;
        } else if (this.etSystem != null) {
            try {
                this.logger.info("      DataChannel Et closeEtSystem(): detach from ET sytem");
                this.etSystem.detach(this.attachment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (!this.stationName.equals("GRAND_CENTRAL")) {
                    this.logger.info("      DataChannel Et closeEtSystem(): remove station " + this.stationName + " from ET sytem");
                    this.etSystem.removeStation(this.station);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logger.info("      DataChannel Et closeEtSystem(): call close()");
            this.etSystem.close();
            this.etSystem = null;
            this.logger.info("      DataChannel Et closeEtSystem(): done");
        }
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.ET;
    }

    @Override
    public int getInputLevel() {
        return this.bbSupply.getFillLevel();
    }

    @Override
    public void prestart() throws CmdExecException {
        super.prestart();
        this.pause = false;
        if (!this.input) {
            if (this.getEtEventCount() < 4 * this.chunk) {
                this.deadLockAtPrestart = true;
                this.logger.info("      DataChannel Et: newEvents() using timed mode to avoid deadlock");
            }
        } else {
            List<DataChannel> outChannels;
            int etEventSize = (int)this.getEtEventSize();
            this.logger.info("      DataChannel Et: eventSize = " + etEventSize);
            int numEtBufs = 140000000 / etEventSize;
            numEtBufs = numEtBufs < 8 ? 8 : numEtBufs;
            numEtBufs = numEtBufs > 2048 ? 2048 : numEtBufs;
            numEtBufs = EmuUtilities.powerOfTwo(numEtBufs, false);
            this.logger.info("      DataChannel Et: # copy-ET-buffers in input supply -> " + numEtBufs);
            int poolSize = 3300 * (etEventSize / 4000000) + 200;
            this.nodePools = new EvioNodePool[numEtBufs];
            for (int i = 0; i < numEtBufs; ++i) {
                this.nodePools[i] = new EvioNodePool(poolSize);
            }
            this.bbSupply = this.isER ? ((outChannels = this.emu.getOutChannels()).size() < 1 || outChannels.size() == 1 && outChannels.get(0).getTransportType() == TransportType.FILE ? new ByteBufferSupply(numEtBufs, etEventSize, this.module.getOutputOrder(), false, false, this.nodePools) : new ByteBufferSupply(numEtBufs, etEventSize, this.module.getOutputOrder(), false, false, this.nodePools)) : new ByteBufferSupply(numEtBufs, etEventSize, this.module.getOutputOrder(), false, true, this.nodePools);
        }
        this.startHelper();
        this.channelState = CODAState.PAUSED;
    }

    @Override
    public void go() {
        this.pause = false;
        this.channelState = CODAState.ACTIVE;
    }

    @Override
    public void pause() {
        this.pause = true;
        this.channelState = CODAState.PAUSED;
    }

    private void interruptThreads() {
        if (this.dataInputThread != null) {
            this.logger.info("      DataChannel Et interruptThreads(): shutdown dataInputThread");
            this.dataInputThread.interruptThreads();
            if (this.etSysLocal != null) {
                this.etSysLocal.detach(this.attachmentLocal);
            } else if (this.etSystem != null) {
                try {
                    this.logger.info("      DataChannel Et interruptThreads(): wake up attachment to ET station " + this.stationName);
                    this.etSystem.wakeUpAttachment(this.attachment);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.dataOutputThread != null) {
            this.logger.info("      DataChannel Et interruptThreads(): shutdown dataOutputThread");
            this.dataOutputThread.shutdown();
        }
    }

    private void joinThreads() {
        try {
            if (this.dataInputThread != null) {
                this.logger.info("      DataChannel Et joinThreads(): join dataInputThread");
                this.dataInputThread.join(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.dataOutputThread != null) {
            this.logger.info("      DataChannel Et joinThreads(): join dataOutputThread");
            this.dataOutputThread.waitForThreadsToEnd(1000);
        }
        this.logger.info("      DataChannel Et joinThreads(): done");
    }

    @Override
    public void end() {
        this.logger.info("      DataChannel Et: " + this.name + " - end threads & close ET system");
        this.gotEndCmd = true;
        this.gotResetCmd = false;
        this.stopGetterThread = true;
        this.logger.info("      DataChannel Et end(): interrupt threads");
        this.interruptThreads();
        this.logger.info("      DataChannel Et end(): join threads");
        this.joinThreads();
        try {
            this.logger.info("      DataChannel Et end(): close ET sytem");
            this.closeEtSystem();
        }
        catch (DataTransportException e) {
            e.printStackTrace();
        }
        this.channelState = CODAState.DOWNLOADED;
        this.logger.info("      DataChannel Et: end() done");
    }

    @Override
    public void reset() {
        this.logger.debug("      DataChannel Et: reset " + this.name + " channel");
        this.gotEndCmd = false;
        this.gotResetCmd = true;
        this.stopGetterThread = true;
        this.interruptThreads();
        this.joinThreads();
        try {
            this.closeEtSystem();
        }
        catch (DataTransportException dataTransportException) {
            // empty catch block
        }
        this.errorMsg.set(null);
        this.channelState = CODAState.CONFIGURED;
    }

    private void startHelper() {
        if (this.input) {
            this.dataInputThread = new DataInputHelper(this.emu.getThreadGroup(), this.name() + "et_in");
            this.dataInputThread.start();
            this.dataInputThread.waitUntilStarted();
        } else {
            this.dataOutputThread = new DataOutputHelper(this.emu.getThreadGroup(), this.name() + "et_out");
            this.dataOutputThread.start();
            this.dataOutputThread.waitUntilStarted();
        }
    }

    private class DataOutputHelper
    extends Thread {
        private int pauseCounter;
        private EvGetter getter;
        private EvPutter putter;
        private final CountDownLatch startLatch;
        private volatile DataChannelAdapter.ThreadState threadState;
        private RingItem unusedRingItem;
        private int ringSize;
        private RingBuffer<EtContainer> rb;
        private Sequence etFillSequence;
        private SequenceBarrier etFillBarrier;
        private static final int maxEvioItemsPerEtBuf = 10000;

        DataOutputHelper(ThreadGroup group, String name) {
            super(group, name);
            this.startLatch = new CountDownLatch(2);
            int ringSize = 4;
            this.rb = RingBuffer.createSingleProducer((EventFactory)new ContainerFactory(), (int)ringSize, (WaitStrategy)new SpinCountBackoffWaitStrategy(10000, (WaitStrategy)new LiteBlockingWaitStrategy()));
            this.etFillBarrier = this.rb.newBarrier(new Sequence[0]);
            this.etFillSequence = new Sequence(-1L);
            SequenceBarrier etPutBarrier = this.rb.newBarrier(new Sequence[]{this.etFillSequence});
            Sequence etPutSequence = new Sequence(-1L);
            this.rb.addGatingSequences(new Sequence[]{etPutSequence});
            this.putter = new EvPutter(group, name + "_EvPutter", etPutSequence, etPutBarrier);
            this.putter.start();
            this.getter = new EvGetter(group, name + "_EvGetter");
            this.getter.start();
        }

        private void waitUntilStarted() {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private boolean waitForThreadsToEnd(int milliseconds) {
            int oneThreadWaitTime = milliseconds / 3;
            if (oneThreadWaitTime < 0) {
                oneThreadWaitTime = 0;
            }
            try {
                this.getter.join(oneThreadWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.putter.join(oneThreadWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.join(oneThreadWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.isAlive() && !this.putter.isAlive() && !this.getter.isAlive();
        }

        private void shutdown() {
            if (DataChannelImplEt.this.etSystem == null || DataChannelImplEt.this.attachment == null) {
                return;
            }
            try {
                DataChannelImplEt.this.logger.info("      DataChannel Et out: wake up attachment to ET station " + DataChannelImplEt.this.stationName + " in order to shutdown threads");
                DataChannelImplEt.this.etSystem.wakeUpAttachment(DataChannelImplEt.this.attachment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.threadState = DataChannelAdapter.ThreadState.RUNNING;
            this.startLatch.countDown();
            try {
                EventType pBankType = null;
                ControlType pBankControlType = null;
                long TIMEOUT = 2000L;
                int outputRingIndex = 0;
                ByteBuffer etBuffer = ByteBuffer.allocate(128);
                etBuffer.order(DataChannelImplEt.this.byteOrder);
                EventWriterUnsync writer = new EventWriterUnsync(etBuffer, 1100000, 10000, null, null, DataChannelImplEt.this.emu.getCodaid(), 0);
                writer.close();
                int ringItemSize = 0;
                int etSize = (int)DataChannelImplEt.this.etSystem.getEventSize();
                boolean isUserOrControl = false;
                boolean isUser = false;
                boolean isControl = false;
                boolean gotPrestart = false;
                long etNextFillSequence = this.etFillSequence.get() + 1L;
                long etAvailableFillSequence = -1L;
                BitSet bitInfo = new BitSet(24);
                DataChannelImplEt.this.recordId = 1;
                block8: while (true) {
                    int validEvents;
                    EtEvent[] events;
                    EtContainer etContainer;
                    if (DataChannelImplEt.this.pause) {
                        if (this.pauseCounter++ % 400 != 0) continue;
                        Thread.sleep(5L);
                        continue;
                    }
                    EtEvent event = null;
                    try {
                        if (etAvailableFillSequence < etNextFillSequence) {
                            etAvailableFillSequence = this.etFillBarrier.waitFor(etNextFillSequence);
                        }
                        etContainer = (EtContainer)this.rb.get(etNextFillSequence);
                        events = etContainer.getEventArray();
                        validEvents = etContainer.getEventCount();
                        etContainer.setLastIndex(validEvents - 1);
                    }
                    catch (InterruptedException e) {
                        if (DataChannelImplEt.this.haveInputEndEvent) {
                            DataChannelImplEt.this.logger.info("      DataChannel Et out: wake up " + DataChannelImplEt.this.name + ", other thd found END, quit");
                            return;
                        }
                        if (!DataChannelImplEt.this.gotResetCmd) return;
                        DataChannelImplEt.this.logger.info("      DataChannel Et out: " + DataChannelImplEt.this.name + " got RESET cmd, quitting");
                        return;
                    }
                    catch (Exception e) {
                        throw new EmuException("Error getting events to fill", e);
                    }
                    int j = 0;
                    while (true) {
                        block43: {
                            int itemCount;
                            boolean etEventInitialized;
                            int banksInEtBuf;
                            int bytesToEtBuf;
                            long startTime;
                            if (j < validEvents) {
                                startTime = DataChannelImplEt.this.emu.getTime();
                                bytesToEtBuf = 0;
                                banksInEtBuf = 0;
                                etEventInitialized = false;
                                itemCount = 0;
                                if (event != null) {
                                    writer.close();
                                    event.setLength((int)writer.getBytesWrittenToBuffer());
                                }
                            } else {
                                writer.close();
                                event.setLength((int)writer.getBytesWrittenToBuffer());
                                this.etFillSequence.set(etNextFillSequence++);
                                continue block8;
                            }
                            event = events[j];
                            do {
                                RingItem ringItem;
                                block45: {
                                    block44: {
                                        if (this.unusedRingItem != null) {
                                            ringItem = this.unusedRingItem;
                                            this.unusedRingItem = null;
                                        } else {
                                            try {
                                                ringItem = DataChannelImplEt.this.getNextOutputRingItem(outputRingIndex);
                                            }
                                            catch (InterruptedException e) {
                                                return;
                                            }
                                            pBankType = ringItem.getEventType();
                                            pBankControlType = ringItem.getControlType();
                                            isUser = pBankType.isUser();
                                            isControl = pBankType.isControl();
                                            isUserOrControl = pBankType.isUserOrControl();
                                            if (!gotPrestart) {
                                                if (pBankControlType != null) {
                                                    gotPrestart = pBankControlType.isPrestart();
                                                    if (!gotPrestart) {
                                                        throw new EmuException("Prestart event must be first control event");
                                                    }
                                                } else if (!isUser) {
                                                    throw new EmuException("Only user or prestart event allowed to be first");
                                                }
                                            }
                                            ringItemSize = ringItem.getTotalBytes() + 64;
                                        }
                                        if (bytesToEtBuf + ringItemSize <= etSize && itemCount < 10000) break block44;
                                        if (banksInEtBuf < 1) {
                                            DataChannelImplEt.this.etSystem.dumpEvents(DataChannelImplEt.this.attachment, new EtEvent[]{event});
                                            DataChannelImplEt.this.logger.rcConsole("\n      DataChannel Et out (" + DataChannelImplEt.this.name + "): filler, using over-sized (temp) ET event", "DANGER !!!\n");
                                            EtEvent[] evts = DataChannelImplEt.this.etSystem.newEvents(DataChannelImplEt.this.attachment, Mode.SLEEP, false, 0, 1, ringItemSize, DataChannelImplEt.this.group);
                                            events[j] = event = evts[0];
                                            break block45;
                                        } else {
                                            this.unusedRingItem = ringItem;
                                            break block43;
                                        }
                                    }
                                    if (isUserOrControl) {
                                        if (banksInEtBuf > 0) {
                                            this.unusedRingItem = ringItem;
                                            break block43;
                                        }
                                        if (pBankControlType == ControlType.END) {
                                            etContainer.setHasEndEvent(true);
                                            etContainer.setLastIndex(j);
                                        }
                                    }
                                }
                                if (!etEventInitialized) {
                                    if (DataChannelImplEt.this.isFinalEB) {
                                        ((DataChannelImplEt)DataChannelImplEt.this).control[0] = pBankType.getValue();
                                        event.setControl(DataChannelImplEt.this.control);
                                    } else if (DataChannelImplEt.this.isEB || DataChannelImplEt.this.isROC) {
                                        event.setControl(DataChannelImplEt.this.control);
                                    }
                                    event.setByteOrder(DataChannelImplEt.this.byteOrder);
                                    bitInfo.clear();
                                    EmuUtilities.setEventType(bitInfo, pBankType);
                                    int myRecordId = -1;
                                    if (!isUserOrControl) {
                                        myRecordId = DataChannelImplEt.this.recordId;
                                    } else if (ringItem.isFirstEvent()) {
                                        EmuUtilities.setFirstEvent(bitInfo);
                                    }
                                    ++DataChannelImplEt.this.recordId;
                                    etBuffer = event.getDataBuffer();
                                    etBuffer.clear();
                                    etBuffer.order(DataChannelImplEt.this.byteOrder);
                                    etEventInitialized = true;
                                    writer.setBuffer(etBuffer, bitInfo, myRecordId);
                                }
                                EvioNode node = ringItem.getNode();
                                ByteBuffer buf = ringItem.getBuffer();
                                if (buf != null) {
                                    writer.writeEvent(buf);
                                } else if (node != null) {
                                    writer.writeEvent(node, false, false);
                                }
                                ++itemCount;
                                ++banksInEtBuf;
                                bytesToEtBuf += ringItemSize;
                                ringItem.releaseByteBuffer();
                                DataChannelImplEt.this.releaseCurrentAndGoToNextOutputRingItem(outputRingIndex);
                                if (pBankControlType != null) {
                                    if (pBankControlType == ControlType.END) {
                                        writer.close();
                                        event.setLength((int)writer.getBytesWrittenToBuffer());
                                        DataChannelImplEt.this.stopGetterThread = true;
                                        this.etFillSequence.set(etNextFillSequence);
                                        this.threadState = DataChannelAdapter.ThreadState.DONE;
                                        return;
                                    }
                                    if (pBankControlType == ControlType.GO) {
                                        outputRingIndex = DataChannelImplEt.this.ringIndex;
                                    }
                                }
                                if (DataChannelImplEt.this.outputRingCount <= 1 || isUserOrControl) continue;
                                outputRingIndex = DataChannelImplEt.this.setNextEventAndRing();
                            } while (DataChannelImplEt.this.emu.getTime() - startTime <= 2000L && !isUserOrControl);
                            if (pBankControlType == ControlType.PRESTART) {
                                writer.close();
                                event.setLength((int)writer.getBytesWrittenToBuffer());
                                etContainer.setLastIndex(j);
                                this.etFillSequence.set(etNextFillSequence++);
                                continue block8;
                            }
                        }
                        ++j;
                    }
                    break;
                }
            }
            catch (InterruptedException ringItem) {
            }
            catch (Exception e) {
                DataChannelImplEt.this.logger.warn("      DataChannel Et out: exit thd w/ error = " + e.getMessage());
                e.printStackTrace();
                DataChannelImplEt.this.channelState = CODAState.ERROR;
                DataChannelImplEt.this.emu.setErrorState("DataChannel Et out: " + e.getMessage());
            }
            this.threadState = DataChannelAdapter.ThreadState.DONE;
        }

        private final class EvGetter
        extends Thread {
            EvGetter(ThreadGroup group, String name) {
                super(group, name);
            }

            @Override
            public void run() {
                String errorString;
                boolean gotError;
                int eventSize = (int)DataChannelImplEt.this.getEtEventSize();
                DataOutputHelper.this.startLatch.countDown();
                try {
                    if (DataChannelImplEt.this.deadLockAtPrestart) {
                        while (true) {
                            if (DataChannelImplEt.this.stopGetterThread) {
                                return;
                            }
                            long sequence = DataOutputHelper.this.rb.nextIntr(1);
                            EtContainer etContainer = (EtContainer)DataOutputHelper.this.rb.get(sequence);
                            etContainer.newEvents(DataChannelImplEt.this.attachment, Mode.TIMED, 100000, DataChannelImplEt.this.chunk, eventSize, DataChannelImplEt.this.group);
                            while (true) {
                                try {
                                    DataChannelImplEt.this.etSystem.newEvents(etContainer);
                                }
                                catch (EtTimeoutException e) {
                                    continue;
                                }
                                break;
                            }
                            DataOutputHelper.this.rb.publish(sequence++);
                        }
                    }
                    while (true) {
                        if (DataChannelImplEt.this.stopGetterThread) {
                            return;
                        }
                        long sequence = DataOutputHelper.this.rb.nextIntr(1);
                        EtContainer etContainer = (EtContainer)DataOutputHelper.this.rb.get(sequence);
                        etContainer.newEvents(DataChannelImplEt.this.attachment, Mode.SLEEP, 0, DataChannelImplEt.this.chunk, eventSize, DataChannelImplEt.this.group);
                        DataChannelImplEt.this.etSystem.newEvents(etContainer);
                        DataOutputHelper.this.rb.publish(sequence++);
                    }
                }
                catch (EtWakeUpException e) {
                    if (DataChannelImplEt.this.haveInputEndEvent) {
                        DataChannelImplEt.this.logger.info("      DataChannel Et out: wake up " + DataChannelImplEt.this.name + ", other thd found END, quit");
                    } else if (DataChannelImplEt.this.gotResetCmd) {
                        DataChannelImplEt.this.logger.info("      DataChannel Et out: " + DataChannelImplEt.this.name + " got RESET cmd, quitting");
                    }
                    return;
                }
                catch (IOException e) {
                    gotError = true;
                    errorString = "DataChannel Et out: network communication error with Et";
                    e.printStackTrace();
                }
                catch (EtException e) {
                    gotError = true;
                    errorString = "DataChannel Et out: internal error handling Et";
                    e.printStackTrace();
                }
                catch (EtDeadException e) {
                    gotError = true;
                    errorString = "DataChannel Et out: Et system dead";
                }
                catch (EtClosedException e) {
                    gotError = true;
                    errorString = "DataChannel Et out: Et connection closed";
                }
                catch (Exception e) {
                    gotError = true;
                    errorString = "DataChannel Et out: " + e.getMessage();
                }
                if (gotError) {
                    DataChannelImplEt.this.channelState = CODAState.ERROR;
                    System.out.println("      DataChannel Et out: " + DataChannelImplEt.this.name + ", " + errorString);
                    DataChannelImplEt.this.emu.setErrorState(errorString);
                }
                System.out.println("      DataChannel Et out: GETTER is Quitting");
            }
        }

        private class EvPutter
        extends Thread {
            private Sequence sequence;
            private SequenceBarrier barrier;

            EvPutter(ThreadGroup group, String name, Sequence sequence, SequenceBarrier barrier) {
                super(group, name);
                this.barrier = barrier;
                this.sequence = sequence;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DataOutputHelper.this.startLatch.countDown();
                int lastIndex = 0;
                long availableSequence = -1L;
                long nextSequence = this.sequence.get() + 1L;
                try {
                    boolean hasEnd;
                    do {
                        int eventsToDump;
                        int eventsToPut;
                        if (DataChannelImplEt.this.gotResetCmd) {
                            return;
                        }
                        if (availableSequence < nextSequence) {
                            availableSequence = this.barrier.waitFor(nextSequence);
                        }
                        EtContainer etContainer = (EtContainer)DataOutputHelper.this.rb.get(nextSequence);
                        int validEvents = etContainer.getEventCount();
                        lastIndex = etContainer.getLastIndex();
                        hasEnd = etContainer.hasEndEvent();
                        if (lastIndex + 1 < validEvents) {
                            eventsToPut = lastIndex + 1;
                            eventsToDump = validEvents - eventsToPut;
                        } else {
                            eventsToPut = validEvents;
                            eventsToDump = 0;
                        }
                        etContainer.putEvents(DataChannelImplEt.this.attachment, 0, eventsToPut);
                        DataChannelImplEt.this.etSystem.putEvents(etContainer);
                        if (eventsToDump > 0) {
                            etContainer.dumpEvents(DataChannelImplEt.this.attachment, lastIndex + 1, eventsToDump);
                            DataChannelImplEt.this.etSystem.dumpEvents(etContainer);
                        }
                        this.sequence.set(nextSequence++);
                    } while (!hasEnd);
                    if (DataChannelImplEt.this.endCallback != null) {
                        DataChannelImplEt.this.endCallback.endWait();
                    }
                    System.out.println("      DataChannel Et out (" + DataChannelImplEt.this.name + "): PUTTER got END event, quitting thread");
                    return;
                }
                catch (AlertException e) {
                    DataChannelImplEt.this.channelState = CODAState.ERROR;
                    DataChannelImplEt.this.emu.setErrorState("DataChannel Et out: ring buffer error");
                }
                catch (InterruptedException e) {
                    System.out.println("      DataChannel Et out: " + DataChannelImplEt.this.name + " interrupted thread");
                }
                catch (TimeoutException e) {
                    DataChannelImplEt.this.channelState = CODAState.ERROR;
                    DataChannelImplEt.this.emu.setErrorState("DataChannel Et out: time out in ring buffer");
                }
                catch (IOException e) {
                    DataChannelImplEt.this.channelState = CODAState.ERROR;
                    System.out.println("      DataChannel Et out: " + DataChannelImplEt.this.name + " network communication error with Et");
                    DataChannelImplEt.this.emu.setErrorState("DataChannel Et out: network communication error with Et");
                    e.printStackTrace();
                }
                catch (EtException e) {
                    DataChannelImplEt.this.channelState = CODAState.ERROR;
                    System.out.println("      DataChannel Et out: " + DataChannelImplEt.this.name + " internal error handling Et");
                    DataChannelImplEt.this.emu.setErrorState("DataChannel Et out: internal error handling Et");
                    e.printStackTrace();
                }
                catch (EtDeadException e) {
                    DataChannelImplEt.this.channelState = CODAState.ERROR;
                    System.out.println("      DataChannel Et out: " + DataChannelImplEt.this.name + " Et system dead");
                    DataChannelImplEt.this.emu.setErrorState("DataChannel Et out: Et system dead");
                }
                catch (EtClosedException e) {
                    DataChannelImplEt.this.channelState = CODAState.ERROR;
                    System.out.println("      DataChannel Et out: " + DataChannelImplEt.this.name + " Et connection closed");
                    DataChannelImplEt.this.emu.setErrorState("DataChannel Et out: Et connection closed");
                }
                finally {
                    DataChannelImplEt.this.logger.info("      DataChannel Et out: PUTTER is Quitting");
                }
            }
        }
    }

    private class DataInputHelper
    extends Thread {
        private EtEvent[] events;
        private int pauseCounter;
        private final CountDownLatch latch;
        private static final long timeBetweenMupdates = 500L;
        private EvGetter getter;
        private RingBuffer<EtContainer> rb;
        private Sequence etConsumeSequence;
        private SequenceBarrier etConsumeBarrier;
        private int expectedRecordId;

        DataInputHelper(ThreadGroup group, String name) {
            super(group, name);
            this.pauseCounter = 0;
            this.latch = new CountDownLatch(2);
            this.expectedRecordId = 1;
            int ringSize = 2;
            this.rb = RingBuffer.createSingleProducer((EventFactory)new ContainerFactory(), (int)ringSize, (WaitStrategy)new SpinCountBackoffWaitStrategy(10000, (WaitStrategy)new LiteBlockingWaitStrategy()));
            this.etConsumeBarrier = this.rb.newBarrier(new Sequence[0]);
            this.etConsumeSequence = new Sequence(-1L);
            this.rb.addGatingSequences(new Sequence[]{this.etConsumeSequence});
            this.getter = new EvGetter(group, name + "_Getter");
            this.getter.start();
        }

        private void waitUntilStarted() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void interruptThreads() {
            DataChannelImplEt.this.stopGetterThread = true;
            this.getter.interrupt();
            this.interrupt();
        }

        @Override
        public void run() {
            this.latch.countDown();
            String errorString = null;
            try {
                EvioCompactReaderUnsync compactReader = null;
                boolean delay = false;
                boolean useDirectEt = DataChannelImplEt.this.etSysLocal != null;
                boolean etAlive = true;
                boolean isUser = false;
                EtContainer etContainer = null;
                long nextSequence = this.etConsumeSequence.get() + 1L;
                long availableSequence = -1L;
                int validEvents = 0;
                if (!useDirectEt) {
                    etAlive = DataChannelImplEt.this.etSystem.alive();
                }
                long t1 = System.currentTimeMillis();
                while (etAlive) {
                    if (delay) {
                        Thread.sleep(1L);
                        delay = false;
                    }
                    if (DataChannelImplEt.this.pause) {
                        DataChannelImplEt.this.logger.warn("      DataChannel Et in: " + DataChannelImplEt.this.name + " - PAUSED");
                        Thread.sleep(5L);
                        continue;
                    }
                    try {
                        if (availableSequence < nextSequence) {
                            availableSequence = this.etConsumeBarrier.waitFor(nextSequence);
                        }
                        etContainer = (EtContainer)this.rb.get(nextSequence);
                        if (useDirectEt) {
                            this.events = etContainer.getEventArrayLocal();
                            validEvents = this.events.length;
                        } else {
                            this.events = etContainer.getEventArray();
                            validEvents = etContainer.getEventCount();
                        }
                    }
                    catch (AlertException alertException) {
                    }
                    catch (InterruptedException e) {
                        if (DataChannelImplEt.this.haveInputEndEvent) {
                            DataChannelImplEt.this.logger.info("      DataChannel Et in: wake up " + DataChannelImplEt.this.name + ", other thd found END, quit");
                        } else if (DataChannelImplEt.this.gotResetCmd) {
                            DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + " got RESET cmd, quitting");
                        }
                        return;
                    }
                    catch (TimeoutException e) {
                        if (DataChannelImplEt.this.haveInputEndEvent) {
                            DataChannelImplEt.this.logger.info("      DataChannel Et in: timeout " + DataChannelImplEt.this.name + ", other thd found END, quit");
                            return;
                        }
                        if (DataChannelImplEt.this.gotResetCmd) {
                            DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + " got RESET cmd, quitting");
                            return;
                        }
                        delay = true;
                        continue;
                    }
                    for (int j = 0; j < validEvents; ++j) {
                        EvioNodePool nodePool;
                        ByteBufferItem bbItem = DataChannelImplEt.this.bbSupply.get();
                        EtEvent ev = this.events[j];
                        int evSize = ev.getLength();
                        bbItem.ensureCapacity(evSize);
                        ByteBuffer buf = bbItem.getBuffer();
                        DataChannelImplEt.copyBuffer(ev.getDataBuffer(), buf, evSize);
                        try {
                            nodePool = (EvioNodePool)bbItem.getMyObject();
                            nodePool.reset();
                            if (compactReader == null) {
                                compactReader = new EvioCompactReaderUnsync(buf, (EvioNodeSource)nodePool);
                            } else {
                                compactReader.setBuffer(buf, (EvioNodeSource)nodePool);
                            }
                        }
                        catch (EvioException e) {
                            DataChannelImplEt.this.bbSupply.release(bbItem);
                            if (DataChannelImplEt.this.ignoreDataErrors) {
                                System.out.println("IGNORE ERROR: " + e.getMessage());
                                continue;
                            }
                            Utilities.printBuffer((ByteBuffer)buf, (int)0, (int)21, (String)"BAD EVENT ");
                            e.printStackTrace();
                            errorString = "DataChannel Et in: ET data NOT evio v4 format";
                            throw e;
                        }
                        BlockHeaderV4 header4 = compactReader.getFirstBlockHeader();
                        if (header4.getVersion() < 4) {
                            DataChannelImplEt.this.bbSupply.release(bbItem);
                            if (DataChannelImplEt.this.ignoreDataErrors) {
                                System.out.println("IGNORE ERROR: version = " + header4.getVersion());
                                continue;
                            }
                            errorString = "DataChannel Et in: ET data NOT evio v4 format";
                            throw new EvioException("Evio data needs to be written in version 4+ format");
                        }
                        ControlType controlType = null;
                        boolean hasFirstEvent = header4.hasFirstEvent();
                        EventType eventType = EventType.getEventType(header4.getEventType());
                        if (eventType == null || !eventType.isEbFriendly()) {
                            DataChannelImplEt.this.bbSupply.release(bbItem);
                            if (DataChannelImplEt.this.ignoreDataErrors) {
                                System.out.println("IGNORE ERROR: event type  = " + (Object)((Object)eventType));
                                continue;
                            }
                            throw new EvioException("bad evio format or improper event type");
                        }
                        int sourceId = header4.getReserved1();
                        if (eventType == EventType.PARTIAL_PHYSICS) {
                            sourceId = ev.getControl()[0];
                        }
                        int recordId = header4.getNumber();
                        this.expectedRecordId = Evio.checkRecordIdSequence(recordId, this.expectedRecordId, true, eventType, DataChannelImplEt.this);
                        int eventCount = compactReader.getEventCount();
                        bbItem.setUsers(eventCount);
                        long t2 = DataChannelImplEt.this.emu.getTime();
                        if (DataChannelImplEt.this.isFirstEB && eventType.isBuildable() && t2 - t1 > 500L) {
                            DataChannelImplEt.this.emu.getCmsgPortal().sendMHandlerMessage(eventCount, "M");
                            t1 = t2;
                        }
                        for (int i = 1; i < eventCount + 1; ++i) {
                            EvioNode node = DataChannelImplEt.this.isER ? compactReader.getEvent(i) : compactReader.getScannedEvent(i, (EvioNodeSource)nodePool);
                            if (eventType == EventType.ROC_RAW) {
                                if (Evio.isUserEvent(node)) {
                                    isUser = true;
                                    eventType = EventType.USER;
                                    if (hasFirstEvent) {
                                        DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + " got First event from ROC");
                                    } else {
                                        DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + " got USER event from ROC");
                                    }
                                } else if (!node.getDataTypeObj().isBank()) {
                                    DataChannelImplEt.this.bbSupply.release(bbItem);
                                    if (DataChannelImplEt.this.ignoreDataErrors) {
                                        System.out.println("IGNORE ERROR: ROC raw record contains " + node.getDataTypeObj() + " instead of banks (data corruption?)");
                                        continue;
                                    }
                                    DataType eventDataType = node.getDataTypeObj();
                                    throw new EvioException("ROC raw record contains " + eventDataType + " instead of banks (data corruption?)");
                                }
                            } else if (eventType == EventType.CONTROL) {
                                controlType = ControlType.getControlType(node.getTag());
                                DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + " got CONTROL event, " + (Object)((Object)controlType));
                                if (controlType == null) {
                                    DataChannelImplEt.this.bbSupply.release(bbItem);
                                    if (DataChannelImplEt.this.ignoreDataErrors) {
                                        System.out.println("IGNORE ERROR: unidentified control event");
                                        continue;
                                    }
                                    errorString = "DataChannel Et in:  unidentified control event, tag = 0x" + Integer.toHexString(node.getTag());
                                    throw new EvioException("unidentified control event, tag = 0x" + Integer.toHexString(node.getTag()));
                                }
                            } else if (eventType == EventType.USER) {
                                isUser = true;
                                if (hasFirstEvent) {
                                    DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + " got FIRST event");
                                } else {
                                    DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + " got USER event");
                                }
                            } else if (!node.getDataTypeObj().isBank()) {
                                DataChannelImplEt.this.bbSupply.release(bbItem);
                                if (DataChannelImplEt.this.ignoreDataErrors) {
                                    System.out.println("IGNORE ERROR: physics record contains " + node.getDataTypeObj() + " instead of banks (data corruption?)");
                                    continue;
                                }
                                DataType eventDataType = node.getDataTypeObj();
                                throw new EvioException("physics record contains " + eventDataType + " instead of banks (data corruption?)");
                            }
                            DataChannelImplEt.this.nextRingItem = DataChannelImplEt.this.ringBufferIn.nextIntr(1);
                            RingItem ri = (RingItem)DataChannelImplEt.this.ringBufferIn.get(DataChannelImplEt.this.nextRingItem);
                            if (eventType.isBuildable()) {
                                ri.setAll(null, null, node, eventType, controlType, isUser, hasFirstEvent, DataChannelImplEt.this.id, recordId, sourceId, node.getNum(), DataChannelImplEt.this.name, bbItem, DataChannelImplEt.this.bbSupply);
                            } else {
                                ri.setAll(null, null, node, eventType, controlType, isUser, hasFirstEvent, DataChannelImplEt.this.id, recordId, sourceId, 1, DataChannelImplEt.this.name, bbItem, DataChannelImplEt.this.bbSupply);
                            }
                            hasFirstEvent = false;
                            isUser = false;
                            DataChannelImplEt.this.ringBufferIn.publish(DataChannelImplEt.this.nextRingItem);
                            if (controlType != ControlType.END) continue;
                            DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + " found END event");
                            DataChannelImplEt.this.haveInputEndEvent = true;
                            break;
                        }
                        if (DataChannelImplEt.this.haveInputEndEvent) break;
                    }
                    try {
                        if (useDirectEt) {
                            etContainer.putEvents(DataChannelImplEt.this.attachmentLocal);
                            DataChannelImplEt.this.etSysLocal.putEvents(etContainer);
                        } else {
                            etContainer.putEvents(DataChannelImplEt.this.attachment, 0, validEvents);
                            DataChannelImplEt.this.etSystem.putEvents(etContainer);
                        }
                        this.etConsumeSequence.set(nextSequence++);
                    }
                    catch (IOException e) {
                        if (DataChannelImplEt.this.ignoreDataErrors) {
                            System.out.println("IGNORE ERROR: " + e.getMessage());
                            continue;
                        }
                        errorString = "DataChannel Et in: network communication error with Et";
                        throw e;
                    }
                    catch (EtException e) {
                        if (DataChannelImplEt.this.ignoreDataErrors) {
                            System.out.println("IGNORE ERROR: " + e.getMessage());
                            continue;
                        }
                        errorString = "DataChannel Et in: internal error handling Et";
                        throw e;
                    }
                    catch (EtDeadException e) {
                        if (DataChannelImplEt.this.ignoreDataErrors) {
                            System.out.println("IGNORE ERROR: " + e.getMessage());
                            continue;
                        }
                        errorString = "DataChannel Et in: Et system dead";
                        throw e;
                    }
                    catch (EtClosedException e) {
                        if (DataChannelImplEt.this.ignoreDataErrors) {
                            System.out.println("IGNORE ERROR: " + e.getMessage());
                            continue;
                        }
                        errorString = "DataChannel Et in: Et connection closed";
                        throw e;
                    }
                    if (DataChannelImplEt.this.haveInputEndEvent) {
                        DataChannelImplEt.this.stopGetterThread = true;
                        if (useDirectEt) {
                            System.out.println("Might be an issue waking up the GETTER thread which is sleeping");
                        } else {
                            DataChannelImplEt.this.logger.info("      DataChannel Et in: wake up GETTER's getEvents() call so it can exit thread");
                            DataChannelImplEt.this.etSystem.wakeUpAttachment(DataChannelImplEt.this.attachment);
                        }
                        if (DataChannelImplEt.this.endCallback != null) {
                            DataChannelImplEt.this.endCallback.endWait();
                        }
                        DataChannelImplEt.this.logger.info("      DataChannel Et in: have END, " + DataChannelImplEt.this.name + " quit parsing thd");
                        return;
                    }
                    if (useDirectEt) continue;
                    etAlive = DataChannelImplEt.this.etSystem.alive();
                }
            }
            catch (InterruptedException e) {
                DataChannelImplEt.this.logger.warn("      DataChannel Et in: " + DataChannelImplEt.this.name + "  interrupted thd, exiting");
            }
            catch (Exception e) {
                DataChannelImplEt.this.channelState = CODAState.ERROR;
                if (errorString == null) {
                    errorString = e.getMessage();
                }
                DataChannelImplEt.this.emu.setErrorState(errorString);
                System.out.println("      DataChannel Et in: " + DataChannelImplEt.this.name + " exit thd: " + errorString);
            }
        }

        private final class EvGetter
        extends Thread {
            EvGetter(ThreadGroup group, String name) {
                super(group, name);
            }

            @Override
            public void run() {
                String errorString;
                boolean gotError;
                boolean useDirectEt = DataChannelImplEt.this.etSysLocal != null;
                DataInputHelper.this.latch.countDown();
                try {
                    while (true) {
                        if (DataChannelImplEt.this.stopGetterThread) {
                            return;
                        }
                        long sequence = DataInputHelper.this.rb.nextIntr(1);
                        EtContainer etContainer = (EtContainer)DataInputHelper.this.rb.get(sequence);
                        if (useDirectEt) {
                            do {
                                try {
                                    etContainer.getEvents(DataChannelImplEt.this.attachmentLocal, Mode.TIMED.getValue(), 500, DataChannelImplEt.this.chunk);
                                    DataChannelImplEt.this.etSysLocal.getEvents(etContainer);
                                }
                                catch (EtTimeoutException etTimeoutException) {
                                    // empty catch block
                                }
                            } while (!DataChannelImplEt.this.stopGetterThread);
                            return;
                        }
                        etContainer.getEvents(DataChannelImplEt.this.attachment, Mode.SLEEP, Modify.NOTHING, 0, DataChannelImplEt.this.chunk);
                        DataChannelImplEt.this.etSystem.getEvents(etContainer);
                        etContainer = null;
                        DataInputHelper.this.rb.publish(sequence++);
                    }
                }
                catch (EtWakeUpException e) {
                    if (DataChannelImplEt.this.haveInputEndEvent) {
                        DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + ", Getter thd woken up, got END event");
                    } else if (DataChannelImplEt.this.gotResetCmd) {
                        DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + ", Getter thd woken up, got RESET cmd");
                    } else {
                        DataChannelImplEt.this.logger.info("      DataChannel Et in: " + DataChannelImplEt.this.name + ", Getter thd woken up");
                    }
                    return;
                }
                catch (IOException e) {
                    gotError = true;
                    errorString = "DataChannel Et in: network communication error with Et";
                }
                catch (EtException e) {
                    gotError = true;
                    errorString = "DataChannel Et in: internal error handling Et";
                }
                catch (EtDeadException e) {
                    gotError = true;
                    errorString = "DataChannel Et in: Et system dead";
                }
                catch (EtClosedException e) {
                    gotError = true;
                    errorString = "DataChannel Et in: Et connection closed";
                }
                catch (Exception e) {
                    gotError = true;
                    errorString = "DataChannel Et in: " + e.getMessage();
                }
                if (gotError) {
                    DataChannelImplEt.this.channelState = CODAState.ERROR;
                    System.out.println("      DataChannel Et in: " + DataChannelImplEt.this.name + ", " + errorString);
                    DataChannelImplEt.this.emu.setErrorState(errorString);
                }
                System.out.println("      DataChannel Et in: GETTER is Quitting");
            }
        }
    }

    private final class ContainerFactory
    implements EventFactory<EtContainer> {
        private ContainerFactory() {
        }

        public EtContainer newInstance() {
            try {
                return new EtContainer(DataChannelImplEt.this.chunk, (int)DataChannelImplEt.this.getEtEventSize());
            }
            catch (EtException etException) {
                return null;
            }
        }
    }
}

