/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.messaging;

import java.util.Set;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.emu.support.codaComponent.CODACommand;
import org.jlab.coda.emu.support.control.Command;
import org.jlab.coda.emu.support.messaging.CMSGPortal;
import org.jlab.coda.emu.support.messaging.GenericCallback;

class RcCommandHandler
extends GenericCallback
implements cMsgCallbackInterface {
    private CMSGPortal cmsgPortal;

    RcCommandHandler(CMSGPortal cmsgPortal) {
        this.cmsgPortal = cmsgPortal;
    }

    public void callback(cMsgMessage msg, Object o) {
        try {
            CODACommand codaCmd = CODACommand.get(msg.getType());
            if (codaCmd == null) {
                return;
            }
            if (codaCmd == CODACommand.RESET) {
                this.cmsgPortal.emu.reset();
                return;
            }
            Command cmd = new Command(codaCmd);
            cmd.setMessage(msg);
            Set names = msg.getPayloadNames();
            for (String name : names) {
                cmd.setArg(name, msg.getPayloadItem(name));
            }
            if (!codaCmd.isTransition()) {
                this.cmsgPortal.emu.execute(cmd);
                return;
            }
            this.cmsgPortal.emu.postCommand(cmd);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

