/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.logger;

import java.io.PrintStream;
import org.jlab.coda.emu.support.logger.LoggerAppender;
import org.jlab.coda.emu.support.logger.LoggingEvent;

public class StdOutAppender
implements LoggerAppender {
    public static boolean enabled = true;

    private static String formatLocation(StackTraceElement ste) {
        if (ste == null) {
            return "";
        }
        return ste.getClassName() + '.' + ste.getMethodName() + '(' + ste.getFileName() + ':' + ste.getLineNumber() + ')';
    }

    @Override
    public void append(LoggingEvent event) {
        if (!enabled) {
            return;
        }
        PrintStream out = System.out;
        if (event.getLevel() == 11) {
            out = System.err;
        }
        String data = "";
        if (event.hasData()) {
            data = " [" + event.getFormatedData() + ']';
        }
        out.println(event.getMessage() + data + "\t  " + StdOutAppender.formatLocation(event.getLocation()));
        if (event.getThrowable() != null) {
            event.getThrowable().printStackTrace(out);
        }
    }
}

