/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.data;

public final class Statistics {
    private int[] histogram;
    private final int[] data;
    private final int window;
    private int dataIndex;
    private boolean once;
    private int mean;
    private int max = Integer.MIN_VALUE;
    private int min = Integer.MAX_VALUE;
    private int binSize;
    private int binCount;
    private int startingBinValue;
    private boolean calculateBinSize;

    public Statistics(int window) {
        this(window, 40, 0);
    }

    public Statistics(int window, int binCount) {
        this(window, binCount, 0);
    }

    public Statistics(int window, int binCount, int binSize) {
        if (window < 100) {
            window = 100;
        }
        if (binCount < 10) {
            binCount = 10;
        }
        if (binSize <= 0) {
            binSize = 0;
            this.calculateBinSize = true;
        }
        this.window = window;
        this.binSize = binSize;
        this.binCount = binCount;
        this.data = new int[window];
        this.histogram = new int[binCount + 5];
    }

    public int[] getHistogram() {
        return this.histogram;
    }

    public void addValue(int val) {
        this.data[this.dataIndex] = val;
        if (!this.once && this.dataIndex == this.window - 1) {
            this.once = true;
        }
        ++this.dataIndex;
        this.dataIndex %= this.window;
    }

    private int calculateStats() {
        long total = 0L;
        int size = this.window;
        if (!this.once) {
            size = this.dataIndex;
        }
        for (int i = 0; i < size; ++i) {
            if (this.data[i] < this.min) {
                this.min = this.data[i];
            }
            if (this.data[i] > this.max) {
                this.max = this.data[i];
            }
            total += (long)this.data[i];
        }
        if (size != 0) {
            this.mean = (int)(total / (long)size);
        }
        return size;
    }

    public int[] fillHistogram() {
        int numValidDataPts = this.calculateStats();
        int cutOffMax = 5 * this.mean;
        if (this.calculateBinSize) {
            this.binSize = (cutOffMax - this.min) / this.binCount;
            if (this.binSize < 100) {
                this.binSize = 100;
            }
            if (this.binSize > 100) {
                this.binSize = this.binSize / 100 * 100;
            }
        }
        this.startingBinValue = this.min / 100 * 100;
        this.histogram[0] = this.binSize;
        this.histogram[1] = this.startingBinValue;
        this.histogram[2] = this.mean;
        this.histogram[3] = this.min;
        this.histogram[4] = this.max;
        for (int i = 0; i < numValidDataPts; ++i) {
            int bin = (this.data[i] - this.startingBinValue) / this.binSize;
            if (bin < 0 || bin >= this.binCount) continue;
            int n = bin + 5;
            this.histogram[n] = this.histogram[n] + 1;
        }
        return this.histogram;
    }

    public void printBuildTimeHistogram(String label, String units) {
        this.fillHistogram();
        System.out.println('\n' + label);
        System.out.println("    Mean = " + this.mean + ' ' + units + ", min = " + this.min + ", max = " + this.max);
        for (int i = 0; i < this.binCount; ++i) {
            System.out.println(this.startingBinValue + i * this.binSize + " - " + (this.startingBinValue + ((i + 1) * this.binSize - 1)) + ' ' + units + " = " + this.histogram[i + 5]);
        }
        System.out.println();
    }
}

