/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.RingItemAdapter;
import org.jlab.coda.jevio.EvioNode;

public class PayloadBuffer
extends RingItemAdapter {
    public PayloadBuffer() {
    }

    public PayloadBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public PayloadBuffer(ByteBuffer buffer, Object attachment, EvioNode node) {
        this.node = node;
        this.buffer = buffer;
        this.attachment = attachment;
    }

    public PayloadBuffer(ByteBuffer buffer, EventType eventType, ControlType controlType, int recordId, int sourceId, String sourceName, EvioNode node) {
        this.buffer = buffer;
        this.eventType = eventType;
        this.controlType = controlType;
        this.recordId = recordId;
        this.sourceId = sourceId;
        this.sourceName = sourceName;
        this.attachment = null;
        this.node = node;
    }

    public PayloadBuffer(PayloadBuffer buf) {
        super(buf);
        if (buf.buffer != null) {
            this.buffer = buf.buffer.duplicate();
            this.buffer.order(buf.buffer.order());
        } else if (buf.node != null) {
            this.buffer = buf.node.getStructureBuffer(true);
            this.node = null;
            this.byteBufferItem = null;
            this.byteBufferSupply = null;
        }
    }

    @Override
    public int getTotalBytes() {
        if (this.buffer != null) {
            return this.buffer.limit();
        }
        if (this.node != null) {
            return this.node.getTotalBytes();
        }
        return 0;
    }

    @Override
    public ByteOrder getByteOrder() {
        if (this.buffer != null) {
            return this.buffer.order();
        }
        if (this.node != null) {
            return this.node.getBufferNode().getBuffer().order();
        }
        return null;
    }

    @Override
    public Object clone() {
        PayloadBuffer item = (PayloadBuffer)super.clone();
        item.attachment = null;
        if (this.buffer != null) {
            item.event = null;
            item.byteBufferItem = null;
            item.byteBufferSupply = null;
            ByteOrder order = this.buffer.order();
            ByteBuffer buf = this.buffer.duplicate().order(order);
            int pos = buf.position();
            int lim = buf.limit();
            item.buffer = ByteBuffer.allocate(buf.capacity()).order(order);
            buf.limit(buf.capacity()).position(0);
            item.buffer.put(buf).position(0);
            item.buffer.limit(lim).position(pos);
        } else {
            item.buffer = null;
        }
        return item;
    }
}

