/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.data;

public enum EventType {
    ROC_RAW(0),
    PHYSICS(1),
    PARTIAL_PHYSICS(2),
    DISENTANGLED_PHYSICS(3),
    USER(4),
    CONTROL(5),
    MIXED(6),
    OTHER(15);

    private int value;
    private static EventType[] intToType;

    public static EventType getEventType(int val) {
        if (val > 15 || val < 0) {
            return null;
        }
        return intToType[val];
    }

    public static String getName(int val) {
        if (val > 15 || val < 0) {
            return null;
        }
        EventType type = EventType.getEventType(val);
        if (type == null) {
            return null;
        }
        return type.name();
    }

    private EventType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isMixed() {
        return this == MIXED;
    }

    public boolean isControl() {
        return this == CONTROL;
    }

    public boolean isUserOrControl() {
        return this == USER || this == CONTROL;
    }

    public boolean isROCRaw() {
        return this == ROC_RAW;
    }

    public boolean isAnyPhysics() {
        return this == PHYSICS || this == PARTIAL_PHYSICS || this == DISENTANGLED_PHYSICS;
    }

    public boolean isPhysics() {
        return this == PHYSICS;
    }

    public boolean isPartialPhysics() {
        return this == PARTIAL_PHYSICS;
    }

    public boolean isDisentangledPhysics() {
        return this == DISENTANGLED_PHYSICS;
    }

    public boolean isEbFriendly() {
        return this.isBuildable() || this == CONTROL || this == USER;
    }

    public boolean isBuildable() {
        return this == ROC_RAW || this == PHYSICS || this == PARTIAL_PHYSICS;
    }

    public boolean isUser() {
        return this == USER;
    }

    static {
        intToType = new EventType[16];
        EventType[] eventTypeArray = EventType.values();
        int n = eventTypeArray.length;
        for (int i = 0; i < n; ++i) {
            EventType type;
            EventType.intToType[type.value] = type = eventTypeArray[i];
        }
    }
}

