/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;

public class ByteBufferItem {
    private int bufferSize;
    private ByteBuffer buffer;
    private final ByteOrder order;
    private final boolean direct;
    private final boolean orderedRelease;
    private long producerSequence;
    private long consumerSequence;
    private AtomicInteger atomicCounter;
    private volatile int volatileCounter;
    private boolean multipleUsers;
    private boolean force;
    private boolean fromConsumerGet;
    private int userInt;
    private boolean userBoolean;
    private Object myObject;
    public int myIndex;
    private final int myId;

    ByteBufferItem(int bufferSize, ByteOrder order, boolean direct, boolean orderedRelease, int myId) {
        this(bufferSize, order, direct, orderedRelease, myId, null, 0);
    }

    ByteBufferItem(int bufferSize, ByteOrder order, boolean direct, boolean orderedRelease, int myId, Object auxObject, int auxIndex) {
        this.myId = myId;
        this.order = order;
        this.direct = direct;
        this.myIndex = auxIndex;
        this.myObject = auxObject;
        this.bufferSize = bufferSize;
        this.orderedRelease = orderedRelease;
        this.buffer = direct ? ByteBuffer.allocateDirect(bufferSize).order(order) : ByteBuffer.allocate(bufferSize).order(order);
    }

    ByteBufferItem(ByteBuffer templateBuf, boolean orderedRelease, int myId) {
        this.myId = myId;
        this.order = templateBuf.order();
        this.direct = templateBuf.isDirect();
        this.bufferSize = templateBuf.capacity();
        this.orderedRelease = orderedRelease;
        if (this.direct) {
            this.buffer = ByteBuffer.allocateDirect(this.bufferSize).order(this.order);
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer.put(i, templateBuf.get(i));
            }
        } else {
            this.buffer = ByteBuffer.allocate(this.bufferSize).order(this.order);
            System.arraycopy(templateBuf.array(), 0, this.buffer.array(), 0, this.bufferSize);
        }
        this.buffer.position(templateBuf.position());
        this.buffer.limit(templateBuf.limit());
    }

    public void reset() {
        this.buffer.clear();
        this.userInt = 0;
        this.force = false;
        this.userBoolean = false;
        this.multipleUsers = false;
        this.fromConsumerGet = false;
        this.consumerSequence = 0L;
        this.producerSequence = 0L;
    }

    public int getMyId() {
        return this.myId;
    }

    public Object getMyObject() {
        return this.myObject;
    }

    public void setMyObject(Object obj) {
        this.myObject = obj;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isFromConsumerGet() {
        return this.fromConsumerGet;
    }

    public void setFromConsumerGet(boolean fromConsumerGet) {
        this.fromConsumerGet = fromConsumerGet;
    }

    public int getUserInt() {
        return this.userInt;
    }

    public void setUserInt(int i) {
        this.userInt = i;
    }

    public boolean getUserBoolean() {
        return this.userBoolean;
    }

    public void setUserBoolean(boolean bool) {
        this.userBoolean = bool;
    }

    public long getProducerSequence() {
        return this.producerSequence;
    }

    public void setProducerSequence(long sequence) {
        this.producerSequence = sequence;
    }

    public long getConsumerSequence() {
        return this.consumerSequence;
    }

    public void setConsumerSequence(long sequence) {
        this.consumerSequence = sequence;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public ByteBuffer getBuffer() {
        this.buffer.position(0);
        return this.buffer;
    }

    public ByteBuffer getBufferAsIs() {
        return this.buffer;
    }

    public void ensureCapacity(int capacity) {
        if (this.bufferSize < capacity) {
            this.buffer = this.direct ? ByteBuffer.allocateDirect(capacity).order(this.order) : ByteBuffer.allocate(capacity).order(this.order);
            this.bufferSize = capacity;
        }
    }

    public void setUsers(int users) {
        if (users > 1) {
            this.multipleUsers = true;
            if (this.orderedRelease) {
                this.volatileCounter = users;
            } else {
                this.atomicCounter = new AtomicInteger(users);
            }
        }
    }

    public int getUsers() {
        if (this.multipleUsers) {
            if (this.orderedRelease) {
                return this.volatileCounter;
            }
            return this.atomicCounter.get();
        }
        return 1;
    }

    boolean decrementCounter() {
        if (!this.multipleUsers) {
            return true;
        }
        if (this.orderedRelease) {
            return --this.volatileCounter < 1;
        }
        return this.atomicCounter.decrementAndGet() < 1;
    }

    public void addUsers(int additionalUsers) {
        if (additionalUsers < 1) {
            return;
        }
        if (!this.multipleUsers) {
            if (this.orderedRelease) {
                this.volatileCounter = additionalUsers + 1;
            } else {
                this.atomicCounter = new AtomicInteger(additionalUsers + 1);
            }
        } else if (this.orderedRelease) {
            this.volatileCounter += additionalUsers;
        } else {
            this.atomicCounter.addAndGet(additionalUsers);
        }
    }
}

