/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.concurrent.TimeUnit;
import org.jlab.coda.emu.support.data.EventType;

public class EmuUtilities {
    private static final long SLEEP_PRECISION = TimeUnit.MILLISECONDS.toNanos(2L);
    private static final long SPIN_YIELD_PRECISION = TimeUnit.MICROSECONDS.toNanos(2L);

    public static void sleepNanos(long nanoDuration) throws InterruptedException {
        long end = System.nanoTime() + nanoDuration;
        long timeLeft = nanoDuration;
        do {
            if (timeLeft > SLEEP_PRECISION) {
                Thread.sleep(1L);
            } else if (timeLeft > SPIN_YIELD_PRECISION) {
                Thread.yield();
            }
            timeLeft = end - System.nanoTime();
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        } while (timeLeft > 0L);
    }

    public static final void printStackTrace() {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            System.out.println(ste);
        }
    }

    public static final ByteBuffer deepCopy(ByteBuffer source) {
        if (source == null) {
            return null;
        }
        int sourceP = source.position();
        int sourceL = source.limit();
        source.clear();
        ByteBuffer target = ByteBuffer.allocate(source.capacity());
        target.put(source);
        target.flip();
        source.position(sourceP);
        source.limit(sourceL);
        return target;
    }

    public static final String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(46) < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public static final String inputStr(String s) {
        String aLine = "";
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(s);
        try {
            aLine = input.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aLine;
    }

    public static final void setEventType(BitSet bSet, EventType eType) {
        int type = eType.getValue();
        if (type < 0) {
            type = 0;
        } else if (type > 15) {
            type = 15;
        }
        if (bSet == null || bSet.size() < 6) {
            return;
        }
        for (int i = 2; i < 6; ++i) {
            bSet.set(i, (type >>> i - 2 & 1) > 0);
        }
    }

    public static final void setFirstEvent(BitSet bSet) {
        if (bSet == null || bSet.size() < 7) {
            return;
        }
        bSet.set(6, true);
    }

    public static final void unsetFirstEvent(BitSet bSet) {
        if (bSet == null || bSet.size() < 7) {
            return;
        }
        bSet.set(6, false);
    }

    public static final int powerOfTwo(int x, boolean roundUp) {
        int y;
        if (x < 0) {
            return -1;
        }
        if (roundUp) {
            --x;
            x |= x >> 1;
            x |= x >> 2;
            x |= x >> 4;
            x |= x >> 8;
            x |= x >> 16;
            return x + 1;
        }
        do {
            y = x;
        } while ((x &= x - 1) != 0);
        return y;
    }
}

