/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test.blast;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.data.RingItemFactory;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.EvioCompactReaderUnsync;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;

public class EmuBlastee2 {
    private AtomicInteger clientNumber = new AtomicInteger(1);
    private AtomicInteger clientCount = new AtomicInteger(0);
    private volatile boolean killThreads;
    private boolean direct;
    private boolean parseData;
    private ConcurrentHashMap<Integer, ByteBufferSupply> allSupplies = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ClientMergerForEvio> mergers = new ConcurrentHashMap();
    private ClientMergerForBuffers mergerForBuffersThread;
    private ClientMergerForEvio mergerForEvioThread;
    private int bufferSize = 8192;
    private int receiveBufferSize = 32768;
    private int blasteePort = 22333;
    private int blockCount = 4;
    private boolean noDelay;
    private int timeInterval = 5;
    private long messageCount = 0L;
    private volatile long byteCount = 0L;
    private Statistics statThread;

    private static void usage() {
        System.out.println("\nUsage:\n\n   java EmuBlastee\n        [-d <buf size>]    reading data buffer size in bytes (8192)\n        [-r <buf size>]    TCP receive buffer size in bytes (4*8192)\n        [-b <blocks>]      number of buffers to read in one loop (4)\n        [-p <port>]        TCP port (22333)\n        [-t <seconds>]     time between printouts in sec (5)\n        [-parse]           parse data into evio events and place in ring\n        [-help]            print this message\n");
    }

    public static void main(String[] args) {
        try {
            EmuBlastee2 blastee = new EmuBlastee2(args);
            blastee.run();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void stopServer() {
    }

    public EmuBlastee2(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        boolean setReceiveBufSize = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-help")) {
                    EmuBlastee2.usage();
                    System.exit(-1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-d")) {
                    this.bufferSize = Integer.parseInt(args[i + 1]);
                    if (this.bufferSize < 1) {
                        System.out.println("Data buffer size must be > 0");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-r")) {
                    this.receiveBufferSize = Integer.parseInt(args[i + 1]);
                    if (this.receiveBufferSize < 1) {
                        System.out.println("TCP receive buffer size must be > 0");
                        System.exit(1);
                    }
                    setReceiveBufSize = true;
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-b")) {
                    this.blockCount = Integer.parseInt(args[i + 1]);
                    if (this.blockCount < 1) {
                        System.out.println("Number of blocks must be > 0");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-p")) {
                    this.blasteePort = Integer.parseInt(args[i + 1]);
                    if (this.blasteePort < 1024 || this.blasteePort > 65535) {
                        System.out.println("Port must be > 1023 & < 65536");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-parse")) {
                    this.parseData = true;
                    System.out.println("ParseData = true");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-t")) {
                    this.timeInterval = Integer.parseInt(args[i + 1]);
                    if (this.timeInterval < 1) {
                        this.timeInterval = 1;
                    }
                    ++i;
                    continue;
                }
                EmuBlastee2.usage();
                System.exit(-1);
            }
        }
        catch (Exception ex) {
            EmuBlastee2.usage();
            System.exit(-1);
        }
        if (!setReceiveBufSize) {
            this.receiveBufferSize = this.bufferSize <= 8192 ? 32768 : 4 * this.bufferSize;
        }
    }

    public void run() {
        this.statThread = new Statistics();
        this.statThread.start();
        if (!this.parseData) {
            this.mergerForBuffersThread = new ClientMergerForBuffers();
        }
        try {
            ServerSocket listeningSocket = new ServerSocket();
            listeningSocket.setReuseAddress(true);
            listeningSocket.setReceiveBufferSize(this.receiveBufferSize);
            listeningSocket.setPerformancePreferences(0, 0, 1);
            listeningSocket.bind(new InetSocketAddress(this.blasteePort));
            while (true) {
                Socket socket = listeningSocket.accept();
                socket.setPerformancePreferences(0, 0, 1);
                if (this.receiveBufferSize > 0) {
                    socket.setReceiveBufferSize(this.receiveBufferSize);
                }
                BufferedInputStream bufferedIn = new BufferedInputStream(socket.getInputStream());
                DataInputStream in = new DataInputStream(bufferedIn);
                int id = in.readInt();
                int socketCount = in.readInt();
                int socketPosition = in.readInt();
                System.out.println("Got connection from " + id + ", socket count = " + socketCount + ", pos = " + socketPosition);
                if (this.parseData) {
                    ClientMergerForEvio merger = this.mergers.get(id);
                    if (merger == null) {
                        System.out.println("Create new merger");
                        merger = new ClientMergerForEvio(id, socketCount);
                        this.mergers.put(id, merger);
                    }
                    if (merger.handlerCount < socketCount) {
                        System.out.println("Add handler to existing merger");
                        merger.addHandler(new ClientHandler(id, socket, in, socketCount, socketPosition));
                        if (!merger.isReady()) continue;
                        System.out.println("Merger is ready (handler count = " + merger.handlerCount + "), start merger");
                        merger.start();
                        continue;
                    }
                    System.out.println("Too many sockets for 1 emu connection");
                    continue;
                }
                ClientHandler handler = new ClientHandler(id, socket, in, socketCount, socketPosition);
                handler.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    private class Statistics
    extends Thread {
        private boolean init;
        private long totalBytes;
        private long oldVal;
        private long totalT;
        private long totalCount;
        long localByteCount;
        long t;
        long deltaT;
        long deltaCount;
        private int skip = 2;

        private Statistics() {
        }

        private synchronized void clear() {
            this.totalBytes = 0L;
            this.totalT = 0L;
            this.totalCount = 0L;
            EmuBlastee2.this.byteCount = 0L;
            EmuBlastee2.this.messageCount = 0L;
            this.oldVal = 0L;
            this.skip = 2;
            this.init = true;
            this.t = System.currentTimeMillis();
        }

        @Override
        public void run() {
            int sleepTime = 1000 * EmuBlastee2.this.timeInterval;
            this.clear();
            while (true) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.localByteCount = EmuBlastee2.this.byteCount;
                this.deltaT = System.currentTimeMillis() - this.t;
                if (this.localByteCount > 0L) {
                    if (!this.init) {
                        this.totalBytes += this.localByteCount;
                    }
                    if (this.skip-- < 1) {
                        this.totalT += this.deltaT;
                        this.deltaCount = this.totalBytes - this.oldVal;
                        this.totalCount += this.deltaCount;
                        System.out.printf("%3.2e bytes/s in %d sec, %3.2e avg,  Messages: %d Hz,  %d blasters\n", (double)this.deltaCount * 1000.0 / (double)this.deltaT, EmuBlastee2.this.timeInterval, (double)this.totalCount * 1000.0 / (double)this.totalT, EmuBlastee2.this.messageCount * 1000L / this.deltaT, EmuBlastee2.this.clientCount.get());
                    } else {
                        System.out.printf("%3.2e bytes/s in %d sec,  Messages: %d Hz,  %d blasters\n", (double)this.localByteCount * 1000.0 / (double)this.deltaT, EmuBlastee2.this.timeInterval, EmuBlastee2.this.messageCount * 1000L / this.deltaT, EmuBlastee2.this.clientCount.get());
                    }
                    this.t = System.currentTimeMillis();
                    this.init = false;
                    this.oldVal = this.totalBytes;
                    EmuBlastee2.this.byteCount = 0L;
                    EmuBlastee2.this.messageCount = 0L;
                    continue;
                }
                System.out.println("No bytes read in the last " + EmuBlastee2.this.timeInterval + " seconds.");
                this.clear();
            }
        }
    }

    private class ClientMergerForEvio
    extends Thread {
        int id;
        int socketCount;
        int handlerCount;
        ClientHandler[] handlers;
        int pCounter = 0;

        ClientMergerForEvio(int id, int socketCount) {
            this.id = id;
            this.socketCount = socketCount;
            this.handlers = new ClientHandler[socketCount];
        }

        public void addHandler(ClientHandler handler) {
            if (this.handlerCount >= this.socketCount) {
                System.out.println("Trying to add too many handlers!!!");
                return;
            }
            if (this.id != handler.id) {
                System.out.println("\n\n\nID Mismatch!!!\n\n\n");
            }
            this.handlers[handler.socketPosition - 1] = handler;
            ++this.handlerCount;
        }

        public boolean isReady() {
            return this.handlerCount == this.socketCount;
        }

        public void startHandlers() {
            for (ClientHandler client : this.handlers) {
                if (client == null) continue;
                client.start();
            }
        }

        @Override
        public void run() {
            System.out.println("Starting merger");
            long counter = 0L;
            try {
                block2: while (true) {
                    ClientHandler[] clientHandlerArray = this.handlers;
                    int n = clientHandlerArray.length;
                    int n2 = 0;
                    while (true) {
                        RingItem ri;
                        if (n2 >= n) continue block2;
                        ClientHandler client = clientHandlerArray[n2];
                        do {
                            if (client.availableSequence <= client.nextSequence) {
                                client.availableSequence = client.barrier.waitFor(client.nextSequence);
                            }
                            ri = (RingItem)client.ringBuffer.get(client.nextSequence);
                            if (this.pCounter++ < 565) {
                                long[] data = ri.getNode().getLongData();
                                System.out.println(client.socketPosition + " ts = " + data[2] + ", 0x" + Long.toHexString(data[2]));
                            }
                            ri.getByteBufferSupply().release(ri.getByteBufferItem());
                            client.sequence.set(client.nextSequence++);
                        } while (!ri.getSwitchRing());
                        ++n2;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private class ClientMergerForBuffers
    extends Thread {
        ClientMergerForBuffers() {
            this.start();
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    Iterator iterator = EmuBlastee2.this.allSupplies.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        ByteBufferSupply supply = (ByteBufferSupply)iterator.next();
                        ByteBufferItem item = supply.consumerGet();
                        supply.release(item);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private class ClientHandler
    extends Thread {
        Socket socket;
        DataInputStream in;
        ByteBufferSupply bbSupply;
        int me;
        int id;
        int socketCount;
        int socketPosition;
        boolean ready;
        long nextSequence;
        long availableSequence = -1L;
        Sequence sequence;
        SequenceBarrier barrier;
        RingBuffer<RingItem> ringBuffer;

        ClientHandler(int id, Socket socket, DataInputStream in, int socketCount, int socketPosition) {
            this.in = in;
            this.id = id;
            this.socket = socket;
            this.socketCount = socketCount;
            this.socketPosition = socketPosition;
            if (EmuBlastee2.this.parseData) {
                this.ringBuffer = RingBuffer.createSingleProducer((EventFactory)new RingItemFactory(), (int)4096, (WaitStrategy)new YieldingWaitStrategy());
                this.barrier = this.ringBuffer.newBarrier(new Sequence[0]);
                this.sequence = new Sequence(-1L);
                this.ringBuffer.addGatingSequences(new Sequence[]{this.sequence});
                this.nextSequence = this.sequence.get() + 1L;
            }
            this.start();
        }

        @Override
        public void run() {
            boolean blasteeStop = false;
            this.me = EmuBlastee2.this.clientNumber.getAndIncrement();
            SocketChannel channel = this.socket.getChannel();
            ParsingThread parsingThread = null;
            ByteBuffer wordCmdBuf = ByteBuffer.allocate(8);
            IntBuffer ibuf = wordCmdBuf.asIntBuffer();
            System.out.println("Client " + this.me + ", bufferSize = " + EmuBlastee2.this.bufferSize);
            this.bbSupply = new ByteBufferSupply(16, EmuBlastee2.this.bufferSize, ByteOrder.BIG_ENDIAN, EmuBlastee2.this.direct, true);
            if (EmuBlastee2.this.parseData) {
                parsingThread = new ParsingThread();
            } else {
                System.out.println("Client " + this.me + ", parseData = false");
            }
            EmuBlastee2.this.allSupplies.put(this.me, this.bbSupply);
            EmuBlastee2.this.clientCount.getAndIncrement();
            EmuBlastee2.this.statThread.clear();
            block5: while (true) {
                if (blasteeStop) {
                    if (!EmuBlastee2.this.parseData) break;
                    parsingThread.stop();
                    break;
                }
                int blocks = 0;
                while (true) {
                    int size;
                    if (blocks >= EmuBlastee2.this.blockCount) continue block5;
                    ByteBufferItem item = null;
                    try {
                        int cmd;
                        item = this.bbSupply.get();
                        ByteBuffer buf = item.getBuffer();
                        byte[] array = item.getBuffer().array();
                        if (EmuBlastee2.this.direct) {
                            channel.read(wordCmdBuf);
                            cmd = ibuf.get();
                            size = ibuf.get();
                            ibuf.position(0);
                            wordCmdBuf.position(0);
                            buf.limit(size);
                            while (buf.position() < buf.limit()) {
                                channel.read(buf);
                            }
                            buf.flip();
                            buf.position(0).limit(size);
                        } else {
                            long cmdAndSize = this.in.readLong();
                            cmd = (int)(cmdAndSize >>> 32 & 0xFFL);
                            size = (int)cmdAndSize;
                            buf.limit(size);
                            this.in.readFully(array, 0, size);
                        }
                    }
                    catch (InterruptedException ex) {
                        blasteeStop = true;
                        continue block5;
                    }
                    catch (IOException ex) {
                        blasteeStop = true;
                        continue block5;
                    }
                    this.bbSupply.publish(item);
                    EmuBlastee2.this.byteCount = EmuBlastee2.this.byteCount + (long)(size + 8);
                    EmuBlastee2.this.messageCount++;
                    ++blocks;
                }
                break;
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Blaster " + this.me + " quitting");
            EmuBlastee2.this.allSupplies.remove(this.me);
            EmuBlastee2.this.clientCount.getAndDecrement();
            if (EmuBlastee2.this.parseData) {
                EmuBlastee2.this.mergerForEvioThread.stop();
                EmuBlastee2.this.mergerForEvioThread = new ClientMergerForEvio(this.id, this.socketCount);
            } else {
                EmuBlastee2.this.mergerForBuffersThread.stop();
                EmuBlastee2.this.mergerForBuffersThread = new ClientMergerForBuffers();
            }
            EmuBlastee2.this.statThread.clear();
        }

        private class ParsingThread
        extends Thread {
            boolean isER = false;

            ParsingThread() {
                this.start();
            }

            @Override
            public void run() {
                System.out.println("Parsing Thread started");
                long counter = 0L;
                try {
                    while (true) {
                        ByteBufferItem item = ClientHandler.this.bbSupply.consumerGet();
                        this.parseToRing(item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }

            private final void parseToRing(ByteBufferItem item) throws IOException, EvioException {
                boolean isUser = false;
                boolean dumpData = false;
                boolean haveInputEndEvent = false;
                ControlType controlType = null;
                EvioCompactReaderUnsync compactReader = null;
                int id = 0;
                int sourceId = 0;
                ByteBuffer buf = item.getBuffer();
                try {
                    if (compactReader == null) {
                        compactReader = new EvioCompactReaderUnsync(buf);
                    } else {
                        compactReader.setBuffer(buf);
                    }
                }
                catch (EvioException e) {
                    System.out.println("EmuBlastee: data NOT evio v4 format");
                    throw e;
                }
                BlockHeaderV4 blockHeader = compactReader.getFirstBlockHeader();
                if (blockHeader.getVersion() < 4) {
                    System.out.println("EmuBlastee: data NOT evio v4 format");
                    throw new EvioException("Data not in evio v4 format");
                }
                boolean hasFirstEvent = blockHeader.hasFirstEvent();
                EventType eventType = EventType.getEventType(blockHeader.getEventType());
                if (eventType == null) {
                    System.out.println("EmuBlastee: bad format evio block header");
                    throw new EvioException("bad format evio block header");
                }
                int recordId = blockHeader.getNumber();
                int eventCount = compactReader.getEventCount();
                item.setUsers(eventCount);
                for (int i = 1; i < eventCount + 1; ++i) {
                    EvioNode node = this.isER ? compactReader.getEvent(i) : compactReader.getScannedEvent(i);
                    if (eventType == EventType.ROC_RAW) {
                        if (Evio.isUserEvent(node)) {
                            isUser = true;
                            eventType = EventType.USER;
                            if (hasFirstEvent) {
                                System.out.println("EmuBlastee: FIRST event from ROC RAW");
                            } else {
                                System.out.println("EmuBlastee: USER event from ROC RAW");
                            }
                        }
                    } else if (eventType == EventType.CONTROL) {
                        controlType = ControlType.getControlType(node.getTag());
                        System.out.println("EmuBlastee: " + (Object)((Object)controlType) + " event from ROC");
                        if (controlType == null) {
                            System.out.println("EmuBlastee: found unidentified control event");
                            throw new EvioException("Found unidentified control event");
                        }
                    } else if (eventType == EventType.USER) {
                        isUser = true;
                        if (hasFirstEvent) {
                            System.out.println("EmuBlastee: FIRST event");
                        } else {
                            System.out.println("EmuBlastee: USER event");
                        }
                    }
                    if (dumpData) {
                        ClientHandler.this.bbSupply.release(item);
                        continue;
                    }
                    long nextRingItem = ClientHandler.this.ringBuffer.next();
                    RingItem ri = (RingItem)ClientHandler.this.ringBuffer.get(nextRingItem);
                    if (eventType.isBuildable()) {
                        ri.setAll(null, null, node, eventType, controlType, isUser, hasFirstEvent, id, recordId, sourceId, node.getNum(), "Blaster", item, ClientHandler.this.bbSupply);
                    } else {
                        ri.setAll(null, null, node, eventType, controlType, isUser, hasFirstEvent, id, recordId, sourceId, 1, "Blaster", item, ClientHandler.this.bbSupply);
                    }
                    if (i == eventCount) {
                        ri.setSwitchRing(true);
                    }
                    hasFirstEvent = false;
                    isUser = false;
                    ClientHandler.this.ringBuffer.publish(nextRingItem);
                    if (controlType != ControlType.END) continue;
                    System.out.println("EmuBlastee: found END event");
                    haveInputEndEvent = true;
                    break;
                }
            }
        }
    }
}

