/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.emu.test.LocalEmuDomainServer;

public class EmuDomainReceiver {
    private boolean debug;
    private int tcpPort = 46100;
    private String expid;
    private String name = "Eb1";

    EmuDomainReceiver(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                EmuDomainReceiver.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                String port = args[i + 1];
                ++i;
                try {
                    this.tcpPort = Integer.parseInt(port);
                    if (this.tcpPort >= 1024 && this.tcpPort <= 65535) continue;
                    this.tcpPort = 46100;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            if (args[i].equalsIgnoreCase("-x")) {
                this.expid = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            EmuDomainReceiver.usage();
            System.exit(-1);
        }
        if (this.expid == null) {
            this.expid = System.getenv("EXPID");
            if (this.expid == null) {
                System.out.println("Provide an EXPID either on the cmd line");
                System.out.println("or in an environmental variable");
                System.exit(-1);
            }
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java EmuDomainReceiver\n        [-p <port>]   TCP port to listen on for connections\n        [-x <expid>]  EXPID of experiment\n        [-n <name>]   name of server's CODA component\n        [-debug]      turn on printout\n        [-h]          print this help\n");
    }

    public static void main(String[] args) {
        try {
            EmuDomainReceiver receiver = new EmuDomainReceiver(args);
            receiver.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run() {
        try {
            LocalEmuDomainServer server = new LocalEmuDomainServer(this.tcpPort, this.expid, this.name, null);
            server.start();
        }
        catch (cMsgException e) {
            e.printStackTrace();
        }
    }
}

