/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicLong;

public class BuildThreadTest {
    private boolean debug;
    private boolean global;
    private boolean volLong;
    private int buildThreadCount = 2;
    private AtomicLong releaseIndex = new AtomicLong(0L);
    private long releaseIndexLong = 0L;
    private long[] waitHistogram;
    private long[] nextReleaseIndexes;
    private Phaser phaser;

    BuildThreadTest(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                BuildThreadTest.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                String threads = args[i + 1];
                ++i;
                try {
                    this.buildThreadCount = Integer.parseInt(threads);
                    if (this.buildThreadCount >= 2) continue;
                    this.buildThreadCount = 2;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (args[i].equalsIgnoreCase("-g")) {
                this.global = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-v")) {
                this.volLong = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            BuildThreadTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java BuildThreadTest\n        [-t <threads>]   number of simulated build threads to run\n        [-debug]         turn on printout\n        [-h]             print this help\n");
    }

    public static void main(String[] args) {
        try {
            BuildThreadTest receiver = new BuildThreadTest(args);
            receiver.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run() {
        this.waitHistogram = new long[this.buildThreadCount];
        this.nextReleaseIndexes = new long[this.buildThreadCount];
        BuildThread[] bt = new BuildThread[this.buildThreadCount];
        BuildThreadVol[] btVol = new BuildThreadVol[this.buildThreadCount];
        this.phaser = new Phaser(this.buildThreadCount);
        System.out.println("Use " + this.buildThreadCount + " build threads");
        for (int i = 0; i < this.buildThreadCount; ++i) {
            if (this.volLong) {
                btVol[i] = new BuildThreadVol(i);
                btVol[i].start();
                continue;
            }
            bt[i] = new BuildThread(i);
            bt[i].start();
        }
        while (true) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if (!this.debug) continue;
            for (int i = 0; i < this.buildThreadCount; ++i) {
                System.out.println(i + 1 + " - " + this.waitHistogram[i]);
            }
            System.out.println();
        }
    }

    class BuildThread
    extends Thread {
        int btIndex;
        long nextReleaseIndex;

        public BuildThread(int btIndex) {
            this.btIndex = btIndex;
            ((BuildThreadTest)BuildThreadTest.this).nextReleaseIndexes[btIndex] = this.nextReleaseIndex = (long)btIndex;
        }

        @Override
        public void run() {
            BuildThreadTest.this.phaser.arriveAndAwaitAdvance();
            while (true) {
                long counter = 0L;
                if (BuildThreadTest.this.global) {
                    while (BuildThreadTest.this.nextReleaseIndexes[this.btIndex] > BuildThreadTest.this.releaseIndex.get()) {
                        Thread.yield();
                        if (!BuildThreadTest.this.debug || ++counter <= 2000000L) continue;
                        counter = 0L;
                        long[] lArray = BuildThreadTest.this.waitHistogram;
                        int n = this.btIndex;
                        lArray[n] = lArray[n] + 1L;
                        System.out.print(this.btIndex + ", " + BuildThreadTest.this.releaseIndex.get() + ": ");
                        for (int j = 0; j < BuildThreadTest.this.buildThreadCount; ++j) {
                            System.out.print(BuildThreadTest.this.nextReleaseIndexes[j] + ", ");
                        }
                        System.out.println();
                    }
                } else {
                    while (this.nextReleaseIndex > BuildThreadTest.this.releaseIndex.get()) {
                        Thread.yield();
                        if (!BuildThreadTest.this.debug || ++counter <= 2000000L) continue;
                        counter = 0L;
                        long[] lArray = BuildThreadTest.this.waitHistogram;
                        int n = this.btIndex;
                        lArray[n] = lArray[n] + 1L;
                        System.out.println(this.btIndex + ", " + BuildThreadTest.this.releaseIndex.get() + ": " + this.nextReleaseIndex);
                    }
                }
                System.out.print(this.btIndex + " ");
                if (BuildThreadTest.this.global) {
                    long[] lArray = BuildThreadTest.this.nextReleaseIndexes;
                    int n = this.btIndex;
                    lArray[n] = lArray[n] + (long)BuildThreadTest.this.buildThreadCount;
                } else {
                    this.nextReleaseIndex += (long)BuildThreadTest.this.buildThreadCount;
                }
                BuildThreadTest.this.releaseIndex.getAndIncrement();
            }
        }
    }

    class BuildThreadVol
    extends Thread {
        int btIndex;
        long nextReleaseIndex;

        public BuildThreadVol(int btIndex) {
            this.btIndex = btIndex;
            ((BuildThreadTest)BuildThreadTest.this).nextReleaseIndexes[btIndex] = this.nextReleaseIndex = (long)btIndex;
        }

        @Override
        public void run() {
            BuildThreadTest.this.phaser.arriveAndAwaitAdvance();
            while (true) {
                long counter = 0L;
                if (BuildThreadTest.this.global) {
                    while (BuildThreadTest.this.nextReleaseIndexes[this.btIndex] > BuildThreadTest.this.releaseIndexLong) {
                        Thread.yield();
                        if (!BuildThreadTest.this.debug || ++counter <= 2000000L) continue;
                        counter = 0L;
                        System.out.print(this.btIndex + ", " + BuildThreadTest.this.releaseIndex.get() + ": ");
                        for (int j = 0; j < BuildThreadTest.this.buildThreadCount; ++j) {
                            System.out.print(BuildThreadTest.this.nextReleaseIndexes[j] + ", ");
                        }
                        System.out.println();
                    }
                } else {
                    while (this.nextReleaseIndex > BuildThreadTest.this.releaseIndexLong) {
                        Thread.yield();
                        if (!BuildThreadTest.this.debug || ++counter <= 2000000L) continue;
                        counter = 0L;
                        long[] lArray = BuildThreadTest.this.waitHistogram;
                        int n = this.btIndex;
                        lArray[n] = lArray[n] + 1L;
                        System.out.println(this.btIndex + ", " + BuildThreadTest.this.releaseIndex.get() + ": " + this.nextReleaseIndex);
                    }
                }
                System.out.print(this.btIndex + " ");
                if (BuildThreadTest.this.global) {
                    long[] lArray = BuildThreadTest.this.nextReleaseIndexes;
                    int n = this.btIndex;
                    lArray[n] = lArray[n] + (long)BuildThreadTest.this.buildThreadCount;
                } else {
                    this.nextReleaseIndex += (long)BuildThreadTest.this.buildThreadCount;
                }
                BuildThreadTest.this.releaseIndexLong++;
            }
        }
    }
}

