/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.layout.GroupLayout;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.support.codaComponent.CODACommand;
import org.jlab.coda.emu.support.configurer.Configurer;
import org.jlab.coda.emu.support.configurer.DataNode;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.logger.QueueAppender;
import org.jlab.coda.emu.support.ui.AboutBox;
import org.jlab.coda.emu.support.ui.HelpBox;
import org.jlab.coda.emu.support.ui.MDIDesktopPane;
import org.jlab.coda.emu.support.ui.SmartToolbar;
import org.jlab.coda.emu.support.ui.log.SwingLogConsoleDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DebugFrame
extends JFrame {
    private int documentCount = 0;
    private Logger logger;
    private Emu emu;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem quitMenuItem;
    private JMenu editMenu;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem undoMenuItem;
    private JMenu logMenu;
    private JMenuItem clearMenuItem;
    private JCheckBox errorLoggingCheckBox;
    private JCheckBox debugLoggingCheckBox;
    private JMenu helpMenu;
    private JMenuItem help;
    private JMenuItem aboutMenuItem;
    private SmartToolbar smartToolbar;
    private SmartToolbar smartToolbar1;
    private SmartToolbar smartToolbar2;
    private JSplitPane splitPane1;
    private JScrollPane scrollPane1;
    private MDIDesktopPane desktopPane;
    private JScrollPane logScrollPane;
    private SwingLogConsoleDialog logPanel;
    private SmartToolbar smartToolbar3;

    public DebugFrame(Emu emu) {
        this.initComponents();
        this.setTitle(emu.name());
        QueueAppender logQueueAppender = new QueueAppender(1024);
        this.emu = emu;
        this.logger = emu.getLogger();
        this.logger.addAppender(logQueueAppender);
        this.logPanel.monitor(logQueueAppender);
        this.smartToolbar.configure(emu, 0);
        this.smartToolbar1.configure(emu, 1);
        this.smartToolbar2.configure(emu, 2);
        this.smartToolbar3.configure(emu, 3);
        this.splitPane1.setDividerLocation(0.75);
        this.setVisible(true);
    }

    public void generateInputPanel() {
        SmartToolbar[] toolbars;
        EnumSet<CODACommand> enumSet = EnumSet.allOf(CODACommand.class);
        for (CODACommand item : CODACommand.values()) {
            if (item.getInputType() != null && item.getGuiGroup() >= 0) continue;
            enumSet.remove((Object)item);
        }
        LinkedHashMap<JButton, SmartToolbar> buttons = new LinkedHashMap<JButton, SmartToolbar>();
        for (SmartToolbar toolbar : toolbars = new SmartToolbar[]{this.smartToolbar, this.smartToolbar1, this.smartToolbar2, this.smartToolbar3}) {
            Component[] comps;
            for (Component comp : comps = toolbar.getComponents()) {
                for (CODACommand cmd : enumSet) {
                    if (!cmd.name().equals(comp.getName())) continue;
                    buttons.put((JButton)comp, toolbar);
                }
            }
        }
        JPanel panel = new JPanel();
        Color color = new Color(0, 0, 255);
        LineBorder border = new LineBorder(color, 1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Input", 1, 2, null, color);
        panel.setBorder(titledBorder);
        GroupLayout layout = new GroupLayout((Container)panel);
        panel.setLayout((LayoutManager)layout);
        layout.setAutocreateGaps(false);
        layout.setAutocreateContainerGaps(false);
        GroupLayout.ParallelGroup hGroup = layout.createParallelGroup();
        layout.setHorizontalGroup((GroupLayout.Group)hGroup);
        GroupLayout.SequentialGroup rows = layout.createSequentialGroup();
        layout.setVerticalGroup((GroupLayout.Group)rows);
        for (Map.Entry entry : buttons.entrySet()) {
            JButton button = (JButton)entry.getKey();
            SmartToolbar toolbar = (SmartToolbar)entry.getValue();
            GroupLayout.ParallelGroup row = layout.createParallelGroup(3);
            GroupLayout.SequentialGroup col = layout.createSequentialGroup();
            JLabel label = new JLabel(button.getName());
            JTextField text = new JTextField();
            row.add((Component)label);
            col.add((Component)label);
            row.add((Component)text);
            col.add((Component)text);
            rows.add((GroupLayout.Group)row);
            hGroup.add((GroupLayout.Group)col);
            toolbar.addButtonListener(this.emu, button, text);
        }
        this.addPanel(panel, "Input");
    }

    public void addDocument(Document doc) {
        if (doc == null) {
            return;
        }
        try {
            Element node = doc.getDocumentElement();
            DataNode dn = Configurer.treeToPanel(node, 0);
            JInternalFrame f = new JInternalFrame(dn.getValue(), true, false, true, true);
            f.getContentPane().add(dn.getContainer());
            f.setMinimumSize(new Dimension(200, 200));
            f.setLocation(220 * this.documentCount, 0);
            f.pack();
            f.setVisible(true);
            f.setSelected(true);
            this.desktopPane.add(f);
            this.desktopPane.validate();
            doc.setUserData("DisplayPanel", f, null);
            this.pack();
        }
        catch (Exception e) {
            System.err.println("ERROR " + e.getMessage());
            e.printStackTrace();
        }
        ++this.documentCount;
    }

    public void addPanel(JPanel panel, String title) {
        try {
            JInternalFrame f = new JInternalFrame(title, true, false, true, true);
            f.getContentPane().add(panel);
            f.setPreferredSize(new Dimension(200, 200));
            f.setMinimumSize(new Dimension(200, 200));
            f.setLocation(220 * this.documentCount, 0);
            f.pack();
            f.setVisible(true);
            f.setSelected(true);
            this.desktopPane.add(f);
            this.desktopPane.validate();
            this.pack();
        }
        catch (Exception e) {
            System.err.println("ERROR " + e.getMessage());
            e.printStackTrace();
        }
        ++this.documentCount;
    }

    public void removeDocument(Document doc) {
        JInternalFrame p = (JInternalFrame)doc.getUserData("DisplayPanel");
        if (p == null) {
            return;
        }
        --this.documentCount;
        this.desktopPane.remove(p);
        this.desktopPane.validate();
        this.desktopPane.repaint();
    }

    public SmartToolbar getToolBar() {
        return this.smartToolbar;
    }

    private void helpActionPerformed(ActionEvent e) {
        HelpBox theBox = new HelpBox(this);
        theBox.setVisible(true);
    }

    private static void aboutMenuItemActionPerformed(ActionEvent e) {
        AboutBox theBox = new AboutBox();
        theBox.setVisible(true);
    }

    private static void quitMenuItemActionPerformed(ActionEvent e) {
        System.exit(0);
    }

    private void errorLoggingCheckBoxActionPerformed(ActionEvent e) {
        boolean selected = ((JCheckBox)e.getSource()).getModel().isSelected();
        if (selected) {
            if (!this.logger.isErrorEnabled()) {
                this.logger.toggleError();
                this.logger.info("Enable error logging");
            }
        } else if (this.logger.isErrorEnabled()) {
            this.logger.info("Disable error logging");
            this.logger.toggleError();
        }
    }

    private void debugLoggingCheckBoxActionPerformed(ActionEvent e) {
        boolean selected = ((JCheckBox)e.getSource()).getModel().isSelected();
        if (selected) {
            if (!this.logger.isDebugEnabled()) {
                this.logger.toggleDebug();
                this.logger.info("Enable debug logging");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.info("Disable debug logging");
            this.logger.toggleDebug();
        }
    }

    private void clearMenuItemActionPerformed(ActionEvent e) {
        this.logPanel.clear();
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("org.jlab.coda.emu.support.ui.rsrc.strings");
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.quitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.undoMenuItem = new JMenuItem();
        this.logMenu = new JMenu();
        this.clearMenuItem = new JMenuItem();
        this.errorLoggingCheckBox = new JCheckBox();
        this.debugLoggingCheckBox = new JCheckBox();
        this.helpMenu = new JMenu();
        this.help = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.smartToolbar = new SmartToolbar();
        this.smartToolbar1 = new SmartToolbar();
        this.smartToolbar2 = new SmartToolbar();
        this.splitPane1 = new JSplitPane();
        this.scrollPane1 = new JScrollPane();
        this.desktopPane = new MDIDesktopPane();
        this.logScrollPane = new JScrollPane();
        this.logPanel = new SwingLogConsoleDialog();
        this.logPanel.setLogger(this.logger);
        this.smartToolbar3 = new SmartToolbar();
        this.setTitle(bundle.getString("debugFrame.title"));
        Container contentPane = this.getContentPane();
        this.fileMenu.setText(bundle.getString("fileMenu.text"));
        this.quitMenuItem.setText(bundle.getString("quitMenuItem.text"));
        this.quitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugFrame.quitMenuItemActionPerformed(e);
            }
        });
        this.fileMenu.add(this.quitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText(bundle.getString("editMenu.text"));
        this.editMenu.setPreferredSize(new Dimension(37, 19));
        this.cutMenuItem.setText(bundle.getString("cutMenuItem.text"));
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText(bundle.getString("copyMenuItem.text"));
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText(bundle.getString("pasteMenuItem.text"));
        this.editMenu.add(this.pasteMenuItem);
        this.undoMenuItem.setText(bundle.getString("undoMenuItem.text"));
        this.editMenu.add(this.undoMenuItem);
        this.menuBar.add(this.editMenu);
        this.logMenu.setText(bundle.getString("logMenu.text"));
        this.clearMenuItem.setText(bundle.getString("clearMenuItem.text"));
        this.clearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugFrame.this.clearMenuItemActionPerformed(e);
            }
        });
        this.logMenu.add(this.clearMenuItem);
        this.errorLoggingCheckBox.setText(bundle.getString("errorLoggingCheckBox.text"));
        this.errorLoggingCheckBox.setPreferredSize(new Dimension(57, 23));
        this.errorLoggingCheckBox.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.errorLoggingCheckBox.setMinimumSize(new Dimension(1, 1));
        this.errorLoggingCheckBox.setSelected(true);
        this.errorLoggingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugFrame.this.errorLoggingCheckBoxActionPerformed(e);
            }
        });
        this.logMenu.add(this.errorLoggingCheckBox);
        this.debugLoggingCheckBox.setText(bundle.getString("debugLoggingCheckBox.text"));
        this.debugLoggingCheckBox.setPreferredSize(new Dimension(57, 23));
        this.debugLoggingCheckBox.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.debugLoggingCheckBox.setMinimumSize(new Dimension(1, 1));
        this.debugLoggingCheckBox.setSelected(true);
        this.debugLoggingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugFrame.this.debugLoggingCheckBoxActionPerformed(e);
            }
        });
        this.logMenu.add(this.debugLoggingCheckBox);
        this.menuBar.add(this.logMenu);
        this.helpMenu.setText(bundle.getString("helpMenu.text"));
        this.help.setText(bundle.getString("help.text"));
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugFrame.this.helpActionPerformed(e);
            }
        });
        this.helpMenu.add(this.help);
        this.aboutMenuItem.setText(bundle.getString("aboutMenuItem.text"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugFrame.aboutMenuItemActionPerformed(e);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.smartToolbar.setFloatable(false);
        this.smartToolbar1.setFloatable(false);
        this.smartToolbar2.setFloatable(false);
        this.splitPane1.setOrientation(0);
        this.scrollPane1.setViewportView(this.desktopPane);
        this.splitPane1.setTopComponent(this.scrollPane1);
        this.logScrollPane.setViewportView(this.logPanel);
        this.splitPane1.setBottomComponent(this.logScrollPane);
        this.smartToolbar3.setFloatable(false);
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout((LayoutManager)contentPaneLayout);
        contentPaneLayout.setHorizontalGroup((GroupLayout.Group)contentPaneLayout.createParallelGroup().add((GroupLayout.Group)contentPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)contentPaneLayout.createParallelGroup().add((Component)this.splitPane1, -1, 694, Short.MAX_VALUE).add((Component)this.smartToolbar1, -1, 694, Short.MAX_VALUE).add((Component)this.smartToolbar, -1, 694, Short.MAX_VALUE).add((Component)this.smartToolbar2, -1, 694, Short.MAX_VALUE).add((Component)this.smartToolbar3, -1, 694, Short.MAX_VALUE)).addContainerGap()));
        contentPaneLayout.setVerticalGroup((GroupLayout.Group)contentPaneLayout.createParallelGroup().add((GroupLayout.Group)contentPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.smartToolbar, -2, -1, -2).addPreferredGap(0).add((Component)this.smartToolbar1, -2, -1, -2).addPreferredGap(0).add((Component)this.smartToolbar2, -2, -1, -2).addPreferredGap(0).add((Component)this.smartToolbar3, -2, -1, -2).addPreferredGap(0).add((Component)this.splitPane1, -1, 666, Short.MAX_VALUE).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

