/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.support.codaComponent.CODAClass;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.emu.support.data.PayloadBuffer;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannelAdapter;
import org.jlab.coda.emu.support.transport.DataTransportException;
import org.jlab.coda.emu.support.transport.DataTransportImplFile;
import org.jlab.coda.emu.support.transport.TransportType;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.EventWriterUnsync;
import org.jlab.coda.jevio.EvioCompactReader;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.Utilities;

public class DataChannelImplFile
extends DataChannelAdapter {
    private Thread dataThread;
    private DataOutputHelper dataOutputThread;
    private String fileName;
    private long split;
    private int splitCount;
    private String directory;
    private String dictionaryXML;
    private EventWriterUnsync evioFileWriter;
    private int outputNameIndex;
    private long dumpedEvents;
    private long dumpedWords;
    private boolean isER;
    private EvioCompactReader compactFileReader;
    private EventType eventType;
    private int sourceId;
    private int recordId;
    private int eventCount;
    private boolean hasFirstEvent;
    private static AtomicInteger subStreamIdCount = new AtomicInteger(0);

    DataChannelImplFile(String name, DataTransportImplFile transport, Map<String, String> attributeMap, boolean input, Emu emu, EmuModule module, int outputIndex) throws DataTransportException {
        block27: {
            String runType;
            int runNumber;
            block26: {
                super(name, transport, attributeMap, input, emu, module, outputIndex);
                runNumber = emu.getRunNumber();
                runType = emu.getRunType();
                try {
                    this.directory = attributeMap.get("dir");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    String dictionaryFile = attributeMap.get("dictionary");
                    if (dictionaryFile != null) {
                        File dFile = new File(dictionaryFile);
                        if (dFile.exists() && dFile.isFile()) {
                            FileInputStream fileInputStream = new FileInputStream(dFile);
                            int fileSize = (int)fileInputStream.getChannel().size();
                            byte[] buf = new byte[fileSize];
                            DataInputStream dataStream = new DataInputStream(fileInputStream);
                            dataStream.read(buf);
                            this.dictionaryXML = new String(buf, 0, fileSize, "US-ASCII");
                        } else {
                            this.logger.info("      DataChannel File: dictionary file cannot be read");
                        }
                    }
                }
                catch (Exception dictionaryFile) {
                    // empty catch block
                }
                try {
                    String splitStr = attributeMap.get("split");
                    if (splitStr == null) break block26;
                    try {
                        this.split = Long.parseLong(splitStr);
                        if (this.split < 0L) {
                            this.split = 0L;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.split = 0L;
                    }
                }
                catch (Exception splitStr) {
                    // empty catch block
                }
            }
            try {
                this.fileName = attributeMap.get("fileName");
            }
            catch (Exception splitStr) {
                // empty catch block
            }
            if (this.fileName == null) {
                this.fileName = input ? "codaInputFile.dat" : (this.split > 0L ? "codaOutputFile_%d.dat%05d" : "codaOutputFile_%d.dat");
            }
            try {
                if (input) {
                    this.isER = emu.getCodaClass() == CODAClass.ER;
                    this.compactFileReader = new EvioCompactReader(this.fileName);
                    BlockHeaderV4 firstBlockHeader = this.compactFileReader.getFirstBlockHeader();
                    this.hasFirstEvent = firstBlockHeader.hasFirstEvent();
                    this.eventCount = this.compactFileReader.getEventCount();
                    this.eventType = EventType.getEventType(firstBlockHeader.getEventType());
                    this.sourceId = firstBlockHeader.getReserved1();
                    this.recordId = firstBlockHeader.getNumber();
                    DataInputHelper helper = new DataInputHelper();
                    this.dataThread = new Thread(emu.getThreadGroup(), helper, this.name() + " data input");
                    this.dataThread.start();
                    helper.waitUntilStarted();
                    break block27;
                }
                boolean overWriteOK = true;
                if (this.split > 0L) {
                    overWriteOK = false;
                }
                int internalBufferSizeBytes = 64000000;
                String bufBytes = attributeMap.get("evioRamBuffer");
                if (bufBytes != null) {
                    try {
                        internalBufferSizeBytes = Integer.parseInt(bufBytes);
                        if (internalBufferSizeBytes < 64000000) {
                            internalBufferSizeBytes = 64000000;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.evioFileWriter = new EventWriterUnsync(this.fileName, this.directory, runType, runNumber, this.split, 0x1000000, 10000, internalBufferSizeBytes, this.byteOrder, this.dictionaryXML, null, overWriteOK, false, null, emu.getDataStreamId(), subStreamIdCount.getAndIncrement(), emu.getFileOutputCount(), emu.getDataStreamCount());
                if (this.evioFileWriter.isDiskFull()) {
                    emu.sendRcWarningMessage("files cannot be written, disk almost full");
                }
                this.logger.info("      DataChannel File: streamId = " + emu.getDataStreamId() + ", stream count = " + emu.getDataStreamCount() + ", filecount = " + emu.getFileOutputCount());
                this.logger.info("      DataChannel File: file = " + this.evioFileWriter.getCurrentFilePath());
                this.outputNameIndex = emu.addOutputDestination(this.evioFileWriter.getCurrentFilePath());
                if (this.split > 0L) {
                    this.splitCount = this.evioFileWriter.getSplitCount();
                }
                this.dataOutputThread = new DataOutputHelper(emu.getThreadGroup(), this.name() + " data out");
                this.dataOutputThread.start();
                this.dataOutputThread.waitUntilStarted();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.channelState = CODAState.ERROR;
                if (input) {
                    System.out.println("      DataChannel File in: Cannot open file, " + e.getMessage());
                    emu.setErrorState("DataChannel File in: Cannot open file, " + e.getMessage());
                    throw new DataTransportException("      DataChannel File in: Cannot open data file " + e.getMessage(), e);
                }
                System.out.println("      DataChannel File out: Cannot create file, " + e.getMessage());
                emu.setErrorState("DataChannel File out: Cannot create file, " + e.getMessage());
                throw new DataTransportException("      DataChannel File out: Cannot create data file " + e.getMessage(), e);
            }
        }
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.FILE;
    }

    @Override
    public void go() {
        this.pause = false;
        this.channelState = CODAState.ACTIVE;
    }

    @Override
    public void pause() {
        this.pause = true;
        this.channelState = CODAState.PAUSED;
    }

    @Override
    public void end() {
        this.logger.info("      DataChannel File: end() " + this.name);
        this.gotEndCmd = true;
        this.gotResetCmd = false;
        subStreamIdCount.set(0);
        if (this.dataThread != null) {
            this.dataThread.interrupt();
        }
        this.channelState = CODAState.DOWNLOADED;
    }

    @Override
    public void reset() {
        this.logger.info("      DataChannel File: reset " + this.name + " channel");
        this.gotEndCmd = false;
        this.gotResetCmd = true;
        subStreamIdCount.set(0);
        if (this.dataThread != null) {
            this.dataThread.interrupt();
        }
        try {
            if (this.compactFileReader != null) {
                this.compactFileReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.evioFileWriter != null) {
                if (this.channelState == CODAState.PAUSED || this.channelState == CODAState.ACTIVE) {
                    Object[] stats = this.module.getStatistics();
                    long eventsWritten = 0L;
                    if (stats != null) {
                        eventsWritten = (Long)stats[0];
                    }
                    PayloadBuffer endBuf = Evio.createControlBuffer(ControlType.END, this.emu.getRunNumber(), this.emu.getRunTypeId(), (int)eventsWritten, 0, this.byteOrder, true);
                    if (this.emu.isFileWritingOn()) {
                        this.evioFileWriter.writeEventToFile(null, endBuf.getBuffer(), true);
                    }
                }
                if (this.emu.isFileWritingOn()) {
                    this.evioFileWriter.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.channelState = CODAState.CONFIGURED;
        this.logger.info("      DataChannel File: reset " + this.name + " - done");
    }

    private class DataOutputHelper
    extends Thread {
        private CountDownLatch latch;
        private int pauseCounter;
        private volatile DataChannelAdapter.ThreadState threadState;

        DataOutputHelper(ThreadGroup group, String name) {
            super(group, name);
            this.latch = new CountDownLatch(1);
        }

        private void waitUntilStarted() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private final void writeEvioDataOrig(RingItem ri, boolean forceToDisk) throws IOException, EvioException {
            if (DataChannelImplFile.this.emu.isFileWritingOn()) {
                if (ri.getBuffer() != null) {
                    DataChannelImplFile.this.evioFileWriter.writeEvent(ri.getBuffer(), forceToDisk);
                } else {
                    DataChannelImplFile.this.evioFileWriter.writeEvent(ri.getNode(), forceToDisk, true);
                }
            }
            ri.releaseByteBuffer();
        }

        private final void writeEvioData(RingItem ri, boolean forceToDisk) throws IOException, EvioException, InterruptedException {
            if (DataChannelImplFile.this.emu.isFileWritingOn()) {
                int repeatLoops = 0;
                boolean sentMsgToRC = false;
                boolean written = ri.getBuffer() != null ? DataChannelImplFile.this.evioFileWriter.writeEventToFile(null, ri.getBuffer(), forceToDisk) : DataChannelImplFile.this.evioFileWriter.writeEventToFile(ri.getNode(), forceToDisk, true);
                while (!written) {
                    if (!sentMsgToRC && repeatLoops++ > 1) {
                        DataChannelImplFile.this.logger.info("      DataChannel File out: disc is full, waiting ...");
                        DataChannelImplFile.this.emu.sendRcWarningMessage("cannot write file, disc is full");
                        sentMsgToRC = true;
                    }
                    if (DataChannelImplFile.this.emu.theEndIsNigh()) {
                        forceToDisk = true;
                        if (ri.getEventType().isBuildable()) {
                            DataChannelImplFile.this.dumpedEvents++;
                            DataChannelImplFile.this.dumpedWords = DataChannelImplFile.this.dumpedWords + (long)(ri.getTotalBytes() / 4);
                            break;
                        }
                        if (ri.getBuffer() != null) {
                            DataChannelImplFile.this.evioFileWriter.writeEventToFile(null, ri.getBuffer(), forceToDisk);
                            break;
                        }
                        DataChannelImplFile.this.evioFileWriter.writeEventToFile(ri.getNode(), forceToDisk, true);
                        break;
                    }
                    Thread.sleep(1000L);
                    if (ri.getBuffer() != null) {
                        written = DataChannelImplFile.this.evioFileWriter.writeEventToFile(null, ri.getBuffer(), forceToDisk);
                        continue;
                    }
                    written = DataChannelImplFile.this.evioFileWriter.writeEventToFile(ri.getNode(), forceToDisk, true);
                }
                if (sentMsgToRC && !DataChannelImplFile.this.emu.theEndIsNigh()) {
                    DataChannelImplFile.this.logger.info("      DataChannel File out: disc space is now available");
                    DataChannelImplFile.this.emu.sendRcInfoMessage("disc space is now available");
                }
            }
            ri.releaseByteBuffer();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.threadState = DataChannelAdapter.ThreadState.RUNNING;
            this.latch.countDown();
            try {
                ControlType pBankControlType;
                EventType pBankType;
                RingItem ringItem;
                block47: {
                    boolean gotPrestart = false;
                    if (!DataChannelImplFile.this.emu.isFileWritingOn()) {
                        DataChannelImplFile.this.logger.rcConsole("      DataChannel File out " + DataChannelImplFile.this.outputIndex + ": File writing TURNED OFF", "NO FILE");
                    }
                    while (true) {
                        block51: {
                            block50: {
                                ringItem = DataChannelImplFile.this.getNextOutputRingItem(0);
                                pBankType = ringItem.getEventType();
                                pBankControlType = ringItem.getControlType();
                                if (pBankType != EventType.CONTROL) break block50;
                                if (pBankControlType == ControlType.PRESTART) {
                                    if (gotPrestart) {
                                        throw new EmuException("got 2 PRESTART events");
                                    }
                                    gotPrestart = true;
                                    this.writeEvioData(ringItem, true);
                                    break block51;
                                } else {
                                    if (!gotPrestart) {
                                        throw new EmuException("PRESTART, not " + (Object)((Object)pBankControlType) + ", must be first control event");
                                    }
                                    if (pBankControlType != ControlType.GO && pBankControlType != ControlType.END) {
                                        throw new EmuException("second control event must be GO or END");
                                    }
                                    this.writeEvioData(ringItem, false);
                                    DataChannelImplFile.this.gotoNextRingItem(0);
                                    DataChannelImplFile.this.releaseOutputRingItem(0);
                                    if (pBankControlType == ControlType.END) {
                                        break;
                                    }
                                    break block47;
                                }
                            }
                            if (pBankType != EventType.USER) {
                                throw new EmuException((Object)((Object)pBankType) + " type of events must come after GO event");
                            }
                            if (ringItem.isFirstEvent()) {
                                if (DataChannelImplFile.this.emu.isFileWritingOn()) {
                                    try {
                                        if (ringItem.getBuffer() != null) {
                                            DataChannelImplFile.this.evioFileWriter.setFirstEvent(ringItem.getBuffer());
                                        } else {
                                            DataChannelImplFile.this.evioFileWriter.setFirstEvent(ringItem.getNode());
                                        }
                                    }
                                    catch (EvioException e) {
                                        DataChannelImplFile.this.emu.sendRcWarningMessage(e.getMessage());
                                        System.out.println("      DataChannel File out " + DataChannelImplFile.this.outputIndex + ": failed writing \"first\" user event -> " + e.getMessage());
                                        Utilities.printBufferBytes((ByteBuffer)ringItem.getNode().getStructureBuffer(true), (int)0, (int)80, (String)"Bad user event bytes:");
                                        System.out.println("\n      DataChannel File out " + DataChannelImplFile.this.outputIndex + ": IGNORING USER EVENT, go to next event");
                                    }
                                }
                                ringItem.releaseByteBuffer();
                            } else {
                                try {
                                    this.writeEvioData(ringItem, true);
                                }
                                catch (EvioException e) {
                                    DataChannelImplFile.this.emu.sendRcWarningMessage(e.getMessage());
                                    System.out.println("      DataChannel File out " + DataChannelImplFile.this.outputIndex + ": failed writing user event -> " + e.getMessage());
                                    Utilities.printBufferBytes((ByteBuffer)ringItem.getNode().getStructureBuffer(true), (int)0, (int)80, (String)"Bad user event bytes:");
                                    System.out.println("\n      DataChannel File out " + DataChannelImplFile.this.outputIndex + ": IGNORING USER EVENT, go to next event");
                                }
                            }
                        }
                        DataChannelImplFile.this.gotoNextRingItem(0);
                    }
                    DataChannelImplFile.this.logger.info("      DataChannel File out " + DataChannelImplFile.this.outputIndex + ": wrote END");
                    if (DataChannelImplFile.this.emu.isFileWritingOn()) {
                        try {
                            DataChannelImplFile.this.evioFileWriter.close();
                        }
                        catch (Exception e) {
                            DataChannelImplFile.this.errorMsg.compareAndSet(null, "Cannot write to file");
                            throw e;
                        }
                    }
                    if (DataChannelImplFile.this.endCallback != null) {
                        DataChannelImplFile.this.endCallback.endWait();
                    }
                    this.threadState = DataChannelAdapter.ThreadState.DONE;
                    return;
                }
                DataChannelImplFile.this.logger.info("      DataChannel File out " + DataChannelImplFile.this.outputIndex + ": wrote GO");
                while (true) {
                    if (DataChannelImplFile.this.pause) {
                        if (this.pauseCounter++ % 400 != 0) continue;
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    try {
                        ringItem = DataChannelImplFile.this.getNextOutputRingItem(DataChannelImplFile.this.ringIndex);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    pBankType = ringItem.getEventType();
                    pBankControlType = ringItem.getControlType();
                    try {
                        if (ringItem.isFirstEvent()) {
                            if (DataChannelImplFile.this.emu.isFileWritingOn()) {
                                if (ringItem.getBuffer() != null) {
                                    DataChannelImplFile.this.evioFileWriter.setFirstEvent(ringItem.getBuffer());
                                } else {
                                    DataChannelImplFile.this.evioFileWriter.setFirstEvent(ringItem.getNode());
                                }
                            }
                            ringItem.releaseByteBuffer();
                        } else {
                            this.writeEvioData(ringItem, false);
                        }
                    }
                    catch (Exception e) {
                        DataChannelImplFile.this.errorMsg.compareAndSet(null, "Cannot write to file");
                        throw e;
                    }
                    DataChannelImplFile.this.releaseCurrentAndGoToNextOutputRingItem(DataChannelImplFile.this.ringIndex);
                    if (DataChannelImplFile.this.outputRingCount > 1 && !pBankType.isUser()) {
                        DataChannelImplFile.this.setNextEventAndRing();
                    }
                    if (DataChannelImplFile.this.split > 0L && DataChannelImplFile.this.evioFileWriter.getSplitCount() > DataChannelImplFile.this.splitCount) {
                        DataChannelImplFile.this.emu.setOutputDestination(DataChannelImplFile.this.outputNameIndex, DataChannelImplFile.this.evioFileWriter.getCurrentFilePath());
                        DataChannelImplFile.this.splitCount = DataChannelImplFile.this.evioFileWriter.getSplitCount();
                        if (DataChannelImplFile.this.splitCount > 999 && DataChannelImplFile.this.split <= (long)(999 + DataChannelImplFile.this.emu.getDataStreamCount())) {
                            DataChannelImplFile.this.emu.sendRcWarningMessage("split number over 999");
                        }
                    }
                    if (pBankControlType == ControlType.END) {
                        DataChannelImplFile.this.logger.info("      DataChannel File out " + DataChannelImplFile.this.outputIndex + ": got ev " + DataChannelImplFile.this.nextEvent + ", ring " + DataChannelImplFile.this.ringIndex + " = END!");
                        if (DataChannelImplFile.this.dumpedEvents > 0L) {
                            DataChannelImplFile.this.module.adjustStatistics(-1L * DataChannelImplFile.this.dumpedEvents, -1L * DataChannelImplFile.this.dumpedWords);
                            DataChannelImplFile.this.emu.sendRcWarningMessage(DataChannelImplFile.this.dumpedEvents + " physics events discarded");
                            DataChannelImplFile.this.logger.info("      DataChannel File out " + DataChannelImplFile.this.outputIndex + ": discarded " + DataChannelImplFile.this.dumpedEvents + " events due to full disk");
                        }
                        if (DataChannelImplFile.this.emu.isFileWritingOn()) {
                            try {
                                DataChannelImplFile.this.evioFileWriter.close();
                            }
                            catch (Exception e) {
                                DataChannelImplFile.this.errorMsg.compareAndSet(null, "Cannot write to file");
                                throw e;
                            }
                        }
                        if (DataChannelImplFile.this.endCallback != null) {
                            DataChannelImplFile.this.endCallback.endWait();
                        }
                        this.threadState = DataChannelAdapter.ThreadState.DONE;
                        return;
                    }
                    if (DataChannelImplFile.this.gotResetCmd) break;
                }
                System.out.println("      DataChannel File out, " + DataChannelImplFile.this.outputIndex + ": got RESET/END cmd, quitting 1");
                this.threadState = DataChannelAdapter.ThreadState.DONE;
                return;
            }
            catch (InterruptedException e) {
                DataChannelImplFile.this.logger.warn("      DataChannel File out, " + DataChannelImplFile.this.outputIndex + ": interrupted thd, exiting");
            }
            catch (Exception e) {
                DataChannelImplFile.this.channelState = CODAState.ERROR;
                DataChannelImplFile.this.emu.setErrorState("DataChannel File out: " + e.getMessage());
                e.printStackTrace();
                System.out.println("      DataChannel File out, " + DataChannelImplFile.this.outputIndex + " : exit thd: " + e.getMessage());
            }
            this.threadState = DataChannelAdapter.ThreadState.DONE;
        }
    }

    private class DataInputHelper
    implements Runnable {
        private CountDownLatch latch = new CountDownLatch(1);

        private DataInputHelper() {
        }

        private void waitUntilStarted() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            int counter = 0;
            boolean isUser = false;
            this.latch.countDown();
            try {
                RingItem ringItem;
                long nextRingItem;
                ControlType controlType = null;
                for (int i = 0; i < DataChannelImplFile.this.eventCount && !DataChannelImplFile.this.dataThread.isInterrupted(); ++i) {
                    EvioNode node = DataChannelImplFile.this.isER ? DataChannelImplFile.this.compactFileReader.getEvent(i) : DataChannelImplFile.this.compactFileReader.getScannedEvent(i);
                    EventType bankType = DataChannelImplFile.this.eventType;
                    if (DataChannelImplFile.this.eventType == EventType.ROC_RAW) {
                        if (Evio.isUserEvent(node)) {
                            bankType = EventType.USER;
                            isUser = true;
                        }
                    } else if (DataChannelImplFile.this.eventType == EventType.CONTROL) {
                        controlType = ControlType.getControlType(node.getTag());
                        if (controlType == null) {
                            DataChannelImplFile.this.channelState = CODAState.ERROR;
                            DataChannelImplFile.this.emu.setErrorState("DataChannel File in: found unidentified control event");
                            return;
                        }
                    } else if (DataChannelImplFile.this.eventType == EventType.USER) {
                        isUser = true;
                    }
                    nextRingItem = DataChannelImplFile.this.ringBufferIn.nextIntr(1);
                    ringItem = (RingItem)DataChannelImplFile.this.ringBufferIn.get(nextRingItem);
                    if (bankType.isBuildable()) {
                        ringItem.setAll(null, null, node, bankType, controlType, isUser, DataChannelImplFile.this.hasFirstEvent, DataChannelImplFile.this.id, DataChannelImplFile.this.recordId, DataChannelImplFile.this.sourceId, node.getNum(), DataChannelImplFile.this.name, null, null);
                    } else {
                        ringItem.setAll(null, null, node, bankType, controlType, isUser, DataChannelImplFile.this.hasFirstEvent, DataChannelImplFile.this.id, DataChannelImplFile.this.recordId, DataChannelImplFile.this.sourceId, 1, DataChannelImplFile.this.name, null, null);
                    }
                    isUser = DataChannelImplFile.this.hasFirstEvent = false;
                    DataChannelImplFile.this.ringBufferIn.publish(nextRingItem);
                    ++counter;
                }
                nextRingItem = DataChannelImplFile.this.ringBufferIn.nextIntr(1);
                ringItem = (RingItem)DataChannelImplFile.this.ringBufferIn.get(nextRingItem);
                ringItem.setAll(Evio.createControlEvent(ControlType.END, 0, 0, counter, 0, false), null, null, EventType.CONTROL, ControlType.END, false, false, DataChannelImplFile.this.id, DataChannelImplFile.this.recordId, DataChannelImplFile.this.sourceId, 1, DataChannelImplFile.this.name, null, null);
                DataChannelImplFile.this.ringBufferIn.publish(nextRingItem);
                if (DataChannelImplFile.this.endCallback != null) {
                    DataChannelImplFile.this.endCallback.endWait();
                }
            }
            catch (InterruptedException e) {
                DataChannelImplFile.this.logger.warn("      DataChannel File in: (" + DataChannelImplFile.this.name + ") thd interrupted");
            }
            catch (Exception e) {
                DataChannelImplFile.this.channelState = CODAState.ERROR;
                DataChannelImplFile.this.emu.setErrorState("DataChannel File in: " + e.getMessage());
            }
        }
    }
}

