/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.configurer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.layout.GroupLayout;
import org.w3c.dom.Node;

public class DataNode {
    private final Node node;
    private final int level;
    private String value;
    private JLabel tagField;
    private JTextField valueField;
    private JPanel container;
    private TitledBorder titledBorder;
    private static LineBorder[] borders;
    private static Color[] colors;
    private GroupLayout layout;
    private GroupLayout.ParallelGroup hGroup;
    private GroupLayout.SequentialGroup rows;

    public DataNode(Node n, int level) {
        n.setUserData("DataNode", this, null);
        this.node = n;
        this.value = n.getNodeValue();
        this.level = level;
        String pname = n.getNodeName();
        if (n.getNodeType() == 2) {
            this.tagField = new JLabel(pname);
            this.valueField = new JTextField(this.value);
            this.valueField.setEditable(false);
            this.valueField.setBackground(Color.white);
        } else {
            this.container = new JPanel();
            this.titledBorder = BorderFactory.createTitledBorder(borders[level % 4], pname, 1, 2, null, colors[level % 4]);
            this.container.setBorder(this.titledBorder);
            this.layout = new GroupLayout((Container)this.container);
            this.container.setLayout((LayoutManager)this.layout);
            this.layout.setAutocreateGaps(false);
            this.layout.setAutocreateContainerGaps(false);
            this.hGroup = this.layout.createParallelGroup();
            this.layout.setHorizontalGroup((GroupLayout.Group)this.hGroup);
            this.rows = this.layout.createSequentialGroup();
            this.layout.setVerticalGroup((GroupLayout.Group)this.rows);
        }
    }

    public void addToPanel(DataNode dn) {
        if (dn.isContainer()) {
            this.hGroup.add((Component)dn.container);
            this.rows.add((Component)dn.container);
        } else {
            GroupLayout.ParallelGroup row = this.layout.createParallelGroup(3);
            GroupLayout.SequentialGroup col = this.layout.createSequentialGroup();
            row.add((Component)dn.tagField);
            col.add((Component)dn.tagField);
            row.add((Component)dn.valueField);
            col.add((Component)dn.valueField);
            this.rows.add((GroupLayout.Group)row);
            this.hGroup.add((GroupLayout.Group)col);
        }
    }

    public void removeFromPanel(DataNode dn) {
        if (dn.isContainer()) {
            this.layout.removeLayoutComponent((Component)dn.container);
        } else {
            this.layout.removeLayoutComponent((Component)dn.tagField);
            this.layout.removeLayoutComponent((Component)dn.valueField);
        }
    }

    public boolean isContainer() {
        return this.container != null;
    }

    public int getLevel() {
        return this.level;
    }

    public JLabel getTagField() {
        return this.tagField;
    }

    public JTextField getValueField() {
        return this.valueField;
    }

    public JPanel getContainer() {
        return this.container;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.node.setNodeValue(value);
        if (this.container != null) {
            this.titledBorder.setTitle(value);
        }
        if (this.valueField != null) {
            this.valueField.setText(value);
        }
    }

    public static DataNode getDataNode(Node n) {
        return (DataNode)n.getUserData("DataNode");
    }

    public Node getNode() {
        return this.node;
    }

    static {
        colors = new Color[4];
        DataNode.colors[0] = new Color(0, 0, 255);
        DataNode.colors[1] = new Color(155, 0, 255);
        DataNode.colors[2] = new Color(180, 0, 100);
        DataNode.colors[3] = new Color(230, 0, 0);
        borders = new LineBorder[4];
        DataNode.borders[0] = new LineBorder(colors[0], 1);
        DataNode.borders[1] = new LineBorder(colors[1], 1);
        DataNode.borders[2] = new LineBorder(colors[2], 1);
        DataNode.borders[3] = new LineBorder(colors[3], 1);
    }
}

