/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.configurer;

import org.jlab.coda.emu.support.configurer.DataNode;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.logger.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSParserFilter;
import org.w3c.dom.ls.LSSerializer;

public class Configurer
implements DOMErrorHandler,
LSParserFilter {
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final int DEFAULT_PARSE_MODE = 0;
    protected static final int STRING_PARSE_MODE = 1;
    protected static final int FILE_PARSE_MODE = 2;
    private static DOMImplementationLS domImplementor;
    private static LSParser domBuilder;
    private static LSSerializer domWriter;
    private static Logger logger;

    public static synchronized void setLogger(Logger logger) {
        Configurer.logger = logger;
    }

    public static void removeEmptyTextNodes(Element node) {
        Node el = node.getFirstChild();
        while (el != null) {
            Node next = el.getNextSibling();
            switch (el.getNodeType()) {
                case 3: {
                    String str = el.getNodeValue().trim();
                    if (!str.isEmpty()) break;
                    node.removeChild(el);
                    break;
                }
                case 1: {
                    Configurer.removeEmptyTextNodes((Element)el);
                    break;
                }
                case 8: {
                    node.removeChild(el);
                }
            }
            el = next;
        }
    }

    public static synchronized Document parseFile(String configFile) throws DataNotFoundException {
        try {
            return domBuilder.parseURI(configFile);
        }
        catch (Exception e) {
            throw new DataNotFoundException("Cannot parse configuration file", e);
        }
    }

    public static synchronized Document parseString(String xmlConfig) throws DataNotFoundException {
        LSInput input = domImplementor.createLSInput();
        input.setStringData(xmlConfig);
        try {
            return domBuilder.parse(input);
        }
        catch (Exception e) {
            throw new DataNotFoundException("Cannot parse XML string", e);
        }
    }

    public static synchronized String serialize(Document doc) {
        try {
            return domWriter.writeToString(doc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public synchronized boolean handleError(DOMError error) {
        short severity = error.getSeverity();
        if (severity == 2) {
            if (logger != null) {
                logger.error("[dom3-error]: " + error.getMessage());
            } else {
                System.out.println("[dom3-error]: " + error.getMessage());
            }
        }
        if (severity == 1) {
            if (logger != null) {
                logger.error("[dom3-warning]: " + error.getMessage());
            } else {
                System.out.println("[dom3-warning]: " + error.getMessage());
            }
        }
        return true;
    }

    @Override
    public short acceptNode(Node enode) {
        return 1;
    }

    @Override
    public int getWhatToShow() {
        return 1;
    }

    @Override
    public short startElement(Element elt) {
        return 1;
    }

    public static String getValue(Document doc, String path) throws DataNotFoundException {
        Node n = Configurer.getNode(doc, path);
        if (n == null) {
            return null;
        }
        if (n.getNodeType() == 2) {
            return n.getNodeValue();
        }
        if (n.getFirstChild() != null) {
            return n.getFirstChild().getTextContent();
        }
        return null;
    }

    private static DataNode getData(Document doc, String path) throws DataNotFoundException {
        Node n = Configurer.getNode(doc, path);
        if (n == null) {
            return null;
        }
        DataNode dn = (DataNode)n.getUserData("DataNode");
        if (dn == null) {
            throw new DataNotFoundException("no DataNode associated with path " + path);
        }
        return dn;
    }

    public static void setValue(Document doc, String path, String value) throws DataNotFoundException {
        DataNode dn = Configurer.getData(doc, path);
        if (dn == null) {
            return;
        }
        dn.setValue(value);
    }

    public static void newValue(Document doc, String path, String name, String value) throws DataNotFoundException {
        Node n = Configurer.getNode(doc, path);
        if (n == null) {
            return;
        }
        Element el = (Element)n;
        Attr a = doc.createAttribute(name);
        a.setNodeValue(value);
        Attr replacedNode = el.setAttributeNode(a);
        DataNode dn = (DataNode)n.getUserData("DataNode");
        if (dn != null) {
            DataNode rdn;
            if (replacedNode != null && (rdn = (DataNode)replacedNode.getUserData("DataNode")) != null) {
                dn.removeFromPanel(rdn);
            }
            DataNode newdn = new DataNode(a, dn.getLevel() + 1);
            dn.addToPanel(newdn);
        }
    }

    public static void newContainer(Document doc, String path, String name) throws DataNotFoundException {
        Node n = Configurer.getNode(doc, path);
        if (n == null) {
            return;
        }
        Element newNode = doc.createElement(name);
        n.appendChild(newNode);
        DataNode dn = (DataNode)n.getUserData("DataNode");
        if (dn != null) {
            DataNode newdn = new DataNode(newNode, dn.getLevel() + 1);
            dn.addToPanel(newdn);
        }
    }

    public static DataNode treeToPanel(Node node, int level) {
        NamedNodeMap attr;
        DataNode dn = new DataNode(node, level);
        if (node.hasAttributes()) {
            attr = node.getAttributes();
            Node nameAttr = attr.getNamedItem("name");
            if (nameAttr != null) {
                dn.setValue(nameAttr.getNodeValue() + " (" + node.getNodeName() + ')');
            } else {
                dn.setValue(node.getNodeName());
            }
        } else {
            dn.setValue(node.getNodeName());
        }
        if (node.hasChildNodes()) {
            NodeList l = node.getChildNodes();
            for (int jx = 0; jx < l.getLength(); ++jx) {
                Node n = l.item(jx);
                String nn = n.getNodeName();
                if (nn == null || nn.startsWith("#")) continue;
                dn.addToPanel(Configurer.treeToPanel(n, level + 1));
            }
        }
        if (node.hasAttributes()) {
            attr = node.getAttributes();
            for (int ix = 0; ix < attr.getLength(); ++ix) {
                Node aNode = attr.item(ix);
                DataNode adn = new DataNode(aNode, level + 1);
                dn.addToPanel(adn);
            }
        }
        return dn;
    }

    public static Node getNode(Document doc, String path) throws DataNotFoundException {
        String[] s = path.split("/");
        Document n = doc;
        if (n == null) {
            return null;
        }
        NodeList childNodes = n.getChildNodes();
        Node found = null;
        for (String partialPath : s) {
            NamedNodeMap nnm;
            found = null;
            for (int jx = 0; jx < childNodes.getLength(); ++jx) {
                String childName = childNodes.item(jx).getNodeName();
                if (childName != null) {
                    // empty if block
                }
                if (childName == null || !childName.matches(partialPath)) continue;
                found = childNodes.item(jx);
                break;
            }
            if (found == null && (nnm = n.getAttributes()) != null && (found = nnm.getNamedItem(partialPath)) != null) {
                return found;
            }
            if (found == null) {
                throw new DataNotFoundException("No child node of " + n.getNodeName() + " named " + partialPath);
            }
            n = found;
            childNodes = n.getChildNodes();
        }
        if (found != null) {
            return found;
        }
        throw new DataNotFoundException("No node found with path : " + path);
    }

    static {
        try {
            Configurer instance = new Configurer();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            domImplementor = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            domBuilder = domImplementor.createLSParser((short)1, null);
            DOMConfiguration config = domBuilder.getDomConfig();
            domBuilder.setFilter(instance);
            config.setParameter("error-handler", instance);
            config.setParameter("validate", Boolean.FALSE);
            domWriter = domImplementor.createLSSerializer();
            config = domWriter.getDomConfig();
            config.setParameter("xml-declaration", Boolean.FALSE);
        }
        catch (Exception e) {
            System.out.println("Exception initializing class Configurer : " + e.getMessage());
            e.printStackTrace();
        }
    }
}

