/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.codaComponent;

import java.util.EnumSet;
import java.util.HashMap;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.codaComponent.CODATransition;

public enum CODAState implements CODAStateIF
{
    BOOTED("coda component not configured", EnumSet.of(CODATransition.CONFIGURE)),
    CONFIGURED("configuration loaded", EnumSet.of(CODATransition.CONFIGURE, CODATransition.DOWNLOAD, CODATransition.RESET)),
    DOWNLOADED("modules loaded", EnumSet.of(CODATransition.DOWNLOAD, CODATransition.PRESTART, CODATransition.RESET)),
    PAUSED("modules initialized, channels created, ready to go", EnumSet.of(CODATransition.GO, CODATransition.END, CODATransition.RESET)),
    ACTIVE("taking data", EnumSet.of(CODATransition.PAUSE, CODATransition.END, CODATransition.RESET)),
    CONFIGURING("between booted and configured", EnumSet.noneOf(CODATransition.class)),
    DOWNLOADING("between configured and downloaded", EnumSet.noneOf(CODATransition.class)),
    PRESTARTING("between downloaded and paused", EnumSet.noneOf(CODATransition.class)),
    ACTIVATING("between paused and active", EnumSet.noneOf(CODATransition.class)),
    ENDING("ending run", EnumSet.noneOf(CODATransition.class)),
    RESETTING("resetting", EnumSet.noneOf(CODATransition.class)),
    ERROR("an error has occurred", EnumSet.noneOf(CODATransition.class));

    private final String description;
    private final EnumSet<CODATransition> allowed;
    private static final HashMap<String, CODAState> commandTypeToEnumMap;

    public static CODAState get(String s) {
        return commandTypeToEnumMap.get(s);
    }

    private CODAState(String description, EnumSet<CODATransition> allowed) {
        this.description = description;
        this.allowed = allowed;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public EnumSet<CODATransition> allowed() {
        return this.allowed;
    }

    static {
        commandTypeToEnumMap = new HashMap(12);
        for (CODAState item : CODAState.values()) {
            commandTypeToEnumMap.put(item.name(), item);
        }
    }
}

