/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.codaComponent;

import java.util.HashMap;

public enum CODAClass {
    TS("trigger supervisor", 1210),
    GT("gt", 1110),
    ROC("read out controller", 1010),
    DC("data concentrator", 910),
    EBER("event builder", 810),
    PEBER("event builder", 810),
    SEBER("event builder", 810),
    SEB("event builder", 610),
    PEB("event builder", 510),
    FCS("farm controller", 410),
    ER("event recorder", 310),
    SLC("slow control component", 110),
    USR("user component", 10),
    EMU("event management unit", 0);

    private final String description;
    private final int priority;
    private static HashMap<String, CODAClass> codaClassToEnumMap;

    private CODAClass(String description, int priority) {
        this.priority = priority;
        this.description = description;
    }

    public static CODAClass get(String s) {
        return codaClassToEnumMap.get(s);
    }

    public String description() {
        return this.description;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isEventBuilder() {
        return this == DC || this == SEB || this == PEB || this == PEBER || this == SEBER;
    }

    public boolean isFinalEventBuilder() {
        return this == SEB || this == PEB || this == PEBER || this == SEBER;
    }

    public boolean isEventRecorder() {
        return this == ER;
    }

    static {
        codaClassToEnumMap = new HashMap(11);
        for (CODAClass item : CODAClass.values()) {
            codaClassToEnumMap.put(item.name(), item);
        }
    }
}

