/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.modules.ModuleAdapter;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.control.CmdExecException;

public class TsFixedRateSimulation
extends ModuleAdapter {
    private String syncSubjectIn = "syncFromRoc";
    private String initSubjectIn = "initFromRoc";
    private cMsgSubscriptionHandle syncSub;
    private cMsgSubscriptionHandle initSub;
    private cMsgMessage syncMessage;
    private cMsgMessage initMessage;
    private cMsg coda;
    private int count;
    private boolean debug = true;
    private ArrayList<String> expectedRocs = new ArrayList(20);
    private ArrayList<String> initRespondingRocs = new ArrayList(20);
    private ArrayList<Integer> eventSizes = new ArrayList(20);
    private ArrayList<String> syncRespondingRocs = new ArrayList(20);
    private ArrayList<Integer> syncRespondingStates = new ArrayList(20);
    private SyncCallback syncCallback = new SyncCallback();
    private InitCallback initCallback = new InitCallback();
    private long desiredTotalDataRate = 2600000000L;
    private int largestEntangledEventByteSize;
    private int avgEntangledEventByteSize;
    private int rocCount = 63;
    private double desiredBuffersPerSec;
    private final CountDownLatch initLatch = new CountDownLatch(1);

    public TsFixedRateSimulation(String name, Map<String, String> attributeMap, Emu emu) {
        super(name, attributeMap, emu);
        String roc;
        try {
            this.desiredTotalDataRate = Long.parseLong(attributeMap.get("dataRate"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.desiredTotalDataRate < 0L) {
            this.desiredTotalDataRate = 500000000L;
        } else if (this.desiredTotalDataRate > 3000000000L) {
            this.desiredTotalDataRate = 3000000000L;
        }
        this.rocCount = 0;
        int counter = 2;
        String rocName = "r1";
        while ((roc = attributeMap.get(rocName)) != null) {
            System.out.println("  TS mod: adding roc " + rocName);
            this.expectedRocs.add(rocName);
            rocName = "r" + counter++;
            ++this.rocCount;
        }
        this.syncMessage = new cMsgMessage();
        this.syncMessage.setSubject("sync");
        this.syncMessage.setType("ROC");
        try {
            this.syncMessage.setHistoryLengthMax(0);
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        this.initMessage = new cMsgMessage();
        this.initMessage.setSubject("init");
        this.initMessage.setType("ROC");
        try {
            this.initMessage.setHistoryLengthMax(0);
        }
        catch (cMsgException cMsgException3) {
            // empty catch block
        }
    }

    @Override
    public void go() {
        try {
            this.initLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.moduleState = CODAState.ACTIVE;
        this.paused = false;
    }

    @Override
    public void prestart() {
        this.debug = true;
        if (this.debug) {
            System.out.println("  TS mod: prestart");
        }
        this.coda = this.emu.getCmsgPortal().getCmsgServer();
        try {
            if (this.initSub != null) {
                this.coda.unsubscribe(this.initSub);
            }
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        try {
            if (this.syncSub != null) {
                this.coda.unsubscribe(this.syncSub);
            }
        }
        catch (cMsgException cMsgException3) {
            // empty catch block
        }
        try {
            System.out.println("  TS mod: subscribe to sub = " + this.initSubjectIn + ", typ = *");
            this.initSub = this.coda.subscribe(this.initSubjectIn, "*", (cMsgCallbackInterface)this.initCallback, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("  TS mod: subscribe to sub = " + this.syncSubjectIn + ", typ = *");
            this.syncSub = this.coda.subscribe(this.syncSubjectIn, "*", (cMsgCallbackInterface)this.syncCallback, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.moduleState = CODAState.PAUSED;
        this.paused = false;
    }

    @Override
    public void reset() {
        if (this.debug) {
            System.out.println("  TS mod: reset()");
        }
        try {
            if (this.coda != null && this.syncSub != null) {
                this.coda.unsubscribe(this.syncSub);
            }
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        try {
            if (this.coda != null && this.initSub != null) {
                this.coda.unsubscribe(this.initSub);
            }
        }
        catch (cMsgException cMsgException3) {
            // empty catch block
        }
        this.moduleState = CODAState.CONFIGURED;
        this.paused = false;
    }

    @Override
    public void end() throws CmdExecException {
        if (this.debug) {
            System.out.println("  TS mod: end()");
        }
        this.moduleState = CODAState.DOWNLOADED;
        this.paused = false;
    }

    private class InitCallback
    extends cMsgCallbackAdapter {
        private InitCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            TsFixedRateSimulation.this.initRespondingRocs.add(msg.getType());
            TsFixedRateSimulation.this.eventSizes.add(msg.getUserInt());
            System.out.println("  TS mod: got roc = " + msg.getType() + ", event size = " + msg.getUserInt());
            if (TsFixedRateSimulation.this.initRespondingRocs.size() == TsFixedRateSimulation.this.expectedRocs.size()) {
                int totalEventSize = 0;
                TsFixedRateSimulation.this.largestEntangledEventByteSize = -1;
                Iterator iterator = TsFixedRateSimulation.this.eventSizes.iterator();
                while (iterator.hasNext()) {
                    int size = (Integer)iterator.next();
                    if (size > TsFixedRateSimulation.this.largestEntangledEventByteSize) {
                        TsFixedRateSimulation.this.largestEntangledEventByteSize = size;
                    }
                    totalEventSize += size;
                }
                TsFixedRateSimulation.this.avgEntangledEventByteSize = totalEventSize / TsFixedRateSimulation.this.expectedRocs.size();
                int eventsPerBuffer = 3999936 / TsFixedRateSimulation.this.largestEntangledEventByteSize;
                TsFixedRateSimulation.this.desiredBuffersPerSec = (double)TsFixedRateSimulation.this.desiredTotalDataRate / (double)(TsFixedRateSimulation.this.rocCount * TsFixedRateSimulation.this.avgEntangledEventByteSize * eventsPerBuffer);
                double bytesPerSecPerRoc = TsFixedRateSimulation.this.desiredBuffersPerSec * (double)eventsPerBuffer * (double)TsFixedRateSimulation.this.avgEntangledEventByteSize;
                System.out.println("All ROCs reporting event sizes, largest ev size = " + TsFixedRateSimulation.this.largestEntangledEventByteSize + ", avg size = " + TsFixedRateSimulation.this.avgEntangledEventByteSize + ", events/buf = " + eventsPerBuffer + ", bufs/sec = " + TsFixedRateSimulation.this.desiredBuffersPerSec + ", *** Avg Data Rate / Roc = " + bytesPerSecPerRoc + " ***");
                TsFixedRateSimulation.this.initMessage.setUserInt(eventsPerBuffer);
                try {
                    cMsgPayloadItem item = new cMsgPayloadItem("bufsPerSec", TsFixedRateSimulation.this.desiredBuffersPerSec);
                    TsFixedRateSimulation.this.initMessage.addPayloadItem(item);
                }
                catch (cMsgException item) {
                    // empty catch block
                }
                try {
                    TsFixedRateSimulation.this.coda.send(TsFixedRateSimulation.this.initMessage);
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                }
                TsFixedRateSimulation.this.initLatch.countDown();
            }
        }
    }

    private class SyncCallback
    extends cMsgCallbackAdapter {
        private SyncCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            TsFixedRateSimulation.this.syncRespondingRocs.add(msg.getType());
            TsFixedRateSimulation.this.syncRespondingStates.add(msg.getUserInt());
            if (TsFixedRateSimulation.this.syncRespondingRocs.size() == TsFixedRateSimulation.this.expectedRocs.size()) {
                if (!TsFixedRateSimulation.this.syncRespondingStates.contains(0)) {
                    System.out.println("  TS mod: all ROCs got end cmd");
                    TsFixedRateSimulation.this.syncMessage.setUserInt(1);
                } else {
                    TsFixedRateSimulation.this.syncMessage.setUserInt(0);
                }
                try {
                    TsFixedRateSimulation.this.coda.send(TsFixedRateSimulation.this.syncMessage);
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                }
                TsFixedRateSimulation.this.syncRespondingRocs.clear();
                TsFixedRateSimulation.this.syncRespondingStates.clear();
                TsFixedRateSimulation.this.count++;
            }
        }
    }
}

