/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.EmuUtilities;
import org.jlab.coda.emu.modules.ModuleAdapter;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.configurer.Configurer;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.emu.support.data.PayloadBuffer;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.Utilities;

public class FastEventBuilder
extends ModuleAdapter {
    private int buildingThreadCount;
    private ArrayList<BuildingThread> buildingThreadList = new ArrayList(6);
    private int runNumber;
    private int runTypeId;
    private volatile boolean haveAllPrestartEvents;
    private boolean debug = true;
    private boolean dumpData;
    private boolean checkTimestamps;
    private int timestampSlop;
    private boolean includeRunData;
    private boolean sparsify;
    private volatile boolean haveEndEvent;
    protected int ringItemCount;
    private RingBuffer<RingItem>[] ringBuffersIn;
    private int[] ringBufferSize;
    private Sequence[][] buildSequenceIn;
    private SequenceBarrier[] buildBarrierIn;
    private long[][] lastSeq;
    private long[] lastSeqReleased;
    private long[] maxSeqReleased;
    private int[] betweenReleased;
    private long builtEventCount;
    private int outputRingSize;

    public FastEventBuilder(String name, Map<String, String> attributeMap, Emu emu) {
        super(name, attributeMap, emu);
        this.buildingThreadCount = this.eventProducingThreads;
        if (!this.epThreadsSetInConfig) {
            this.eventProducingThreads = 2;
            this.buildingThreadCount = 2;
        }
        this.logger.info("  EB mod: output byte order = little endian");
        this.logger.info("  EB mod: # of event building threads = " + this.buildingThreadCount);
        String str = attributeMap.get("runData");
        if (str != null && (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("in") || str.equalsIgnoreCase("on") || str.equalsIgnoreCase("yes"))) {
            this.includeRunData = true;
        }
        if ((str = attributeMap.get("dump")) != null && (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("on") || str.equalsIgnoreCase("yes"))) {
            this.dumpData = true;
        }
        this.sparsify = false;
        str = attributeMap.get("sparsify");
        if (str != null && (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("on") || str.equalsIgnoreCase("yes"))) {
            this.sparsify = true;
        }
        this.checkTimestamps = true;
        str = attributeMap.get("tsCheck");
        if (str != null && (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("off") || str.equalsIgnoreCase("no"))) {
            this.checkTimestamps = false;
        }
        this.timestampSlop = 2;
        try {
            this.timestampSlop = Integer.parseInt(attributeMap.get("tsSlop"));
            if (this.timestampSlop < 1) {
                this.timestampSlop = 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int ringCount = 256;
        ringCount = this.buildingThreadCount == 3 ? 64 : (ringCount /= this.buildingThreadCount);
        str = attributeMap.get("ringCount");
        if (str != null) {
            try {
                ringCount = Integer.parseInt(str);
                if (ringCount < 16) {
                    ringCount = 16;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.ringItemCount = EmuUtilities.powerOfTwo(ringCount, true);
        this.outputRingSize = this.getInternalRingCount();
        this.logger.info("  EB mod: internal ring buf count -> " + this.ringItemCount);
    }

    @Override
    public int getInternalRingCount() {
        return this.buildingThreadCount * this.ringItemCount;
    }

    private void keepStats(int bufSize) {
        if (bufSize > this.maxEventSize) {
            this.maxEventSize = bufSize;
        }
        if (bufSize < this.minEventSize) {
            this.minEventSize = bufSize;
        }
        this.avgEventSize = (int)(((long)this.avgEventSize * this.builtEventCount + (long)bufSize) / (this.builtEventCount + 1L));
        this.goodChunk_X_EtBufSize = this.avgEventSize * this.outputRingSize * 3 / 4;
        if (++this.builtEventCount * (long)this.avgEventSize < 0L) {
            this.avgEventSize = 0;
            this.builtEventCount = 0;
        }
    }

    private void bankToOutputChannel(List<RingItem> banksOut, int ringNum, int channelNum) throws InterruptedException {
        if (this.outputChannelCount < 1) {
            for (RingItem bank : banksOut) {
                bank.releaseByteBuffer();
            }
            return;
        }
        RingBuffer<RingItem> rb = ((DataChannel)this.outputChannels.get(channelNum)).getRingBuffersOut()[ringNum];
        long lastRingItem = rb.next(banksOut.size());
        long ringItem = lastRingItem - (long)banksOut.size() + 1L;
        for (int i = 0; i < banksOut.size(); ++i) {
            PayloadBuffer pb = (PayloadBuffer)rb.get(ringItem += (long)i);
            pb.setBuffer(banksOut.get(i).getBuffer());
            pb.setEventType(banksOut.get(i).getEventType());
            pb.setControlType(banksOut.get(i).getControlType());
            pb.setSourceName(banksOut.get(i).getSourceName());
            pb.setAttachment(banksOut.get(i).getAttachment());
            pb.setReusableByteBuffer(banksOut.get(i).getByteBufferSupply(), banksOut.get(i).getByteBufferItem());
            rb.publish(ringItem);
        }
    }

    private void eventToOutputRing(int ringNum, int channelNum, int eventCount, ByteBuffer buf, EventType eventType, ByteBufferItem item, ByteBufferSupply bbSupply) throws InterruptedException {
        if (this.outputChannelCount < 1) {
            bbSupply.release(item);
            return;
        }
        RingBuffer<RingItem> rb = ((DataChannel)this.outputChannels.get(channelNum)).getRingBuffersOut()[ringNum];
        long nextRingItem = rb.nextIntr(1);
        RingItem ri = (RingItem)rb.get(nextRingItem);
        ri.setBuffer(buf);
        ri.setEventType(eventType);
        ri.setControlType(null);
        ri.setSourceName(null);
        ri.setReusableByteBuffer(bbSupply, item);
        ri.setEventCount(eventCount);
        rb.publish(nextRingItem);
    }

    private ControlType getAllControlEvents(Sequence[] sequences, SequenceBarrier[] barriers, long[] nextSequences, int threadIndex) throws EmuException, InterruptedException {
        int i;
        PayloadBuffer[] buildingBanks = new PayloadBuffer[this.inputChannelCount];
        ControlType controlType = null;
        for (i = 0; i < this.inputChannelCount; ++i) {
            try {
                ControlType cType;
                block10: {
                    while (true) {
                        barriers[i].waitFor(nextSequences[i]);
                        buildingBanks[i] = (PayloadBuffer)this.ringBuffersIn[i].get(nextSequences[i]);
                        cType = buildingBanks[i].getControlType();
                        if (cType != null) break block10;
                        EventType eType = buildingBanks[i].getEventType();
                        if (eType == null || eType != EventType.USER) break;
                        this.handleUserEvent(buildingBanks[i], (DataChannel)this.inputChannels.get(i), false);
                        sequences[i].set(nextSequences[i]);
                        int n = i;
                        nextSequences[n] = nextSequences[n] + 1L;
                    }
                    throw new EmuException("Expecting control, but got some other, non-user event");
                }
                if (controlType == null) {
                    controlType = cType;
                } else if (cType != controlType) {
                    throw new EmuException("Control event differs across inputs, expect " + (Object)((Object)controlType) + ", got " + (Object)((Object)cType));
                }
                if (cType.isEnd() || cType.isGo() || cType.isPrestart()) continue;
                if (threadIndex == 0) {
                    Utilities.printBuffer((ByteBuffer)buildingBanks[i].getBuffer(), (int)0, (int)5, (String)"Bad control event");
                }
                throw new EmuException("Expecting prestart, go or end, got " + (Object)((Object)cType));
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                throw new EmuException("Cannot get control event", e);
            }
            catch (AlertException e) {
                e.printStackTrace();
                throw new EmuException("Cannot get control event", e);
            }
        }
        Evio.gotConsistentControlEvents(buildingBanks, this.runNumber, this.runTypeId);
        for (i = 0; i < this.inputChannelCount; ++i) {
            sequences[i].set(nextSequences[i]);
            int n = i;
            nextSequences[n] = nextSequences[n] + 1L;
            if (threadIndex != 0) continue;
            buildingBanks[i].releaseByteBuffer();
        }
        return controlType;
    }

    private ControlType hopOverControlEvents(SequenceBarrier[] barriers, long[] nextSequences, int threadIndex) throws EmuException, InterruptedException {
        int i;
        ControlType controlType = null;
        for (i = 0; i < this.inputChannelCount; ++i) {
            try {
                ControlType cType;
                PayloadBuffer buildingBanks;
                block10: {
                    while (true) {
                        barriers[i].waitFor(nextSequences[i]);
                        buildingBanks = (PayloadBuffer)this.ringBuffersIn[i].get(nextSequences[i]);
                        cType = buildingBanks.getControlType();
                        if (cType != null) break block10;
                        EventType eType = buildingBanks.getEventType();
                        if (eType == null || eType != EventType.USER) break;
                        int n = i;
                        nextSequences[n] = nextSequences[n] + 1L;
                    }
                    throw new EmuException("Expecting control, but got some other, non-user event");
                }
                if (controlType == null) {
                    controlType = cType;
                } else if (cType != controlType) {
                    throw new EmuException("Control event differs across inputs, expect " + (Object)((Object)controlType) + ", got " + (Object)((Object)cType));
                }
                if (cType.isEnd() || cType.isGo() || cType.isPrestart()) continue;
                if (threadIndex == 0) {
                    Utilities.printBuffer((ByteBuffer)buildingBanks.getBuffer(), (int)0, (int)5, (String)"Bad control event");
                }
                throw new EmuException("Expecting prestart, go or end, got " + (Object)((Object)cType));
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                throw new EmuException("Cannot get control event", e);
            }
            catch (AlertException e) {
                e.printStackTrace();
                throw new EmuException("Cannot get control event", e);
            }
        }
        i = 0;
        while (i < this.inputChannelCount) {
            int n = i++;
            nextSequences[n] = nextSequences[n] + 1L;
        }
        return controlType;
    }

    private void controlToOutputAsync(boolean isPrestart) throws InterruptedException {
        int i;
        if (this.outputChannelCount < 1) {
            return;
        }
        ControlType controlType = isPrestart ? ControlType.PRESTART : ControlType.GO;
        PayloadBuffer[] controlBufs = new PayloadBuffer[this.outputChannelCount];
        controlBufs[0] = Evio.createControlBuffer(controlType, this.runNumber, this.runTypeId, (int)this.eventCountTotal, 0, this.outputOrder, false);
        for (i = 1; i < this.outputChannelCount; ++i) {
            controlBufs[i] = new PayloadBuffer(controlBufs[0]);
        }
        for (i = 0; i < this.outputChannelCount; ++i) {
            this.eventToOutputChannel((RingItem)controlBufs[i], i, 0);
        }
        if (isPrestart) {
            System.out.println("  EB mod: wrote PRESTART from build thread");
        } else {
            System.out.println("  EB mod: wrote GO from build thread");
        }
    }

    private void handleUserEvent(PayloadBuffer buildingBank, DataChannel inputChannel, boolean recordIdError) throws InterruptedException {
        ByteBuffer buffy = buildingBank.getBuffer();
        EvioNode inputNode = buildingBank.getNode();
        EventType eventType = buildingBank.getEventType();
        Evio.checkInput(buildingBank, inputChannel, eventType, inputNode, recordIdError);
        if (this.outputOrder != buildingBank.getByteOrder()) {
            try {
                if (buffy != null) {
                    ByteDataTransformer.swapEvent((ByteBuffer)buffy, (ByteBuffer)buffy, (int)0, (int)0, (boolean)false, null);
                } else if (inputNode != null) {
                    buffy = inputNode.getStructureBuffer(true);
                    ByteDataTransformer.swapEvent((ByteBuffer)buffy, null, (int)0, (int)0, (boolean)false, null);
                    buildingBank.setBuffer(buffy);
                    buildingBank.setNode(null);
                    buildingBank.releaseByteBuffer();
                }
            }
            catch (EvioException evioException) {}
        } else if (buffy == null) {
            buffy = inputNode.getStructureBuffer(true);
            buildingBank.setBuffer(buffy);
            buildingBank.setNode(null);
            buildingBank.releaseByteBuffer();
        }
        buildingBank.setEventCount(1);
        this.eventToOutputChannel((RingItem)buildingBank, 0, 0);
    }

    private void interruptThreads(boolean end) {
        if (end && !this.haveEndEvent) {
            System.out.println("  EB mod: endBuildThreads: will end building/filling threads but no END event");
            this.moduleState = CODAState.ERROR;
            this.emu.setErrorState("EB will end building/filling threads but no END event");
        }
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        for (Thread thread : this.buildingThreadList) {
            thread.interrupt();
        }
    }

    private void joinThreads() {
        if (this.RateCalculator != null) {
            try {
                this.RateCalculator.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (Thread thread : this.buildingThreadList) {
            try {
                thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void startThreads() {
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        this.RateCalculator = new Thread(this.emu.getThreadGroup(), new ModuleAdapter.RateCalculatorThread(this), this.name + ":watcher");
        if (this.RateCalculator.getState() == Thread.State.NEW) {
            this.RateCalculator.start();
        }
        int inChanCount = this.inputChannels.size();
        this.buildingThreadList.clear();
        for (int i = 0; i < this.buildingThreadCount; ++i) {
            BuildingThread thd1 = new BuildingThread(i, this.emu.getThreadGroup(), this.name + ":builder" + i);
            this.buildingThreadList.add(thd1);
            thd1.start();
        }
    }

    @Override
    public void reset() {
        CODAStateIF previousState = this.moduleState;
        this.moduleState = CODAState.CONFIGURED;
        this.interruptThreads(false);
        this.joinThreads();
        this.RateCalculator = null;
        this.buildingThreadList.clear();
        this.paused = false;
        if (previousState.equals(CODAState.ACTIVE)) {
            try {
                Configurer.setValue(this.emu.parameters(), "status/run_end_time", new Date().toString());
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void end() {
        System.out.println("  EB mod: end(), set state to DOWNLOADED");
        this.moduleState = CODAState.DOWNLOADED;
        if (this.timeStatsOn) {
            System.out.println("  EB mod: end(), print histogram");
            this.statistics.printBuildTimeHistogram("Time to build one event:", "nsec");
        }
        System.out.println("  EB mod: end(), interrupt threads");
        this.interruptThreads(true);
        this.joinThreads();
        this.RateCalculator = null;
        this.buildingThreadList.clear();
        this.paused = false;
        try {
            System.out.println("  EB mod: end(), set internal ending time parameter");
            Configurer.setValue(this.emu.parameters(), "status/run_end_time", new Date().toString());
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
        System.out.println("  EB mod: end(), done");
    }

    @Override
    public void prestart() throws CmdExecException {
        int i;
        if (this.inputChannelCount < 1) {
            this.moduleState = CODAState.ERROR;
            System.out.println("  EB mod: prestart, no input channels to EB");
            this.emu.setErrorState("no input channels to EB");
            throw new CmdExecException("no input channels to EB");
        }
        for (i = 0; i < this.inputChannelCount; ++i) {
            for (int j = i + 1; j < this.inputChannelCount; ++j) {
                if (((DataChannel)this.inputChannels.get(i)).getID() != ((DataChannel)this.inputChannels.get(j)).getID()) continue;
                this.moduleState = CODAState.ERROR;
                System.out.println("  EB mod: prestart, input channels have duplicate rocIDs");
                this.emu.setErrorState("input channels have duplicate rocIDs");
                throw new CmdExecException("input channels have duplicate rocIDs");
            }
        }
        this.moduleState = CODAState.PAUSED;
        this.paused = true;
        this.lastSeq = new long[this.buildingThreadCount][this.inputChannelCount];
        this.lastSeqReleased = new long[this.inputChannelCount];
        this.maxSeqReleased = new long[this.inputChannelCount];
        this.betweenReleased = new int[this.inputChannelCount];
        for (i = 0; i < this.buildingThreadCount; ++i) {
            Arrays.fill(this.lastSeq[i], -1L);
        }
        Arrays.fill(this.lastSeqReleased, -1L);
        Arrays.fill(this.maxSeqReleased, -1L);
        this.ringBuffersIn = new RingBuffer[this.inputChannelCount];
        this.buildSequenceIn = new Sequence[this.buildingThreadCount][this.inputChannelCount];
        this.buildBarrierIn = new SequenceBarrier[this.inputChannelCount];
        this.inputChanLevels = new int[this.inputChannelCount];
        this.outputChanLevels = new int[this.outputChannelCount];
        int indx = 0;
        this.inputChanNames = new String[this.inputChannelCount];
        for (DataChannel ch : this.inputChannels) {
            this.inputChanNames[indx++] = ch.name();
        }
        indx = 0;
        this.outputChanNames = new String[this.outputChannelCount];
        for (DataChannel ch : this.outputChannels) {
            this.outputChanNames[indx++] = ch.name();
        }
        this.ringBufferSize = new int[this.inputChannelCount];
        for (int i2 = 0; i2 < this.inputChannelCount; ++i2) {
            RingBuffer<RingItem> rb = ((DataChannel)this.inputChannels.get(i2)).getRingBufferIn();
            this.ringBuffersIn[i2] = rb;
            this.ringBufferSize[i2] = rb.getBufferSize();
            for (int j = 0; j < this.buildingThreadCount; ++j) {
                this.buildSequenceIn[j][i2] = new Sequence(-1L);
                rb.addGatingSequences(new Sequence[]{this.buildSequenceIn[j][i2]});
            }
            this.buildBarrierIn[i2] = rb.newBarrier(new Sequence[0]);
        }
        this.wordRate = 0.0f;
        this.eventRate = 0.0f;
        this.wordCountTotal = 0L;
        this.eventCountTotal = 0L;
        this.runTypeId = this.emu.getRunTypeId();
        this.runNumber = this.emu.getRunNumber();
        this.haveEndEvent = false;
        this.haveAllPrestartEvents = false;
        this.startThreads();
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", "--prestart--");
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void go() throws CmdExecException {
        if (!this.haveAllPrestartEvents && !this.dumpData) {
            System.out.println("  EB mod: go, have not received all prestart events");
            throw new CmdExecException("have not received all prestart events");
        }
        this.moduleState = CODAState.ACTIVE;
        this.paused = false;
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", new Date().toString());
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    static /* synthetic */ ControlType access$700(FastEventBuilder x0, Sequence[] x1, SequenceBarrier[] x2, long[] x3, int x4) throws EmuException, InterruptedException {
        return x0.getAllControlEvents(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$800(FastEventBuilder x0, boolean x1) throws InterruptedException {
        x0.controlToOutputAsync(x1);
    }

    static /* synthetic */ ControlType access$900(FastEventBuilder x0, SequenceBarrier[] x1, long[] x2, int x3) throws EmuException, InterruptedException {
        return x0.hopOverControlEvents(x1, x2, x3);
    }

    static /* synthetic */ boolean access$1000(FastEventBuilder x0) {
        return x0.debug;
    }

    static /* synthetic */ boolean access$1102(FastEventBuilder x0, boolean x1) {
        x0.haveAllPrestartEvents = x1;
        return x0.haveAllPrestartEvents;
    }

    static /* synthetic */ boolean access$1202(FastEventBuilder x0, boolean x1) {
        x0.haveEndEvent = x1;
        return x0.haveEndEvent;
    }

    static /* synthetic */ void access$1300(FastEventBuilder x0, PayloadBuffer x1, DataChannel x2, boolean x3) throws InterruptedException {
        x0.handleUserEvent(x1, x2, x3);
    }

    static /* synthetic */ boolean access$1400(FastEventBuilder x0) {
        return x0.includeRunData;
    }

    static /* synthetic */ boolean access$1500(FastEventBuilder x0) {
        return x0.sparsify;
    }

    static /* synthetic */ boolean access$1600(FastEventBuilder x0) {
        return x0.checkTimestamps;
    }

    static /* synthetic */ int access$1700(FastEventBuilder x0) {
        return x0.timestampSlop;
    }

    static /* synthetic */ void access$1800(FastEventBuilder x0, int x1, int x2, int x3, ByteBuffer x4, EventType x5, ByteBufferItem x6, ByteBufferSupply x7) throws InterruptedException {
        x0.eventToOutputRing(x1, x2, x3, x4, x5, x6, x7);
    }

    static /* synthetic */ void access$1900(FastEventBuilder x0, int x1) {
        x0.keepStats(x1);
    }

    class BuildingThread
    extends Thread {
        private final int btCount;
        private final int btIndex;
        private boolean fastCopyReady;
        private long evIndex;
        private int outputChannelIndex;
        private Sequence[] buildSequences;
        private long[] availableSequences;
        private long[] nextSequences;

        BuildingThread(int btIndex, ThreadGroup group, String name) {
            super(group, name);
            this.evIndex = 0L;
            this.outputChannelIndex = 0;
            this.btIndex = btIndex;
            this.evIndex = btIndex;
            this.btCount = FastEventBuilder.this.buildingThreadCount;
            System.out.println("  EB mod: create Build Thread with index " + btIndex + ", count = " + this.btCount);
        }

        int getInputLevel(int chanIndex) {
            return ((int)(FastEventBuilder.this.ringBuffersIn[chanIndex].getCursor() - FastEventBuilder.this.ringBuffersIn[chanIndex].getMinimumGatingSequence()) + 1) * 100 / FastEventBuilder.this.ringBufferSize[chanIndex];
        }

        private void handleEndEvent(PayloadBuffer[] buildingBanks) {
            int i;
            System.out.println("  EB mod: in handleEndEvent(), bt #" + this.btIndex + ", output chan count = " + FastEventBuilder.this.outputChannelCount);
            if (FastEventBuilder.this.outputChannelCount > 0) {
                PayloadBuffer[] endBufs = new PayloadBuffer[FastEventBuilder.this.outputChannelCount];
                endBufs[0] = Evio.createControlBuffer(ControlType.END, FastEventBuilder.this.runNumber, FastEventBuilder.this.runTypeId, (int)FastEventBuilder.this.eventCountTotal, 0, FastEventBuilder.this.outputOrder, false);
                for (i = 1; i < FastEventBuilder.this.outputChannelCount; ++i) {
                    endBufs[i] = new PayloadBuffer(endBufs[0]);
                }
                this.outputChannelIndex = (int)(this.evIndex % (long)FastEventBuilder.this.outputChannelCount);
                System.out.println("  EB mod: try sending END event to output channel " + this.outputChannelIndex + ", ring " + this.btIndex + ", ev# = " + this.evIndex);
                try {
                    FastEventBuilder.this.eventToOutputChannel((RingItem)endBufs[0], this.outputChannelIndex, this.btIndex);
                }
                catch (InterruptedException e) {
                    return;
                }
                System.out.println("  EB mod: sent END event to output channel  " + this.outputChannelIndex);
                if (FastEventBuilder.this.outputChannelCount > 1) {
                    for (i = 0; i < FastEventBuilder.this.inputChannelCount; ++i) {
                        int j;
                        long ev;
                        int timeLeft = 2000;
                        if (FastEventBuilder.this.buildingThreadCount > 1) {
                            ev = Long.MAX_VALUE;
                            for (j = 0; j < FastEventBuilder.this.buildingThreadCount; ++j) {
                                long seq = FastEventBuilder.this.buildSequenceIn[j][i].get();
                                ev = Math.min(seq, ev);
                            }
                        } else {
                            ev = FastEventBuilder.this.buildSequenceIn[0][i].get();
                        }
                        while (ev < this.evIndex - 1L && timeLeft > 0) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException seq) {
                                // empty catch block
                            }
                            if (FastEventBuilder.this.buildingThreadCount > 1) {
                                ev = Long.MAX_VALUE;
                                for (j = 0; j < FastEventBuilder.this.buildingThreadCount; ++j) {
                                    long seq = FastEventBuilder.this.buildSequenceIn[j][i].get();
                                    ev = Math.min(seq, ev);
                                }
                            } else {
                                ev = FastEventBuilder.this.buildSequenceIn[0][i].get();
                            }
                            timeLeft -= 200;
                        }
                        if (ev >= this.evIndex - 1L) continue;
                        System.out.println("  EB mod: WARNING, might have a problem writing END event");
                    }
                }
                for (i = 1; i < FastEventBuilder.this.outputChannelCount; ++i) {
                    int nextChannel = (int)((this.evIndex + (long)i) % (long)FastEventBuilder.this.outputChannelCount);
                    int nextBtIndex = (int)((this.evIndex + (long)i) % (long)this.btCount);
                    System.out.println("  EB mod: try sending END event to output channel " + nextChannel + ", ring " + nextBtIndex + ", ev# = " + this.evIndex);
                    try {
                        FastEventBuilder.this.eventToOutputChannel((RingItem)endBufs[i], nextChannel, nextBtIndex);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    System.out.println("  EB mod: sent END event to output channel  " + nextChannel);
                }
                ++FastEventBuilder.this.eventCountTotal;
                FastEventBuilder.this.wordCountTotal += 5L;
            }
            for (i = 0; i < FastEventBuilder.this.inputChannelCount; ++i) {
                int n = i;
                long l = this.nextSequences[n];
                this.nextSequences[n] = l + 1L;
                this.buildSequences[i].set(l);
                if (buildingBanks == null) continue;
                buildingBanks[i].releaseByteBuffer();
            }
            if (FastEventBuilder.this.endCallback != null) {
                FastEventBuilder.this.endCallback.endWait();
            }
        }

        private int findEnd(int endChannel, long endSequence, int endEventCount) {
            try {
                block3: for (int ch = 0; ch < FastEventBuilder.this.inputChannelCount; ++ch) {
                    if (ch == endChannel) continue;
                    int offset = 0;
                    boolean done = false;
                    long veryNextSequence = endSequence + 1L;
                    while (true) {
                        if (FastEventBuilder.this.ringBuffersIn[ch].getCursor() < veryNextSequence) {
                            if (FastEventBuilder.this.moduleState == CODAState.DOWNLOADED || FastEventBuilder.this.moduleState != CODAState.ACTIVE) {
                                System.out.println("  EB mod: findEnd, stop looking for END on channel " + ch + " as module state = " + FastEventBuilder.this.moduleState);
                                continue block3;
                            }
                            Thread.sleep(100L);
                            continue;
                        }
                        long available = FastEventBuilder.this.buildBarrierIn[ch].waitFor(veryNextSequence);
                        while (veryNextSequence <= available) {
                            ++offset;
                            PayloadBuffer pBuf = (PayloadBuffer)FastEventBuilder.this.ringBuffersIn[ch].get(veryNextSequence);
                            String source = pBuf.getSourceName();
                            if (pBuf.getControlType() == ControlType.END) {
                                System.out.println("  EB mod: findEnd, chan " + ch + " got END from " + source + ", back " + offset + " places in ring");
                                ++endEventCount;
                                done = true;
                                break;
                            }
                            pBuf.releaseByteBuffer();
                            for (int bt = 0; bt < this.btCount; ++bt) {
                                FastEventBuilder.this.buildSequenceIn[bt][ch].set(veryNextSequence);
                            }
                            ++veryNextSequence;
                        }
                        if (done) continue block3;
                    }
                }
            }
            catch (InterruptedException available) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return endEventCount;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 62[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

