/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.util.ArrayList;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.emu.EmuUtilities;

public class RocSynchronizer {
    private String subjectIn = "syncFromRoc";
    private cMsgSubscriptionHandle sub;
    private cMsgMessage message;
    private cMsg coda;
    private String UDL;
    private String name = "Synchronizer";
    private String description = "synchronize fake ROCs";
    private int count;
    private boolean debug;
    private ArrayList<String> expectedRocs = new ArrayList(10);
    private ArrayList<String> respondingRocs = new ArrayList(10);
    private ArrayList<Integer> respondingStates = new ArrayList(10);

    RocSynchronizer(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                RocSynchronizer.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                this.expectedRocs.add(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            RocSynchronizer.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java RocSynchronizer\n        [-u <UDL>]    set UDL to connect to cMsg\n        [-r <roc>]    fake ROC to sync (use this multiple times)\n        [-debug]      turn on printout\n        [-h]          print this help\n");
    }

    public static void main(String[] args) {
        try {
            RocSynchronizer receiver = new RocSynchronizer(args);
            receiver.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running RocSynchronzier\n");
        }
        if (this.UDL == null) {
            this.UDL = "cMsg://localhost/cMsg/RocSync";
        }
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        System.out.println("  connected");
        this.message = new cMsgMessage();
        this.message.setSubject("sync");
        this.message.setType("ROC");
        this.message.setHistoryLengthMax(0);
        myCallback cb = new myCallback();
        this.sub = this.coda.subscribe(this.subjectIn, "*", (cMsgCallbackInterface)cb, null);
        this.coda.start();
        long totalT = 0L;
        long totalC = 0L;
        long period = 3000L;
        while (true) {
            this.count = 0;
            long t1 = System.currentTimeMillis();
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long t2 = System.currentTimeMillis();
            long deltaT = t2 - t1;
            double freq = (double)this.count / (double)deltaT * 1000.0;
            double freqAvg = (double)(totalC += (long)this.count) / (double)(totalT += deltaT) * 1000.0;
            if (this.debug) {
                System.out.println("count = " + this.count + ", total = " + totalC);
                System.out.println("freq  = " + EmuUtilities.doubleToString(freq, 1) + " Hz, Avg = " + EmuUtilities.doubleToString(freqAvg, 1) + " Hz");
            }
            if (this.coda.isConnected()) continue;
            System.out.println("No longer connected to server, quitting");
            System.exit(-1);
        }
    }

    class myCallback
    extends cMsgCallbackAdapter {
        myCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            RocSynchronizer.this.respondingRocs.add(msg.getType());
            RocSynchronizer.this.respondingStates.add(msg.getUserInt());
            if (RocSynchronizer.this.respondingRocs.size() == RocSynchronizer.this.expectedRocs.size()) {
                if (!RocSynchronizer.this.respondingStates.contains(0)) {
                    System.out.println("All ROCs got end cmd");
                    RocSynchronizer.this.message.setUserInt(1);
                } else {
                    RocSynchronizer.this.message.setUserInt(0);
                }
                try {
                    RocSynchronizer.this.coda.send(RocSynchronizer.this.message);
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                }
                RocSynchronizer.this.respondingRocs.clear();
                RocSynchronizer.this.respondingStates.clear();
                RocSynchronizer.this.count++;
            }
        }
    }
}

