/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.codaComponent.CODATransition;
import org.jlab.coda.emu.support.configurer.Configurer;
import org.jlab.coda.emu.support.control.Command;
import org.jlab.coda.emu.support.control.CommandAcceptor;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.logger.QueueAppender;
import org.jlab.coda.emu.support.ui.AboutBox;
import org.jlab.coda.emu.support.ui.HelpBox;
import org.jlab.coda.emu.support.ui.SmartToolbar;
import org.jlab.coda.emu.support.ui.log.SwingLogConsoleDialog;
import org.w3c.dom.Document;

public class EMUCommander
extends JFrame {
    String TEST_UDL = "cMsg://localhost:7030/cMsg/test";
    Thread monitor;
    cMsg server;
    String UDL;
    boolean verbose = true;
    private Logger logger;
    private static String normalFormat = "%18s  %24s    %9d    %-18s  %-18s    %s";
    private static String normalHeader = "%18s  %24s    %9s    %-18s  %-18s    %s";
    private static String wideFormat = "%18s  %24s    %9d    %-30s  %-30s    %s";
    private static String wideHeader = "%18s  %24s    %9s    %-30s  %-30s    %s";
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem quitMenuItem;
    private JMenu editMenu;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem undoMenuItem;
    private JMenu logMenu;
    private JMenuItem clearMenuItem;
    private JCheckBox errorLoggingCheckBox;
    private JCheckBox debugLoggingCheckBox;
    private JMenu helpMenu;
    private JMenuItem help;
    private JMenuItem aboutMenuItem;
    private SmartToolbar smartToolbar;
    private SmartToolbar smartToolbar1;
    private SmartToolbar smartToolbar2;
    private JScrollPane logScrollPane;
    private SwingLogConsoleDialog logPanel;

    public static void main(String[] args) {
        new EMUCommander();
    }

    public EMUCommander() {
        this.initComponents();
        this.pack();
        this.setVisible(true);
        QueueAppender logQueueAppender = new QueueAppender(1024);
        this.logger.addAppender(logQueueAppender);
        this.logPanel.monitor(logQueueAppender);
        this.smartToolbar.configure(new CommandHandler("run/transition/"), 0);
        this.smartToolbar1.configure(new CommandHandler("run/control/"), 1);
        this.smartToolbar2.configure(new CommandHandler("session/control/"), 2);
        try {
            this.UDL = System.getProperty("cmsgUDL");
            boolean bl = this.verbose = System.getProperty("verbose") != null;
            if (this.UDL == null) {
                this.UDL = this.TEST_UDL;
            }
            this.server = new cMsg(this.UDL, "EMUCommander", "Tool to send commands to EMUs and log responses");
            this.server.connect();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            this.server.subscribe("*", "*", (cMsgCallbackInterface)new CallbackAdapter(), null);
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.server.start();
        try {
            while (this.server.isConnected()) {
                Thread.sleep(1L);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.server.stop();
        try {
            this.server.disconnect();
        }
        catch (Exception e) {
            System.exit(-1);
        }
        System.exit(0);
    }

    private static void quitMenuItemActionPerformed(ActionEvent e) {
        System.exit(0);
    }

    private void helpActionPerformed(ActionEvent e) {
        HelpBox theBox = new HelpBox(this);
        theBox.setVisible(true);
    }

    private static void aboutMenuItemActionPerformed(ActionEvent e) {
        AboutBox theBox = new AboutBox();
        theBox.setVisible(true);
    }

    private void errorLoggingCheckBoxActionPerformed(ActionEvent e) {
        boolean selected = ((JCheckBox)e.getSource()).getModel().isSelected();
        if (selected) {
            if (!this.logger.isErrorEnabled()) {
                this.logger.toggleError();
                this.logger.info("Enable error logging");
            }
        } else if (this.logger.isErrorEnabled()) {
            this.logger.info("Disable error logging");
            this.logger.toggleError();
        }
    }

    private void debugLoggingCheckBoxActionPerformed(ActionEvent e) {
        boolean selected = ((JCheckBox)e.getSource()).getModel().isSelected();
        if (selected) {
            if (!this.logger.isDebugEnabled()) {
                this.logger.toggleDebug();
                this.logger.info("Enable debug logging");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.info("Disable debug logging");
            this.logger.toggleDebug();
        }
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("org.jlab.coda.emu.support.ui.rsrc.strings");
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.quitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.undoMenuItem = new JMenuItem();
        this.logMenu = new JMenu();
        this.clearMenuItem = new JMenuItem();
        this.errorLoggingCheckBox = new JCheckBox();
        this.debugLoggingCheckBox = new JCheckBox();
        this.helpMenu = new JMenu();
        this.help = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.smartToolbar = new SmartToolbar();
        this.smartToolbar1 = new SmartToolbar();
        this.smartToolbar2 = new SmartToolbar();
        this.logScrollPane = new JScrollPane();
        this.logPanel = new SwingLogConsoleDialog();
        this.logPanel.setLogger(this.logger);
        this.setTitle(bundle.getString("emuCommander.title"));
        Container contentPane = this.getContentPane();
        this.fileMenu.setText(bundle.getString("fileMenu.text"));
        this.quitMenuItem.setText(bundle.getString("quitMenuItem.text"));
        this.quitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EMUCommander.quitMenuItemActionPerformed(e);
            }
        });
        this.fileMenu.add(this.quitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText(bundle.getString("editMenu.text"));
        this.cutMenuItem.setText(bundle.getString("cutMenuItem.text"));
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText(bundle.getString("copyMenuItem.text"));
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText(bundle.getString("pasteMenuItem.text"));
        this.editMenu.add(this.pasteMenuItem);
        this.undoMenuItem.setText(bundle.getString("undoMenuItem.text"));
        this.editMenu.add(this.undoMenuItem);
        this.menuBar.add(this.editMenu);
        this.logMenu.setText(bundle.getString("logMenu.text"));
        this.clearMenuItem.setText(bundle.getString("clearMenuItem.text"));
        this.logMenu.add(this.clearMenuItem);
        this.errorLoggingCheckBox.setText(bundle.getString("errorLoggingCheckBox.text"));
        this.errorLoggingCheckBox.setPreferredSize(new Dimension(57, 19));
        this.errorLoggingCheckBox.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.errorLoggingCheckBox.setMinimumSize(new Dimension(1, 1));
        this.errorLoggingCheckBox.setSelected(true);
        this.errorLoggingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EMUCommander.this.errorLoggingCheckBoxActionPerformed(e);
            }
        });
        this.logMenu.add(this.errorLoggingCheckBox);
        this.debugLoggingCheckBox.setText(bundle.getString("debugLoggingCheckBox.text"));
        this.debugLoggingCheckBox.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.debugLoggingCheckBox.setMinimumSize(new Dimension(1, 1));
        this.debugLoggingCheckBox.setPreferredSize(new Dimension(57, 19));
        this.debugLoggingCheckBox.setSelected(true);
        this.debugLoggingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EMUCommander.this.debugLoggingCheckBoxActionPerformed(e);
            }
        });
        this.logMenu.add(this.debugLoggingCheckBox);
        this.menuBar.add(this.logMenu);
        this.helpMenu.setText(bundle.getString("helpMenu.text"));
        this.help.setText(bundle.getString("help.text"));
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EMUCommander.this.helpActionPerformed(e);
            }
        });
        this.helpMenu.add(this.help);
        this.aboutMenuItem.setText(bundle.getString("aboutMenuItem.text"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EMUCommander.aboutMenuItemActionPerformed(e);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.smartToolbar.setFloatable(false);
        this.smartToolbar1.setFloatable(false);
        this.smartToolbar2.setFloatable(false);
        this.logScrollPane.setViewportView(this.logPanel);
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout((LayoutManager)contentPaneLayout);
        contentPaneLayout.setHorizontalGroup((GroupLayout.Group)contentPaneLayout.createParallelGroup().add(2, (GroupLayout.Group)contentPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)contentPaneLayout.createParallelGroup(2).add(1, (Component)this.smartToolbar2, -1, 694, Short.MAX_VALUE).add(1, (Component)this.smartToolbar1, -1, 694, Short.MAX_VALUE).add(1, (Component)this.smartToolbar, -1, 694, Short.MAX_VALUE).add(1, (Component)this.logScrollPane, -1, 694, Short.MAX_VALUE)).addContainerGap()));
        contentPaneLayout.setVerticalGroup((GroupLayout.Group)contentPaneLayout.createParallelGroup().add((GroupLayout.Group)contentPaneLayout.createSequentialGroup().add((Component)this.smartToolbar, -2, -1, -2).addPreferredGap(1).add((Component)this.smartToolbar1, -2, -1, -2).addPreferredGap(1).add((Component)this.smartToolbar2, -2, -1, -2).addPreferredGap(1).add((Component)this.logScrollPane, -1, 697, Short.MAX_VALUE).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    protected class CallbackAdapter
    extends cMsgCallbackAdapter {
        protected CallbackAdapter() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            if (EMUCommander.this.verbose) {
                System.out.println(String.format(normalFormat, msg.getSenderHost(), new Timestamp(msg.getSenderTime().getTime()), msg.getUserInt(), msg.getSubject(), msg.getType(), msg.getText()));
            }
            switch (msg.getUserInt()) {
                case 1: {
                    EMUCommander.this.logger.debug(msg.getText());
                    break;
                }
                case 11: {
                    EMUCommander.this.logger.error(msg.getText());
                    break;
                }
                case 2: {
                    EMUCommander.this.logger.info(msg.getText());
                    break;
                }
                case 8: {
                    EMUCommander.this.logger.warn(msg.getText());
                }
            }
        }
    }

    protected class CommandHandler
    implements CommandAcceptor {
        private String subject;
        private CODAStateIF state = CODAState.BOOTED;
        private String errorMsg;

        CommandHandler(String subject) {
            this.subject = subject;
        }

        @Override
        public void postCommand(Command cmd) throws InterruptedException {
            cMsgMessage msg = new cMsgMessage();
            msg.setSubject(cmd.toString());
            msg.setType(this.subject + cmd.toString());
            msg.setText(cmd.toString());
            if (cmd.equals((Object)CODATransition.CONFIGURE)) {
                String configFile;
                String emuName = System.getProperty("name");
                if (emuName == null) {
                    System.out.println("usage: java EMUCommander -Dname=\"my name\"");
                    System.exit(-1);
                }
                if ((configFile = System.getProperty("config")) == null) {
                    System.out.println("Put -Dconfig=xxx option on cmd line for local config file");
                    System.exit(-1);
                }
                try {
                    System.out.println("Parse : " + configFile);
                    Document d = Configurer.parseFile(configFile);
                    Configurer.removeEmptyTextNodes(d.getDocumentElement());
                    System.out.println("Document : " + Configurer.serialize(d));
                    String content = Configurer.serialize(d);
                    msg.addPayloadItem(new cMsgPayloadItem("configuration", content));
                    System.out.println('\"' + content + '\"');
                }
                catch (Exception e) {
                    System.err.println("Exception " + e);
                }
            }
            try {
                CODAStateIF tmp;
                System.out.println("CMSGPortal.append server = " + EMUCommander.this.server);
                if (EMUCommander.this.server != null) {
                    EMUCommander.this.server.send(msg);
                }
                if ((tmp = cmd.success()) != null) {
                    this.state = tmp;
                    System.out.println("Allowed transitions are " + this.state.allowed());
                    EMUCommander.this.smartToolbar.updateButtons(this.state);
                    System.out.println("State of " + this + " is now " + this.state());
                } else {
                    System.out.println("State not changed by command");
                }
            }
            catch (cMsgException e) {
                System.out.println("CMSGPortal.append error " + e.getMessage());
            }
        }

        @Override
        public CODAStateIF state() {
            return this.state;
        }

        @Override
        public String getError() {
            return this.errorMsg;
        }
    }
}

