/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.transport.DataTransportImplEmu;
import org.jlab.coda.emu.support.transport.EmuDomainTcpServer;
import org.jlab.coda.emu.support.transport.EmuDomainUdpListener;

public class EmuDomainServer
extends Thread {
    String domain = "emu";
    final int serverPort;
    private EmuDomainUdpListener listener;
    private EmuDomainTcpServer tcpServer;
    private final String expid;
    private final String name;
    final DataTransportImplEmu transport;

    public EmuDomainServer(int port, String expid, String name, DataTransportImplEmu transport) throws cMsgException {
        this.name = name;
        this.expid = expid;
        this.serverPort = port;
        this.transport = transport;
    }

    public EmuDomainTcpServer getTcpServer() {
        return this.tcpServer;
    }

    public void stopServer() {
        this.listener.killAllThreads();
        this.tcpServer.killAllThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.tcpServer = new EmuDomainTcpServer(this, this.serverPort);
            this.tcpServer.start();
            Thread thread = this.tcpServer;
            synchronized (thread) {
                if (!this.tcpServer.isAlive()) {
                    try {
                        this.tcpServer.wait();
                    }
                    catch (InterruptedException e) {
                        this.transport.transportState = CODAState.ERROR;
                        this.transport.emu.setErrorState("Transport Emu: error starting emu TCP server");
                        return;
                    }
                }
            }
            this.listener = new EmuDomainUdpListener(this, this.serverPort, this.expid, this.name);
            this.listener.start();
            thread = this.listener;
            synchronized (thread) {
                if (!this.listener.isAlive()) {
                    try {
                        this.listener.wait();
                    }
                    catch (InterruptedException e) {
                        this.transport.transportState = CODAState.ERROR;
                        this.transport.emu.setErrorState("Transport Emu: error starting emu UDP server");
                        return;
                    }
                }
            }
        }
        catch (cMsgException e) {
            this.transport.transportState = CODAState.ERROR;
            this.transport.emu.setErrorState("Transport Emu: error starting emu domain server: " + e.getMessage());
        }
    }
}

