/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import java.util.HashMap;
import java.util.Map;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.emu.support.transport.DataChannelImplFifo;
import org.jlab.coda.emu.support.transport.DataTransportAdapter;
import org.jlab.coda.emu.support.transport.DataTransportException;

public class DataTransportImplFifo
extends DataTransportAdapter {
    private final HashMap<String, DataChannelImplFifo> allChannels = new HashMap(4);

    public DataTransportImplFifo(String pname, Map<String, String> attrib, Emu emu) throws DataNotFoundException {
        super(pname, attrib, emu);
    }

    @Override
    public void end() {
        this.allChannels.clear();
    }

    @Override
    public void reset() {
        this.allChannels.clear();
    }

    @Override
    public synchronized DataChannel createChannel(String name, Map<String, String> attributeMap, boolean isInput, Emu emu, EmuModule module, int outputIndex) throws DataTransportException {
        String channelName = this.name() + ':' + name;
        DataChannelImplFifo c = this.allChannels.get(channelName);
        if (c == null) {
            if (isInput) {
                System.out.println("    DataTransport Fifo : will create channel " + channelName + " as input");
            } else {
                System.out.println("    DataTransport Fifo : will create channel " + channelName + " as output");
            }
            c = new DataChannelImplFifo(channelName, this, attributeMap, isInput, emu, module);
            this.allChannels.put(channelName, c);
        } else if (isInput) {
            System.out.println("    DataTransport Fifo : setup channel " + c.name() + " as input");
            c.setupInputRingBuffers();
        } else {
            System.out.println("    DataTransport Fifo : setup channel " + c.name() + " as output");
            c.setupOutputRingBuffers();
        }
        return c;
    }
}

