/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import java.util.Map;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.emu.support.transport.DataChannelImplCmsg;
import org.jlab.coda.emu.support.transport.DataTransportAdapter;
import org.jlab.coda.emu.support.transport.DataTransportException;

public class DataTransportImplCmsg
extends DataTransportAdapter {
    private cMsg cmsgConnection;
    private Logger logger;

    public cMsg getCmsgConnection() {
        return this.cmsgConnection;
    }

    public DataTransportImplCmsg(String pname, Map<String, String> attrib, Emu emu) throws DataNotFoundException {
        super(pname, attrib, emu);
        this.logger = emu.getLogger();
        String udl = attrib.get("udl");
        if (udl == null) {
            this.transportState = CODAState.ERROR;
            emu.setErrorState("Transport cmsg: cannot find udl");
            throw new DataNotFoundException("Cannot find udl");
        }
        if (udl.equalsIgnoreCase("platform")) {
            udl = "cMsg://" + emu.getCmsgPortal().getPlatformHost() + ':' + emu.getCmsgPortal().getPlatformPort() + "/cMsg/CODA/?cmsgpassword=" + emu.getExpid();
        }
        try {
            this.cmsgConnection = new cMsg(udl, pname + '_' + emu.name(), "");
        }
        catch (cMsgException e) {
            this.transportState = CODAState.ERROR;
            emu.setErrorState("Transport cmsg: cannot connect to server, " + e.getMessage());
            throw new DataNotFoundException("Cannot connect to cmsg server", e);
        }
    }

    @Override
    public DataChannel createChannel(String name, Map<String, String> attributeMap, boolean isInput, Emu emu, EmuModule module, int outputIndex) throws DataTransportException {
        return new DataChannelImplCmsg(name, this, attributeMap, isInput, emu, module, outputIndex);
    }

    @Override
    public void reset() {
        try {
            this.logger.debug("    Transport cmsg reset: disconnect : " + this.name());
            this.cmsgConnection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void prestart() throws CmdExecException {
        try {
            this.logger.debug("    Transport cMsg prestart: connect : " + this.name());
            this.cmsgConnection.connect();
            this.logger.debug("    Transport cMsg prestart: start receiving : " + this.name());
            this.cmsgConnection.start();
        }
        catch (cMsgException e) {
            this.transportState = CODAState.ERROR;
            this.emu.setErrorState("Transport cmsg: cannot connect to server, " + e.getMessage());
            this.logger.debug("    Transport cmsg prestart: cannot connect to server (bad UDL or network) : " + this.name());
            throw new CmdExecException("cannot connect to cMsg server (bad UDL or network)", e);
        }
    }

    @Override
    public void pause() {
        this.logger.debug("    Transport cmsg pause: stop receiving : " + this.name());
        this.cmsgConnection.stop();
    }

    @Override
    public void end() {
        try {
            this.logger.debug("    Transport cmsg end: disconnect : " + this.name());
            this.cmsgConnection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

