/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SpinCountBackoffWaitStrategy;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuEventNotify;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.EmuUtilities;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.codaComponent.CODAStateMachineAdapter;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.data.RingItemFactory;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.emu.support.transport.DataChannelImplFifo;
import org.jlab.coda.emu.support.transport.DataTransport;
import org.jlab.coda.emu.support.transport.TransportType;

public abstract class DataChannelAdapter
extends CODAStateMachineAdapter
implements DataChannel {
    protected int id;
    protected int recordId;
    protected int prescale;
    protected boolean singleEventOut;
    protected CODAStateIF channelState;
    protected AtomicReference<String> errorMsg = new AtomicReference();
    protected final String name;
    protected boolean ignoreDataErrors;
    protected final boolean isFifo;
    protected final boolean input;
    protected final Emu emu;
    protected final Logger logger;
    protected ByteOrder byteOrder;
    protected EmuEventNotify endCallback;
    protected EmuEventNotify prestartCallback;
    protected final EmuModule module;
    protected final DataTransport dataTransport;
    protected volatile boolean pause;
    protected volatile boolean gotEndCmd;
    protected volatile boolean gotResetCmd;
    protected String[] ipAddrList;
    protected String[] bAddrList;
    protected boolean regulateBufferRate;
    protected double buffersPerSec;
    protected long nanoSecPerBuf;
    protected int eventsPerBuffer;
    protected int outputChannelCount;
    protected int outputRingCount;
    protected int outputIndex;
    protected int ringIndex;
    protected long nextEvent;
    protected RingBuffer<RingItem> ringBufferIn;
    protected int inputRingItemCount;
    protected RingBuffer<RingItem>[] ringBuffersOut;
    protected int outputRingItemCount;
    protected int outputModuleInternalRingCount;
    protected SequenceBarrier[] sequenceBarriers;
    protected Sequence[] sequences;
    protected long[] nextSequences;
    protected long[] availableSequences;
    private long[] lastSequencesReleased;
    private long[] maxSequences;
    private int[] betweens;
    protected int[] outputChannelFill;
    protected int totalRingCapacity;

    public DataChannelAdapter(String name, DataTransport transport, Map<String, String> attributeMap, boolean input, Emu emu, EmuModule module, int outputIndex) {
        this.emu = emu;
        this.name = name;
        this.input = input;
        this.module = module;
        this.outputIndex = outputIndex;
        this.dataTransport = transport;
        this.logger = emu.getLogger();
        this.id = 0;
        String attribString = attributeMap.get("id");
        if (attribString != null) {
            try {
                this.id = Integer.parseInt(attribString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.ignoreDataErrors = false;
        attribString = attributeMap.get("ignoreErrors");
        if (attribString != null && (attribString.equalsIgnoreCase("true") || attribString.equalsIgnoreCase("on") || attribString.equalsIgnoreCase("yes"))) {
            this.ignoreDataErrors = true;
        }
        this.logger.info("      DataChannel Adapter: ignore data errors = " + this.ignoreDataErrors);
        this.isFifo = this instanceof DataChannelImplFifo;
        this.logger.info("      DataChannel Adapter: channel " + name + " is a fifo = " + this.isFifo);
        if (input) {
            this.inputRingItemCount = 4096;
            attribString = attributeMap.get("ringSize");
            if (attribString != null) {
                try {
                    int ringSize = EmuUtilities.powerOfTwo(Integer.parseInt(attribString), true);
                    if (ringSize < 128) {
                        ringSize = 128;
                    }
                    this.inputRingItemCount = ringSize;
                }
                catch (NumberFormatException ringSize) {
                    // empty catch block
                }
            }
            this.logger.info("      DataChannel Adapter: input ring item count -> " + this.inputRingItemCount);
            this.setupInputRingBuffers();
        } else {
            this.outputModuleInternalRingCount = module.getInternalRingCount();
            this.outputRingItemCount = this.outputModuleInternalRingCount / module.getEventProducingThreadCount();
            if (this.outputRingItemCount < 1) {
                this.outputRingItemCount = 128;
            }
            if (emu.getCodaClass().isEventRecorder()) {
                this.outputRingItemCount = 4096;
            }
            this.outputRingItemCount = EmuUtilities.powerOfTwo(this.outputRingItemCount, false);
            if (this.isFifo) {
                this.logger.info("      DataChannel Adapter: fifo output ring item count -> " + this.outputRingItemCount);
            } else {
                this.logger.info("      DataChannel Adapter: output ring item count -> " + this.outputRingItemCount);
            }
            this.prescale = 1;
            attribString = attributeMap.get("prescale");
            if (attribString != null) {
                try {
                    int val = Integer.parseInt(attribString);
                    if (val < 1) {
                        val = 1;
                    }
                    this.prescale = val;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.logger.info("      DataChannel Adapter: output prescale -> " + this.prescale);
            }
            this.singleEventOut = false;
            attribString = attributeMap.get("single");
            if (attribString != null && (attribString.equalsIgnoreCase("true") || attribString.equalsIgnoreCase("on") || attribString.equalsIgnoreCase("yes"))) {
                this.singleEventOut = true;
            }
            this.byteOrder = module.getOutputOrder();
            this.logger.info("      DataChannel Adapter: byte order = " + this.byteOrder);
            this.outputRingCount = module.getEventProducingThreadCount();
            if (this.isFifo) {
                this.logger.info("      DataChannel Adapter: fifo output ring count (1/buildthread) = " + this.outputRingCount);
            } else {
                this.logger.info("      DataChannel Adapter: output ring count (1/buildthread) = " + this.outputRingCount);
            }
            this.ringBuffersOut = new RingBuffer[this.outputRingCount];
            this.setupOutputRingBuffers();
            this.totalRingCapacity = this.outputRingCount * this.outputRingItemCount;
            this.lastSequencesReleased = new long[this.outputRingCount];
            this.maxSequences = new long[this.outputRingCount];
            this.betweens = new int[this.outputRingCount];
            Arrays.fill(this.lastSequencesReleased, -1L);
            Arrays.fill(this.maxSequences, -1L);
            Arrays.fill(this.betweens, 0);
        }
    }

    void setupOutputRingBuffers() {
        this.sequenceBarriers = new SequenceBarrier[this.outputRingCount];
        this.sequences = new Sequence[this.outputRingCount];
        this.nextSequences = new long[this.outputRingCount];
        this.availableSequences = new long[this.outputRingCount];
        Arrays.fill(this.availableSequences, -1L);
        for (int i = 0; i < this.outputRingCount; ++i) {
            this.ringBuffersOut[i] = RingBuffer.createSingleProducer((EventFactory)new RingItemFactory(), (int)this.outputRingItemCount, (WaitStrategy)new SpinCountBackoffWaitStrategy(30000, (WaitStrategy)new LiteBlockingWaitStrategy()));
            this.sequenceBarriers[i] = this.ringBuffersOut[i].newBarrier(new Sequence[0]);
            this.sequenceBarriers[i].clearAlert();
            this.sequences[i] = new Sequence(-1L);
            this.ringBuffersOut[i].addGatingSequences(new Sequence[]{this.sequences[i]});
            this.nextSequences[i] = this.sequences[i].get() + 1L;
        }
    }

    void setupInputRingBuffers() {
        if (this.isFifo) {
            this.inputRingItemCount = this.outputModuleInternalRingCount;
            this.inputRingItemCount = EmuUtilities.powerOfTwo(this.inputRingItemCount, true);
            this.logger.info("      DataChannel Adapter: setupInputRingBuffers, fifo, input ring item count = " + this.inputRingItemCount);
        }
        this.ringBufferIn = RingBuffer.createSingleProducer((EventFactory)new RingItemFactory(), (int)this.inputRingItemCount, (WaitStrategy)new SpinCountBackoffWaitStrategy(30000, (WaitStrategy)new LiteBlockingWaitStrategy()));
    }

    @Override
    public void prestart() throws CmdExecException {
        if (this.input) {
            return;
        }
        this.outputChannelCount = this.module.getOutputChannels().size();
        this.nextEvent = this.outputIndex;
        this.ringIndex = (int)(this.nextEvent % (long)this.outputRingCount);
    }

    protected int setNextEventAndRing() {
        this.nextEvent += (long)this.outputChannelCount;
        this.ringIndex = (int)(this.nextEvent % (long)this.outputRingCount);
        return this.ringIndex;
    }

    @Override
    public abstract TransportType getTransportType();

    @Override
    public EmuModule getModule() {
        return this.module;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getRecordId() {
        return this.recordId;
    }

    @Override
    public void setRecordId(int recordId) {
        this.recordId = recordId;
    }

    @Override
    public CODAStateIF state() {
        return this.channelState;
    }

    @Override
    public String getError() {
        return this.errorMsg.get();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isInput() {
        return this.input;
    }

    @Override
    public DataTransport getDataTransport() {
        return this.dataTransport;
    }

    @Override
    public int getOutputRingCount() {
        return this.outputRingCount;
    }

    @Override
    public RingBuffer<RingItem> getRingBufferIn() {
        return this.ringBufferIn;
    }

    @Override
    public RingBuffer<RingItem>[] getRingBuffersOut() {
        return this.ringBuffersOut;
    }

    @Override
    public void registerEndCallback(EmuEventNotify callback) {
        this.endCallback = callback;
    }

    @Override
    public EmuEventNotify getEndCallback() {
        return this.endCallback;
    }

    @Override
    public void registerPrestartCallback(EmuEventNotify callback) {
        this.prestartCallback = callback;
    }

    @Override
    public EmuEventNotify getPrestartCallback() {
        return this.prestartCallback;
    }

    public long getNextSequence(int ringIndex) {
        if (ringIndex < 0) {
            return -1L;
        }
        return this.nextSequences[ringIndex];
    }

    @Override
    public int getInputLevel() {
        return 0;
    }

    @Override
    public int getOutputLevel() {
        int count = 0;
        for (int i = 0; i < this.outputRingCount; ++i) {
            count += (int)(this.ringBuffersOut[i].getCursor() - this.nextSequences[i] + 1L);
        }
        return count * 100 / this.totalRingCapacity;
    }

    @Override
    public void setDestinationIpList(String[] ipList) {
        this.ipAddrList = ipList;
    }

    @Override
    public void setDestinationBaList(String[] baList) {
        this.bAddrList = baList;
    }

    @Override
    public int getPrescale() {
        return this.prescale;
    }

    @Override
    public void regulateOutputBufferRate(int eventsPerBuffer, double buffersPerSec) {
        this.buffersPerSec = buffersPerSec;
        this.eventsPerBuffer = eventsPerBuffer;
        this.nanoSecPerBuf = (long)(1.0E9 / buffersPerSec);
        this.regulateBufferRate = true;
    }

    protected RingItem getNextOutputRingItem(int ringIndex) throws InterruptedException, EmuException {
        RingItem item = null;
        try {
            if (this.availableSequences[ringIndex] < this.nextSequences[ringIndex]) {
                this.availableSequences[ringIndex] = this.sequenceBarriers[ringIndex].waitFor(this.nextSequences[ringIndex]);
            }
            item = (RingItem)this.ringBuffersOut[ringIndex].get(this.nextSequences[ringIndex]);
        }
        catch (TimeoutException timeoutException) {
        }
        catch (AlertException ex) {
            this.emu.setErrorState("Channel Adapter: ring buf alert");
            this.channelState = CODAState.ERROR;
            throw new EmuException("Channel Adapter: ring buf alert");
        }
        return item;
    }

    protected void releaseCurrentAndGoToNextOutputRingItem(int ringIndex) {
        this.sequences[ringIndex].set(this.nextSequences[ringIndex]);
        int n = ringIndex;
        this.nextSequences[n] = this.nextSequences[n] + 1L;
    }

    protected void releaseOutputRingItem(int ringIndex) {
        this.sequences[ringIndex].set(this.nextSequences[ringIndex] - 1L);
    }

    protected void gotoNextRingItem(int ringIndex) {
        int n = ringIndex;
        this.nextSequences[n] = this.nextSequences[n] + 1L;
    }

    protected synchronized void sequentialReleaseOutputRingItem(byte[] ringIndexes, long[] seqs, int len) {
        for (int i = 0; i < len; ++i) {
            long seq = seqs[i];
            byte ringIndex = ringIndexes[i];
            if (seq > this.maxSequences[ringIndex]) {
                if (this.maxSequences[ringIndex] > this.lastSequencesReleased[ringIndex]) {
                    byte by = ringIndex;
                    this.betweens[by] = this.betweens[by] + 1;
                }
                this.maxSequences[ringIndex] = seq;
            } else if (seq > this.lastSequencesReleased[ringIndex]) {
                byte by = ringIndex;
                this.betweens[by] = this.betweens[by] + 1;
            }
            if (this.maxSequences[ringIndex] - this.lastSequencesReleased[ringIndex] - 1L != (long)this.betweens[ringIndex]) continue;
            this.sequences[ringIndex].set(this.maxSequences[ringIndex]);
            this.lastSequencesReleased[ringIndex] = this.maxSequences[ringIndex];
            this.betweens[ringIndex] = 0;
        }
    }

    protected static enum ThreadState {
        RUNNING,
        DONE,
        INTERRUPTED;

    }
}

