/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.messaging;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.support.codaComponent.CODAClass;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.logger.LoggerAppender;
import org.jlab.coda.emu.support.logger.LoggingEvent;
import org.jlab.coda.emu.support.messaging.MvalReportingHandler;
import org.jlab.coda.emu.support.messaging.RcCommandHandler;

public class CMSGPortal
implements LoggerAppender {
    final Emu emu;
    private cMsg rcServer;
    private String rcUDL;
    private cMsg server;
    private String UDL;
    private cMsg rocServer;
    private String rocUDL;
    private String platformHost;
    private int platformPort;
    private Logger logger;
    private cMsgMessage errorMessage;

    public CMSGPortal(Emu emu) throws EmuException {
        String rcAddress;
        this.emu = emu;
        this.rcUDL = System.getProperty("cmsgUDL");
        if (this.rcUDL == null) {
            this.rcUDL = "cMsg:rc://multicast/" + emu.getExpid();
        }
        if ((rcAddress = System.getProperty("rcAddr")) != null) {
            System.out.println("Emu: rc server must use address = " + rcAddress);
            this.rcUDL = this.rcUDL + "?ip=" + rcAddress;
        }
        System.out.println("Emu: CMSGPortal using rc UDL = " + this.rcUDL);
        this.logger = emu.getLogger();
        this.logger.addAppender(this);
        this.errorMessage = new cMsgMessage();
        try {
            this.errorMessage.setHistoryLengthMax(0);
            this.errorMessage.setSubject(emu.name());
            this.errorMessage.setType("rc/report/dalog");
            cMsgPayloadItem item = new cMsgPayloadItem("EXPID", emu.getExpid());
            this.errorMessage.addPayloadItem(item);
            item = new cMsgPayloadItem("codaid", emu.getCodaid());
            this.errorMessage.addPayloadItem(item);
            item = new cMsgPayloadItem("hostName", emu.getHostName());
            this.errorMessage.addPayloadItem(item);
            String userName = System.getProperty("user.name");
            if (userName != null) {
                item = new cMsgPayloadItem("userName", userName);
                this.errorMessage.addPayloadItem(item);
            }
            item = new cMsgPayloadItem("session", emu.getSession());
            this.errorMessage.addPayloadItem(item);
            item = new cMsgPayloadItem("codaClass", emu.getCodaClass().toString());
            this.errorMessage.addPayloadItem(item);
        }
        catch (cMsgException item) {
            // empty catch block
        }
        try {
            this.rcServer = new cMsg(this.rcUDL, emu.name(), "EMU called " + this.emu.name());
            this.rcServer.connect();
            this.rcServer.start();
            RcCommandHandler handler = new RcCommandHandler(this);
            this.rcServer.subscribe(emu.name(), "run/transition/*", (cMsgCallbackInterface)handler, null);
            this.rcServer.subscribe(emu.name(), "run/control/*", (cMsgCallbackInterface)handler, null);
            this.rcServer.subscribe(emu.name(), "session/control/*", (cMsgCallbackInterface)handler, null);
            this.rcServer.subscribe(emu.name(), "coda/info/*", (cMsgCallbackInterface)handler, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.warn("Emu: exit due to rc/cMsg connect error: " + e.getMessage());
            System.exit(-1);
        }
    }

    public synchronized void cMsgServerConnect() throws EmuException {
        MvalReportingHandler mHandler = new MvalReportingHandler(this);
        String[] addrs = this.emu.getPlatformIpAddresses();
        if (addrs == null) {
            throw new EmuException("Did not receive platform's IP addresses");
        }
        if (this.platformPort == 0) {
            this.platformPort = this.emu.getPlatformTcpPort();
        }
        if (this.platformHost == null) {
            this.platformHost = addrs[0];
        }
        if (this.emu.getCodaClass() == CODAClass.SEB || this.emu.getCodaClass() == CODAClass.PEB || this.emu.getCodaClass() == CODAClass.PEBER || this.emu.getCodaClass() == CODAClass.SEBER) {
            boolean foundServer = false;
            if (this.server == null) {
                for (String ip : addrs) {
                    this.UDL = "cMsg://" + ip + ':' + this.platformPort + "/cMsg/M?cmsgpassword=" + this.emu.getExpid();
                    try {
                        this.server = new cMsg(this.UDL, this.emu.name() + "_emu", "EmuInternal");
                        this.server.connect();
                    }
                    catch (cMsgException e) {
                        continue;
                    }
                    foundServer = true;
                    this.platformHost = ip;
                    break;
                }
                if (!foundServer) {
                    throw new EmuException("Cannot connect to platform's cMsg domain server");
                }
                try {
                    this.server.start();
                    this.server.subscribe(this.emu.name(), "*", (cMsgCallbackInterface)mHandler, null);
                    this.rocUDL = "cMsg://" + this.platformHost + ':' + this.platformPort + "/cMsg/" + this.emu.getExpid() + "?cmsgpassword=" + this.emu.getExpid();
                    this.rocServer = new cMsg(this.rocUDL, this.emu.name() + "_toRoc", "EmuToRoc");
                    this.rocServer.connect();
                }
                catch (cMsgException e) {
                    try {
                        this.server.disconnect();
                    }
                    catch (cMsgException cMsgException2) {
                        // empty catch block
                    }
                    this.server = null;
                    throw new EmuException("Cannot connect to platform's cMsg domain server", e);
                }
            }
        } else if (this.emu.getCodaClass() == CODAClass.ROC || this.emu.getCodaClass() == CODAClass.TS) {
            boolean foundServer = false;
            if (this.server == null) {
                for (String ip : addrs) {
                    this.UDL = "cMsg://" + ip + ':' + this.platformPort + "/cMsg/RocSync?cmsgpassword=" + this.emu.getExpid();
                    try {
                        this.server = new cMsg(this.UDL, this.emu.name() + "_emu", "RocSync");
                        this.server.connect();
                        this.server.start();
                    }
                    catch (cMsgException e) {
                        continue;
                    }
                    foundServer = true;
                    this.platformHost = ip;
                    break;
                }
                if (!foundServer) {
                    throw new EmuException("Cannot synchronize ROCs");
                }
            }
        }
    }

    public synchronized void shutdown() throws cMsgException {
        this.logger.removeAppender(this);
        if (this.rcServer != null) {
            try {
                this.rcServer.disconnect();
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        this.rcServer = null;
        if (this.server != null) {
            try {
                this.server.disconnect();
            }
            catch (cMsgException cMsgException3) {
                // empty catch block
            }
        }
        this.server = null;
        if (this.rocServer != null) {
            try {
                this.rocServer.disconnect();
            }
            catch (cMsgException cMsgException4) {
                // empty catch block
            }
        }
        this.rocServer = null;
    }

    public String getPlatformHost() {
        return this.platformHost;
    }

    public int getPlatformPort() {
        return this.platformPort;
    }

    public cMsg getRcServer() {
        return this.rcServer;
    }

    public cMsg getCmsgServer() {
        return this.server;
    }

    public String getRcUDL() {
        return this.rcUDL;
    }

    public synchronized void sendMHandlerMessage(int val, String type) {
        if (this.server != null && this.server.isConnected()) {
            try {
                cMsgMessage msg = new cMsgMessage();
                msg.setSubject(this.emu.name());
                msg.setType(type);
                msg.setUserInt(val);
                if (this.server != null) {
                    this.server.send(msg);
                }
            }
            catch (cMsgException e) {
                try {
                    if (this.server.isConnected()) {
                        this.server.disconnect();
                    }
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
                this.server = null;
            }
        }
    }

    public synchronized void sendRocMessage(int lowM, int highM, int highSafeM) {
        if (this.rocServer != null && this.rocServer.isConnected()) {
            try {
                cMsgMessage msg = new cMsgMessage();
                msg.setHistoryLengthMax(0);
                msg.setSubject(this.emu.name());
                msg.setType("eventsPerBuffer");
                msg.setUserInt(highSafeM);
                cMsgPayloadItem lowItem = new cMsgPayloadItem("lowM", lowM);
                cMsgPayloadItem highItem = new cMsgPayloadItem("highM", highM);
                msg.addPayloadItem(lowItem);
                msg.addPayloadItem(highItem);
                if (this.rocServer != null) {
                    this.rocServer.send(msg);
                }
            }
            catch (cMsgException e) {
                try {
                    if (this.rocServer.isConnected()) {
                        this.rocServer.disconnect();
                    }
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
                this.rocServer = null;
            }
        }
    }

    private void updateAndSendLoggingMessage(String errorMsg, int errorLevel, String severityString) {
        if (errorMsg == null) {
            return;
        }
        if (this.rcServer == null || !this.rcServer.isConnected()) {
            return;
        }
        try {
            cMsgPayloadItem item = new cMsgPayloadItem("runNumber", this.emu.getRunNumber());
            this.errorMessage.addPayloadItem(item);
            item = new cMsgPayloadItem("state", this.emu.state().name());
            this.errorMessage.addPayloadItem(item);
            String runType = this.emu.getRunType();
            if (runType != null) {
                item = new cMsgPayloadItem("config", runType);
                this.errorMessage.addPayloadItem(item);
                item = new cMsgPayloadItem("runType", this.emu.getRunTypeId());
                this.errorMessage.addPayloadItem(item);
            }
            this.errorMessage.setText(errorMsg);
            if (errorLevel < 1 || errorLevel > 16) {
                errorLevel = 2;
            }
            if (severityString != null && severityString.length() > 0) {
                item = new cMsgPayloadItem("severity", severityString);
                this.errorMessage.addPayloadItem(item);
            }
            this.errorMessage.setUserInt(errorLevel);
        }
        catch (cMsgException item) {
            // empty catch block
        }
        try {
            this.rcServer.send(this.errorMessage);
        }
        catch (cMsgException e) {
            try {
                if (this.rcServer.isConnected()) {
                    this.rcServer.disconnect();
                }
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
            this.rcServer = null;
        }
    }

    @Override
    public synchronized void append(LoggingEvent event) {
        if (event == null) {
            return;
        }
        String severity = null;
        Object obj = event.getData();
        if (obj instanceof String) {
            severity = (String)obj;
        }
        this.updateAndSendLoggingMessage(event.getMessage(), event.getLevel(), severity);
    }

    public synchronized void rcGuiInfoMessage(String text) {
        this.updateAndSendLoggingMessage(text, 15, "INFO");
    }

    public synchronized void rcGuiWarningMessage(String text) {
        this.updateAndSendLoggingMessage(text, 9, "WARNING");
    }

    public synchronized void rcGuiErrorMessage(String text) {
        this.updateAndSendLoggingMessage(text, 11, "ERROR");
    }

    public synchronized void rcGuiSevereMessage(String text) {
        this.updateAndSendLoggingMessage(text, 13, "SEVERE ERROR");
    }
}

