/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.logger;

import java.io.PrintWriter;
import org.jlab.coda.emu.support.logger.LoggerAppender;
import org.jlab.coda.emu.support.logger.LoggingEvent;

public class PrintAppender
implements LoggerAppender {
    private final PrintWriter out;

    public PrintAppender(PrintWriter outp) {
        this.out = outp;
    }

    private static String formatLocation(StackTraceElement ste) {
        if (ste == null) {
            return "";
        }
        return ste.getClassName() + '.' + ste.getMethodName() + '(' + ste.getFileName() + ':' + ste.getLineNumber() + ')';
    }

    @Override
    public void append(LoggingEvent event) {
        String data = "";
        if (event.hasData()) {
            data = " [" + event.getFormatedData() + ']';
        }
        this.out.println(event.getMessage() + data + "\t  " + PrintAppender.formatLocation(event.getLocation()));
        if (event.getThrowable() != null) {
            event.getThrowable().printStackTrace(this.out);
        }
    }
}

