/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.logger;

public class LoggingEvent {
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 8;
    public static final int ERROR = 11;
    public static final int CODA_WARN = 9;
    public static final int SEVERE = 13;
    public static final int RC_GUI_CONSOLE = 15;
    private int level;
    private String message;
    private StackTraceElement location;
    private boolean hasData = false;
    private Object data;
    private Throwable throwable;
    private final long eventTime = System.currentTimeMillis();

    private LoggingEvent() {
    }

    public LoggingEvent(int level, String message, StackTraceElement location, Throwable throwable) {
        this();
        this.level = level;
        this.message = message;
        this.location = location;
        this.throwable = throwable;
    }

    public LoggingEvent(int level, String message, StackTraceElement location, Throwable throwable, Object data) {
        this(level, message, location, throwable);
        this.setData(data);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
        this.hasData = true;
    }

    public boolean hasData() {
        return this.hasData;
    }

    public String getFormatedData() {
        if (this.hasData()) {
            if (this.data == null) {
                return "{null}";
            }
            return this.data.toString();
        }
        return "";
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public int getLevel() {
        return this.level;
    }

    public StackTraceElement getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getFormatedLevel() {
        switch (this.level) {
            case 13: {
                return "SEVERE";
            }
            case 11: {
                return "ERROR";
            }
            case 8: {
                return "WARN";
            }
            case 2: {
                return "INFO";
            }
            case 1: {
                return "DEBUG";
            }
            case 15: {
                if (this.hasData) {
                    return (String)this.data;
                }
                return "NO_LEVEL";
            }
            case 9: {
                if (this.hasData) {
                    return (String)this.data;
                }
                return "ERROR_LITE";
            }
        }
        return "UNKNOWN";
    }
}

