/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioNode;

abstract class RingItemAdapter
implements RingItem {
    protected EvioEvent event;
    protected ByteBuffer buffer;
    protected EvioNode node;
    protected EventType eventType;
    protected ControlType controlType;
    protected boolean isUser;
    protected boolean isFirst;
    protected int sourceId;
    protected boolean matchesId = true;
    protected String sourceName;
    protected int recordId;
    protected int eventCount;
    protected long firstEventNumber;
    protected boolean switchRing;
    protected boolean isSync;
    protected boolean hasError;
    protected boolean reserved;
    protected boolean nonFatalBuildingError;
    protected Object attachment;
    protected ByteBufferSupply byteBufferSupply;
    protected ByteBufferItem byteBufferItem;

    public RingItemAdapter() {
    }

    public RingItemAdapter(RingItem ringItem) {
        this.copy(ringItem);
    }

    @Override
    public void copy(RingItem ringItem) {
        this.event = ringItem.getEvent();
        this.buffer = ringItem.getBuffer();
        this.node = ringItem.getNode();
        this.eventType = ringItem.getEventType();
        this.controlType = ringItem.getControlType();
        this.isUser = ringItem.isUser();
        this.isFirst = ringItem.isFirstEvent();
        this.sourceId = ringItem.getSourceId();
        this.matchesId = ringItem.matchesId();
        this.sourceName = ringItem.getSourceName();
        this.recordId = ringItem.getRecordId();
        this.eventCount = ringItem.getEventCount();
        this.firstEventNumber = ringItem.getFirstEventNumber();
        this.switchRing = ringItem.getSwitchRing();
        this.isSync = ringItem.isSync();
        this.hasError = ringItem.hasError();
        this.nonFatalBuildingError = ringItem.hasNonFatalBuildingError();
        this.attachment = ringItem.getAttachment();
        this.byteBufferItem = ringItem.getByteBufferItem();
        this.byteBufferSupply = ringItem.getByteBufferSupply();
    }

    @Override
    public abstract ByteOrder getByteOrder();

    @Override
    public abstract int getTotalBytes();

    @Override
    public void setAll(EvioEvent ev, ByteBuffer buf, EvioNode nd, EventType eType, ControlType cType, boolean user, boolean first, int chanId, int rId, int sId, int evCount, String sName, ByteBufferItem bbItem, ByteBufferSupply bbSupply) {
        this.event = ev;
        this.buffer = buf;
        this.node = nd;
        this.eventType = eType;
        this.controlType = cType;
        this.isUser = user;
        this.isFirst = first;
        this.recordId = rId;
        this.sourceId = sId;
        this.matchesId = sId == chanId;
        this.sourceName = sName;
        this.firstEventNumber = 1L;
        this.switchRing = false;
        this.isSync = false;
        this.hasError = false;
        this.nonFatalBuildingError = false;
        this.attachment = null;
        this.byteBufferItem = bbItem;
        this.byteBufferSupply = bbSupply;
        this.eventCount = evCount;
    }

    @Override
    public EvioEvent getEvent() {
        return this.event;
    }

    @Override
    public void setEvent(EvioEvent event) {
        this.event = event;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public EvioNode getNode() {
        return this.node;
    }

    @Override
    public void setNode(EvioNode node) {
        this.node = node;
    }

    @Override
    public void releaseByteBuffer() {
        if (this.byteBufferSupply == null) {
            return;
        }
        this.byteBufferSupply.release(this.byteBufferItem);
        this.byteBufferSupply = null;
        this.byteBufferItem = null;
    }

    @Override
    public void setReusableByteBuffer(ByteBufferSupply byteBufferSupply, ByteBufferItem byteBufferItem) {
        this.byteBufferItem = byteBufferItem;
        this.byteBufferSupply = byteBufferSupply;
    }

    @Override
    public ByteBufferSupply getByteBufferSupply() {
        return this.byteBufferSupply;
    }

    @Override
    public ByteBufferItem getByteBufferItem() {
        return this.byteBufferItem;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public boolean isControlEvent() {
        return this.controlType != null;
    }

    @Override
    public ControlType getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(ControlType type) {
        this.controlType = type;
    }

    @Override
    public boolean isUser() {
        return this.isUser;
    }

    public void isUser(boolean isUser) {
        this.isUser = isUser;
    }

    @Override
    public boolean isFirstEvent() {
        return this.isFirst;
    }

    @Override
    public void isFirstEvent(boolean isFirst) {
        this.isFirst = isFirst;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public void setEventType(EventType type) {
        this.eventType = type;
    }

    @Override
    public int getSourceId() {
        return this.sourceId;
    }

    @Override
    public void setSourceId(int sourceId) {
        this.sourceId = sourceId;
    }

    @Override
    public boolean matchesId() {
        return this.matchesId;
    }

    @Override
    public void matchesId(boolean matchesId) {
        this.matchesId = matchesId;
    }

    @Override
    public int getRecordId() {
        return this.recordId;
    }

    @Override
    public void setRecordId(int recordId) {
        this.recordId = recordId;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    @Override
    public long getFirstEventNumber() {
        return this.firstEventNumber;
    }

    @Override
    public void setFirstEventNumber(long firstEventNumber) {
        this.firstEventNumber = firstEventNumber;
    }

    @Override
    public boolean getSwitchRing() {
        return this.switchRing;
    }

    @Override
    public void setSwitchRing(boolean switchRing) {
        this.switchRing = switchRing;
    }

    @Override
    public boolean isSync() {
        return this.isSync;
    }

    @Override
    public void setSync(boolean sync) {
        this.isSync = sync;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public void setError(boolean hasError) {
        this.hasError = hasError;
    }

    @Override
    public boolean hasNonFatalBuildingError() {
        return this.nonFatalBuildingError;
    }

    @Override
    public void setNonFatalBuildingError(boolean nonFatalBuildingError) {
        this.nonFatalBuildingError = nonFatalBuildingError;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }
}

