/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.support.data.CODATag;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.PayloadBuffer;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.CompactEventBuilder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.Utilities;

public class Evio {
    private static final int ID_BIT_MASK = 4095;
    private static final int STATUS_BIT_MASK = 61440;
    private static final int SYNC_BIT_MASK = 4096;
    private static final int ERROR_BIT_MASK = 8192;
    private static final int ENDIAN_BIT_MASK = 16384;
    private static final int SINGLE_EVENT_MODE_BIT_MASK = 32768;

    private Evio() {
    }

    public static int createCodaTag(boolean sync, boolean error, boolean isBigEndian, boolean singleEventMode, int id) {
        int status = 0;
        if (sync) {
            status |= 0x1000;
        }
        if (error) {
            status |= 0x2000;
        }
        if (isBigEndian) {
            status |= 0x4000;
        }
        if (singleEventMode) {
            status |= 0x8000;
        }
        return status | id & 0xFFF;
    }

    public static int createCodaTag(int status, int id) {
        return status << 12 | id & 0xFFF;
    }

    public static int getTagCodaId(int codaTag) {
        return 0xFFF & codaTag;
    }

    public static boolean isTagSingleEventMode(int codaTag) {
        return (codaTag & 0x8000) != 0;
    }

    public static boolean isTagSyncEvent(int codaTag) {
        return (codaTag & 0x1000) != 0;
    }

    public static boolean isTagBigEndian(int codaTag) {
        return (codaTag & 0x4000) != 0;
    }

    public static int setTagEndian(int codaTag, boolean isBigEndian) {
        if (isBigEndian) {
            return codaTag | 0x4000;
        }
        return codaTag & 0xFFFFBFFF;
    }

    public static boolean tagHasError(int codaTag) {
        return (codaTag & 0x2000) != 0;
    }

    public static int getTagStatus(int codaTag) {
        return codaTag >>> 12;
    }

    public static int getTagStatus(EvioBank bank) {
        if (bank == null) {
            return -1;
        }
        return Evio.getTagStatus(bank.getHeader().getTag());
    }

    public static boolean isSyncEvent(EvioNode node) {
        if (node == null) {
            return false;
        }
        return node.getTag() == ControlType.SYNC.getValue() && node.getNum() == 0 && node.getDataType() == 1 && node.getLength() == 4;
    }

    public static boolean isUserEvent(EvioBank bank) {
        return bank != null && bank.getHeader().getNumber() == 0;
    }

    public static boolean isUserEvent(EvioNode node) {
        return node != null && node.getNum() == 0;
    }

    public static boolean isRawTriggerBank(EvioNode node) {
        return node != null && CODATag.isRawTrigger(node.getTag());
    }

    public static boolean isBuiltTriggerBank(EvioNode node) {
        return node != null && CODATag.isBuiltTrigger(node.getTag());
    }

    public static void checkPayload(PayloadBuffer pBuf, DataChannel channel) throws EmuException {
        int recordId = pBuf.getRecordId();
        int sourceId = pBuf.getSourceId();
        EvioNode node = pBuf.getNode();
        boolean nonFatalError = false;
        boolean nonFatalRecordIdError = false;
        EventType eventType = pBuf.getEventType();
        if (eventType == null || !eventType.isEbFriendly()) {
            System.out.println("checkPayload: unknown type, dump payload buffer");
            return;
        }
        if (eventType.isAnyPhysics() || eventType.isROCRaw()) {
            if (recordId != channel.getRecordId() && recordId != channel.getRecordId() + 1) {
                System.out.println("checkPayload: record ID out of sequence, got " + recordId + ", expecting " + channel.getRecordId() + " or " + (channel.getRecordId() + 1) + ", type = " + (Object)((Object)eventType) + ", name = " + channel.name());
                nonFatalRecordIdError = true;
            }
            channel.setRecordId(recordId);
            int tag = node.getTag();
            if (sourceId != Evio.getTagCodaId(tag)) {
                System.out.println("checkPayload: buf source Id (" + sourceId + ") != buf's id from tag (" + Evio.getTagCodaId(tag) + ')');
                nonFatalError = true;
            }
            if (node.getDataTypeObj() != DataType.BANK && node.getDataTypeObj() != DataType.ALSOBANK) {
                throw new EmuException("ROC raw / physics record not in proper format");
            }
            pBuf.setSync(Evio.isTagSyncEvent(tag));
            pBuf.setError(Evio.tagHasError(tag));
        }
        if (!pBuf.matchesId()) {
            System.out.println("checkPayload: buf source id = " + pBuf.getSourceId() + " != input channel id = " + channel.getID());
            nonFatalError = true;
        }
        pBuf.setNonFatalBuildingError(nonFatalError || nonFatalRecordIdError);
    }

    public static void checkInput(PayloadBuffer pBuf, DataChannel channel, EventType eventType, EvioNode inputNode, boolean recordIdError) {
        int sourceId = pBuf.getSourceId();
        boolean nonFatalError = false;
        if (eventType != null && eventType.isBuildable()) {
            int tag = inputNode.getTag();
            if (sourceId != Evio.getTagCodaId(tag)) {
                System.out.println("checkInput: buf source Id (" + sourceId + ") != buf's id from tag (" + Evio.getTagCodaId(tag) + ')');
                nonFatalError = true;
            }
            pBuf.setSync(Evio.isTagSyncEvent(tag));
            pBuf.setError(Evio.tagHasError(tag));
        }
        if (!pBuf.matchesId()) {
            System.out.println("checkInput: buf source id = " + sourceId + " != input channel id = " + channel.getID());
            nonFatalError = true;
        }
        pBuf.setNonFatalBuildingError(nonFatalError || recordIdError);
    }

    public static int checkRecordIdSequence(int recordId, int expectedRecordId, boolean print, EventType eventType, DataChannel channel) {
        if (eventType.isBuildable()) {
            if (recordId != expectedRecordId) {
                if (print) {
                    System.out.println("checkRecordIdSequence: record ID out of sequence, got " + recordId + ", expecting " + expectedRecordId + ", type = " + (Object)((Object)eventType) + ", name = " + channel.name());
                }
                return recordId + 1;
            }
            return expectedRecordId + 1;
        }
        return expectedRecordId;
    }

    public static boolean checkInputType(int recordId, DataChannel channel, EventType eventType, EvioNode inputNode) throws EmuException {
        if (eventType == null || !eventType.isEbFriendly()) {
            throw new EmuException("unknown event type");
        }
        boolean nonFatalRecordIdError = false;
        if (eventType.isBuildable()) {
            int chanRecordId = channel.getRecordId();
            if (recordId != chanRecordId && recordId != chanRecordId + 1) {
                System.out.println("checkInputType: record ID out of sequence, got " + recordId + ", expecting " + chanRecordId + " or " + (chanRecordId + 1) + ", type = " + (Object)((Object)eventType) + ", name = " + channel.name());
                nonFatalRecordIdError = true;
            }
            channel.setRecordId(recordId);
            if (!inputNode.getDataTypeObj().isBank()) {
                DataType eventDataType = inputNode.getDataTypeObj();
                throw new EmuException("ROC raw / physics record contains " + eventDataType + " instead of banks (data corruption?)");
            }
        }
        return nonFatalRecordIdError;
    }

    public static boolean checkConsistency(PayloadBuffer[] buildingBanks, long eventNumber, int entangledCount) throws EmuException {
        boolean nonFatalError = false;
        int syncBankCount = 0;
        int physicsEventCount = 0;
        int numEvents = buildingBanks[0].getNode().getNum();
        for (int i = 0; i < buildingBanks.length; ++i) {
            if (buildingBanks[i].isSync()) {
                ++syncBankCount;
            }
            if (buildingBanks[i].getEventType().isAnyPhysics()) {
                ++physicsEventCount;
            }
            for (int j = i + 1; j < buildingBanks.length; ++j) {
                if (buildingBanks[i].getSourceId() != buildingBanks[j].getSourceId()) continue;
                nonFatalError = true;
                System.out.println("  EB mod: events have duplicate source ids");
            }
            if (numEvents == buildingBanks[i].getNode().getNum()) continue;
            System.out.println("Differing # of events sent by each ROC:\n");
            System.out.println("numEvents       name      codaID");
            for (PayloadBuffer bank : buildingBanks) {
                System.out.println("   " + bank.getNode().getNum() + "        " + bank.getSourceName() + "        " + bank.getSourceId());
            }
            throw new EmuException("differing # of events sent by each ROC");
        }
        int numBanks = buildingBanks.length;
        if (syncBankCount > 0 && syncBankCount != numBanks) {
            System.out.print("  EB mod: these channels have NO sync at event " + (eventNumber + (long)entangledCount - 1L) + ": ");
            for (PayloadBuffer buildingBank : buildingBanks) {
                if (buildingBank.isSync()) continue;
                System.out.print(buildingBank.getSourceName() + ", ");
            }
            System.out.println();
            nonFatalError = true;
        }
        if (physicsEventCount > 0 && physicsEventCount != numBanks) {
            throw new EmuException("not all events are physics or not all are ROC raw");
        }
        return nonFatalError;
    }

    public static void gotConsistentControlEvents(PayloadBuffer[] buildingBanks, int runNumber, int runType) throws EmuException {
        boolean debug = false;
        ControlType firstControlType = buildingBanks[0].getControlType();
        for (PayloadBuffer buf : buildingBanks) {
            if (buf.getControlType() == firstControlType) continue;
            throw new EmuException("different type control events on each channel");
        }
        if (firstControlType == ControlType.PRESTART) {
            for (PayloadBuffer buf : buildingBanks) {
                IntBuffer prestartData = buf.getNode().getByteData(false).asIntBuffer();
                if (prestartData.remaining() < 1) {
                    throw new EmuException("PRESTART event does not have data");
                }
                int runN = prestartData.get(1);
                int runT = prestartData.get(2);
                if (runN != runNumber) {
                    if (debug) {
                        System.out.println("gotValidControlEvents: warning, PRESTART event bad run #, " + runN + ", should be " + runNumber);
                    }
                    throw new EmuException("PRESTART event bad run # = " + runN + ", should be " + runNumber);
                }
                if (runT == runType) continue;
                if (debug) {
                    System.out.println("gotValidControlEvents: warning, PRESTART event bad run type, " + runT + ", should be " + runType);
                }
                throw new EmuException("PRESTART event bad run type = " + runT + ", should be " + runType);
            }
        }
        if (debug) {
            System.out.println("gotValidControlEvents: found control event of type " + firstControlType.name());
        }
    }

    public static EvioEvent createControlEvent(ControlType type, int runNumber, int runType, int eventsInRun, int eventsSinceSync, boolean error) {
        try {
            EventBuilder eventBuilder;
            int[] data;
            int time = (int)(System.currentTimeMillis() / 1000L);
            switch (type) {
                case SYNC: {
                    data = new int[]{time, eventsSinceSync, eventsInRun};
                    eventBuilder = new EventBuilder(type.getValue(), DataType.UINT32, 0);
                    break;
                }
                case PRESTART: {
                    data = new int[]{time, runNumber, runType};
                    eventBuilder = new EventBuilder(type.getValue(), DataType.UINT32, 0);
                    break;
                }
                default: {
                    data = error ? new int[]{time, -1, eventsInRun} : new int[]{time, 0, eventsInRun};
                    eventBuilder = new EventBuilder(type.getValue(), DataType.UINT32, 0);
                }
            }
            EvioEvent ev = eventBuilder.getEvent();
            eventBuilder.appendIntData((BaseStructure)ev, data);
            return ev;
        }
        catch (EvioException evioException) {
            return null;
        }
    }

    public static PayloadBuffer createControlBuffer(ControlType type, int runNumber, int runType, int eventsInRun, int eventsSinceSync, ByteOrder order, boolean error) {
        try {
            int[] data;
            CompactEventBuilder builder = new CompactEventBuilder(20, order);
            int time = (int)(System.currentTimeMillis() / 1000L);
            switch (type) {
                case SYNC: {
                    data = new int[]{time, eventsSinceSync, eventsInRun};
                    break;
                }
                case PRESTART: {
                    data = new int[]{time, runNumber, runType};
                    break;
                }
                default: {
                    data = error ? new int[]{time, -1, eventsInRun} : new int[]{time, 0, eventsInRun};
                }
            }
            builder.openBank(type.getValue(), 0, DataType.UINT32);
            builder.addIntData(data);
            builder.closeStructure();
            PayloadBuffer pBuf = new PayloadBuffer(builder.getBuffer());
            pBuf.setEventType(EventType.CONTROL);
            pBuf.setControlType(type);
            pBuf.setEventCount(1);
            return pBuf;
        }
        catch (EvioException evioException) {
            return null;
        }
    }

    public static boolean makeTriggerBankFromPhysicsOrig(PayloadBuffer[] inputPayloadBanks, CompactEventBuilder builder, int ebId, int runNumber, int runType, boolean includeRunData, boolean sparsify, boolean checkTimestamps, int timestampSlop) throws EmuException {
        int triggerTag;
        long[] longData;
        if (builder == null || inputPayloadBanks == null || inputPayloadBanks.length < 1) {
            throw new EmuException("arguments are null or zero-length");
        }
        int totalRocCount = 0;
        int numInputBanks = inputPayloadBanks.length;
        EvioNode[] triggerBanks = new EvioNode[numInputBanks];
        boolean nonFatalError = false;
        boolean allHaveRunData = true;
        boolean haveTimestamps = true;
        boolean haveTrigWithNoRocSpecificData = false;
        int numEvents = inputPayloadBanks[0].getNode().getNum();
        boolean firstTrigTimestamped = false;
        for (int i = 0; i < numInputBanks; ++i) {
            inputPayloadBanks[i].setEventCount(numEvents);
            triggerBanks[i] = inputPayloadBanks[i].getNode().getChildAt(0);
            CODATag tag = CODATag.getTagType(triggerBanks[i].getTag());
            if (!Evio.isBuiltTriggerBank(triggerBanks[i])) {
                throw new EmuException("No built trigger bank in physics event");
            }
            if (i == 0) {
                firstTrigTimestamped = tag.hasTimestamp();
            }
            int rocCount = triggerBanks[i].getNum();
            totalRocCount += rocCount;
            allHaveRunData = allHaveRunData && tag.hasRunData();
            boolean isTimestamped = tag.hasTimestamp();
            boolean bl = haveTimestamps = haveTimestamps && isTimestamped;
            if (firstTrigTimestamped != isTimestamped) {
                throw new EmuException("If 1 trigger bank has timestamps, all must");
            }
            if (tag.hasRocSpecificData()) {
                if (triggerBanks[i].getChildCount() == rocCount + 2) continue;
                throw new EmuException("Trigger bank does not have correct # of segments (" + (rocCount + 2) + "), it has " + triggerBanks[i].getChildCount());
            }
            haveTrigWithNoRocSpecificData = true;
            if (triggerBanks[i].getChildCount() == 2) continue;
            throw new EmuException("Trigger bank does not have correct # of segments (2), it has " + triggerBanks[i].getChildCount());
        }
        if (checkTimestamps && !haveTimestamps) {
            nonFatalError = true;
            checkTimestamps = false;
        }
        if (sparsify) {
            if (haveTimestamps) {
                sparsify = false;
            }
        } else if (haveTrigWithNoRocSpecificData) {
            sparsify = true;
        }
        EvioNode eventTypeSeg = triggerBanks[0].getChildAt(1);
        short[] shortCommonData = eventTypeSeg.getShortData();
        long[] longCommonData = triggerBanks[0].getChildAt(0).getLongData();
        long firstEventNumber = longCommonData[0];
        long[] timestampsAvg = null;
        long[] timestampsMax = null;
        long[] timestampsMin = null;
        if (checkTimestamps) {
            timestampsAvg = new long[numEvents];
            timestampsMax = new long[numEvents];
            timestampsMin = new long[numEvents];
            Arrays.fill(timestampsMin, Long.MAX_VALUE);
        }
        for (int i = 0; i < numInputBanks; ++i) {
            long[] commonLong;
            int j;
            if (i > 0) {
                short[] commonShort = triggerBanks[i].getChildAt(1).getShortData();
                if (shortCommonData.length != commonShort.length) {
                    throw new EmuException("Trying to merge records with different numbers of events");
                }
                for (j = 0; j < shortCommonData.length; ++j) {
                    if (shortCommonData[j] == commonShort[j]) continue;
                    throw new EmuException("Trying to merge records with different event types");
                }
                commonLong = triggerBanks[i].getChildAt(0).getLongData();
                if (firstEventNumber != commonLong[0]) {
                    throw new EmuException("Trying to merge records with different event numbers");
                }
                if (allHaveRunData && longCommonData.length == 2 + numEvents && commonLong.length == 2 + numEvents && longCommonData[1 + numEvents] != commonLong[1 + numEvents]) {
                    throw new EmuException("Trying to merge records with different run numbers and/or types");
                }
            } else {
                commonLong = longCommonData;
            }
            if (!checkTimestamps) continue;
            if (commonLong.length < numEvents + 1) {
                nonFatalError = true;
                checkTimestamps = false;
                System.out.println("Timestamp data is missing!");
                continue;
            }
            for (j = 0; j < numEvents; ++j) {
                long ts = commonLong[j + 1];
                int n = j;
                timestampsAvg[n] = timestampsAvg[n] + ts;
                timestampsMax[j] = ts > timestampsMax[j] ? ts : timestampsMax[j];
                timestampsMin[j] = ts < timestampsMin[j] ? ts : timestampsMin[j];
            }
        }
        if (checkTimestamps) {
            for (int j = 0; j < numEvents; ++j) {
                int n = j;
                timestampsAvg[n] = timestampsAvg[n] / (long)numInputBanks;
                if (timestampsMax[j] - timestampsMin[j] > 0L) {
                    // empty if block
                }
                if (timestampsMax[j] - timestampsMin[j] <= (long)timestampSlop) continue;
                nonFatalError = true;
                System.out.println("Timestamp NOT consistent: ev #" + (firstEventNumber + (long)j) + ", diff = " + (timestampsMax[j] - timestampsMin[j]) + ", allowed = " + timestampSlop);
            }
        }
        if (!checkTimestamps) {
            if (includeRunData) {
                longData = new long[]{firstEventNumber, (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL};
                triggerTag = sparsify ? CODATag.BUILT_TRIGGER_RUN_NRSD.getValue() : CODATag.BUILT_TRIGGER_RUN.getValue();
            } else {
                longData = new long[]{firstEventNumber};
                triggerTag = sparsify ? CODATag.BUILT_TRIGGER_NRSD.getValue() : CODATag.BUILT_TRIGGER_BANK.getValue();
            }
        } else if (includeRunData) {
            longData = new long[2 + numEvents];
            longData[0] = firstEventNumber;
            System.arraycopy(timestampsAvg, 0, longData, 1, numEvents);
            longData[numEvents + 1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
            triggerTag = CODATag.BUILT_TRIGGER_TS_RUN.getValue();
        } else {
            longData = new long[1 + numEvents];
            longData[0] = firstEventNumber;
            System.arraycopy(timestampsAvg, 0, longData, 1, numEvents);
            triggerTag = CODATag.BUILT_TRIGGER_TS.getValue();
        }
        try {
            builder.openBank(triggerTag, totalRocCount, DataType.SEGMENT);
            eventTypeSeg.updateTag(ebId);
            builder.openSegment(ebId, DataType.ULONG64);
            builder.addLongData(longData);
            builder.closeStructure();
            builder.addEvioNode(eventTypeSeg);
            if (!sparsify) {
                for (EvioNode trBank : triggerBanks) {
                    for (int j = 2; j < trBank.getChildCount(); ++j) {
                        builder.addEvioNode(trBank.getChildAt(j));
                    }
                }
            }
            builder.closeStructure();
        }
        catch (EvioException evioException) {
            // empty catch block
        }
        return nonFatalError;
    }

    public static boolean makeTriggerBankFromPhysics(PayloadBuffer[] inputPayloadBanks, CompactEventBuilder builder, int ebId, int runNumber, int runType, boolean includeRunData, boolean sparsify, boolean checkTimestamps, int timestampSlop) throws EmuException {
        long[] commonLong;
        int triggerTag;
        long[] longData;
        if (builder == null || inputPayloadBanks == null || inputPayloadBanks.length < 1) {
            throw new EmuException("arguments are null or zero-length");
        }
        int totalRocCount = 0;
        int numInputBanks = inputPayloadBanks.length;
        EvioNode[] triggerBanks = new EvioNode[numInputBanks];
        boolean nonFatalError = false;
        boolean allHaveRunData = true;
        boolean haveTimestamps = true;
        boolean haveTrigWithNoRocSpecificData = false;
        boolean firstTrigTimestamped = false;
        EvioNode eventTypesSeg = null;
        long firstEventNumber = 0L;
        long[] longCommonData = null;
        short[] eventTypesRoc1 = null;
        int numEvents = inputPayloadBanks[0].getNode().getNum();
        for (int i = 0; i < numInputBanks; ++i) {
            inputPayloadBanks[i].setEventCount(numEvents);
            EvioNode triggerBank = triggerBanks[i] = inputPayloadBanks[i].getNode().getChildAt(0);
            CODATag tag = CODATag.getTagType(triggerBank.getTag());
            if (tag == null || !Evio.isBuiltTriggerBank(triggerBank)) {
                throw new EmuException("No built trigger bank or bad tag in physics event");
            }
            if (i == 0) {
                eventTypesSeg = triggerBanks[0].getChildAt(1);
                eventTypesRoc1 = eventTypesSeg.getShortData();
                longCommonData = triggerBanks[0].getChildAt(0).getLongData();
                firstEventNumber = longCommonData[0];
                firstTrigTimestamped = tag.hasTimestamp();
            } else {
                short[] eventTypes = triggerBank.getChildAt(1).getShortData();
                if (eventTypesRoc1.length != eventTypes.length) {
                    throw new EmuException("Trying to merge records with different numbers of events");
                }
                for (int j = 0; j < eventTypesRoc1.length; ++j) {
                    if (eventTypesRoc1[j] == eventTypes[j]) continue;
                    throw new EmuException("Trying to merge records with different event types");
                }
            }
            int rocCount = triggerBank.getNum();
            totalRocCount += rocCount;
            allHaveRunData = allHaveRunData && tag.hasRunData();
            boolean isTimestamped = tag.hasTimestamp();
            boolean bl = haveTimestamps = haveTimestamps && isTimestamped;
            if (firstTrigTimestamped != isTimestamped) {
                throw new EmuException("If 1 trigger bank has timestamps, all must");
            }
            if (tag.hasRocSpecificData()) {
                if (triggerBank.getChildCount() == rocCount + 2) continue;
                throw new EmuException("Trigger bank does not have correct # of segments (" + (rocCount + 2) + "), it has " + triggerBank.getChildCount());
            }
            haveTrigWithNoRocSpecificData = true;
            if (triggerBank.getChildCount() == 2) continue;
            throw new EmuException("Trigger bank does not have correct # of segments (2), it has " + triggerBank.getChildCount());
        }
        if (checkTimestamps && !haveTimestamps) {
            nonFatalError = true;
            checkTimestamps = false;
        }
        if (sparsify) {
            if (haveTimestamps) {
                sparsify = false;
            }
        } else if (haveTrigWithNoRocSpecificData) {
            sparsify = true;
        }
        if (!checkTimestamps) {
            if (includeRunData) {
                longData = new long[]{firstEventNumber, (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL};
                triggerTag = sparsify ? CODATag.BUILT_TRIGGER_RUN_NRSD.getValue() : CODATag.BUILT_TRIGGER_RUN.getValue();
            } else {
                longData = new long[]{firstEventNumber};
                triggerTag = sparsify ? CODATag.BUILT_TRIGGER_NRSD.getValue() : CODATag.BUILT_TRIGGER_BANK.getValue();
            }
        } else if (includeRunData) {
            longData = new long[2 + numEvents];
            longData[0] = firstEventNumber;
            longData[numEvents + 1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
            triggerTag = CODATag.BUILT_TRIGGER_TS_RUN.getValue();
        } else {
            longData = new long[1 + numEvents];
            longData[0] = firstEventNumber;
            triggerTag = CODATag.BUILT_TRIGGER_TS.getValue();
        }
        long[] timestampsMax = null;
        long[] timestampsMin = null;
        if (checkTimestamps) {
            timestampsMax = new long[numEvents];
            timestampsMin = new long[numEvents];
            Arrays.fill(timestampsMin, Long.MAX_VALUE);
        }
        for (int i = 0; i < numInputBanks; ++i) {
            if (i > 0) {
                commonLong = triggerBanks[i].getChildAt(0).getLongData();
                if (firstEventNumber != commonLong[0]) {
                    throw new EmuException("Trying to merge records with different event numbers: 1st bank = " + firstEventNumber + ", bank from chan " + i + " = " + commonLong[0]);
                }
                if (allHaveRunData && longCommonData.length == 2 + numEvents && commonLong.length == 2 + numEvents && longCommonData[1 + numEvents] != commonLong[1 + numEvents]) {
                    throw new EmuException("Trying to merge records with different run numbers and/or types");
                }
            } else {
                commonLong = longCommonData;
            }
            if (!checkTimestamps) continue;
            if (commonLong.length < numEvents + 1) {
                nonFatalError = true;
                checkTimestamps = false;
                System.out.println("Timestamp data is missing!");
                continue;
            }
            for (int j = 0; j < numEvents; ++j) {
                long ts = commonLong[j + 1];
                int n = j + 1;
                longData[n] = longData[n] + ts;
                if (ts > timestampsMax[j]) {
                    timestampsMax[j] = ts;
                }
                if (ts >= timestampsMin[j]) continue;
                timestampsMin[j] = ts;
            }
        }
        if (checkTimestamps) {
            for (int j = 0; j < numEvents; ++j) {
                if (timestampsMax[j] - timestampsMin[j] > (long)timestampSlop) {
                    nonFatalError = true;
                    if (j == 0) {
                        System.out.println("Timestamp NOT consistent, first ev : ev #" + (firstEventNumber + (long)j) + ", diff = " + (timestampsMax[j] - timestampsMin[j]) + ", allowed = " + timestampSlop + ", TS sum over inputs = 0x" + Long.toHexString(longData[j + 1]) + ", TS avg = 0x" + Long.toHexString(longData[j + 1] / (long)numInputBanks));
                        System.out.print("Timestamps for first ev : ");
                        for (int i = 0; i < numInputBanks; ++i) {
                            commonLong = triggerBanks[i].getChildAt(0).getLongData();
                            System.out.print("0x" + Long.toHexString(commonLong[1]) + ",  ");
                        }
                        System.out.println("");
                    }
                }
                int n = j + 1;
                longData[n] = longData[n] / (long)numInputBanks;
            }
        }
        try {
            builder.openBank(triggerTag, totalRocCount, DataType.SEGMENT);
            eventTypesSeg.updateTag(ebId);
            builder.openSegment(ebId, DataType.ULONG64);
            builder.addLongData(longData);
            builder.closeStructure();
            if (longData[0] != firstEventNumber) {
                System.out.println("ERROR !!!!!!!!!!!!!!!!!!!, longData[0] = " + longData[0] + ", firstEventNumber = " + firstEventNumber);
            }
            builder.addEvioNode(eventTypesSeg);
            if (!sparsify) {
                for (EvioNode trBank : triggerBanks) {
                    for (int j = 2; j < trBank.getChildCount(); ++j) {
                        builder.addEvioNode(trBank.getChildAt(j));
                    }
                }
            }
            builder.closeStructure();
        }
        catch (EvioException evioException) {
            // empty catch block
        }
        return nonFatalError;
    }

    public static boolean makeTriggerBankFromPhysics(PayloadBuffer[] inputPayloadBanks, EvioNode[] rocNodes, EvioNode[] triggerBanks, ByteBuffer[] inputBuffers, ByteBuffer evBuf, int ebId, int runNumber, int runType, boolean includeRunData, boolean sparsify, boolean checkTimestamps, boolean fastCopyReady, int timestampSlop, int[] returnLen, long[] longData, long[] commonLong, long[] firstInputCommonLong, long[] timestampsMin, long[] timestampsMax, short[] eventTypes, short[] eventTypesRoc1) throws EmuException {
        int triggerTag;
        int longDataLen;
        int totalRocCount = 0;
        int validLongs = 0;
        int validShorts = 0;
        int validShortsRoc1 = 0;
        int numInputBanks = inputPayloadBanks.length;
        boolean nonFatalError = false;
        boolean allHaveRunData = true;
        boolean haveTimestamps = true;
        boolean haveTrigWithNoRocSpecificData = false;
        boolean firstTrigTimestamped = false;
        EvioNode eventTypesSeg = null;
        long firstEventNumber = 0L;
        int numEvents = rocNodes[0].getNum();
        for (int i = 0; i < numInputBanks; ++i) {
            inputPayloadBanks[i].setEventCount(numEvents);
            EvioNode triggerBank = triggerBanks[i];
            CODATag tag = CODATag.getTagType(triggerBank.getTag());
            if (tag == null || !Evio.isBuiltTriggerBank(triggerBank)) {
                throw new EmuException("No built trigger bank or bad tag in physics event");
            }
            if (i == 0) {
                eventTypesSeg = triggerBanks[0].getChildAt(1);
                eventTypesRoc1 = eventTypesSeg.getShortData(eventTypesRoc1, returnLen);
                validShortsRoc1 = returnLen[0];
                firstInputCommonLong = triggerBanks[0].getChildAt(0).getLongData(firstInputCommonLong, returnLen);
                validLongs = returnLen[0];
                firstEventNumber = firstInputCommonLong[0];
                firstTrigTimestamped = tag.hasTimestamp();
            } else {
                eventTypes = triggerBank.getChildAt(1).getShortData(eventTypes, returnLen);
                validShorts = returnLen[0];
                if (validShortsRoc1 != validShorts) {
                    throw new EmuException("Trying to merge records with different numbers of events");
                }
                for (int j = 0; j < validShortsRoc1; ++j) {
                    if (eventTypesRoc1[j] == eventTypes[j]) continue;
                    throw new EmuException("Trying to merge records with different event types");
                }
            }
            int rocCount = triggerBank.getNum();
            totalRocCount += rocCount;
            allHaveRunData = allHaveRunData && tag.hasRunData();
            boolean isTimestamped = tag.hasTimestamp();
            boolean bl = haveTimestamps = haveTimestamps && isTimestamped;
            if (firstTrigTimestamped != isTimestamped) {
                throw new EmuException("If 1 trigger bank has timestamps, all must");
            }
            if (tag.hasRocSpecificData()) {
                if (triggerBank.getChildCount() == rocCount + 2) continue;
                throw new EmuException("Trigger bank does not have correct # of segments (" + (rocCount + 2) + "), it has " + triggerBank.getChildCount());
            }
            haveTrigWithNoRocSpecificData = true;
            if (triggerBank.getChildCount() == 2) continue;
            throw new EmuException("Trigger bank does not have correct # of segments (2), it has " + triggerBank.getChildCount());
        }
        if (checkTimestamps && !haveTimestamps) {
            nonFatalError = true;
            checkTimestamps = false;
        }
        if (sparsify) {
            if (haveTimestamps) {
                sparsify = false;
            }
        } else if (haveTrigWithNoRocSpecificData) {
            sparsify = true;
        }
        if (!checkTimestamps) {
            if (includeRunData) {
                longData[0] = firstEventNumber;
                longData[1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
                longDataLen = 2;
                triggerTag = sparsify ? CODATag.BUILT_TRIGGER_RUN_NRSD.getValue() : CODATag.BUILT_TRIGGER_RUN.getValue();
            } else {
                longData[0] = firstEventNumber;
                longDataLen = 1;
                triggerTag = sparsify ? CODATag.BUILT_TRIGGER_NRSD.getValue() : CODATag.BUILT_TRIGGER_BANK.getValue();
            }
        } else if (includeRunData) {
            longData[0] = firstEventNumber;
            longData[numEvents + 1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
            longDataLen = numEvents + 2;
            triggerTag = CODATag.BUILT_TRIGGER_TS_RUN.getValue();
        } else {
            longData[0] = firstEventNumber;
            longDataLen = numEvents + 1;
            triggerTag = CODATag.BUILT_TRIGGER_TS.getValue();
        }
        for (int i = 0; i < numInputBanks; ++i) {
            long[] longArray;
            if (i > 0) {
                longArray = triggerBanks[i].getChildAt(0).getLongData(commonLong, returnLen);
                int len = returnLen[0];
                if (firstEventNumber != commonLong[0]) {
                    throw new EmuException("Trying to merge records with different event numbers: 1st bank = " + firstEventNumber + ", bank from chan " + i + " = " + commonLong[0]);
                }
                if (allHaveRunData && validLongs == 2 + numEvents && len == 2 + numEvents && firstInputCommonLong[1 + numEvents] != commonLong[1 + numEvents]) {
                    throw new EmuException("Trying to merge records with different run numbers and/or types");
                }
            } else {
                longArray = firstInputCommonLong;
            }
            if (!checkTimestamps) continue;
            if (validLongs < numEvents + 1) {
                nonFatalError = true;
                checkTimestamps = false;
                System.out.println("Timestamp data is missing!");
                continue;
            }
            for (int j = 0; j < numEvents; ++j) {
                long ts = longArray[j + 1];
                int n = j + 1;
                longData[n] = longData[n] + ts;
                timestampsMax[j] = ts >= timestampsMax[j] ? ts : timestampsMax[j];
                timestampsMin[j] = ts <= timestampsMin[j] ? ts : timestampsMin[j];
            }
        }
        if (checkTimestamps) {
            for (int j = 0; j < numEvents; ++j) {
                int n = j + 1;
                longData[n] = longData[n] / (long)numInputBanks;
                if (timestampsMax[j] - timestampsMin[j] <= (long)timestampSlop) continue;
                nonFatalError = true;
                System.out.println("Timestamp NOT consistent: ev #" + (firstEventNumber + (long)j) + ", diff = " + (timestampsMax[j] - timestampsMin[j]) + ", allowed = " + timestampSlop);
            }
        }
        int writeIndex = 12;
        int headerWord = triggerTag << 16 | (DataType.SEGMENT.getValue() & 0x3F) << 8 | totalRocCount & 0xFF;
        evBuf.putInt(writeIndex, headerWord);
        headerWord = ebId << 24 | (DataType.ULONG64.getValue() & 0x3F) << 16 | 2 * longDataLen & 0xFFFF;
        evBuf.putInt(writeIndex += 4, headerWord);
        writeIndex += 4;
        for (int i = 0; i < longDataLen; ++i) {
            evBuf.putLong(writeIndex, longData[i]);
            writeIndex += 8;
        }
        int padding = eventTypesSeg.getPad();
        headerWord = ebId << 24 | padding << 22 | (DataType.USHORT16.getValue() & 0x3F) << 16 | eventTypesSeg.getLength() & 0xFFFF;
        evBuf.putInt(writeIndex, headerWord);
        writeIndex += 4;
        for (int i = 0; i < numEvents; ++i) {
            evBuf.putShort(writeIndex, eventTypesRoc1[i]);
            writeIndex += 2;
        }
        writeIndex += padding;
        if (!sparsify) {
            for (int i = 0; i < numInputBanks; ++i) {
                EvioNode trigBank = triggerBanks[i];
                ByteBuffer inputBuffer = inputBuffers[i];
                for (int j = 2; j < trigBank.getChildCount(); ++j) {
                    int segBytes;
                    EvioNode trigSeg = trigBank.getChildAt(j);
                    if (fastCopyReady) {
                        segBytes = trigSeg.getTotalBytes();
                        System.arraycopy(inputBuffer.array(), trigSeg.getPosition(), evBuf.array(), writeIndex, segBytes);
                    } else {
                        headerWord = trigSeg.getTag() << 24 | (trigSeg.getType() & 0x3F) << 16 | trigSeg.getLength() & 0xFFFF;
                        evBuf.putInt(writeIndex, headerWord);
                        writeIndex += 4;
                        segBytes = 4 * trigSeg.getDataLength();
                        int srcPos = trigSeg.getDataPosition();
                        ByteBuffer duplicateBuf = inputBuffer.duplicate();
                        duplicateBuf.limit(srcPos + segBytes).position(srcPos);
                        evBuf.position(writeIndex);
                        evBuf.put(duplicateBuf);
                        evBuf.position(0);
                    }
                    writeIndex += segBytes;
                }
            }
        }
        evBuf.putInt(8, writeIndex / 4 - 3);
        returnLen[0] = writeIndex;
        return nonFatalError;
    }

    public static boolean makeTriggerBankFromRocRaw(PayloadBuffer[] inputPayloadBanks, ByteBuffer builtEventBuf, int ebId, long firstEventNumber, int runNumber, int runType, boolean includeRunData, boolean sparsify, boolean checkTimestamps, int timestampSlop, int buildThreadOrder, long[] longData, short[] evData, int[] segmentData, int[] returnLen, int[] rocOffset, ByteBuffer[] rocRecord, EvioNode[] rocNodes, boolean fastCopyReady) throws EmuException {
        CODATag trigTag;
        int longDataLen;
        EvioNode trigBank;
        boolean turnOffChecks = false;
        int firstTrigTag = 0;
        int rocTrigBankCount = 0;
        int numROCs = inputPayloadBanks.length;
        int numEvents = inputPayloadBanks[0].getNode().getNum();
        boolean haveMiscData = false;
        boolean nonFatalError = false;
        boolean fatalError = false;
        boolean firstTagFound = false;
        if (turnOffChecks) {
            checkTimestamps = false;
        }
        for (int i = 0; i < numROCs; ++i) {
            EvioNode rocNode = rocNodes[i];
            trigBank = rocNode.getChildAt(0);
            if (trigBank == null) {
                fatalError = true;
                continue;
            }
            int tag = trigBank.getTag() & 0xFF1F;
            if (!CODATag.isRawTrigger(tag)) {
                fatalError = true;
                continue;
            }
            ++rocTrigBankCount;
            if (!firstTagFound) {
                firstTrigTag = tag;
                firstTagFound = true;
            }
            inputPayloadBanks[i].setEventCount(numEvents);
            if (turnOffChecks) continue;
            if (numEvents != trigBank.getNum()) {
                fatalError = true;
                continue;
            }
            if (numEvents != rocNode.getNum()) {
                fatalError = true;
                continue;
            }
            if (trigBank.getChildCount() != numEvents) {
                fatalError = true;
                continue;
            }
            if (tag == firstTrigTag) continue;
            fatalError = true;
        }
        if (fatalError && rocTrigBankCount == 0) {
            throw new EmuException("No trigger bank found in any ROC");
        }
        boolean haveTimestamps = CODATag.hasTimestamp(firstTrigTag);
        if (checkTimestamps && !haveTimestamps) {
            nonFatalError = true;
            checkTimestamps = false;
        }
        if (!checkTimestamps) {
            if (includeRunData) {
                longData[0] = firstEventNumber;
                longData[1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
                longDataLen = 2;
                trigTag = CODATag.BUILT_TRIGGER_RUN;
            } else {
                longData[0] = firstEventNumber;
                longDataLen = 1;
                trigTag = CODATag.BUILT_TRIGGER_BANK;
            }
        } else if (includeRunData) {
            longData[0] = firstEventNumber;
            longData[numEvents + 1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
            longDataLen = numEvents + 2;
            trigTag = CODATag.BUILT_TRIGGER_TS_RUN;
        } else {
            longData[0] = firstEventNumber;
            longDataLen = numEvents + 1;
            trigTag = CODATag.BUILT_TRIGGER_TS;
        }
        int[] triggerData = null;
        int firstEvNum = (int)firstEventNumber;
        for (int i = 0; i < numEvents; ++i) {
            long ts;
            EvioNode triggerSegment;
            int j;
            long timestampsMax = 0L;
            long timestampsMin = Long.MAX_VALUE;
            int evNum = firstEvNum + i;
            int numRocsWithTSs = numROCs;
            boolean haveTypeInfo = false;
            for (j = 0; j < numROCs; ++j) {
                trigBank = rocNodes[j].getChildAt(0);
                if (trigBank == null) {
                    --numRocsWithTSs;
                    fatalError = true;
                    continue;
                }
                triggerSegment = trigBank.getChildAt(i);
                if (triggerSegment == null) {
                    --numRocsWithTSs;
                    fatalError = true;
                    continue;
                }
                if (!haveTypeInfo) {
                    evData[i] = (short)triggerSegment.getTag();
                    haveTypeInfo = true;
                }
                if (!turnOffChecks) {
                    if (evData[i] != (short)triggerSegment.getTag()) {
                        System.out.println("makeTriggerBankFromRocRaw: event type differs across ROCs, first has " + evData[i] + " #" + j + " ROC has " + (short)triggerSegment.getTag());
                        nonFatalError = true;
                    }
                    if (evNum != (triggerData = triggerSegment.getIntData(segmentData, returnLen))[0]) {
                        nonFatalError = true;
                    }
                    if (!haveMiscData && !haveTimestamps && returnLen[0] > 1) {
                        haveMiscData = true;
                    }
                }
                if (!checkTimestamps || returnLen[0] <= 2) continue;
                ts = (0xFFFFL & (long)triggerData[2]) << 32 | 0xFFFFFFFFL & (long)triggerData[1];
                int n = i + 1;
                longData[n] = longData[n] + ts;
                timestampsMax = ts >= timestampsMax ? ts : timestampsMax;
                timestampsMin = ts <= timestampsMin ? ts : timestampsMin;
            }
            if (!checkTimestamps || fatalError) continue;
            int n = i + 1;
            longData[n] = longData[n] / (long)numRocsWithTSs;
            if (timestampsMax - timestampsMin <= (long)timestampSlop) continue;
            nonFatalError = true;
            System.out.println("Timestamp NOT consistent: ev #" + (firstEvNum + i) + ", diff = " + (timestampsMax - timestampsMin) + ", allowed = " + timestampSlop);
            for (j = 0; j < numROCs; ++j) {
                trigBank = rocNodes[j].getChildAt(0);
                if (trigBank == null || (triggerSegment = trigBank.getChildAt(i)) == null) continue;
                triggerData = triggerSegment.getIntData(segmentData, returnLen);
                if (returnLen[0] <= 2) continue;
                ts = (0xFFFFL & (long)triggerData[2]) << 32 | 0xFFFFFFFFL & (long)triggerData[1];
                System.out.println("TS = " + ts + " for " + inputPayloadBanks[j].getSourceName());
            }
        }
        boolean bl = sparsify = sparsify && !haveTimestamps && !haveMiscData;
        if (sparsify) {
            trigTag = trigTag.hasRunData() ? CODATag.BUILT_TRIGGER_RUN_NRSD : CODATag.BUILT_TRIGGER_NRSD;
        }
        if (fatalError) {
            trigTag = CODATag.BUILT_TRIGGER_ROC_ERROR;
        }
        int writeIndex = 12;
        boolean trigBankLen = true;
        int headerWord = trigTag.getValue() << 16 | (DataType.SEGMENT.getValue() & 0x3F) << 8 | numROCs & 0xFF;
        builtEventBuf.putInt(writeIndex, headerWord);
        headerWord = ebId << 24 | (DataType.ULONG64.getValue() & 0x3F) << 16 | 2 * longDataLen & 0xFFFF;
        builtEventBuf.putInt(writeIndex += 4, headerWord);
        writeIndex += 4;
        for (int i = 0; i < longDataLen; ++i) {
            builtEventBuf.putLong(writeIndex, longData[i]);
            writeIndex += 8;
        }
        int padding = numEvents % 2 == 0 ? 0 : 2;
        headerWord = ebId << 24 | padding << 22 | (DataType.USHORT16.getValue() & 0x3F) << 16 | (numEvents + 1) / 2 & 0xFFFF;
        builtEventBuf.putInt(writeIndex, headerWord);
        writeIndex += 4;
        for (int i = 0; i < numEvents; ++i) {
            builtEventBuf.putShort(writeIndex, evData[i]);
            writeIndex += 2;
        }
        writeIndex += padding;
        if (!sparsify) {
            int dataWordsFromEachSeg = 0;
            for (int i = 0; i < numROCs; ++i) {
                int bufOffset = rocOffset[i];
                ByteBuffer backingBuf = rocRecord[i];
                int destHeaderPos = writeIndex;
                writeIndex += 4;
                int segTotalBytes = 0;
                int totalSegDataWords = 0;
                for (int j = 0; j < numEvents; ++j) {
                    int srcPos = bufOffset + j * segTotalBytes + 16;
                    int segWords = backingBuf.getInt(srcPos) & 0xFFFF;
                    int dataWords = segWords - 1;
                    totalSegDataWords += dataWords;
                    if (j == 0) {
                        dataWordsFromEachSeg = segWords;
                        segTotalBytes = 4 * (segWords + 1);
                    } else if (segWords != dataWordsFromEachSeg) {
                        System.out.println("makeTriggerBankFromRocRaw: failure for ROC " + i + ", event " + j);
                        System.out.println("                         : segTotalBytes = " + segTotalBytes);
                        System.out.println("                         : bufOffset = " + bufOffset);
                        System.out.println("                         : srcPos = " + srcPos);
                        System.out.println("                         : segWords = " + segWords);
                        System.out.println("                         : segWords from event 0 = " + dataWordsFromEachSeg);
                        Utilities.printBufferBytes((ByteBuffer)backingBuf, (int)bufOffset, (int)140, (String)("Roc " + i));
                        Utilities.printBufferBytes((ByteBuffer)backingBuf, (int)srcPos, (int)20, (String)("Roc " + i + ", bad seg " + j));
                        throw new EmuException("Trigger segments contain different amounts of data");
                    }
                    srcPos += 8;
                    if (fastCopyReady) {
                        int len = 4 * dataWords;
                        System.arraycopy(backingBuf.array(), srcPos, builtEventBuf.array(), writeIndex, len);
                        srcPos += len;
                        writeIndex += len;
                        continue;
                    }
                    for (int k = 0; k < dataWords; ++k) {
                        builtEventBuf.putInt(writeIndex, backingBuf.getInt(srcPos));
                        srcPos += 4;
                        writeIndex += 4;
                    }
                }
                headerWord = inputPayloadBanks[i].getSourceId() << 24 | (DataType.UINT32.getValue() & 0x3F) << 16 | totalSegDataWords & 0xFFFF;
                builtEventBuf.putInt(destHeaderPos, headerWord);
            }
        }
        builtEventBuf.putInt(8, (writeIndex - 8) / 4 - 1);
        returnLen[0] = writeIndex;
        return nonFatalError || fatalError;
    }

    public static boolean makeTriggerBankFromRocRaw(PayloadBuffer[] inputPayloadBanks, CompactEventBuilder builder, int ebId, long firstEventNumber, int runNumber, int runType, boolean includeRunData, boolean sparsify, boolean checkTimestamps, int timestampSlop, int buildThreadOrder) throws EmuException {
        CODATag trigTag;
        long[] longData;
        EvioNode trigBank;
        int numROCs;
        if (builder == null || inputPayloadBanks == null || inputPayloadBanks.length < 1) {
            throw new EmuException("arguments are null or zero-length");
        }
        boolean turnOffChecks = false;
        int firstTrigTag = 0;
        int rocTrigBankCount = 0;
        int numRocsWithTSs = numROCs = inputPayloadBanks.length;
        int numEvents = inputPayloadBanks[0].getNode().getNum();
        boolean haveMiscData = false;
        boolean nonFatalError = false;
        boolean fatalError = false;
        boolean firstTagFound = false;
        if (turnOffChecks) {
            checkTimestamps = false;
        }
        for (int i = 0; i < numROCs; ++i) {
            EvioNode rocNode = inputPayloadBanks[i].getNode();
            trigBank = rocNode.getChildAt(0);
            if (trigBank == null) {
                fatalError = true;
                continue;
            }
            int tag = trigBank.getTag() & 0xFF1F;
            if (!CODATag.isRawTrigger(tag)) {
                fatalError = true;
                continue;
            }
            ++rocTrigBankCount;
            if (!firstTagFound) {
                firstTrigTag = tag;
                firstTagFound = true;
            }
            inputPayloadBanks[i].setEventCount(numEvents);
            if (turnOffChecks) continue;
            if (numEvents != trigBank.getNum()) {
                fatalError = true;
                continue;
            }
            if (numEvents != rocNode.getNum()) {
                fatalError = true;
                continue;
            }
            if (trigBank.getChildCount() != numEvents) {
                fatalError = true;
                continue;
            }
            if (tag == firstTrigTag) continue;
            fatalError = true;
        }
        if (fatalError && rocTrigBankCount == 0) {
            throw new EmuException("No trigger bank found in any ROC");
        }
        boolean haveTimestamps = CODATag.hasTimestamp(firstTrigTag);
        if (checkTimestamps && !haveTimestamps) {
            nonFatalError = true;
            checkTimestamps = false;
        }
        if (!checkTimestamps) {
            if (includeRunData) {
                longData = new long[]{firstEventNumber, (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL};
                trigTag = CODATag.BUILT_TRIGGER_RUN;
            } else {
                longData = new long[]{firstEventNumber};
                trigTag = CODATag.BUILT_TRIGGER_BANK;
            }
        } else if (includeRunData) {
            longData = new long[2 + numEvents];
            longData[0] = firstEventNumber;
            longData[numEvents + 1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
            trigTag = CODATag.BUILT_TRIGGER_TS_RUN;
        } else {
            longData = new long[1 + numEvents];
            longData[0] = firstEventNumber;
            trigTag = CODATag.BUILT_TRIGGER_TS;
        }
        int[] triggerData = null;
        int firstEvNum = (int)firstEventNumber;
        short[] evData = new short[numEvents];
        for (int i = 0; i < numEvents; ++i) {
            long timestampsMax = 0L;
            long timestampsMin = Long.MAX_VALUE;
            int evNum = firstEvNum + i;
            numRocsWithTSs = numROCs;
            boolean haveTypeInfo = false;
            for (int j = 0; j < numROCs; ++j) {
                trigBank = inputPayloadBanks[j].getNode().getChildAt(0);
                if (trigBank == null) {
                    --numRocsWithTSs;
                    fatalError = true;
                    continue;
                }
                EvioNode triggerSegment = trigBank.getChildAt(i);
                if (triggerSegment == null) {
                    --numRocsWithTSs;
                    fatalError = true;
                    continue;
                }
                if (!haveTypeInfo) {
                    evData[i] = (short)triggerSegment.getTag();
                    haveTypeInfo = true;
                }
                if (!turnOffChecks) {
                    if (evData[i] != (short)triggerSegment.getTag()) {
                        System.out.println("makeTriggerBankFromRocRaw: event type differs across ROCs, first has " + evData[i] + " #" + j + " ROC has " + (short)triggerSegment.getTag());
                        nonFatalError = true;
                    }
                    if (evNum != (triggerData = triggerSegment.getIntData())[0]) {
                        System.out.println("makeTriggerBankFromRocRaw: event # differs (in Bt# " + buildThreadOrder + ") for ROC id#" + Evio.getTagCodaId(inputPayloadBanks[j].getNode().getTag()) + ", expected " + evNum + " got " + triggerData[0] + " (0x" + Integer.toHexString(triggerData[0]) + ')');
                        nonFatalError = true;
                    }
                    if (!haveMiscData && !haveTimestamps && triggerData.length > 1) {
                        haveMiscData = true;
                    }
                }
                if (!checkTimestamps || triggerData.length <= 2) continue;
                long ts = (0xFFFFL & (long)triggerData[2]) << 32 | 0xFFFFFFFFL & (long)triggerData[1];
                int n = i + 1;
                longData[n] = longData[n] + ts;
                if (ts > timestampsMax) {
                    timestampsMax = ts;
                }
                if (ts >= timestampsMin) continue;
                timestampsMin = ts;
            }
            if (!checkTimestamps) continue;
            int n = i + 1;
            longData[n] = longData[n] / (long)numRocsWithTSs;
            if (timestampsMax - timestampsMin <= (long)timestampSlop) continue;
            nonFatalError = true;
            System.out.println("Timestamp NOT consistent: ev #" + (firstEvNum + i) + ", diff = " + (timestampsMax - timestampsMin) + ", allowed = " + timestampSlop);
            for (PayloadBuffer inputPayloadBank : inputPayloadBanks) {
                Utilities.printBuffer((ByteBuffer)inputPayloadBank.getBuffer(), (int)0, (int)10, (String)("Data from roc " + inputPayloadBanks[i].getSourceName()));
            }
        }
        boolean bl = sparsify = sparsify && !haveTimestamps && !haveMiscData;
        if (sparsify) {
            trigTag = trigTag.hasRunData() ? CODATag.BUILT_TRIGGER_RUN_NRSD : CODATag.BUILT_TRIGGER_NRSD;
        }
        try {
            if (fatalError) {
                trigTag = CODATag.BUILT_TRIGGER_ROC_ERROR;
            }
            builder.openBank(trigTag.getValue(), inputPayloadBanks.length, DataType.SEGMENT);
            builder.openSegment(ebId, DataType.ULONG64);
            builder.addLongData(longData);
            builder.closeStructure();
            builder.openSegment(ebId, DataType.USHORT16);
            builder.addShortData(evData);
            builder.closeStructure();
            if (!sparsify) {
                int dataLenFromEachSeg = 0;
                for (PayloadBuffer inputPayloadBank : inputPayloadBanks) {
                    builder.openSegment(inputPayloadBank.getSourceId(), DataType.UINT32);
                    for (int j = 0; j < numEvents; ++j) {
                        int[] oldData = inputPayloadBank.getNode().getChildAt(0).getChildAt(j).getIntData();
                        if (j == 0) {
                            dataLenFromEachSeg = oldData.length;
                        } else if (oldData.length != dataLenFromEachSeg) {
                            throw new EmuException("Trigger segments contain different amounts of data");
                        }
                        builder.addIntData(oldData, 1);
                    }
                    builder.closeStructure();
                }
            }
            builder.closeStructure();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return nonFatalError || fatalError;
    }

    public static boolean makeTriggerBankFromRocRaw(PayloadBuffer[] inputPayloadBanks, CompactEventBuilder builder, int ebId, long firstEventNumber, int runNumber, int runType, boolean includeRunData, boolean sparsify, boolean checkTimestamps, int timestampSlop, int buildThreadOrder, long[] longData, short[] evData, int[] segmentData, int[] returnLen) throws EmuException {
        CODATag trigTag;
        int longDataLen;
        EvioNode trigBank;
        if (builder == null || inputPayloadBanks == null || inputPayloadBanks.length < 1) {
            throw new EmuException("arguments are null or zero-length");
        }
        boolean turnOffChecks = false;
        int firstTrigTag = 0;
        int rocTrigBankCount = 0;
        int numROCs = inputPayloadBanks.length;
        int numEvents = inputPayloadBanks[0].getNode().getNum();
        boolean haveMiscData = false;
        boolean nonFatalError = false;
        boolean fatalError = false;
        boolean firstTagFound = false;
        if (turnOffChecks) {
            checkTimestamps = false;
        }
        for (int i = 0; i < numROCs; ++i) {
            EvioNode rocNode = inputPayloadBanks[i].getNode();
            trigBank = rocNode.getChildAt(0);
            if (trigBank == null) {
                fatalError = true;
                continue;
            }
            int tag = trigBank.getTag() & 0xFF1F;
            if (!CODATag.isRawTrigger(tag)) {
                fatalError = true;
                continue;
            }
            ++rocTrigBankCount;
            if (!firstTagFound) {
                firstTrigTag = tag;
                firstTagFound = true;
            }
            inputPayloadBanks[i].setEventCount(numEvents);
            if (turnOffChecks) continue;
            if (numEvents != trigBank.getNum()) {
                fatalError = true;
                continue;
            }
            if (numEvents != rocNode.getNum()) {
                fatalError = true;
                continue;
            }
            if (trigBank.getChildCount() != numEvents) {
                fatalError = true;
                continue;
            }
            if (tag == firstTrigTag) continue;
            fatalError = true;
        }
        if (fatalError && rocTrigBankCount == 0) {
            throw new EmuException("No trigger bank found in any ROC");
        }
        boolean haveTimestamps = CODATag.hasTimestamp(firstTrigTag);
        if (checkTimestamps && !haveTimestamps) {
            nonFatalError = true;
            checkTimestamps = false;
        }
        if (!checkTimestamps) {
            if (includeRunData) {
                if (longData.length < 2) {
                    longData = new long[]{firstEventNumber, (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL};
                }
                longDataLen = 2;
                trigTag = CODATag.BUILT_TRIGGER_RUN;
            } else {
                if (longData.length < 1) {
                    longData = new long[]{firstEventNumber};
                }
                longDataLen = 1;
                trigTag = CODATag.BUILT_TRIGGER_BANK;
            }
        } else if (includeRunData) {
            if (longData.length < numEvents + 2) {
                longData = new long[numEvents + 2];
            }
            longData[0] = firstEventNumber;
            longData[numEvents + 1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
            longDataLen = numEvents + 2;
            trigTag = CODATag.BUILT_TRIGGER_TS_RUN;
        } else {
            if (longData.length < numEvents + 1) {
                longData = new long[numEvents + 1];
            }
            longData[0] = firstEventNumber;
            longDataLen = numEvents + 1;
            trigTag = CODATag.BUILT_TRIGGER_TS;
        }
        int[] triggerData = null;
        int firstEvNum = (int)firstEventNumber;
        if (evData.length < numEvents) {
            evData = new short[numEvents];
        }
        for (int i = 0; i < numEvents; ++i) {
            long timestampsMax = 0L;
            long timestampsMin = Long.MAX_VALUE;
            int evNum = firstEvNum + i;
            int numRocsWithTSs = numROCs;
            boolean haveTypeInfo = false;
            for (int j = 0; j < numROCs; ++j) {
                trigBank = inputPayloadBanks[j].getNode().getChildAt(0);
                if (trigBank == null) {
                    --numRocsWithTSs;
                    fatalError = true;
                    continue;
                }
                EvioNode triggerSegment = trigBank.getChildAt(i);
                if (triggerSegment == null) {
                    --numRocsWithTSs;
                    fatalError = true;
                    continue;
                }
                if (!haveTypeInfo) {
                    evData[i] = (short)triggerSegment.getTag();
                    haveTypeInfo = true;
                }
                if (!turnOffChecks) {
                    if (evData[i] != (short)triggerSegment.getTag()) {
                        System.out.println("makeTriggerBankFromRocRaw: event type differs across ROCs, first has " + evData[i] + " #" + j + " ROC has " + (short)triggerSegment.getTag());
                        nonFatalError = true;
                    }
                    if (evNum != (triggerData = triggerSegment.getIntData(segmentData, returnLen))[0]) {
                        System.out.println("makeTriggerBankFromRocRaw: event # differs (in Bt# " + buildThreadOrder + ") for ROC id#" + Evio.getTagCodaId(inputPayloadBanks[j].getNode().getTag()) + ", expected " + evNum + " got " + triggerData[0] + " (0x" + Integer.toHexString(triggerData[0]) + ')');
                        nonFatalError = true;
                    }
                    if (!haveMiscData && !haveTimestamps && returnLen[0] > 1) {
                        haveMiscData = true;
                    }
                }
                if (!checkTimestamps || returnLen[0] <= 2) continue;
                long ts = (0xFFFFL & (long)triggerData[2]) << 32 | 0xFFFFFFFFL & (long)triggerData[1];
                int n = i + 1;
                longData[n] = longData[n] + ts;
                if (ts > timestampsMax) {
                    timestampsMax = ts;
                }
                if (ts >= timestampsMin) continue;
                timestampsMin = ts;
            }
            if (!checkTimestamps) continue;
            int n = i + 1;
            longData[n] = longData[n] / (long)numRocsWithTSs;
            if (timestampsMax - timestampsMin <= (long)timestampSlop) continue;
            nonFatalError = true;
            System.out.println("Timestamp NOT consistent: ev #" + evNum + ", diff = " + (timestampsMax - timestampsMin) + ", allowed = " + timestampSlop);
            for (PayloadBuffer inputPayloadBank : inputPayloadBanks) {
                Utilities.printBuffer((ByteBuffer)inputPayloadBank.getBuffer(), (int)0, (int)10, (String)("Data from roc " + inputPayloadBanks[i].getSourceName()));
            }
        }
        boolean bl = sparsify = sparsify && !haveTimestamps && !haveMiscData;
        if (sparsify) {
            trigTag = trigTag.hasRunData() ? CODATag.BUILT_TRIGGER_RUN_NRSD : CODATag.BUILT_TRIGGER_NRSD;
        }
        try {
            if (fatalError) {
                trigTag = CODATag.BUILT_TRIGGER_ROC_ERROR;
            }
            builder.openBank(trigTag.getValue(), inputPayloadBanks.length, DataType.SEGMENT);
            builder.openSegment(ebId, DataType.ULONG64);
            builder.addLongData(longData, 0, longDataLen);
            builder.closeStructure();
            builder.openSegment(ebId, DataType.USHORT16);
            builder.addShortData(evData, 0, numEvents);
            builder.closeStructure();
            if (!sparsify) {
                int dataLenFromEachSeg = 0;
                for (PayloadBuffer inputPayloadBank : inputPayloadBanks) {
                    builder.openSegment(inputPayloadBank.getSourceId(), DataType.UINT32);
                    for (int j = 0; j < numEvents; ++j) {
                        int[] oldData = inputPayloadBank.getNode().getChildAt(0).getChildAt(j).getIntData(segmentData, returnLen);
                        if (j == 0) {
                            dataLenFromEachSeg = returnLen[0];
                        } else if (returnLen[0] != dataLenFromEachSeg) {
                            throw new EmuException("Trigger segments contain different amounts of data");
                        }
                        builder.addIntData(oldData, 1, returnLen[0] - 1);
                    }
                    builder.closeStructure();
                }
            }
            builder.closeStructure();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return nonFatalError || fatalError;
    }

    public static boolean makeTriggerBankFromRocRawOrig(PayloadBuffer[] inputPayloadBanks, CompactEventBuilder builder, int ebId, long firstEventNumber, int runNumber, int runType, boolean includeRunData, boolean sparsify, boolean checkTimestamps, int timestampSlop, int buildThreadOrder) throws EmuException {
        CODATag trigTag;
        long[] longData;
        if (builder == null || inputPayloadBanks == null || inputPayloadBanks.length < 1) {
            throw new EmuException("arguments are null or zero-length");
        }
        boolean turnOffChecks = false;
        int firstTrigTag = 0;
        int numROCs = inputPayloadBanks.length;
        int numEvents = inputPayloadBanks[0].getNode().getNum();
        boolean haveMiscData = false;
        boolean nonFatalError = false;
        if (turnOffChecks) {
            checkTimestamps = false;
        }
        for (int i = 0; i < numROCs; ++i) {
            EvioNode rocNode = inputPayloadBanks[i].getNode();
            EvioNode trigBank = rocNode.getChildAt(0);
            int tag = trigBank.getTag() & 0xFF1F;
            if (!CODATag.isRawTrigger(tag)) {
                throw new EmuException("No trigger bank in ROC raw record in roc " + inputPayloadBanks[i].getSourceName() + ", tag = 0x" + Integer.toHexString(tag) + ", first event # " + firstEventNumber);
            }
            if (i == 0) {
                firstTrigTag = tag;
            }
            inputPayloadBanks[i].setEventCount(numEvents);
            if (turnOffChecks) continue;
            if (numEvents != trigBank.getNum()) {
                throw new EmuException("Data blocks contain different numbers of events, " + numEvents + " != " + trigBank.getNum() + " from roc " + inputPayloadBanks[i].getSourceName());
            }
            if (numEvents != rocNode.getNum()) {
                throw new EmuException("Data blocks contain different numbers of events, " + numEvents + " != " + rocNode.getNum() + " from roc " + inputPayloadBanks[i].getSourceName());
            }
            if (trigBank.getChildCount() != numEvents) {
                throw new EmuException("Trigger bank does not have correct number of segments, " + numEvents + " != " + trigBank.getChildCount() + " from roc " + inputPayloadBanks[i].getSourceName());
            }
            if (tag == firstTrigTag) continue;
            throw new EmuException("Trigger banks have different tags, 0x" + Integer.toHexString(firstTrigTag) + '(' + inputPayloadBanks[0].getSourceName() + ") != 0x" + Integer.toHexString(tag) + " (" + inputPayloadBanks[i].getSourceName() + ')');
        }
        boolean haveTimestamps = CODATag.hasTimestamp(firstTrigTag);
        if (checkTimestamps && !haveTimestamps) {
            nonFatalError = true;
            checkTimestamps = false;
        }
        if (!checkTimestamps) {
            if (includeRunData) {
                longData = new long[]{firstEventNumber, (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL};
                trigTag = CODATag.BUILT_TRIGGER_RUN;
            } else {
                longData = new long[]{firstEventNumber};
                trigTag = CODATag.BUILT_TRIGGER_BANK;
            }
        } else if (includeRunData) {
            longData = new long[2 + numEvents];
            longData[0] = firstEventNumber;
            longData[numEvents + 1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
            trigTag = CODATag.BUILT_TRIGGER_TS_RUN;
        } else {
            longData = new long[1 + numEvents];
            longData[0] = firstEventNumber;
            trigTag = CODATag.BUILT_TRIGGER_TS;
        }
        int[] triggerData = null;
        int firstEvNum = (int)firstEventNumber;
        short[] evData = new short[numEvents];
        for (int i = 0; i < numEvents; ++i) {
            long timestampsMax = 0L;
            long timestampsMin = Long.MAX_VALUE;
            int evNum = firstEvNum + i;
            for (int j = 0; j < numROCs; ++j) {
                EvioNode triggerSegment = inputPayloadBanks[j].getNode().getChildAt(0).getChildAt(i);
                if (j == 0) {
                    evData[i] = (short)triggerSegment.getTag();
                }
                if (!turnOffChecks) {
                    if (evData[i] != (short)triggerSegment.getTag()) {
                        System.out.println("makeTriggerBankFromRocRaw: event type differs across ROCs, first has " + evData[i] + " #" + j + " ROC has " + (short)triggerSegment.getTag());
                        nonFatalError = true;
                    }
                    if (evNum != (triggerData = triggerSegment.getIntData())[0]) {
                        System.out.println("makeTriggerBankFromRocRaw: event # differs (in Bt# " + buildThreadOrder + ") for ROC id#" + Evio.getTagCodaId(inputPayloadBanks[j].getNode().getTag()) + ", expected " + evNum + " got " + triggerData[0] + " (0x" + Integer.toHexString(triggerData[0]) + ')');
                        nonFatalError = true;
                    }
                    if (!haveMiscData && !haveTimestamps && triggerData.length > 1) {
                        haveMiscData = true;
                    }
                }
                if (!checkTimestamps || triggerData.length <= 2) continue;
                long ts = (0xFFFFL & (long)triggerData[2]) << 32 | 0xFFFFFFFFL & (long)triggerData[1];
                int n = i + 1;
                longData[n] = longData[n] + ts;
                if (ts > timestampsMax) {
                    timestampsMax = ts;
                }
                if (ts >= timestampsMin) continue;
                timestampsMin = ts;
            }
            if (!checkTimestamps) continue;
            int n = i + 1;
            longData[n] = longData[n] / (long)numROCs;
            if (timestampsMax - timestampsMin <= (long)timestampSlop) continue;
            nonFatalError = true;
            System.out.println("Timestamp NOT consistent: ev #" + (firstEvNum + i) + ", diff = " + (timestampsMax - timestampsMin) + ", allowed = " + timestampSlop);
            for (PayloadBuffer inputPayloadBank : inputPayloadBanks) {
                Utilities.printBuffer((ByteBuffer)inputPayloadBank.getBuffer(), (int)0, (int)10, (String)("Data from roc " + inputPayloadBanks[i].getSourceName()));
            }
        }
        boolean bl = sparsify = sparsify && !haveTimestamps && !haveMiscData;
        if (sparsify) {
            trigTag = trigTag.hasRunData() ? CODATag.BUILT_TRIGGER_RUN_NRSD : CODATag.BUILT_TRIGGER_NRSD;
        }
        try {
            builder.openBank(trigTag.getValue(), inputPayloadBanks.length, DataType.SEGMENT);
            builder.openSegment(ebId, DataType.ULONG64);
            builder.addLongData(longData);
            builder.closeStructure();
            builder.openSegment(ebId, DataType.USHORT16);
            builder.addShortData(evData);
            builder.closeStructure();
            if (!sparsify) {
                int dataLenFromEachSeg = 0;
                for (PayloadBuffer inputPayloadBank : inputPayloadBanks) {
                    builder.openSegment(inputPayloadBank.getSourceId(), DataType.UINT32);
                    for (int j = 0; j < numEvents; ++j) {
                        int[] oldData = inputPayloadBank.getNode().getChildAt(0).getChildAt(j).getIntData();
                        if (j == 0) {
                            dataLenFromEachSeg = oldData.length;
                        } else if (oldData.length != dataLenFromEachSeg) {
                            throw new EmuException("Trigger segments contain different amounts of data");
                        }
                        builder.addIntData(oldData, 1);
                    }
                    builder.closeStructure();
                }
            }
            builder.closeStructure();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return nonFatalError;
    }

    public static boolean makeTriggerBankFromRocRawOld(PayloadBuffer[] inputPayloadBanks, CompactEventBuilder builder, int ebId, long firstEventNumber, int runNumber, int runType, boolean includeRunData, boolean sparsify, boolean checkTimestamps, int timestampSlop, int buildThreadOrder) throws EmuException {
        CODATag trigTag;
        long[] longData;
        int i;
        if (builder == null || inputPayloadBanks == null || inputPayloadBanks.length < 1) {
            throw new EmuException("arguments are null or zero-length");
        }
        boolean turnOffChecks = false;
        int firstTrigTag = 0;
        int numROCs = inputPayloadBanks.length;
        int numEvents = inputPayloadBanks[0].getNode().getNum();
        EvioNode[][] triggerSegments = new EvioNode[numROCs][numEvents];
        EvioNode[] triggerBanks = new EvioNode[numROCs];
        boolean haveMiscData = false;
        boolean nonFatalError = false;
        if (turnOffChecks) {
            checkTimestamps = false;
        }
        for (int i2 = 0; i2 < numROCs; ++i2) {
            EvioNode rocNode = inputPayloadBanks[i2].getNode();
            triggerBanks[i2] = rocNode.getChildAt(0);
            if (!Evio.isRawTriggerBank(triggerBanks[i2])) {
                throw new EmuException("No trigger bank in ROC raw record in roc " + inputPayloadBanks[i2].getSourceName() + ", tag = 0x" + Integer.toHexString(triggerBanks[i2].getTag()) + ", first event # " + firstEventNumber);
            }
            if (i2 == 0) {
                firstTrigTag = triggerBanks[i2].getTag() & 0xFFF0;
            }
            inputPayloadBanks[i2].setEventCount(numEvents);
            for (int j = 0; j < numEvents; ++j) {
                triggerSegments[i2][j] = triggerBanks[i2].getChildAt(j);
            }
            if (turnOffChecks) continue;
            if (numEvents != triggerBanks[i2].getNum()) {
                throw new EmuException("Data blocks contain different numbers of events, " + numEvents + " != " + triggerBanks[i2].getNum() + " from roc " + inputPayloadBanks[i2].getSourceName());
            }
            if (numEvents != rocNode.getNum()) {
                throw new EmuException("Data blocks contain different numbers of events, " + numEvents + " != " + rocNode.getNum() + " from roc " + inputPayloadBanks[i2].getSourceName());
            }
            if (triggerBanks[i2].getChildCount() != numEvents) {
                throw new EmuException("Trigger bank does not have correct number of segments, " + numEvents + " != " + triggerBanks[i2].getChildCount() + " from roc " + inputPayloadBanks[i2].getSourceName());
            }
            int tag = triggerBanks[i2].getTag() & 0xFFF0;
            if (tag != 65296) {
                throw new EmuException("Trigger bank has bad tag 0x" + Integer.toHexString(triggerBanks[i2].getTag()) + " from roc " + inputPayloadBanks[i2].getSourceName());
            }
            if (tag == firstTrigTag) continue;
            throw new EmuException("Trigger banks have different tags, 0x" + Integer.toHexString(firstTrigTag) + '(' + inputPayloadBanks[0].getSourceName() + ") != 0x" + Integer.toHexString(tag) + " (" + inputPayloadBanks[i2].getSourceName() + ')');
        }
        boolean haveTimestamps = CODATag.hasTimestamp(triggerBanks[0].getTag());
        if (checkTimestamps && !haveTimestamps) {
            nonFatalError = true;
            checkTimestamps = false;
        }
        short[] evData = new short[numEvents];
        for (int i3 = 0; i3 < numEvents; ++i3) {
            evData[i3] = (short)triggerSegments[0][i3].getTag();
        }
        long[] timestampsAvg = null;
        long[] timestampsMax = null;
        long[] timestampsMin = null;
        if (checkTimestamps) {
            timestampsAvg = new long[numEvents];
            timestampsMax = new long[numEvents];
            timestampsMin = new long[numEvents];
            Arrays.fill(timestampsMin, Long.MAX_VALUE);
        }
        int[] triggerData = null;
        int firstEvNum = (int)firstEventNumber;
        int[][][] trigIntArrays = new int[numROCs][numEvents][];
        for (i = 0; i < numEvents; ++i) {
            for (int j = 0; j < numROCs; ++j) {
                if (!turnOffChecks) {
                    if (evData[i] != (short)triggerSegments[j][i].getTag()) {
                        System.out.println("makeTriggerBankFromRocRaw: event type differs across ROCs, first has " + evData[i] + " #" + j + " ROC has " + (short)triggerSegments[j][i].getTag());
                        nonFatalError = true;
                    }
                    triggerData = ByteDataTransformer.toIntArray((ByteBuffer)triggerSegments[j][i].getByteData(false));
                    trigIntArrays[j][i] = triggerData;
                    if (firstEvNum + i != triggerData[0]) {
                        System.out.println("makeTriggerBankFromRocRaw: event # differs (in Bt# " + buildThreadOrder + ") for ROC id#" + Evio.getTagCodaId(inputPayloadBanks[j].getNode().getTag()) + ", expected " + (firstEvNum + i) + " got " + triggerData[0] + " (0x" + Integer.toHexString(triggerData[0]) + ')');
                        nonFatalError = true;
                    }
                    if (!haveMiscData && !haveTimestamps && triggerData.length > 1) {
                        haveMiscData = true;
                    }
                }
                if (!checkTimestamps || triggerData.length <= 2) continue;
                long ts = (0xFFFFL & (long)triggerData[2]) << 32 | 0xFFFFFFFFL & (long)triggerData[1];
                int n = i;
                timestampsAvg[n] = timestampsAvg[n] + ts;
                timestampsMax[i] = ts > timestampsMax[i] ? ts : timestampsMax[i];
                timestampsMin[i] = ts < timestampsMin[i] ? ts : timestampsMin[i];
            }
            if (!checkTimestamps) continue;
            int n = i;
            timestampsAvg[n] = timestampsAvg[n] / (long)numROCs;
        }
        if (checkTimestamps) {
            for (i = 0; i < numEvents; ++i) {
                if (timestampsMax[i] - timestampsMin[i] <= (long)timestampSlop) continue;
                nonFatalError = true;
                System.out.println("Timestamp NOT consistent: ev #" + (firstEvNum + i) + ", diff = " + (timestampsMax[i] - timestampsMin[i]) + ", allowed = " + timestampSlop);
                for (PayloadBuffer inputPayloadBank : inputPayloadBanks) {
                    Utilities.printBuffer((ByteBuffer)inputPayloadBank.getBuffer(), (int)0, (int)10, (String)("Data from roc " + inputPayloadBanks[i].getSourceName()));
                }
            }
        }
        if (!checkTimestamps) {
            if (includeRunData) {
                longData = new long[]{firstEventNumber, (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL};
                trigTag = CODATag.BUILT_TRIGGER_RUN;
            } else {
                longData = new long[]{firstEventNumber};
                trigTag = CODATag.BUILT_TRIGGER_BANK;
            }
        } else if (includeRunData) {
            longData = new long[2 + numEvents];
            longData[0] = firstEventNumber;
            System.arraycopy(timestampsAvg, 0, longData, 1, numEvents);
            longData[numEvents + 1] = (long)runNumber << 32 | (long)runType & 0xFFFFFFFFL;
            trigTag = CODATag.BUILT_TRIGGER_TS_RUN;
        } else {
            longData = new long[1 + numEvents];
            longData[0] = firstEventNumber;
            System.arraycopy(timestampsAvg, 0, longData, 1, numEvents);
            trigTag = CODATag.BUILT_TRIGGER_TS;
        }
        boolean bl = sparsify = sparsify && !haveTimestamps && !haveMiscData;
        if (sparsify) {
            trigTag = trigTag.hasRunData() ? CODATag.BUILT_TRIGGER_RUN_NRSD : CODATag.BUILT_TRIGGER_NRSD;
        }
        try {
            builder.openBank(trigTag.getValue(), inputPayloadBanks.length, DataType.SEGMENT);
            builder.openSegment(ebId, DataType.ULONG64);
            builder.addLongData(longData);
            builder.closeStructure();
            builder.openSegment(ebId, DataType.USHORT16);
            builder.addShortData(evData);
            builder.closeStructure();
            if (!sparsify) {
                for (int i4 = 0; i4 < numROCs; ++i4) {
                    builder.openSegment(inputPayloadBanks[i4].getSourceId(), DataType.UINT32);
                    EvioNode oldRocSeg = triggerSegments[i4][0];
                    int dataLenFromEachSeg = oldRocSeg.getLength() - 1;
                    int intCount = numEvents * dataLenFromEachSeg;
                    int[] newData = new int[intCount];
                    int position = 0;
                    for (int j = 0; j < numEvents; ++j) {
                        int[] oldData = trigIntArrays[i4][j];
                        if (oldData.length != dataLenFromEachSeg + 1) {
                            throw new EmuException("Trigger segments contain different amounts of data");
                        }
                        System.arraycopy(oldData, 1, newData, position, dataLenFromEachSeg);
                        position += dataLenFromEachSeg;
                    }
                    builder.addIntData(newData);
                    builder.closeStructure();
                }
            }
            builder.closeStructure();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return nonFatalError;
    }

    public static void buildPhysicsEventWithPhysics(EvioNode[] inputNodes, ByteBuffer evBuf, int inputCount, int writeIndex, boolean fastCopyReady, int[] returnLen, ByteBuffer[] rocRecord) {
        boolean switchEndianFastCopyReady = false;
        if (!fastCopyReady) {
            switchEndianFastCopyReady = rocRecord[0].array() != null && evBuf.array() != null;
        }
        for (int i = 0; i < inputCount; ++i) {
            EvioNode node = inputNodes[i];
            int childrenCount = node.getChildCount();
            ByteBuffer rocBuffer = rocRecord[i];
            for (int j = 1; j < childrenCount; ++j) {
                EvioNode dataBank = (EvioNode)node.getChildNodes().get(j);
                int pos = dataBank.getPosition();
                int byteLen = dataBank.getTotalBytes();
                if (fastCopyReady) {
                    System.arraycopy(rocBuffer.array(), pos, evBuf.array(), writeIndex, byteLen);
                    writeIndex += byteLen;
                    continue;
                }
                if (evBuf.order() == rocBuffer.order()) {
                    ByteBuffer duplicateBuf = rocBuffer.duplicate();
                    duplicateBuf.limit(pos + byteLen).position(pos);
                    evBuf.position(writeIndex);
                    evBuf.put(duplicateBuf);
                    evBuf.position(0);
                    writeIndex += byteLen;
                    continue;
                }
                evBuf.putInt(writeIndex, rocBuffer.getInt(pos));
                evBuf.putInt(writeIndex += 4, rocBuffer.getInt(pos += 4));
                writeIndex += 4;
                pos += 4;
                int subChildrenCount = dataBank.getChildCount();
                for (int k = 0; k < subChildrenCount; ++k) {
                    EvioNode dataBlockBank = (EvioNode)dataBank.getChildNodes().get(k);
                    int dataBlockByteLen = 4 * dataBlockBank.getDataLength();
                    evBuf.putInt(writeIndex, rocBuffer.getInt(pos));
                    evBuf.putInt(writeIndex += 4, rocBuffer.getInt(pos += 4));
                    writeIndex += 4;
                    pos += 4;
                    if (switchEndianFastCopyReady) {
                        System.arraycopy(rocBuffer.array(), pos, evBuf.array(), writeIndex, dataBlockByteLen);
                        writeIndex += dataBlockByteLen;
                    } else {
                        ByteBuffer duplicateBuf = rocBuffer.duplicate();
                        duplicateBuf.limit(pos + dataBlockByteLen).position(pos);
                        evBuf.position(writeIndex);
                        evBuf.put(duplicateBuf);
                        evBuf.position(0);
                    }
                    writeIndex += dataBlockByteLen;
                    pos += dataBlockByteLen;
                }
            }
        }
        returnLen[0] = writeIndex;
    }

    public static void buildPhysicsEventWithPhysics(PayloadBuffer[] inputPayloadBanks, CompactEventBuilder builder) {
        try {
            for (PayloadBuffer inputBank : inputPayloadBanks) {
                int childrenCount = inputBank.getNode().getChildCount();
                for (int j = 0; j < childrenCount; ++j) {
                    EvioNode dataBlock = (EvioNode)inputBank.getNode().getChildNodes().get(j);
                    if (Evio.isBuiltTriggerBank(dataBlock)) continue;
                    builder.addEvioNode(dataBlock);
                }
            }
        }
        catch (EvioException evioException) {
            // empty catch block
        }
    }

    public static EvioBank buildPhysicsEventWithRocRaw(EvioNode[] rocNodes, boolean fastCopyReady, int numRocs, int writeIndex, ByteBuffer builtEventBuf, int[] returnLen, ByteBuffer[] rocRecord) {
        for (int i = 0; i < numRocs; ++i) {
            EvioNode rocNode = rocNodes[i];
            ByteBuffer rocBuffer = rocRecord[i];
            int pos = rocBuffer.position();
            int lim = rocBuffer.limit();
            int dataBankPos = writeIndex;
            int secondHeaderWord = rocBuffer.getInt(rocNode.getPosition() + 4);
            builtEventBuf.putInt(writeIndex += 4, secondHeaderWord);
            writeIndex += 4;
            int childrenCount = rocNode.getChildCount();
            int totalLen = 1;
            for (int j = 1; j < childrenCount; ++j) {
                EvioNode blockBank = (EvioNode)rocNode.getChildNodes().get(j);
                int blockPos = blockBank.getPosition();
                builtEventBuf.putInt(writeIndex, rocBuffer.getInt(blockPos));
                builtEventBuf.putInt(writeIndex += 4, rocBuffer.getInt(blockPos + 4));
                writeIndex += 4;
                int dataLen = blockBank.getDataLength();
                if (fastCopyReady) {
                    System.arraycopy(rocBuffer.array(), blockPos + 8, builtEventBuf.array(), writeIndex, 4 * dataLen);
                } else {
                    ByteBuffer duplicateBuf = rocBuffer.duplicate();
                    duplicateBuf.limit(blockPos + 8 + 4 * dataLen).position(blockPos + 8);
                    builtEventBuf.position(writeIndex);
                    builtEventBuf.put(duplicateBuf);
                    builtEventBuf.position(0);
                }
                writeIndex += 4 * dataLen;
                totalLen += dataLen + 2;
            }
            rocBuffer.limit(lim).position(pos);
            builtEventBuf.putInt(dataBankPos, totalLen);
        }
        returnLen[0] = writeIndex;
        return null;
    }

    public static EvioBank buildPhysicsEventWithRocRaw(PayloadBuffer[] inputPayloadBanks, CompactEventBuilder builder) {
        boolean i = false;
        try {
            for (PayloadBuffer inputPayloadBank : inputPayloadBanks) {
                EvioNode inputBank = inputPayloadBank.getNode();
                builder.openBank(inputBank.getTag(), inputBank.getNum(), DataType.BANK);
                int childrenCount = inputBank.getChildCount();
                for (int j = 1; j < childrenCount; ++j) {
                    EvioNode blockBank = (EvioNode)inputBank.getChildNodes().get(j);
                    builder.addEvioNode(blockBank);
                }
                builder.closeStructure();
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int[] generateData(int firstEvNum, int words, boolean isSEM, long timestamp) {
        int index = 0;
        int[] data = isSEM ? new int[3 + words] : new int[1 + words];
        data[index++] = firstEvNum;
        if (isSEM) {
            data[index++] = (int)timestamp;
            data[index++] = (int)(timestamp >>> 32 & 0xFFFFL);
        }
        for (int i = 0; i < words; ++i) {
            data[index + i] = i;
        }
        return data;
    }

    public static void createRocRawRecordFast(int rocID, int triggerType, int detectorId, int status, int eventNumber, int numEvents, long timestamp, ByteBuffer buf, CompactEventBuilder builder) throws EvioException {
        builder.setBuffer(buf);
        int rocTag = Evio.createCodaTag(status, rocID);
        builder.openBank(rocTag, numEvents, DataType.BANK);
        builder.openBank(CODATag.RAW_TRIGGER_TS.getValue(), numEvents, DataType.SEGMENT);
        int[] segmentData = new int[3];
        for (int i = 0; i < numEvents; ++i) {
            builder.openSegment(triggerType, DataType.UINT32);
            segmentData[0] = eventNumber + i;
            segmentData[1] = (int)timestamp;
            segmentData[2] = (int)(timestamp >>> 32 & 0xFFFFL);
            timestamp += 4L;
            builder.addIntData(segmentData);
            builder.closeStructure();
        }
        builder.closeStructure();
        int[] data = Evio.generateData(eventNumber, numEvents * 40, false, timestamp);
        int dataTag = Evio.createCodaTag(status, detectorId);
        builder.openBank(dataTag, numEvents, DataType.UINT32);
        builder.addIntData(data);
        builder.closeAll();
    }
}

