/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.data;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SpinCountBackoffWaitStrategy;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.jevio.EvioNodePool;

public class ByteBufferSupply {
    private int bufferSize;
    private ByteOrder order;
    private boolean direct;
    private final RingBuffer<ByteBufferItem> ringBuffer;
    private final SequenceBarrier barrier;
    private final Sequence sequence;
    private long nextConsumerSequence;
    private long availableConsumerSequence = -1L;
    public Object auxObject;
    private final boolean orderedRelease;
    private long lastSequenceReleased = -1L;
    private long maxSequence = -1L;
    private int between;
    private int itemCounter;

    public ByteBufferSupply(int ringSize, int bufferSize) throws IllegalArgumentException {
        this(ringSize, bufferSize, ByteOrder.BIG_ENDIAN, false);
    }

    public ByteBufferSupply(int ringSize, int bufferSize, ByteOrder order, boolean direct) throws IllegalArgumentException {
        this(ringSize, bufferSize, order, direct, false);
    }

    public ByteBufferSupply(int ringSize, int bufferSize, ByteOrder order, boolean direct, boolean orderedRelease) throws IllegalArgumentException {
        if (ringSize < 1 || bufferSize < 1) {
            throw new IllegalArgumentException("positive args only");
        }
        if (Integer.bitCount(ringSize) != 1) {
            throw new IllegalArgumentException("ringSize must be a power of 2");
        }
        this.order = order;
        this.direct = direct;
        this.bufferSize = bufferSize;
        this.orderedRelease = orderedRelease;
        this.ringBuffer = RingBuffer.createSingleProducer((EventFactory)new ByteBufferFactory(), (int)ringSize, (WaitStrategy)new SpinCountBackoffWaitStrategy(10000, (WaitStrategy)new LiteBlockingWaitStrategy()));
        this.barrier = this.ringBuffer.newBarrier(new Sequence[0]);
        this.sequence = new Sequence(-1L);
        this.ringBuffer.addGatingSequences(new Sequence[]{this.sequence});
        this.nextConsumerSequence = this.sequence.get() + 1L;
    }

    public ByteBufferSupply(int ringSize, int bufferSize, ByteOrder order, boolean direct, boolean orderedRelease, EvioNodePool[] pools) throws IllegalArgumentException {
        if (ringSize < 1 || bufferSize < 1) {
            throw new IllegalArgumentException("positive args only");
        }
        if (Integer.bitCount(ringSize) != 1) {
            throw new IllegalArgumentException("ringSize must be a power of 2");
        }
        if (pools == null || pools.length < ringSize) {
            throw new IllegalArgumentException("pools array must contain at least ringSize # of elements");
        }
        this.order = order;
        this.direct = direct;
        this.bufferSize = bufferSize;
        this.orderedRelease = orderedRelease;
        this.ringBuffer = RingBuffer.createSingleProducer((EventFactory)new AuxByteBufferFactory(pools), (int)ringSize, (WaitStrategy)new SpinCountBackoffWaitStrategy(10000, (WaitStrategy)new LiteBlockingWaitStrategy()));
        this.barrier = this.ringBuffer.newBarrier(new Sequence[0]);
        this.sequence = new Sequence(-1L);
        this.ringBuffer.addGatingSequences(new Sequence[]{this.sequence});
        this.nextConsumerSequence = this.sequence.get() + 1L;
    }

    public ByteBufferSupply(int ringSize, List<ByteBuffer> bufList, boolean orderedRelease) throws IllegalArgumentException {
        if (ringSize < 1) {
            throw new IllegalArgumentException("positive args only");
        }
        if (Integer.bitCount(ringSize) != 1) {
            throw new IllegalArgumentException("ringSize must be a power of 2");
        }
        if (bufList == null || bufList.size() < ringSize) {
            throw new IllegalArgumentException("bufList is null or size < ringSize");
        }
        this.orderedRelease = orderedRelease;
        this.ringBuffer = RingBuffer.createSingleProducer((EventFactory)new PredefinedByteBufferFactory(bufList), (int)ringSize, (WaitStrategy)new SpinCountBackoffWaitStrategy(10000, (WaitStrategy)new LiteBlockingWaitStrategy()));
        this.barrier = this.ringBuffer.newBarrier(new Sequence[0]);
        this.sequence = new Sequence(-1L);
        this.ringBuffer.addGatingSequences(new Sequence[]{this.sequence});
        this.nextConsumerSequence = this.sequence.get() + 1L;
    }

    public int getFillLevel() {
        int ringCount = this.ringBuffer.getBufferSize();
        return (int)(100L * ((long)ringCount - this.ringBuffer.remainingCapacity()) / (long)ringCount);
    }

    public ByteBufferItem get() throws InterruptedException {
        long getSequence = this.ringBuffer.nextIntr(1);
        ByteBufferItem bufItem = (ByteBufferItem)this.ringBuffer.get(getSequence);
        bufItem.reset();
        bufItem.setFromConsumerGet(false);
        bufItem.setProducerSequence(getSequence);
        return bufItem;
    }

    public ByteBufferItem getAsIs() throws InterruptedException {
        long getSequence = this.ringBuffer.nextIntr(1);
        ByteBufferItem bufItem = (ByteBufferItem)this.ringBuffer.get(getSequence);
        bufItem.setFromConsumerGet(false);
        bufItem.setProducerSequence(getSequence);
        return bufItem;
    }

    public ByteBufferItem consumerGet() throws InterruptedException {
        ByteBufferItem item = null;
        try {
            if (this.availableConsumerSequence < this.nextConsumerSequence) {
                this.availableConsumerSequence = this.barrier.waitFor(this.nextConsumerSequence);
            }
            item = (ByteBufferItem)this.ringBuffer.get(this.nextConsumerSequence);
            item.setConsumerSequence(this.nextConsumerSequence++);
            item.setFromConsumerGet(true);
        }
        catch (TimeoutException ex) {
            ex.printStackTrace();
        }
        catch (AlertException ex) {
            ex.printStackTrace();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ByteBufferItem item) {
        if (item == null) {
            return;
        }
        boolean isConsumerGet = item.isFromConsumerGet();
        long seq = isConsumerGet ? item.getConsumerSequence() : item.getProducerSequence();
        if (item.decrementCounter()) {
            if (this.orderedRelease) {
                this.sequence.set(seq);
                return;
            }
            ByteBufferSupply byteBufferSupply = this;
            synchronized (byteBufferSupply) {
                if (seq > this.maxSequence) {
                    if (this.maxSequence > this.lastSequenceReleased) {
                        ++this.between;
                    }
                    this.maxSequence = seq;
                } else if (seq > this.lastSequenceReleased) {
                    ++this.between;
                }
                if (this.maxSequence - this.lastSequenceReleased - 1L == (long)this.between) {
                    this.sequence.set(this.maxSequence);
                    this.lastSequenceReleased = this.maxSequence;
                    this.between = 0;
                }
            }
        }
    }

    public void publish(ByteBufferItem byteBufferItem) {
        if (byteBufferItem == null) {
            return;
        }
        this.ringBuffer.publish(byteBufferItem.getProducerSequence());
    }

    private final class PredefinedByteBufferFactory
    implements EventFactory<ByteBufferItem> {
        private int index;
        private final List<ByteBuffer> bufList;

        public PredefinedByteBufferFactory(List<ByteBuffer> bufList) {
            this.bufList = bufList;
        }

        public ByteBufferItem newInstance() {
            return new ByteBufferItem(this.bufList.get(this.index++), ByteBufferSupply.this.orderedRelease, ByteBufferSupply.this.itemCounter++);
        }
    }

    private final class AuxByteBufferFactory
    implements EventFactory<ByteBufferItem> {
        private int index;
        private final EvioNodePool[] pools;

        public AuxByteBufferFactory(EvioNodePool[] pools) {
            this.pools = pools;
        }

        public ByteBufferItem newInstance() {
            ByteBufferItem item = new ByteBufferItem(ByteBufferSupply.this.bufferSize, ByteBufferSupply.this.order, ByteBufferSupply.this.direct, ByteBufferSupply.this.orderedRelease, ByteBufferSupply.this.itemCounter++, this.pools[this.index], this.pools[this.index].getId());
            ++this.index;
            return item;
        }
    }

    private final class ByteBufferFactory
    implements EventFactory<ByteBufferItem> {
        private ByteBufferFactory() {
        }

        public ByteBufferItem newInstance() {
            return new ByteBufferItem(ByteBufferSupply.this.bufferSize, ByteBufferSupply.this.order, ByteBufferSupply.this.direct, ByteBufferSupply.this.orderedRelease, ByteBufferSupply.this.itemCounter++);
        }
    }
}

