/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.control;

import java.util.HashMap;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.emu.support.codaComponent.CODACommand;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.codaComponent.CODATransition;

public class Command {
    private CODAStateIF success;
    private cMsgMessage msg;
    private boolean fromDebugGui;
    private final CODACommand codaCommand;
    private final HashMap<String, cMsgPayloadItem> args = new HashMap(16);

    public Command(CODACommand codaCommand) {
        this.codaCommand = codaCommand;
        for (CODATransition transition : CODATransition.values()) {
            if (!codaCommand.name().equalsIgnoreCase(transition.name())) continue;
            this.success = transition.success();
        }
    }

    public CODACommand getCodaCommand() {
        return this.codaCommand;
    }

    public String name() {
        return this.codaCommand.name();
    }

    public String description() {
        return this.codaCommand.getDescription();
    }

    public cMsgMessage getMessage() {
        return this.msg;
    }

    public void setMessage(cMsgMessage msg) {
        this.msg = msg;
    }

    public boolean isFromDebugGui() {
        return this.fromDebugGui;
    }

    public void fromDebugGui(boolean fromDebugGui) {
        this.fromDebugGui = fromDebugGui;
    }

    public cMsgPayloadItem getArg(String tag) {
        return this.args.get(tag);
    }

    public void setArg(String tag, cMsgPayloadItem value) {
        this.args.put(tag, value);
    }

    public boolean hasArgs() {
        return !this.args.isEmpty();
    }

    public CODAStateIF success() {
        return this.success;
    }
}

