/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.codaComponent;

import java.util.EnumSet;
import java.util.HashMap;

public enum CODACommand {
    CONFIGURE("Load configuration", "run/transition/configure", true, 0, InputType.PAYLOAD_TEXT, "fileName"),
    DOWNLOAD("Apply configuration and load", "run/transition/download", true, 0, null, null),
    PRESTART("Prepare to start", "run/transition/prestart", true, 0, InputType.PAYLOAD_INT, "runNumber"),
    GO("Start taking data", "run/transition/go", true, 0, null, null),
    END("End taking data", "run/transition/end", true, 0, null, null),
    RESET("Return to configured state", "run/transition/reset", true, 0, null, null),
    GET_STATE("Get state", "coda/info/getState", false, -1, null, null),
    GET_STATUS("Get status", "coda/info/getStatus", false, -1, null, null),
    GET_OBJECT_TYPE("Get object type", "coda/info/getObjectType", false, -1, null, null),
    GET_CODA_CLASS("Get coda class", "coda/info/getCodaClass", false, -1, null, null),
    SET_BUF_LEVEL("Set buffer level", "run/control/setRocBufferLevel", false, -1, null, null),
    GET_BUF_LEVEL("Get buffer level", "run/control/getRocBufferLevel", false, -1, null, null),
    ENABLE_OUTPUT("Enable output channels", "run/control/enableOutput", false, -1, null, null),
    DISABLE_OUTPUT("Disable output channels", "run/control/disableOutput", false, -1, null, null),
    SET_INTERVAL("Set interval", "session/control/setInterval", false, 1, InputType.USER_INT, null),
    START_REPORTING("Start reporting", "session/control/startReporting", false, 1, null, null),
    STOP_REPORTING("Stop reporting", "session/control/stopReporting", false, 1, null, null),
    EXIT("Shutdown coda component", "session/control/exit", false, 1, null, null),
    SET_SESSION("Set session", "session/control/setSession", false, -1, null, null),
    GET_SESSION("Get session", "session/control/getSession", false, -1, null, null),
    SET_RUN_NUMBER("Set run number", "session/control/setRunNumber", false, -1, null, null),
    GET_RUN_NUMBER("Get run number", "session/control/getRunNumber", false, -1, null, null),
    SET_RUN_TYPE("Set run type", "session/control/setRunType", false, -1, null, null),
    GET_RUN_TYPE("Get run type", "session/control/getRunType", false, -1, null, null),
    GET_CONFIG_ID("Get config id", "session/control/configId", false, -1, null, null),
    SET_PRE_END("END is coming", "session/control/preEnd", false, -1, null, null);

    private final String cmdString;
    private final String description;
    private boolean isTransition;
    private final int guiGroup;
    private final InputType inputType;
    private String payloadName;
    private static final HashMap<String, CODACommand> commandTypeToEnumMap;

    public static CODACommand get(String s) {
        return commandTypeToEnumMap.get(s);
    }

    private CODACommand(String description, String cmdString, boolean isTransition, int guiGroup, InputType inputType, String payloadName) {
        this.cmdString = cmdString;
        this.description = description;
        this.isTransition = isTransition;
        this.guiGroup = guiGroup;
        this.inputType = inputType;
        this.payloadName = payloadName;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public int getGuiGroup() {
        return this.guiGroup;
    }

    public boolean isTransition() {
        return this.isTransition;
    }

    public String getPayloadName() {
        return this.payloadName;
    }

    public static EnumSet<CODACommand> getGuiGroup(int group) {
        EnumSet<CODACommand> enumSet = EnumSet.allOf(CODACommand.class);
        for (CODACommand item : CODACommand.values()) {
            if (item.guiGroup == group) continue;
            enumSet.remove((Object)item);
        }
        return enumSet;
    }

    public String getCmdString() {
        return this.cmdString;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        commandTypeToEnumMap = new HashMap(25);
        for (CODACommand item : CODACommand.values()) {
            commandTypeToEnumMap.put(item.cmdString, item);
        }
    }

    public static enum InputType {
        TEXT,
        USER_INT,
        PAYLOAD_TEXT,
        PAYLOAD_INT;

    }
}

