/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.modules.ModuleAdapter;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.configurer.Configurer;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.jevio.EventWriterUnsync;
import org.jlab.coda.jevio.EvioException;

public class ToFile
extends ModuleAdapter {
    RecordingThread thread;
    private DataChannel inputChannel;
    private volatile boolean haveEndEvent;
    private long endingTimeLimit;
    private boolean debug;
    private RingBuffer<RingItem> ringBufferIn;
    public Sequence sequence;
    public SequenceBarrier barrierIn;
    private String directory;
    private String fileName;
    private String dictionaryXML;
    private long split;
    private EventWriterUnsync evioFileWriter;

    public ToFile(String name, Map<String, String> attributeMap, Emu emu) throws EvioException {
        String runType;
        int runNumber;
        block18: {
            super(name, attributeMap, emu);
            this.endingTimeLimit = 30000L;
            this.debug = false;
            runNumber = emu.getRunNumber();
            runType = emu.getRunType();
            try {
                this.directory = attributeMap.get("dir");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fileName = attributeMap.get("fileName");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String dictionaryFile = attributeMap.get("dictionary");
                if (dictionaryFile != null) {
                    File dFile = new File(dictionaryFile);
                    if (dFile.exists() && dFile.isFile()) {
                        FileInputStream fileInputStream = new FileInputStream(dFile);
                        int fileSize = (int)fileInputStream.getChannel().size();
                        byte[] buf = new byte[fileSize];
                        DataInputStream dataStream = new DataInputStream(fileInputStream);
                        dataStream.read(buf);
                        this.dictionaryXML = new String(buf, 0, fileSize, "US-ASCII");
                    } else {
                        this.logger.info("      DataChannel File: dictionary file cannot be read");
                    }
                }
            }
            catch (Exception dictionaryFile) {
                // empty catch block
            }
            try {
                String splitStr = attributeMap.get("split");
                if (splitStr == null) break block18;
                try {
                    this.split = Long.parseLong(splitStr);
                    if (this.split < 0L) {
                        this.split = 0L;
                    }
                }
                catch (NumberFormatException e) {
                    this.split = 0L;
                }
            }
            catch (Exception splitStr) {
                // empty catch block
            }
        }
        if (this.fileName == null) {
            this.fileName = this.split > 0L ? "codaOutputFile_%d.dat%05d" : "codaOutputFile_%d.dat";
        }
        try {
            boolean overWriteOK = true;
            if (this.split > 0L) {
                overWriteOK = false;
            }
            this.evioFileWriter = new EventWriterUnsync(this.fileName, this.directory, runType, runNumber, this.split, this.outputOrder, this.dictionaryXML, overWriteOK);
            this.logger.info("      DataChannel File: file = " + this.evioFileWriter.getCurrentFilePath());
            emu.addOutputDestination(this.evioFileWriter.getCurrentFilePath());
        }
        catch (EvioException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void addInputChannels(ArrayList<DataChannel> input_channels) {
        super.addInputChannels(input_channels);
        if (this.inputChannels.size() > 0) {
            this.inputChannel = (DataChannel)this.inputChannels.get(0);
        }
    }

    public DataChannel getInputChannel() {
        return this.inputChannel;
    }

    @Override
    public void clearChannels() {
        this.inputChannels.clear();
        this.inputChannel = null;
    }

    private void startThreads() {
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        this.RateCalculator = new Thread(this.emu.getThreadGroup(), new ModuleAdapter.RateCalculatorThread(), this.name + ":watcher");
        if (this.RateCalculator.getState() == Thread.State.NEW) {
            this.RateCalculator.start();
        }
        this.thread = new RecordingThread(this.emu.getThreadGroup(), this.name + ":recorder");
        this.thread.start();
    }

    private void endRecordThreads(RecordingThread thisThread, boolean wait) {
        if (wait) {
            long startTime = System.currentTimeMillis();
            boolean haveUnprocessedEvents = true;
            while ((haveUnprocessedEvents || !this.haveEndEvent) && System.currentTimeMillis() - startTime < this.endingTimeLimit) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                haveUnprocessedEvents = false;
            }
            if (haveUnprocessedEvents || !this.haveEndEvent) {
                if (this.debug) {
                    System.out.println("  ToFile mod: will end threads but no END event or ring not empty!");
                }
                this.moduleState = CODAState.ERROR;
                this.emu.setErrorState("ToFile will end threads but no END event or ring not empty");
            }
        }
        if (this.thread != thisThread) {
            this.thread.interrupt();
            try {
                this.thread.join(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void reset() {
        Date theDate = new Date();
        CODAStateIF previousState = this.moduleState;
        this.moduleState = CODAState.CONFIGURED;
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        this.endRecordThreads(null, false);
        this.RateCalculator = null;
        this.paused = false;
        if (previousState.equals(CODAState.ACTIVE)) {
            try {
                Configurer.setValue(this.emu.parameters(), "status/run_end_time", theDate.toString());
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void go() {
        this.moduleState = CODAState.ACTIVE;
        this.paused = false;
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", new Date().toString());
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void end() {
        this.moduleState = CODAState.DOWNLOADED;
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        this.endRecordThreads(null, true);
        this.RateCalculator = null;
        this.paused = false;
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_end_time", new Date().toString());
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void prestart() throws CmdExecException {
        this.moduleState = CODAState.PAUSED;
        this.paused = true;
        if (this.inputChannels.size() != 1) {
            this.moduleState = CODAState.ERROR;
            this.emu.setErrorState("ToFile module does not have exactly 1 input channel");
            return;
        }
        this.ringBufferIn = ((DataChannel)this.inputChannels.get(0)).getRingBufferIn();
        this.sequence = new Sequence(-1L);
        this.ringBufferIn.addGatingSequences(new Sequence[]{this.sequence});
        this.barrierIn = this.ringBufferIn.newBarrier(new Sequence[0]);
        this.wordRate = 0.0f;
        this.eventRate = 0.0f;
        this.wordCountTotal = 0L;
        this.eventCountTotal = 0L;
        this.startThreads();
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", "--prestart--");
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    private class RecordingThread
    extends Thread {
        private long availableSequence;
        private long nextSequence;

        RecordingThread(ThreadGroup group, String name) {
            super(group, name);
        }

        @Override
        public void run() {
            this.availableSequence = -2L;
            this.nextSequence = ToFile.this.sequence.get() + 1L;
            while (ToFile.this.moduleState == CODAState.ACTIVE || ToFile.this.paused) {
                try {
                    this.availableSequence = ToFile.this.barrierIn.waitFor(this.nextSequence);
                    while (this.nextSequence <= this.availableSequence) {
                        RingItem ringItem = (RingItem)ToFile.this.ringBufferIn.get(this.nextSequence);
                        int wordCount = ringItem.getNode().getLength() + 1;
                        ControlType controlType = ringItem.getControlType();
                        int totalNumberEvents = ringItem.getEventCount();
                        if (ringItem.getBuffer() != null) {
                            ToFile.this.evioFileWriter.writeEvent(ringItem.getBuffer());
                        } else if (ringItem.isFirstEvent()) {
                            ToFile.this.evioFileWriter.setFirstEvent(ringItem.getNode());
                        } else {
                            ToFile.this.evioFileWriter.writeEvent(ringItem.getNode(), false);
                        }
                        ringItem.releaseByteBuffer();
                        ToFile.this.eventCountTotal += (long)totalNumberEvents;
                        ToFile.this.wordCountTotal += (long)wordCount;
                        if (controlType == ControlType.END) {
                            System.out.println("  ToFile mod: found END event");
                            try {
                                ToFile.this.evioFileWriter.close();
                            }
                            catch (Exception e) {
                                ToFile.this.errorMsg.compareAndSet(null, "Cannot write to file");
                                throw e;
                            }
                            ToFile.this.haveEndEvent = true;
                            ToFile.this.endRecordThreads(this, false);
                            if (ToFile.this.endCallback != null) {
                                ToFile.this.endCallback.endWait();
                            }
                            return;
                        }
                        if (controlType == ControlType.PRESTART) {
                            ToFile.this.prestartCallback.endWait();
                        }
                        ToFile.this.sequence.set(this.nextSequence++);
                    }
                }
                catch (InterruptedException e) {
                    if (ToFile.this.debug) {
                        System.out.println("  ToFile mod: INTERRUPTED recording thread " + Thread.currentThread().getName());
                    }
                    return;
                }
                catch (AlertException e) {
                    if (ToFile.this.debug) {
                        System.out.println("  ToFile mod: ring buf alert");
                    }
                    ToFile.this.moduleState = CODAState.ERROR;
                    ToFile.this.emu.setErrorState("ToFile ring buf alert");
                    return;
                }
                catch (TimeoutException e) {
                    if (ToFile.this.debug) {
                        System.out.println("  ToFile mod: ring buf timeout");
                    }
                    ToFile.this.moduleState = CODAState.ERROR;
                    ToFile.this.emu.setErrorState("ToFile ring buf timeout");
                    return;
                }
                catch (Exception e) {
                    if (ToFile.this.debug) {
                        System.out.println("  ToFile mod: MAJOR ERROR recording event: " + e.getMessage());
                    }
                    ToFile.this.moduleState = CODAState.ERROR;
                    ToFile.this.emu.setErrorState("ToFile MAJOR ERROR recording event: " + e.getMessage());
                    return;
                }
            }
            System.out.println("  ToFile mod: recording thread ending");
        }
    }
}

