/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import com.lmax.disruptor.RingBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Phaser;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.modules.ModuleAdapter;
import org.jlab.coda.emu.support.codaComponent.CODAClass;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.configurer.Configurer;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;
import org.jlab.coda.emu.support.data.CODATag;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.emu.support.data.PayloadBuffer;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.jevio.CompactEventBuilder;
import org.jlab.coda.jevio.DataType;

public class RocFixedRateSimulation
extends ModuleAdapter {
    private volatile int rocRecordId;
    private EventGeneratingThread[] eventGeneratingThreads;
    private int triggerType;
    private int eventBlockSize;
    private int detectorId;
    private int eventWordSize;
    private int eventSize;
    private int syncCount;
    private int loops;
    private int bufSupplySize;
    private int eventsPerBuffer;
    private int generatedDataWords;
    private double bufsPerSec;
    private boolean noPhysics;
    private boolean synced;
    private cMsg cMsgServer;
    private cMsgMessage syncMessage;
    private cMsgMessage initMessage;
    private cMsgSubscriptionHandle cmsgSubHandle;
    private CountDownLatch initLatch;
    private Phaser syncPhaser;
    private Phaser endPhaser;
    private volatile boolean timeToEnd;
    private volatile boolean gotEndCommand;
    private volatile boolean gotResetCommand;
    private volatile boolean gotGoCommand;
    private SyncCallback syncCallback = new SyncCallback();
    private InitCallback initCallback = new InitCallback();

    private static PayloadBuffer createUserBuffer(ByteOrder order, boolean isFirstEvent, int val) {
        try {
            CompactEventBuilder builder = new CompactEventBuilder(44, order);
            builder.openBank(2, 0, DataType.INT32);
            builder.addIntData(new int[]{val});
            builder.closeAll();
            ByteBuffer bb = builder.getBuffer();
            PayloadBuffer pBuf = new PayloadBuffer(bb);
            pBuf.setEventType(EventType.USER);
            if (isFirstEvent) {
                pBuf.isFirstEvent(true);
            }
            return pBuf;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RocFixedRateSimulation(String name, Map<String, String> attributeMap, Emu emu) {
        super(name, attributeMap, emu);
        this.syncMessage = new cMsgMessage();
        this.syncMessage.setSubject("syncFromRoc");
        this.syncMessage.setType(emu.name());
        try {
            this.syncMessage.setHistoryLengthMax(0);
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        this.triggerType = 15;
        try {
            this.triggerType = Integer.parseInt(attributeMap.get("triggerType"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.triggerType < 0) {
            this.triggerType = 0;
        } else if (this.triggerType > 15) {
            this.triggerType = 15;
        }
        this.detectorId = 111;
        try {
            this.detectorId = Integer.parseInt(attributeMap.get("detectorId"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.detectorId < 0) {
            this.detectorId = 0;
        }
        this.eventBlockSize = 40;
        try {
            this.eventBlockSize = Integer.parseInt(attributeMap.get("blockSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.eventBlockSize < 1) {
            this.eventBlockSize = 1;
        } else if (this.eventBlockSize > 255) {
            this.eventBlockSize = 255;
        }
        this.eventSize = 75;
        try {
            this.eventSize = Integer.parseInt(attributeMap.get("eventSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.eventSize < 1) {
            this.eventSize = 1;
        }
        this.loops = 0;
        try {
            this.loops = Integer.parseInt(attributeMap.get("loops"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.loops < 1) {
            this.loops = 0;
        }
        this.syncCount = 1000000;
        try {
            this.syncCount = Integer.parseInt(attributeMap.get("syncCount"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.syncCount < 10) {
            this.syncCount = 10;
        }
        this.synced = true;
        String s = attributeMap.get("sync");
        if (s != null && (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("off") || s.equalsIgnoreCase("no"))) {
            this.synced = false;
        }
        this.noPhysics = false;
        s = attributeMap.get("noPhysics");
        if (s != null && (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("yes"))) {
            this.noPhysics = true;
            this.eventProducingThreads = 1;
        }
        this.eventGeneratingThreads = new EventGeneratingThread[this.eventProducingThreads];
        this.generatedDataWords = this.eventBlockSize * this.eventSize;
        System.out.println("  Roc mod: generatedDataWords = " + this.generatedDataWords);
        this.eventWordSize = this.getSingleEventBufferWords(this.generatedDataWords);
        System.out.println("  Roc mod: eventWordSize = " + this.eventWordSize);
        this.initMessage = new cMsgMessage();
        this.initMessage.setSubject("initFromRoc");
        this.initMessage.setType(emu.name());
        this.initMessage.setUserInt(4 * this.eventWordSize);
        try {
            this.initMessage.setHistoryLengthMax(0);
        }
        catch (cMsgException cMsgException3) {
            // empty catch block
        }
        emu.setCodaClass(CODAClass.ROC);
    }

    @Override
    public void addInputChannels(ArrayList<DataChannel> input_channels) {
    }

    @Override
    public ArrayList<DataChannel> getInputChannels() {
        return null;
    }

    @Override
    public void clearChannels() {
        this.outputChannels.clear();
    }

    @Override
    public int getInternalRingCount() {
        return this.bufSupplySize;
    }

    private void endThreads() {
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        this.RateCalculator = null;
        for (EventGeneratingThread thd : this.eventGeneratingThreads) {
            if (thd == null) continue;
            try {
                thd.interrupt();
                thd.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void killThreads() {
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        this.RateCalculator = null;
        for (EventGeneratingThread thd : this.eventGeneratingThreads) {
            if (thd == null) continue;
            thd.interrupt();
            try {
                thd.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void eventToOutputRing(int ringNum, ByteBuffer buf, ByteBufferItem item, ByteBufferSupply bbSupply) {
        if (this.outputChannelCount < 1) {
            bbSupply.release(item);
            return;
        }
        RingBuffer<RingItem> rb = ((DataChannel)this.outputChannels.get(0)).getRingBuffersOut()[ringNum];
        long nextRingItem = rb.next();
        RingItem ri = (RingItem)rb.get(nextRingItem);
        ri.setBuffer(buf);
        ri.setEventType(EventType.ROC_RAW);
        ri.setControlType(null);
        ri.setSourceName(null);
        ri.setReusableByteBuffer(bbSupply, item);
        rb.publish(nextRingItem);
    }

    private void sendMsgToSynchronizer(boolean gotEnd) throws cMsgException {
        if (gotEnd) {
            this.syncMessage.setUserInt(1);
        } else {
            this.syncMessage.setUserInt(0);
        }
        this.cMsgServer.send(this.syncMessage);
    }

    private int getSingleEventBufferWords(int generatedDataWords) {
        int dataWordLength = 1 + generatedDataWords;
        return 6 + 4 * this.eventBlockSize + dataWordLength;
    }

    private ByteBuffer createSingleEventBuffer(int generatedDataWords, long eventNumber, long timestamp) {
        int writeIndex = 0;
        int dataLen = 1 + generatedDataWords;
        ByteBuffer buf = ByteBuffer.allocate(4 * this.eventWordSize);
        buf.order(this.outputOrder);
        int rocTag = Evio.createCodaTag(false, false, true, false, this.id);
        int secondWord = rocTag << 16 | DataType.BANK.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex, this.eventWordSize - 1);
        buf.putInt(writeIndex += 4, secondWord);
        secondWord = CODATag.RAW_TRIGGER_TS.getValue() << 16 | DataType.SEGMENT.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex += 4, this.eventWordSize - 2 - dataLen - 2 - 1);
        buf.putInt(writeIndex += 4, secondWord);
        writeIndex += 4;
        int segWord = this.triggerType << 24 | DataType.UINT32.getValue() << 16 | 3;
        for (int i = 0; i < this.eventBlockSize; ++i) {
            buf.putInt(writeIndex, segWord);
            buf.putInt(writeIndex += 4, (int)(eventNumber + (long)i));
            buf.putInt(writeIndex += 4, (int)timestamp);
            buf.putInt(writeIndex += 4, (int)(timestamp >>> 32 & 0xFFFFL));
            writeIndex += 4;
            timestamp += 4L;
        }
        int dataTag = Evio.createCodaTag(false, false, true, false, this.detectorId);
        secondWord = dataTag << 16 | DataType.UINT32.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex, dataLen + 1);
        buf.putInt(writeIndex += 4, secondWord);
        buf.putInt(writeIndex += 4, (int)eventNumber);
        writeIndex += 4;
        for (int i = 0; i < generatedDataWords; ++i) {
            buf.putInt(writeIndex, 1);
            writeIndex += 4;
        }
        return buf;
    }

    void writeEventBuffer(ByteBuffer buf, ByteBuffer templateBuf, long eventNumber, long timestamp, boolean copy) {
        if (copy) {
            if (!buf.hasArray()) {
                templateBuf.position(0);
                buf.put(templateBuf);
            } else {
                System.arraycopy(templateBuf.array(), 0, buf.array(), 0, templateBuf.limit());
            }
        }
        buf.position(0).limit(templateBuf.limit());
        int writeIndex = 16;
        for (int i = 0; i < this.eventBlockSize; ++i) {
            buf.putInt(writeIndex += 4, (int)(eventNumber + (long)i));
            buf.putInt(writeIndex += 4, (int)timestamp);
            buf.putInt(writeIndex += 4, (int)(timestamp >>> 32 & 0xFFFFL));
            writeIndex += 4;
            timestamp += 4L;
        }
        buf.putInt(writeIndex += 8, (int)eventNumber);
    }

    @Override
    public void reset() {
        this.gotResetCommand = true;
        System.out.println("  Roc mod: reset()");
        Date theDate = new Date();
        CODAStateIF previousState = this.moduleState;
        this.moduleState = CODAState.CONFIGURED;
        this.wordRate = 0.0f;
        this.eventRate = 0.0f;
        this.wordCountTotal = 0L;
        this.eventCountTotal = 0L;
        this.killThreads();
        this.paused = false;
        if (previousState.equals(CODAState.ACTIVE)) {
            try {
                Configurer.setValue(this.emu.parameters(), "status/run_end_time", theDate.toString());
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void end() throws CmdExecException {
        this.paused = false;
        this.gotEndCommand = true;
        this.endCallback.endWait();
        if (this.gotGoCommand && this.synced) {
            try {
                this.endPhaser.awaitAdvanceInterruptibly(this.endPhaser.arrive());
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.moduleState = CODAState.DOWNLOADED;
        if (this.synced) {
            try {
                if (this.cmsgSubHandle != null) {
                    this.cMsgServer.unsubscribe(this.cmsgSubHandle);
                    this.cmsgSubHandle = null;
                }
            }
            catch (cMsgException e) {
                // empty catch block
            }
        }
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_end_time", new Date().toString());
        }
        catch (DataNotFoundException e) {
            // empty catch block
        }
        this.killThreads();
        PayloadBuffer pBuf = Evio.createControlBuffer(ControlType.END, 0, 0, (int)this.eventCountTotal, 0, this.outputOrder, false);
        for (int i = 0; i < this.outputChannelCount; ++i) {
            if (i > 0) {
                pBuf = new PayloadBuffer(pBuf);
            }
            try {
                this.eventToOutputChannel((RingItem)pBuf, i, 0);
            }
            catch (InterruptedException e) {
                System.out.println("  Roc mod: end() interrupted");
                return;
            }
            System.out.println("  Roc mod: inserted END event to channel " + i);
        }
    }

    @Override
    public void prestart() {
        System.out.println("  Roc mod: PRESTART");
        this.moduleState = CODAState.PAUSED;
        this.gotResetCommand = false;
        this.gotEndCommand = false;
        this.gotGoCommand = false;
        this.wordRate = 0.0f;
        this.eventRate = 0.0f;
        this.wordCountTotal = 0L;
        this.eventCountTotal = 0L;
        this.rocRecordId = 1;
        this.initLatch = new CountDownLatch(1);
        System.out.println("  Roc mod: init subscribe");
        this.cMsgServer = this.emu.getCmsgPortal().getCmsgServer();
        try {
            this.cmsgSubHandle = this.cMsgServer.subscribe("init", "ROC", (cMsgCallbackInterface)this.initCallback, null);
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        if (this.synced) {
            this.syncPhaser = new Phaser(this.eventProducingThreads + 1);
            this.endPhaser = new Phaser(this.eventProducingThreads + 2);
            this.timeToEnd = false;
            this.gotEndCommand = false;
        }
        this.RateCalculator = new Thread(this.emu.getThreadGroup(), new ModuleAdapter.RateCalculatorThread(), this.emu.name() + ":watcher");
        boolean sendUser = true;
        PayloadBuffer pBuf = Evio.createControlBuffer(ControlType.PRESTART, this.emu.getRunNumber(), this.emu.getRunTypeId(), 0, 0, this.outputOrder, false);
        for (int i = 0; i < this.outputChannelCount; ++i) {
            PayloadBuffer pBuf2 = new PayloadBuffer(pBuf);
            try {
                this.eventToOutputChannel((RingItem)pBuf2, i, 0);
            }
            catch (InterruptedException e) {
                System.out.println("  Roc mod:  prestart() interrupted");
                return;
            }
            System.out.println("  Roc mod: inserted PRESTART event to channel " + i);
        }
        ++this.rocRecordId;
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", "--prestart--");
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
        if (this.synced) {
            this.cMsgServer = this.emu.getCmsgPortal().getCmsgServer();
            try {
                this.cmsgSubHandle = this.cMsgServer.subscribe("sync", "ROC", (cMsgCallbackInterface)this.syncCallback, null);
            }
            catch (cMsgException cMsgException3) {
                // empty catch block
            }
        }
    }

    @Override
    public void go() {
        int i;
        this.gotGoCommand = true;
        if (this.moduleState == CODAState.ACTIVE) {
            // empty if block
        }
        System.out.println("  Roc mod: init send to sub =  " + this.initMessage.getSubject());
        try {
            this.cMsgServer.send(this.initMessage);
        }
        catch (cMsgException e) {
            e.printStackTrace();
        }
        System.out.println("  Roc mod: await init response from TS");
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("  Roc mod: past init");
        PayloadBuffer pBuf = Evio.createControlBuffer(ControlType.GO, 0, 0, (int)this.eventCountTotal, 0, this.outputOrder, false);
        for (i = 0; i < this.outputChannelCount; ++i) {
            PayloadBuffer pBuf2 = new PayloadBuffer(pBuf);
            try {
                this.eventToOutputChannel((RingItem)pBuf2, i, 0);
            }
            catch (InterruptedException e) {
                System.out.println("  Roc mod:  go() interrupted");
                return;
            }
            System.out.println("  Roc mod: inserted GO event to channel " + i);
        }
        ++this.rocRecordId;
        this.moduleState = CODAState.ACTIVE;
        if (this.RateCalculator == null) {
            this.RateCalculator = new Thread(this.emu.getThreadGroup(), new ModuleAdapter.RateCalculatorThread(), this.emu.name() + ":watcher");
        }
        if (this.RateCalculator.getState() == Thread.State.NEW) {
            this.RateCalculator.start();
        }
        if (!this.noPhysics) {
            for (i = 0; i < this.eventProducingThreads; ++i) {
                if (this.eventGeneratingThreads[i] == null) {
                    this.eventGeneratingThreads[i] = new EventGeneratingThread(i, this.emu.getThreadGroup(), this.emu.name() + ":generator");
                } else if (!this.eventGeneratingThreads[i].isAlive()) {
                    this.eventGeneratingThreads[i] = new EventGeneratingThread(i, this.emu.getThreadGroup(), this.emu.name() + ":generator");
                }
                if (this.eventGeneratingThreads[i].getState() != Thread.State.NEW) continue;
                this.eventGeneratingThreads[i].start();
            }
        }
        this.paused = false;
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", new Date().toString());
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    class EventGeneratingThread
    extends Thread {
        private final int myId;
        private int myRocRecordId;
        private long myEventNumber;
        private long timestamp;
        private ByteBufferSupply bbSupply;
        private ByteBuffer templateBuffer;

        EventGeneratingThread(int id, ThreadGroup group, String name) {
            super(group, name);
            this.myId = id;
            this.myRocRecordId = RocFixedRateSimulation.this.rocRecordId + this.myId;
            this.myEventNumber = 1L + (long)(this.myId * RocFixedRateSimulation.this.eventBlockSize);
            this.timestamp = this.myId * 4 * RocFixedRateSimulation.this.eventBlockSize;
            this.templateBuffer = RocFixedRateSimulation.this.createSingleEventBuffer(RocFixedRateSimulation.this.generatedDataWords, this.myEventNumber, this.timestamp);
            System.out.println("  Roc mod: start With (id=" + this.myId + "):\n    record id = " + this.myRocRecordId + ", ev # = " + this.myEventNumber + ", ts = " + this.timestamp + ", blockSize = " + RocFixedRateSimulation.this.eventBlockSize);
        }

        @Override
        public void run() {
            boolean k = false;
            int skip = 3;
            int userEventLoop = RocFixedRateSimulation.this.syncCount;
            long oldVal = 0L;
            long totalT = 0L;
            long totalCount = 0L;
            long bufCounter = 0L;
            boolean copyWholeBuf = true;
            if (RocFixedRateSimulation.this.outputChannelCount > 0) {
                RocFixedRateSimulation.this.bufSupplySize = ((DataChannel)RocFixedRateSimulation.this.outputChannels.get(0)).getRingBuffersOut()[0].getBufferSize();
            } else {
                RocFixedRateSimulation.this.bufSupplySize = 4096;
            }
            this.bbSupply = new ByteBufferSupply(RocFixedRateSimulation.this.bufSupplySize, 4 * RocFixedRateSimulation.this.eventWordSize, ByteOrder.BIG_ENDIAN, false);
            System.out.println("  Roc mod: " + RocFixedRateSimulation.this.bufSupplySize + " buffers of byte size = " + 4 * RocFixedRateSimulation.this.eventWordSize);
            try {
                long t1 = System.currentTimeMillis();
                boolean noBuildableEvents = false;
                System.out.println("SETTING loops to " + RocFixedRateSimulation.this.loops);
                while (RocFixedRateSimulation.this.moduleState == CODAState.ACTIVE || RocFixedRateSimulation.this.paused) {
                    if (RocFixedRateSimulation.this.gotResetCommand) {
                        return;
                    }
                    if (noBuildableEvents) {
                        Thread.sleep(250L);
                    } else {
                        ByteBufferItem bufItem = this.bbSupply.get();
                        ByteBuffer buf = bufItem.getBuffer();
                        if (copyWholeBuf) {
                            buf.order(RocFixedRateSimulation.this.outputOrder);
                            if (++bufCounter > (long)RocFixedRateSimulation.this.bufSupplySize) {
                                copyWholeBuf = false;
                            }
                        }
                        RocFixedRateSimulation.this.writeEventBuffer(buf, this.templateBuffer, this.myEventNumber, this.timestamp, copyWholeBuf);
                        RocFixedRateSimulation.this.eventToOutputRing(this.myId, buf, bufItem, this.bbSupply);
                        RocFixedRateSimulation.this.eventCountTotal += (long)RocFixedRateSimulation.this.eventBlockSize;
                        RocFixedRateSimulation.this.wordCountTotal += (long)RocFixedRateSimulation.this.eventWordSize;
                        this.myEventNumber += (long)(RocFixedRateSimulation.this.eventProducingThreads * RocFixedRateSimulation.this.eventBlockSize);
                        this.timestamp += (long)(4 * RocFixedRateSimulation.this.eventProducingThreads * RocFixedRateSimulation.this.eventBlockSize);
                        this.myRocRecordId += RocFixedRateSimulation.this.eventProducingThreads;
                        if (RocFixedRateSimulation.this.synced && --userEventLoop < 1) {
                            if (RocFixedRateSimulation.this.moduleState == CODAState.DOWNLOADED) {
                                RocFixedRateSimulation.this.gotEndCommand = true;
                            }
                            if (this.myId == 0) {
                                RocFixedRateSimulation.this.sendMsgToSynchronizer(RocFixedRateSimulation.this.gotEndCommand);
                            }
                            RocFixedRateSimulation.this.syncPhaser.arriveAndAwaitAdvance();
                            if (RocFixedRateSimulation.this.timeToEnd) {
                                RocFixedRateSimulation.this.endPhaser.arriveAndDeregister();
                                return;
                            }
                            userEventLoop = ++RocFixedRateSimulation.this.syncCount;
                        }
                    }
                    long t2 = RocFixedRateSimulation.this.emu.getTime();
                    long deltaT = t2 - t1;
                    if (this.myId != 0 || deltaT <= 2000L) continue;
                    if (skip-- < 1) {
                        System.out.println("  Roc mod: event rate = " + String.format("%.3g", (double)(this.myEventNumber - oldVal) * 1000.0 / (double)deltaT) + " Hz,  avg = " + String.format("%.3g", (double)(totalCount += this.myEventNumber - oldVal) * 1000.0 / (double)(totalT += deltaT)));
                    } else {
                        System.out.println("  Roc mod: event rate = " + String.format("%.3g", (double)(this.myEventNumber - oldVal) * 1000.0 / (double)deltaT) + " Hz");
                    }
                    t1 = t2;
                    oldVal = this.myEventNumber;
                }
            }
            catch (InterruptedException noBuildableEvents) {
            }
            catch (Exception e) {
                RocFixedRateSimulation.this.errorMsg.compareAndSet(null, e.getMessage());
                RocFixedRateSimulation.this.moduleState = CODAState.ERROR;
                RocFixedRateSimulation.this.emu.sendStatusMessage();
                return;
            }
        }
    }

    private class InitCallback
    extends cMsgCallbackAdapter {
        private InitCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            RocFixedRateSimulation.this.eventsPerBuffer = msg.getUserInt();
            cMsgPayloadItem item = msg.getPayloadItem("bufsPerSec");
            RocFixedRateSimulation.this.bufsPerSec = 1.0;
            try {
                RocFixedRateSimulation.this.bufsPerSec = item.getDouble();
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
            System.out.println("callback: got init return msg from TS, events/buf = " + RocFixedRateSimulation.this.eventsPerBuffer + ", bus/sec = " + RocFixedRateSimulation.this.bufsPerSec);
            for (DataChannel chan : RocFixedRateSimulation.this.outputChannels) {
                chan.regulateOutputBufferRate(RocFixedRateSimulation.this.eventsPerBuffer, RocFixedRateSimulation.this.bufsPerSec);
            }
            RocFixedRateSimulation.this.initLatch.countDown();
        }
    }

    private class SyncCallback
    extends cMsgCallbackAdapter {
        private SyncCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            System.out.println("callback: got msg from fake TS");
            int endIt = msg.getUserInt();
            if (endIt > 0) {
                RocFixedRateSimulation.this.timeToEnd = true;
                RocFixedRateSimulation.this.endPhaser.arriveAndDeregister();
            }
            RocFixedRateSimulation.this.syncPhaser.arrive();
        }
    }
}

