/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test.blast;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;
import org.jlab.coda.emu.support.data.CODATag;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriterUnsync;
import org.jlab.coda.jevio.EvioException;

public class EmuBlaster {
    private String name = "EmuBlaster";
    private int id;
    private final int generatingThdId;
    private int myRocRecordId;
    private long myEventNumber;
    private long timestamp;
    private ByteBufferSupply bbSupply;
    private boolean direct;
    private ByteBuffer templateBuffer;
    private ByteOrder outputOrder;
    private int generatedDataWords;
    private long eventCountTotal;
    private long byteCountTotal;
    private int eventProducingThreads;
    private volatile int rocRecordId;
    private int triggerType;
    private int eventBlockSize;
    private int detectorId;
    private int eventWordSize;
    private int eventSize;
    private int loops;
    private int bufferSize = 8192;
    private int sendBufferSize = 32768;
    private byte[] buffer;
    private int blasteePort = 22333;
    private String blasteeHost;
    private boolean noDelay;
    private int connectTimeout;
    private EventWriterUnsync writer;

    private static void usage() {
        System.out.println("\nUsage:\n\n   java EmuBlaster\n         -h <host>              blastee host\n        [-d <buf size>]         writing data buffer size in bytes (8192)\n        [-s <buf size>]         TCP send buffer size in bytes (4*8192)\n        [-p <port>]             blastee TCP port (22333)\n        [-nd]                   no-delay socket option on (must be last option specified)\n        [-help]                 print this message\n");
    }

    public static void main(String[] args) {
        try {
            EmuBlaster blaster = new EmuBlaster(args);
            blaster.run();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public EmuBlaster(String[] args) {
        this.decodeCommandLine(args);
        this.buffer = new byte[this.bufferSize];
        this.id = 0;
        this.rocRecordId = 0;
        this.generatingThdId = 0;
        this.eventCountTotal = 0L;
        this.byteCountTotal = 0L;
        this.eventProducingThreads = 1;
        this.outputOrder = ByteOrder.BIG_ENDIAN;
        this.connectTimeout = 5;
        this.eventBlockSize = 20;
        this.eventSize = 40;
        this.triggerType = 15;
        this.detectorId = 111;
        this.myRocRecordId = this.rocRecordId + this.generatingThdId;
        this.myEventNumber = 1L + (long)(this.generatingThdId * this.eventBlockSize);
        this.timestamp = this.generatingThdId * 4 * this.eventBlockSize;
        this.generatedDataWords = this.eventBlockSize * this.eventSize;
        this.eventWordSize = this.getSingleEventBufferWords(this.generatedDataWords);
        this.templateBuffer = this.createSingleEventBuffer(this.generatedDataWords, this.myEventNumber, this.timestamp);
        this.bbSupply = new ByteBufferSupply(16, this.bufferSize, this.outputOrder, this.direct);
        SocketSender sender = new SocketSender();
        sender.start();
    }

    private void decodeCommandLine(String[] args) {
        boolean setSendBufSize = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-help")) {
                    EmuBlaster.usage();
                    System.exit(-1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-h")) {
                    this.blasteeHost = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-d")) {
                    this.bufferSize = Integer.parseInt(args[i + 1]);
                    if (this.bufferSize < 1) {
                        System.out.println("Data buffer size must be > 0");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-s")) {
                    this.sendBufferSize = Integer.parseInt(args[i + 1]);
                    if (this.sendBufferSize < 1) {
                        System.out.println("TCP send buffer size must be > 0");
                        System.exit(1);
                    }
                    setSendBufSize = true;
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-p")) {
                    this.blasteePort = Integer.parseInt(args[i + 1]);
                    if (this.blasteePort < 1024 || this.blasteePort > 65535) {
                        System.out.println("Port must be > 1023 & < 65536");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-nd")) {
                    this.noDelay = true;
                    continue;
                }
                EmuBlaster.usage();
                System.exit(-1);
            }
        }
        catch (Exception ex) {
            EmuBlaster.usage();
            System.exit(-1);
        }
        if (this.blasteeHost == null) {
            System.out.println("\nNeed host specified on command line");
            EmuBlaster.usage();
            System.exit(-1);
        }
        if (!setSendBufSize) {
            this.sendBufferSize = this.bufferSize <= 8192 ? 32768 : 4 * this.bufferSize;
        }
    }

    private int getSingleEventBufferWords(int generatedDataWords) {
        int dataWordLength = 1 + generatedDataWords;
        return 6 + 4 * this.eventBlockSize + dataWordLength;
    }

    private ByteBuffer createSingleEventBuffer(int generatedDataWords, long eventNumber, long timestamp) {
        int writeIndex = 0;
        int dataLen = 1 + generatedDataWords;
        ByteBuffer buf = ByteBuffer.allocate(4 * this.eventWordSize);
        buf.order(this.outputOrder);
        int rocTag = Evio.createCodaTag(false, false, true, false, this.id);
        int secondWord = rocTag << 16 | DataType.BANK.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex, this.eventWordSize - 1);
        buf.putInt(writeIndex += 4, secondWord);
        secondWord = CODATag.RAW_TRIGGER_TS.getValue() << 16 | DataType.SEGMENT.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex += 4, this.eventWordSize - 2 - dataLen - 2 - 1);
        buf.putInt(writeIndex += 4, secondWord);
        writeIndex += 4;
        int segWord = this.triggerType << 24 | DataType.UINT32.getValue() << 16 | 3;
        for (int i = 0; i < this.eventBlockSize; ++i) {
            buf.putInt(writeIndex, segWord);
            buf.putInt(writeIndex += 4, (int)(eventNumber + (long)i));
            buf.putInt(writeIndex += 4, (int)timestamp);
            buf.putInt(writeIndex += 4, (int)(timestamp >>> 32 & 0xFFFFL));
            writeIndex += 4;
            timestamp += 4L;
        }
        int dataTag = Evio.createCodaTag(false, false, true, false, this.detectorId);
        secondWord = dataTag << 16 | DataType.UINT32.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex, dataLen + 1);
        buf.putInt(writeIndex += 4, secondWord);
        buf.putInt(writeIndex += 4, (int)eventNumber);
        writeIndex += 4;
        for (int i = 0; i < generatedDataWords; ++i) {
            buf.putInt(writeIndex, 1);
            writeIndex += 4;
        }
        return buf;
    }

    public void run() {
        int skip = 2;
        int printPeriod = 5000;
        long oldVal = 0L;
        long totalT = 0L;
        long totalCount = 0L;
        long bufCounter = 0L;
        long deltaT = 0L;
        long counter = 0L;
        ByteBufferItem bufItem = null;
        try {
            long t2;
            long t1 = t2 = System.currentTimeMillis();
            while (true) {
                bufItem = this.bbSupply.get();
                this.eventToOutputRing(bufItem, this.bbSupply);
                this.byteCountTotal += this.writer.getBytesWrittenToBuffer();
                if ((0xFFL & counter++) == 0L) {
                    t2 = System.currentTimeMillis();
                }
                deltaT = t2 - t1;
                if (this.generatingThdId != 0 || deltaT <= (long)printPeriod) continue;
                if (skip-- < 1) {
                    long deltaCount = this.byteCountTotal - oldVal;
                    System.out.println("EmuBlaster: byte rate = " + String.format("%.3g", (double)deltaCount * 1000.0 / (double)deltaT) + ",  avg = " + String.format("%.3g", (double)(totalCount += deltaCount) * 1000.0 / (double)(totalT += deltaT)) + " Hz");
                } else {
                    System.out.println("EmuBlaster: byte rate = " + String.format("%.3g", (double)(this.byteCountTotal - oldVal) * 1000.0 / (double)deltaT) + " Hz");
                }
                t1 = t2;
                oldVal = this.byteCountTotal;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private final void eventToOutputRing(ByteBufferItem item, ByteBufferSupply bbSupply) throws EvioException, IOException {
        ByteBuffer destBuf = item.getBuffer();
        this.templateBuffer.position(0);
        int templateSize = this.templateBuffer.remaining();
        if (destBuf.remaining() < this.templateBuffer.remaining()) {
            throw new EvioException("specified buffer needs to be bigger (> " + templateSize + ')');
        }
        try {
            if (this.writer == null) {
                this.writer = new EventWriterUnsync(destBuf);
            } else {
                this.writer.setBuffer(destBuf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (destBuf.remaining() > templateSize + 64) {
            this.templateBuffer.position(0);
            this.writer.writeEvent(this.templateBuffer);
        }
        this.writer.close();
        bbSupply.publish(item);
    }

    private class SocketSender
    extends Thread {
        private volatile boolean killThd;

        private SocketSender() {
        }

        public void killThread() {
            this.killThd = true;
            this.interrupt();
        }

        @Override
        public void run() {
            boolean i = true;
            try {
                Socket tcpSocket = new Socket();
                tcpSocket.setTcpNoDelay(EmuBlaster.this.noDelay);
                tcpSocket.setSendBufferSize(EmuBlaster.this.sendBufferSize);
                tcpSocket.setPerformancePreferences(0, 0, 1);
                tcpSocket.connect(new InetSocketAddress(EmuBlaster.this.blasteeHost, EmuBlaster.this.blasteePort), 2000);
                DataOutputStream domainOut = new DataOutputStream(new BufferedOutputStream(tcpSocket.getOutputStream()));
                while (true) {
                    if (this.killThd) {
                        return;
                    }
                    ByteBufferItem item = EmuBlaster.this.bbSupply.consumerGet();
                    ByteBuffer buf = item.getBufferAsIs();
                    buf.flip();
                    int binaryLength = buf.remaining();
                    try {
                        long emuEvioFileFormat = 1L;
                        domainOut.writeLong(emuEvioFileFormat << 32 | (long)binaryLength & 0xFFFFFFFFL);
                        try {
                            if (binaryLength > 0) {
                                if (EmuBlaster.this.direct) {
                                    domainOut.write(ByteDataTransformer.toByteArray((ByteBuffer)buf));
                                } else {
                                    domainOut.write(buf.array(), buf.arrayOffset(), binaryLength);
                                }
                            }
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        domainOut.flush();
                    }
                    catch (IOException e) {
                        System.out.println("Blastee is dead");
                        System.exit(-1);
                    }
                    EmuBlaster.this.bbSupply.release(item);
                }
            }
            catch (SocketTimeoutException e) {
                System.out.println("EmuBlaster: connection TIMEOUT");
            }
            catch (InterruptedException e) {
                System.out.println("EmuBlaster: socketSender thread interruped");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

