/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SpinCountBackoffWaitStrategy;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class VardanERSAP
extends Thread {
    int streamCount = 2;
    int byteBufferSize = 2048;
    int crateRingItemCount = 256;
    RingBuffer<ByteBuffer>[] crateRingBuffers = new RingBuffer[this.streamCount];
    Sequence[] crateSequences = new Sequence[this.streamCount];
    SequenceBarrier[] crateBarriers = new SequenceBarrier[this.streamCount];
    long[] crateNextSequences = new long[this.streamCount];
    long[] crateAvailableSequences = new long[this.streamCount];
    RingBuffer<ByteBuffer> outputRingBuffer;
    Sequence outputSequence;
    SequenceBarrier outputBarrier;
    long outputNextSequence;
    long outputAvailableSequence = -1L;

    public VardanERSAP() {
        for (int i = 0; i < this.streamCount; ++i) {
            this.crateRingBuffers[i] = RingBuffer.createSingleProducer((EventFactory)new ByteBufferFactory(), (int)this.crateRingItemCount, (WaitStrategy)new SpinCountBackoffWaitStrategy(30000, (WaitStrategy)new LiteBlockingWaitStrategy()));
            this.crateSequences[i] = new Sequence(-1L);
            this.crateBarriers[i] = this.crateRingBuffers[i].newBarrier(new Sequence[0]);
            this.crateRingBuffers[i].addGatingSequences(new Sequence[]{this.crateSequences[i]});
            this.crateNextSequences[i] = this.crateSequences[i].get() + 1L;
        }
        Arrays.fill(this.crateAvailableSequences, -1L);
        this.outputRingBuffer = RingBuffer.createSingleProducer((EventFactory)new ByteBufferFactory(), (int)this.crateRingItemCount, (WaitStrategy)new SpinCountBackoffWaitStrategy(30000, (WaitStrategy)new LiteBlockingWaitStrategy()));
        this.outputSequence = new Sequence(-1L);
        this.outputBarrier = this.outputRingBuffer.newBarrier(new Sequence[0]);
        this.outputRingBuffer.addGatingSequences(new Sequence[]{this.outputSequence});
        this.outputNextSequence = this.outputSequence.get() + 1L;
    }

    @Override
    public void run() {
        try {
            CrateProducer producer1 = new CrateProducer(0);
            CrateProducer producer2 = new CrateProducer(1);
            CrateAggregatingConsumer crateConsumer = new CrateAggregatingConsumer();
            OutputRingConsumer outputConsumer = new OutputRingConsumer();
            outputConsumer.start();
            crateConsumer.start();
            producer1.start();
            producer2.start();
            Thread.sleep(100000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        VardanERSAP test = new VardanERSAP();
        System.out.println("IN main, start all threads");
        test.start();
    }

    class OutputRingConsumer
    extends Thread {
        long getOutSequence;

        OutputRingConsumer() {
        }

        public ByteBuffer get() throws InterruptedException {
            ByteBuffer item = null;
            try {
                if (VardanERSAP.this.outputAvailableSequence < VardanERSAP.this.outputNextSequence) {
                    VardanERSAP.this.outputAvailableSequence = VardanERSAP.this.outputBarrier.waitFor(VardanERSAP.this.outputNextSequence);
                }
                item = (ByteBuffer)VardanERSAP.this.outputRingBuffer.get(VardanERSAP.this.outputNextSequence);
            }
            catch (TimeoutException ex) {
                ex.printStackTrace();
            }
            catch (AlertException ex) {
                ex.printStackTrace();
            }
            return item;
        }

        public void put() {
            VardanERSAP.this.outputSequence.set(VardanERSAP.this.outputNextSequence);
            ++VardanERSAP.this.outputNextSequence;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ByteBuffer buf = this.get();
                    buf.clear();
                    this.put();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class CrateAggregatingConsumer
    extends Thread {
        ByteBuffer[] inputItems;
        ByteBuffer[] outputItems;
        long getOutSequence;

        CrateAggregatingConsumer() {
            this.inputItems = new ByteBuffer[VardanERSAP.this.streamCount];
            this.outputItems = new ByteBuffer[VardanERSAP.this.streamCount];
        }

        public void get() throws InterruptedException {
            try {
                for (int i = 0; i < VardanERSAP.this.streamCount; ++i) {
                    if (VardanERSAP.this.crateAvailableSequences[i] < VardanERSAP.this.crateNextSequences[i]) {
                        VardanERSAP.this.crateAvailableSequences[i] = VardanERSAP.this.crateBarriers[i].waitFor(VardanERSAP.this.crateNextSequences[i]);
                    }
                    this.inputItems[i] = (ByteBuffer)VardanERSAP.this.crateRingBuffers[i].get(VardanERSAP.this.crateNextSequences[i]);
                    this.getOutSequence = VardanERSAP.this.outputRingBuffer.nextIntr(1);
                    this.outputItems[i] = (ByteBuffer)VardanERSAP.this.outputRingBuffer.get(this.getOutSequence);
                }
            }
            catch (TimeoutException ex) {
                ex.printStackTrace();
            }
            catch (AlertException ex) {
                ex.printStackTrace();
            }
        }

        public void put() {
            VardanERSAP.this.outputRingBuffer.publish(this.getOutSequence);
            int i = 0;
            while (i < VardanERSAP.this.streamCount) {
                VardanERSAP.this.crateSequences[i].set(VardanERSAP.this.crateNextSequences[i]);
                int n = i++;
                VardanERSAP.this.crateNextSequences[n] = VardanERSAP.this.crateNextSequences[n] + 1L;
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.get();
                    for (int i = 0; i < VardanERSAP.this.streamCount; ++i) {
                        this.outputItems[i].put(this.inputItems[i]);
                    }
                    this.put();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class CrateProducer
    extends Thread {
        int streamNum;
        long getSequence;

        CrateProducer(int streamNumber) {
            this.streamNum = streamNumber;
        }

        public ByteBuffer get() throws InterruptedException {
            this.getSequence = VardanERSAP.this.crateRingBuffers[this.streamNum].nextIntr(1);
            ByteBuffer buf = (ByteBuffer)VardanERSAP.this.crateRingBuffers[this.streamNum].get(this.getSequence);
            return buf;
        }

        public void publish() {
            VardanERSAP.this.crateRingBuffers[this.streamNum].publish(this.getSequence);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ByteBuffer buf = this.get();
                    buf.clear();
                    this.publish();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public class ByteBufferFactory
    implements EventFactory<ByteBuffer> {
        public ByteBuffer newInstance() {
            return ByteBuffer.allocate(VardanERSAP.this.byteBufferSize);
        }
    }
}

